/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.emf.spring.impl.resolver;

import com.ibm.ccl.sca.composite.emf.spring.impl.Messages;
import com.ibm.ccl.sca.composite.emf.spring.impl.SpringImplActivator;
import com.ibm.ccl.sca.composite.emf.spring.impl.model.ISpringImplementation;
import com.ibm.ccl.sca.composite.emf.spring.impl.model.SpringImplementationFactory;
import com.ibm.ccl.sca.composite.emf.spring.impl.resolver.SCASpringImplementation;
import com.ibm.ccl.sca.core.model.ISCAArtifact;
import com.ibm.ccl.sca.core.model.ISCAArtifactResolver;
import com.ibm.ccl.sca.core.model.SCAModelResolver;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.implementation.spring.SpringImplementation;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;

public class SpringImplementationResolver
implements ISCAArtifactResolver {
    private static final String TYPE_ID = "com.ibm.ccl.sca.spring.implementation.spring";
    private static final String TRACE_COMPONENT = "model/resolver/spring";
    private IProject parentProject;
    private List<IPath> resolvedPaths = new ArrayList<IPath>();
    private IStatus status = null;

    public SpringImplementationResolver(ISCAArtifact<?> context) {
        this(context.getParent());
    }

    public SpringImplementationResolver(IProject project) {
        this.parentProject = project;
    }

    private void searchProject(List<ISCAArtifact<?>> artifacts, IProject project, IPath path, IProgressMonitor monitor) {
        ISpringImplementation impl = SpringImplementationFactory.createSpringImplementation(project, path);
        if (impl != null) {
            artifacts.add(new SCASpringImplementation(impl));
        }
    }

    public List<? extends ISCAArtifact<?>> resolve(Object modelObject, IProgressMonitor monitor) throws CoreException {
        SCAModelResolver.ResolutionStatus resolutionStatus;
        IProject[] referencedProjects;
        this.status = Status.OK_STATUS;
        ArrayList artifacts = new ArrayList();
        String location = ((SpringImplementation)modelObject).getLocation();
        if (location == null || (location = location.trim()).length() == 0) {
            return artifacts;
        }
        Path path = new Path(location);
        if (this.resolvedPaths.contains(path)) {
            return artifacts;
        }
        SpringImplActivator.traceInfo(TRACE_COMPONENT, "Resolving path: " + path);
        SpringImplActivator.traceInfo(TRACE_COMPONENT, "Searching parent project: " + this.parentProject);
        this.searchProject(artifacts, this.parentProject, (IPath)path, monitor);
        IProject[] iProjectArray = referencedProjects = this.parentProject.getReferencedProjects();
        int n = referencedProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            SpringImplActivator.traceInfo(TRACE_COMPONENT, "Searching referenced project: " + project);
            this.searchProject(artifacts, project, (IPath)path, monitor);
            ++n2;
        }
        this.resolvedPaths.add((IPath)path);
        if (artifacts.size() == 0) {
            resolutionStatus = new SCAModelResolver.ResolutionStatus(4, Messages.bind((String)Messages.ERR_UNRESOLVED_LOCATION, (Object)location), (Object)location);
            resolutionStatus.setType(TYPE_ID);
            this.status = resolutionStatus;
        } else if (artifacts.size() > 1) {
            resolutionStatus = new SCAModelResolver.ResolutionStatus(2, Messages.bind((String)Messages.WARN_MULTIPLE_RESOLVED_LOCATION, (Object)location), (Object)location);
            resolutionStatus.setType(TYPE_ID);
            this.status = resolutionStatus;
        }
        SpringImplActivator.traceInfo(TRACE_COMPONENT, "Spring implementations found: " + artifacts.size());
        return artifacts;
    }

    public List<? extends ISCAArtifact<?>> resolve(QName qname, IProgressMonitor monitor) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public IStatus getStatus() {
        return this.status;
    }
}

