/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.emf.spring.impl.reflection;

import com.ibm.ccl.sca.composite.emf.spring.impl.Messages;
import com.ibm.ccl.sca.composite.emf.spring.impl.SpringImplActivator;
import com.ibm.ccl.sca.composite.emf.spring.impl.model.IBeanDefinition;
import com.ibm.ccl.sca.composite.emf.spring.impl.model.ISpringImplementation;
import com.ibm.ccl.sca.composite.emf.spring.impl.reflection.BeanDefinitionReflector;
import com.ibm.ccl.sca.composite.emf.spring.impl.reflection.ConstructorMatcher;
import com.ibm.ccl.sca.composite.emf.spring.impl.reflection.ISignatureMatcher;
import com.ibm.ccl.sca.composite.emf.spring.impl.reflection.ReflectedElement;
import com.ibm.ccl.sca.composite.emf.spring.impl.reflection.SetterMatcher;
import com.ibm.ccl.sca.core.util.JavaUtil;
import com.ibm.ccl.sca.core.util.StatusUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class SpringImplementationReflector {
    private ISpringImplementation impl;
    private Map<String, ReflectedElement> springBeans;
    private Map<String, List<ReflectedElement>> springConstructorArgs;
    private Map<String, List<ReflectedElement>> springProperties;
    private Map<String, ReflectedElement> scaServices;
    private Map<String, ReflectedElement> scaReferences;
    private Map<String, ReflectedElement> scaProperties;
    private List<IBeanDefinition> processed;

    public SpringImplementationReflector(ISpringImplementation impl) {
        this.impl = impl;
    }

    private void init() {
        this.springBeans = new Hashtable<String, ReflectedElement>();
        this.springConstructorArgs = new Hashtable<String, List<ReflectedElement>>();
        this.springProperties = new Hashtable<String, List<ReflectedElement>>();
        this.scaServices = new Hashtable<String, ReflectedElement>();
        this.scaReferences = new Hashtable<String, ReflectedElement>();
        this.scaProperties = new Hashtable<String, ReflectedElement>();
        this.processed = new ArrayList<IBeanDefinition>();
    }

    BeanDefinitionReflector newBeanDefinitionReflector(IBeanDefinition def) throws CoreException {
        if (this.processed.contains(def)) {
            throw new CoreException(StatusUtil.errorStatus((String)Messages.ERR_DUP_DETECTED));
        }
        this.processed.add(def);
        return new BeanDefinitionReflector(this, def);
    }

    private IType findType(IProject project, String fullyQualifiedName) throws CoreException {
        if (project.hasNature("org.eclipse.jdt.core.javanature")) {
            return JavaCore.create((IProject)project).findType(fullyQualifiedName);
        }
        return null;
    }

    private String getServiceType(BeanInfo beanInfo) throws JavaModelException {
        String fullyQualifiedName;
        IType jdtType = beanInfo.jdtType;
        String[] typeNames = jdtType.getSuperInterfaceNames();
        if (typeNames.length > 0 && (fullyQualifiedName = JavaUtil.resolveFullName((IType)jdtType, (String)typeNames[0])) != null) {
            return fullyQualifiedName;
        }
        return beanInfo.serviceType;
    }

    private Map<String, BeanInfo> analyzeBeanTypes() {
        boolean needJdtType;
        boolean needServiceType = this.scaServices.isEmpty();
        boolean bl = needJdtType = this.scaReferences.isEmpty() && this.scaProperties.isEmpty();
        if (!needServiceType && !needJdtType) {
            return null;
        }
        Hashtable<String, BeanInfo> beanInfos = new Hashtable<String, BeanInfo>();
        for (ReflectedElement bean : this.springBeans.values()) {
            IProject project = bean.project;
            String origType = bean.type;
            String key = String.valueOf(project.getName()) + '/' + origType;
            ReflectedElement clone = null;
            BeanInfo beanInfo = null;
            if (needServiceType) {
                clone = bean.cloneIt();
            }
            if (beanInfos.containsKey(key)) {
                if (!needServiceType) continue;
                clone.type = ((BeanInfo)beanInfos.get((Object)key)).serviceType;
                continue;
            }
            try {
                try {
                    IType jdtType = this.findType(project, origType);
                    if (jdtType != null) {
                        beanInfo = new BeanInfo();
                        beanInfo.jdtType = jdtType;
                        beanInfo.serviceType = origType;
                        if (needServiceType) {
                            clone.type = beanInfo.serviceType = this.getServiceType(beanInfo);
                        }
                    }
                }
                catch (CoreException e) {
                    SpringImplActivator.traceError((Exception)((Object)e));
                    if (clone != null) {
                        this.scaServices.put(clone.id, clone);
                    }
                    if (beanInfo == null) continue;
                    beanInfos.put(key, beanInfo);
                    continue;
                }
            }
            catch (Throwable throwable) {
                if (clone != null) {
                    this.scaServices.put(clone.id, clone);
                }
                if (beanInfo != null) {
                    beanInfos.put(key, beanInfo);
                }
                throw throwable;
            }
            if (clone != null) {
                this.scaServices.put(clone.id, clone);
            }
            if (beanInfo == null) continue;
            beanInfos.put(key, beanInfo);
        }
        return beanInfos;
    }

    private IType determineType(ReflectedElement element, IType beanType, String signature, IProgressMonitor monitor) throws JavaModelException {
        JavaUtil.ReflectionParam param = new JavaUtil.ReflectionParam();
        IType jdtType = JavaUtil.determineIType((JavaUtil.ReflectionParam)param, (IType)beanType, (String)signature, (IProgressMonitor)monitor);
        element.type = param.typeName;
        element.isCollection = param.isCollection;
        return jdtType;
    }

    private IType determineType(ReflectedElement element, BeanInfo beanInfo, ISignatureMatcher matcher, IProgressMonitor monitor) throws CoreException {
        boolean needToReflect;
        if (this.springBeans.containsKey(element.id)) {
            element.type = null;
            return null;
        }
        boolean bl = needToReflect = element.type == null || element.index == -2;
        if (needToReflect && beanInfo == null) {
            element.type = "java.lang.Object";
            return null;
        }
        IType jdtType = null;
        if (needToReflect) {
            String signature = matcher.findSignature(beanInfo.jdtType, element);
            if (signature == null) {
                element.type = "java.lang.Object";
                return null;
            }
            jdtType = this.determineType(element, beanInfo.jdtType, signature, monitor);
        }
        if (element.type != null) {
            if (JavaUtil.isKnownPropertyType((String)element.type)) {
                jdtType = null;
            } else if (jdtType == null) {
                jdtType = this.findType(element.project, element.type);
            }
        }
        return jdtType;
    }

    private IStatus processElements(Map<String, List<ReflectedElement>> elements, Map<String, BeanInfo> beanInfos, ISignatureMatcher matcher, IProgressMonitor monitor) {
        for (Map.Entry<String, List<ReflectedElement>> entry : elements.entrySet()) {
            ReflectedElement bean = this.springBeans.get(entry.getKey());
            BeanInfo beanInfo = beanInfos.get(String.valueOf(bean.project.getName()) + '/' + bean.type);
            for (ReflectedElement element : entry.getValue()) {
                try {
                    IType jdtType = this.determineType(element, beanInfo, matcher, monitor);
                    if (element.type == null) continue;
                    if (jdtType != null && jdtType.isInterface()) {
                        this.scaReferences.put(element.id, element);
                        continue;
                    }
                    this.scaProperties.put(element.id, element);
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
            }
        }
        return Status.OK_STATUS;
    }

    public IStatus run(IProgressMonitor monitor) {
        this.init();
        IStatus status = Status.OK_STATUS;
        try {
            IBeanDefinition[] iBeanDefinitionArray = this.impl.getBeanDefinitions();
            int n = iBeanDefinitionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IBeanDefinition def = iBeanDefinitionArray[n2];
                BeanDefinitionReflector reflector = this.newBeanDefinitionReflector(def);
                status = reflector.run(monitor);
                if (!status.isOK()) {
                    IStatus iStatus = status;
                    return iStatus;
                }
                try {
                    this.springBeans.putAll(reflector.getBeans());
                    this.springConstructorArgs.putAll(reflector.getConstructorArgs());
                    this.springProperties.putAll(reflector.getProperties());
                    this.scaServices.putAll(reflector.getScaServices());
                    this.scaReferences.putAll(reflector.getScaReferences());
                    this.scaProperties.putAll(reflector.getScaProperties());
                    ++n2;
                }
                catch (CoreException e) {
                    IStatus iStatus = e.getStatus();
                    return iStatus;
                }
            }
        }
        finally {
            try {
                this.impl.close();
            }
            catch (IOException e) {
                SpringImplActivator.traceError(e);
            }
        }
        Map<String, BeanInfo> beanInfos = this.analyzeBeanTypes();
        if (this.scaReferences.isEmpty() && this.scaProperties.isEmpty()) {
            status = this.processElements(this.springConstructorArgs, beanInfos, new ConstructorMatcher(), monitor);
            if (!status.isOK()) {
                return status;
            }
            status = this.processElements(this.springProperties, beanInfos, new SetterMatcher(), monitor);
            if (!status.isOK()) {
                return status;
            }
        }
        return status;
    }

    public Collection<ReflectedElement> getServices() {
        return this.scaServices.values();
    }

    public Collection<ReflectedElement> getReferences() {
        return this.scaReferences.values();
    }

    public Collection<ReflectedElement> getProperties() {
        return this.scaProperties.values();
    }

    private static class BeanInfo {
        IType jdtType;
        String serviceType;

        private BeanInfo() {
        }
    }
}

