/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.emf.spring.impl.reflection;

import com.ibm.ccl.sca.composite.emf.spring.impl.Messages;
import com.ibm.ccl.sca.composite.emf.spring.impl.SpringImplActivator;
import com.ibm.ccl.sca.composite.emf.spring.impl.model.ISpringImplementation;
import com.ibm.ccl.sca.composite.emf.spring.impl.reflection.ReflectedElement;
import com.ibm.ccl.sca.composite.emf.spring.impl.reflection.SpringImplementationReflector;
import com.ibm.ccl.sca.composite.emf.spring.impl.resolver.SCASpringImplementation;
import com.ibm.ccl.sca.composite.emf.spring.impl.resolver.SpringImplementationResolver;
import com.ibm.ccl.sca.core.model.ISCAArtifact;
import com.ibm.ccl.sca.core.util.StatusUtil;
import com.ibm.ccl.sca.creation.core.extension.IExtensibleReflectImplementationCommand;
import com.ibm.ccl.sca.tuscany.TuscanyModelHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ComponentProperty;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.Multiplicity;
import org.apache.tuscany.sca.implementation.spring.SpringImplementation;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ReflectSpringImplementationCommand
implements IExtensibleReflectImplementationCommand {
    private IProject project;
    private Component component;
    private List<ISCAArtifact<?>> resolvedArtifacts = null;
    private List<ComponentService> services = new ArrayList<ComponentService>();
    private List<ComponentReference> references = new ArrayList<ComponentReference>();
    private List<ComponentProperty> properties = new ArrayList<ComponentProperty>();
    private TuscanyModelHelper helper = TuscanyModelHelper.getInstance();

    public void setProject(IProject project) {
        this.project = project;
    }

    public void setComponent(Component component) {
        this.component = component;
    }

    public void setResolvedArtifacts(List<ISCAArtifact<?>> resolvedArtifacts) {
        this.resolvedArtifacts = resolvedArtifacts;
    }

    private ISpringImplementation getResolvedImplementation(String location) {
        try {
            for (ISCAArtifact<?> artifact : this.resolvedArtifacts) {
                if (!(artifact instanceof SCASpringImplementation) || !artifact.getParent().getFullPath().append(location).equals((Object)artifact.getResource().getFullPath())) continue;
                return (ISpringImplementation)((SCASpringImplementation)artifact).getModelObject();
            }
        }
        catch (CoreException e) {
            SpringImplActivator.traceError((Exception)((Object)e));
        }
        return null;
    }

    private ISpringImplementation getResolvedImplementation(SpringImplementation model, IProgressMonitor monitor) {
        try {
            SpringImplementationResolver resolver = new SpringImplementationResolver(this.project);
            List<ISCAArtifact<?>> artifacts = resolver.resolve(model, monitor);
            if (resolver.getStatus().isOK()) {
                return (ISpringImplementation)((SCASpringImplementation)artifacts.get(0)).getModelObject();
            }
        }
        catch (CoreException e) {
            SpringImplActivator.traceError((Exception)((Object)e));
        }
        return null;
    }

    private void addToServices(Collection<ReflectedElement> elements) {
        for (ReflectedElement element : elements) {
            ComponentService service = this.helper.createComponentService(element.id);
            service.setInterfaceContract((InterfaceContract)this.helper.createJavaInterfaceContract(element.type));
            this.services.add(service);
        }
    }

    private void addToReferences(Collection<ReflectedElement> elements) {
        for (ReflectedElement element : elements) {
            ComponentReference reference = this.helper.createComponentReference(element.id);
            if (element.type != null) {
                reference.setInterfaceContract((InterfaceContract)this.helper.createJavaInterfaceContract(element.type));
            }
            if (element.isCollection) {
                reference.setMultiplicity(Multiplicity.ONE_N);
            }
            this.references.add(reference);
        }
    }

    private void addToProperties(Collection<ReflectedElement> elements) {
        for (ReflectedElement element : elements) {
            ComponentProperty property = this.helper.createComponentProperty(element.id);
            if (element.isCollection) {
                property.setMany(true);
            }
            this.properties.add(property);
        }
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus status = Status.OK_STATUS;
        SpringImplementation model = (SpringImplementation)this.component.getImplementation();
        ISpringImplementation impl = null;
        if (this.resolvedArtifacts != null) {
            String location = model.getLocation();
            if (location != null && (location = location.trim()).length() > 0) {
                impl = this.getResolvedImplementation(location);
            }
        } else {
            impl = this.getResolvedImplementation(model, monitor);
        }
        if (impl == null) {
            return StatusUtil.errorStatus((String)Messages.ERR_CANNOT_LOAD_IMPL_FOR_REFLECTION);
        }
        SpringImplementationReflector reflector = new SpringImplementationReflector(impl);
        status = reflector.run(monitor);
        if (status.isOK()) {
            this.addToServices(reflector.getServices());
            this.addToReferences(reflector.getReferences());
            this.addToProperties(reflector.getProperties());
        }
        return status;
    }

    public List<ComponentService> getServices() {
        return this.services;
    }

    public List<ComponentReference> getReferences() {
        return this.references;
    }

    public List<ComponentProperty> getProperties() {
        return this.properties;
    }
}

