/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.emf.spring.impl.reflection;

import com.ibm.ccl.sca.composite.emf.spring.impl.reflection.BeanDefinitionReflector;
import javax.xml.namespace.QName;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;

public class ParseState {
    private static final String CLASSPATH_BEAN = "org.springframework.context.support.ClassPathXmlApplicationContext";
    private static final String SCA_NS = "http://www.springframework.org/schema/sca";
    private static final String SCA_PREFIX = "sca:";
    private static final String BEANS_TAG = "beans";
    private static final String BEAN_TAG = "bean";
    private static final String ROOT = "root";
    private static final String ROOT_PATH = "/root";
    private static final String IMPORT_PATH = "/root/import";
    private static final String TOP_LEVEL_BEAN_PATH = "/root/bean";
    private static final String CONSTRUCTOR_PATH = "/root/bean/constructor-arg";
    private static final String CONSTRUCTOR_REF_PATH = "/root/bean/constructor-arg/ref";
    private static final String APP_CONSTRUCTOR_PATH = "/root/bean+/constructor-arg";
    private static final String APP_CONSTRUCTOR_VALUE_PATH = "/root/bean+/constructor-arg/value";
    private static final String APP_CONSTRUCTOR_VALUES_PATH = "/root/bean+/constructor-arg/list/value";
    private static final String PROPERTY_PATH = "/root/bean/property";
    private static final String PROPERTY_REF_PATH = "/root/bean/property/ref";
    private static final String SCA_SERVICE_PATH = "/root/sca:service";
    private static final String SCA_REFERENCE_PATH = "/root/sca:reference";
    private static final String SCA_PROPERTY_PATH = "/root/sca:property";
    private StringBuffer buffer = new StringBuffer();
    private String path = "";

    public void pushState(StartElement start) {
        QName name = start.getName();
        String tagName = name.getLocalPart();
        if (SCA_NS.equals(name.getNamespaceURI())) {
            tagName = SCA_PREFIX + tagName;
        } else if (BEANS_TAG.equals(tagName)) {
            tagName = ROOT;
        } else if (BEAN_TAG.equals(tagName) && ROOT_PATH.equals(this.path) && CLASSPATH_BEAN.equals(BeanDefinitionReflector.getAttribute(start, BeanDefinitionReflector.CLASS_ATTR))) {
            tagName = String.valueOf(tagName) + '+';
        }
        this.buffer.append('/').append(tagName);
        this.path = this.buffer.toString();
    }

    public boolean popState(EndElement end) {
        QName name = end.getName();
        String tagName = name.getLocalPart();
        if (SCA_NS.equals(name.getNamespaceURI())) {
            tagName = SCA_PREFIX + tagName;
        } else if (BEANS_TAG.equals(tagName)) {
            tagName = ROOT;
        }
        int idx = this.buffer.lastIndexOf(String.valueOf('/') + tagName);
        if (idx != -1) {
            this.buffer.delete(idx, this.buffer.length());
            this.path = this.buffer.toString();
        }
        return APP_CONSTRUCTOR_PATH.equals(String.valueOf(this.path) + '/' + tagName);
    }

    public boolean isImport() {
        return IMPORT_PATH.equals(this.path);
    }

    public boolean isTopLevelBean() {
        return TOP_LEVEL_BEAN_PATH.equals(this.path);
    }

    public boolean isConstructor() {
        return CONSTRUCTOR_PATH.equals(this.path);
    }

    public boolean isConstructorRef() {
        return CONSTRUCTOR_REF_PATH.equals(this.path);
    }

    public boolean isAppConstructor() {
        return APP_CONSTRUCTOR_PATH.equals(this.path);
    }

    public boolean isAppConstructorValue() {
        return APP_CONSTRUCTOR_VALUE_PATH.equals(this.path) || APP_CONSTRUCTOR_VALUES_PATH.equals(this.path);
    }

    public boolean isProperty() {
        return PROPERTY_PATH.equals(this.path);
    }

    public boolean isPropertyRef() {
        return PROPERTY_REF_PATH.equals(this.path);
    }

    public boolean isScaService() {
        return SCA_SERVICE_PATH.equals(this.path);
    }

    public boolean isScaReference() {
        return SCA_REFERENCE_PATH.equals(this.path);
    }

    public boolean isScaProperty() {
        return SCA_PROPERTY_PATH.equals(this.path);
    }
}

