/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.emf.spring.impl.reflection;

import com.ibm.ccl.sca.composite.emf.spring.impl.model.BeanDefinitionParser;
import com.ibm.ccl.sca.composite.emf.spring.impl.model.IBeanDefinition;
import com.ibm.ccl.sca.composite.emf.spring.impl.model.SpringImplementationFactory;
import com.ibm.ccl.sca.composite.emf.spring.impl.reflection.ParseState;
import com.ibm.ccl.sca.composite.emf.spring.impl.reflection.ReflectedElement;
import com.ibm.ccl.sca.composite.emf.spring.impl.reflection.SpringImplementationReflector;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;

public class BeanDefinitionReflector {
    static final QName ID_ATTR = new QName("", "id");
    static final QName CLASS_ATTR = new QName("", "class");
    static final QName NAME_ATTR = new QName("", "name");
    static final QName TYPE_ATTR = new QName("", "type");
    static final QName INDEX_ATTR = new QName("", "index");
    static final QName RESOURCE_ATTR = new QName("", "resource");
    static final QName VALUE_ATTR = new QName("", "value");
    static final QName REF_ATTR = new QName("", "ref");
    static final QName BEAN_ATTR = new QName("", "bean");
    private SpringImplementationReflector parentReflector;
    private IBeanDefinition def;
    private Map<String, ReflectedElement> springBeans;
    private Map<String, List<ReflectedElement>> springConstructorArgs;
    private Map<String, List<ReflectedElement>> springProperties;
    private List<ReflectedElement> currentConstructorArgs;
    private List<ReflectedElement> currentProperties;
    private Map<String, ReflectedElement> scaServices;
    private Map<String, ReflectedElement> scaReferences;
    private Map<String, ReflectedElement> scaProperties;

    static String getAttribute(StartElement start, QName attr) {
        String value;
        Attribute attribute = start.getAttributeByName(attr);
        if (attribute != null && (value = attribute.getValue().trim()).length() > 0) {
            return value;
        }
        return null;
    }

    public BeanDefinitionReflector(SpringImplementationReflector parentReflector, IBeanDefinition def) {
        this.parentReflector = parentReflector;
        this.def = def;
    }

    private void init() {
        this.springBeans = new Hashtable<String, ReflectedElement>();
        this.springConstructorArgs = new Hashtable<String, List<ReflectedElement>>();
        this.springProperties = new Hashtable<String, List<ReflectedElement>>();
        this.scaServices = new Hashtable<String, ReflectedElement>();
        this.scaReferences = new Hashtable<String, ReflectedElement>();
        this.scaProperties = new Hashtable<String, ReflectedElement>();
    }

    public IStatus run(IProgressMonitor monitor) {
        this.init();
        return BeanDefinitionParser.parse(this.def, new BeanDefinitionParserDelegate(), monitor);
    }

    public Map<String, ReflectedElement> getBeans() {
        return this.springBeans;
    }

    public Map<String, List<ReflectedElement>> getConstructorArgs() {
        return this.springConstructorArgs;
    }

    public Map<String, List<ReflectedElement>> getProperties() {
        return this.springProperties;
    }

    public Map<String, ReflectedElement> getScaServices() {
        return this.scaServices;
    }

    public Map<String, ReflectedElement> getScaReferences() {
        return this.scaReferences;
    }

    public Map<String, ReflectedElement> getScaProperties() {
        return this.scaProperties;
    }

    private class BeanDefinitionParserDelegate
    implements BeanDefinitionParser.IBeanDefinitionParserDelegate {
        private ParseState state = new ParseState();
        private IStatus status = Status.OK_STATUS;
        private ReflectedElement currentElement;

        private BeanDefinitionParserDelegate() {
        }

        private void processImport(String value, IProgressMonitor monitor) {
            if (value == null || !SpringImplementationFactory.isXML(value)) {
                return;
            }
            IBeanDefinition newDef = BeanDefinitionReflector.this.def.newBeanDefinition((IPath)new Path(value));
            if (newDef == null) {
                return;
            }
            try {
                BeanDefinitionReflector reflector = BeanDefinitionReflector.this.parentReflector.newBeanDefinitionReflector(newDef);
                this.status = reflector.run(monitor);
                if (this.status.isOK()) {
                    BeanDefinitionReflector.this.springBeans.putAll(reflector.getBeans());
                    BeanDefinitionReflector.this.springConstructorArgs.putAll(reflector.getConstructorArgs());
                    BeanDefinitionReflector.this.springProperties.putAll(reflector.getProperties());
                    BeanDefinitionReflector.this.scaServices.putAll(reflector.getScaServices());
                    BeanDefinitionReflector.this.scaReferences.putAll(reflector.getScaReferences());
                    BeanDefinitionReflector.this.scaProperties.putAll(reflector.getScaProperties());
                }
            }
            catch (CoreException e) {
                this.status = e.getStatus();
            }
        }

        private void processBean(StartElement start) {
            BeanDefinitionReflector.this.currentConstructorArgs = null;
            BeanDefinitionReflector.this.currentProperties = null;
            String id = BeanDefinitionReflector.getAttribute(start, ID_ATTR);
            if (id == null) {
                return;
            }
            String clazz = BeanDefinitionReflector.getAttribute(start, CLASS_ATTR);
            if (clazz == null) {
                return;
            }
            BeanDefinitionReflector.this.springBeans.put(id, new ReflectedElement(BeanDefinitionReflector.this.def.getProject(), id, clazz));
            BeanDefinitionReflector.this.currentConstructorArgs = new ArrayList();
            BeanDefinitionReflector.this.springConstructorArgs.put(id, BeanDefinitionReflector.this.currentConstructorArgs);
            BeanDefinitionReflector.this.currentProperties = new ArrayList();
            BeanDefinitionReflector.this.springProperties.put(id, BeanDefinitionReflector.this.currentProperties);
        }

        private void processConstructor(StartElement start) {
            if (BeanDefinitionReflector.this.currentConstructorArgs != null && BeanDefinitionReflector.this.scaReferences.isEmpty() && BeanDefinitionReflector.this.scaProperties.isEmpty()) {
                this.currentElement = new ReflectedElement(BeanDefinitionReflector.this.def.getProject(), "", null);
                String type = BeanDefinitionReflector.getAttribute(start, TYPE_ATTR);
                if (type != null) {
                    this.currentElement.type = type;
                } else {
                    String index = BeanDefinitionReflector.getAttribute(start, INDEX_ATTR);
                    if (index != null) {
                        try {
                            this.currentElement.index = Integer.parseInt(index);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                    if (this.currentElement.index <= -1) {
                        this.currentElement = null;
                        return;
                    }
                }
                String ref = BeanDefinitionReflector.getAttribute(start, REF_ATTR);
                if (ref != null) {
                    this.currentElement.id = ref;
                    BeanDefinitionReflector.this.currentConstructorArgs.add(this.currentElement);
                    this.currentElement = null;
                }
            }
        }

        private void processProperty(StartElement start) {
            if (BeanDefinitionReflector.this.currentProperties != null && BeanDefinitionReflector.this.scaReferences.isEmpty() && BeanDefinitionReflector.this.scaProperties.isEmpty()) {
                this.currentElement = new ReflectedElement(BeanDefinitionReflector.this.def.getProject(), "", BeanDefinitionReflector.getAttribute(start, NAME_ATTR));
                this.currentElement.index = -2;
                String ref = BeanDefinitionReflector.getAttribute(start, REF_ATTR);
                if (ref != null) {
                    this.currentElement.id = ref;
                    BeanDefinitionReflector.this.currentProperties.add(this.currentElement);
                    this.currentElement = null;
                }
            }
        }

        private void processRef(StartElement start, List<ReflectedElement> list) {
            String ref;
            if (list != null && this.currentElement != null && BeanDefinitionReflector.this.scaReferences.isEmpty() && BeanDefinitionReflector.this.scaProperties.isEmpty() && (ref = BeanDefinitionReflector.getAttribute(start, BEAN_ATTR)) != null) {
                this.currentElement.id = ref;
                list.add(this.currentElement);
            }
            this.currentElement = null;
        }

        private void processScaElement(StartElement start, Map<String, ReflectedElement> map) {
            String name = BeanDefinitionReflector.getAttribute(start, NAME_ATTR);
            if (name == null) {
                return;
            }
            String type = BeanDefinitionReflector.getAttribute(start, TYPE_ATTR);
            if (type == null) {
                return;
            }
            map.put(name, new ReflectedElement(BeanDefinitionReflector.this.def.getProject(), name, type));
        }

        private void processElement(StartElement start, IProgressMonitor monitor) {
            if (this.state.isImport()) {
                this.processImport(BeanDefinitionReflector.getAttribute(start, RESOURCE_ATTR), monitor);
            } else if (this.state.isTopLevelBean()) {
                this.processBean(start);
            } else if (this.state.isConstructor()) {
                this.processConstructor(start);
            } else if (this.state.isConstructorRef()) {
                this.processRef(start, BeanDefinitionReflector.this.currentConstructorArgs);
            } else if (this.state.isProperty()) {
                this.processProperty(start);
            } else if (this.state.isPropertyRef()) {
                this.processRef(start, BeanDefinitionReflector.this.currentProperties);
            } else if (this.state.isAppConstructor()) {
                BeanDefinitionReflector.this.springBeans.clear();
                BeanDefinitionReflector.this.springConstructorArgs.clear();
                BeanDefinitionReflector.this.springProperties.clear();
                BeanDefinitionReflector.this.scaServices.clear();
                BeanDefinitionReflector.this.scaReferences.clear();
                BeanDefinitionReflector.this.scaProperties.clear();
                this.processImport(BeanDefinitionReflector.getAttribute(start, VALUE_ATTR), monitor);
            } else if (this.state.isScaService()) {
                this.processScaElement(start, BeanDefinitionReflector.this.scaServices);
            } else if (this.state.isScaReference()) {
                this.processScaElement(start, BeanDefinitionReflector.this.scaReferences);
            } else if (this.state.isScaProperty()) {
                this.processScaElement(start, BeanDefinitionReflector.this.scaProperties);
            }
        }

        @Override
        public boolean parse(XMLEvent event, IProgressMonitor monitor) {
            EndElement end;
            if (event.isStartElement()) {
                StartElement start = event.asStartElement();
                this.state.pushState(start);
                this.processElement(start, monitor);
            } else if (event.isCharacters() && this.state.isAppConstructorValue()) {
                Characters chars = event.asCharacters();
                this.processImport(chars.getData().trim(), monitor);
            } else if (event.isEndElement() && this.state.popState(end = event.asEndElement())) {
                return false;
            }
            return this.status.isOK();
        }

        @Override
        public IStatus getStatus() {
            return this.status;
        }
    }
}

