/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.emf.spring.impl.model;

import com.ibm.ccl.sca.composite.emf.spring.impl.model.IBeanDefinition;
import com.ibm.ccl.sca.composite.emf.spring.impl.model.JarredBeanDefinition;
import com.ibm.ccl.sca.composite.emf.spring.impl.model.SpringImplementationArchive;
import com.ibm.ccl.sca.composite.emf.spring.impl.model.SpringImplementationFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;

public class SpringImplementationJar
extends SpringImplementationArchive<IFile> {
    private JarFile jar = null;

    SpringImplementationJar(IFile file) {
        super(file);
    }

    public synchronized JarFile getJar() throws IOException {
        if (this.jar == null) {
            this.jar = new JarFile(new File(((IFile)this.getRoot()).getLocationURI()));
        }
        return this.jar;
    }

    @Override
    protected Manifest getManifest() {
        try {
            return this.getJar().getManifest();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    protected List<IBeanDefinition> getAllBeanDefinitions() {
        ArrayList<IBeanDefinition> list = new ArrayList<IBeanDefinition>();
        Enumeration<JarEntry> entries = this.jar.entries();
        while (entries.hasMoreElements()) {
            String name;
            JarEntry entry = entries.nextElement();
            if (entry.isDirectory() || !(name = entry.getName()).equals("META-INF/spring/application-context.xml")) continue;
            list.add(new JarredBeanDefinition(this, entry));
        }
        return list;
    }

    @Override
    protected List<IBeanDefinition> getFilteredBeanDefinitions(List<Pattern> patterns) {
        ArrayList<IBeanDefinition> list = new ArrayList<IBeanDefinition>();
        Enumeration<JarEntry> entries = this.jar.entries();
        while (entries.hasMoreElements()) {
            String name;
            JarEntry entry = entries.nextElement();
            if (entry.isDirectory() || !SpringImplementationFactory.isXML(name = entry.getName())) continue;
            for (Pattern pattern : patterns) {
                Matcher matcher = pattern.matcher(name);
                if (!matcher.matches()) continue;
                list.add(new JarredBeanDefinition(this, entry));
            }
        }
        return list;
    }

    @Override
    public synchronized void close() throws IOException {
        try {
            if (this.jar != null) {
                this.jar.close();
            }
        }
        finally {
            this.jar = null;
        }
    }
}

