/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.emf.spring.impl.model;

import com.ibm.ccl.sca.composite.emf.spring.impl.model.BeanDefinitionChecker;
import com.ibm.ccl.sca.composite.emf.spring.impl.model.BeanDefinitionParser;
import com.ibm.ccl.sca.composite.emf.spring.impl.model.ISpringImplementation;
import com.ibm.ccl.sca.composite.emf.spring.impl.model.SpringImplementation;
import com.ibm.ccl.sca.composite.emf.spring.impl.model.SpringImplementationContainer;
import com.ibm.ccl.sca.composite.emf.spring.impl.model.SpringImplementationJar;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;

public class SpringImplementationFactory {
    public static final String XML_EXT = "xml";
    public static final String JAR_EXT = "jar";

    public static boolean isXML(String name) {
        int dot = name.lastIndexOf(46);
        if (dot == -1) {
            return false;
        }
        name = name.substring(dot + 1);
        return XML_EXT.equalsIgnoreCase(name);
    }

    public static ISpringImplementation createSpringImplementation(IProject project, IPath path) {
        IResource resource = project.findMember(path);
        if (resource == null || !resource.getProject().equals((Object)project)) {
            return null;
        }
        ISpringImplementation impl = null;
        if (resource.getType() == 1) {
            if (XML_EXT.equalsIgnoreCase(resource.getFileExtension())) {
                impl = new SpringImplementation((IFile)resource);
                BeanDefinitionChecker checker = new BeanDefinitionChecker();
                IStatus status = BeanDefinitionParser.parse(impl.getBeanDefinitions()[0], checker, null);
                return status.isOK() && checker.isValid() ? impl : null;
            }
            if (JAR_EXT.equalsIgnoreCase(resource.getFileExtension())) {
                impl = new SpringImplementationJar((IFile)resource);
            }
        } else if (resource.getType() == 4 || resource.getType() == 2) {
            impl = new SpringImplementationContainer((IContainer)resource);
        }
        if (impl != null && impl.getBeanDefinitions().length > 0) {
            return impl;
        }
        return null;
    }
}

