/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.emf.spring.impl.model;

import com.ibm.ccl.sca.composite.emf.spring.impl.SpringImplActivator;
import com.ibm.ccl.sca.composite.emf.spring.impl.model.BeanDefinition;
import com.ibm.ccl.sca.composite.emf.spring.impl.model.IBeanDefinition;
import com.ibm.ccl.sca.composite.emf.spring.impl.model.SpringImplementationArchive;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class SpringImplementationContainer
extends SpringImplementationArchive<IContainer> {
    SpringImplementationContainer(IContainer container) {
        super(container);
    }

    @Override
    protected Manifest getManifest() {
        IResource resource = ((IContainer)this.getRoot()).findMember((IPath)new Path("META-INF/MANIFEST.MF"));
        if (resource == null || resource.getType() != 1) {
            return null;
        }
        InputStream stream = null;
        try {
            stream = ((IFile)resource).getContents();
            Manifest manifest = new Manifest(stream);
            return manifest;
        }
        catch (CoreException e) {
            SpringImplActivator.traceError((Exception)((Object)e));
        }
        catch (IOException e) {
            SpringImplActivator.traceError(e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    SpringImplActivator.traceError(e);
                }
            }
        }
        return null;
    }

    @Override
    protected List<IBeanDefinition> getAllBeanDefinitions() {
        ArrayList<IBeanDefinition> list = new ArrayList<IBeanDefinition>();
        IFile appContext = ((IContainer)this.getRoot()).getFile((IPath)new Path("META-INF/spring/application-context.xml"));
        if (appContext.exists()) {
            list.add(new BeanDefinition(appContext));
        }
        return list;
    }

    @Override
    protected List<IBeanDefinition> getFilteredBeanDefinitions(final List<Pattern> patterns) {
        final ArrayList<IBeanDefinition> list = new ArrayList<IBeanDefinition>();
        final int segments = ((IContainer)this.getRoot()).getFullPath().segmentCount();
        try {
            ((IContainer)this.getRoot()).accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    if (resource.getType() == 1 && resource.getFileExtension().equalsIgnoreCase("xml")) {
                        IPath path = resource.getFullPath().removeFirstSegments(segments);
                        for (Pattern pattern : patterns) {
                            Matcher matcher = pattern.matcher(path.toString());
                            if (!matcher.matches()) continue;
                            list.add(new BeanDefinition((IFile)resource));
                        }
                    }
                    return true;
                }
            });
        }
        catch (CoreException e) {
            SpringImplActivator.traceError((Exception)((Object)e));
        }
        return list;
    }
}

