/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.emf.spring.impl.model;

import com.ibm.ccl.sca.composite.emf.spring.impl.SpringImplActivator;
import com.ibm.ccl.sca.composite.emf.spring.impl.model.IBeanDefinition;
import com.ibm.ccl.sca.composite.emf.spring.impl.model.ISpringImplementation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IResource;

public abstract class SpringImplementationArchive<T extends IResource>
implements ISpringImplementation {
    protected static final String MANIFEST_MF = "META-INF/MANIFEST.MF";
    protected static final String SPRING_DIR = "META-INF/spring/";
    protected static final String APP_CONTEXT = "META-INF/spring/application-context.xml";
    private T t;
    private IBeanDefinition[] beanDefinitions = null;

    protected SpringImplementationArchive(T t) {
        this.t = t;
        this.beanDefinitions = this.initBeanDefinitions();
    }

    private Pattern toPattern(String value) {
        value = value.replaceAll("\\.", "\\\\.").replaceAll("\\*", ".*");
        return Pattern.compile(value);
    }

    private List<Pattern> getPatterns(Manifest manifest) {
        Attributes attributes;
        String springContext;
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        if (manifest != null && (springContext = (attributes = manifest.getMainAttributes()).getValue("Spring-Context")) != null) {
            String[] values;
            String[] stringArray = values = springContext.split("\\s*;\\s*");
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                if (value.indexOf(":=") == -1) {
                    patterns.add(this.toPattern(value));
                }
                ++n2;
            }
        }
        return patterns;
    }

    private IBeanDefinition[] initBeanDefinitions() {
        try {
            Manifest manifest = this.getManifest();
            List<Pattern> patterns = this.getPatterns(manifest);
            List<IBeanDefinition> list = null;
            list = patterns.isEmpty() ? this.getAllBeanDefinitions() : this.getFilteredBeanDefinitions(patterns);
            IBeanDefinition[] iBeanDefinitionArray = list.toArray(new IBeanDefinition[list.size()]);
            return iBeanDefinitionArray;
        }
        finally {
            try {
                this.close();
            }
            catch (IOException e) {
                SpringImplActivator.traceError(e);
            }
        }
    }

    public T getRoot() {
        return this.t;
    }

    @Override
    public IBeanDefinition[] getBeanDefinitions() {
        return this.beanDefinitions;
    }

    @Override
    public void close() throws IOException {
    }

    protected abstract Manifest getManifest();

    protected abstract List<IBeanDefinition> getAllBeanDefinitions();

    protected abstract List<IBeanDefinition> getFilteredBeanDefinitions(List<Pattern> var1);
}

