/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.emf.spring.impl.model;

import com.ibm.ccl.sca.composite.emf.spring.impl.SpringImplActivator;
import com.ibm.ccl.sca.composite.emf.spring.impl.model.IBeanDefinition;
import com.ibm.ccl.sca.composite.emf.spring.impl.model.SpringImplementationJar;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarEntry;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class JarredBeanDefinition
implements IBeanDefinition {
    private SpringImplementationJar impl;
    private JarEntry entry;

    JarredBeanDefinition(SpringImplementationJar impl, JarEntry entry) {
        this.impl = impl;
        this.entry = entry;
    }

    @Override
    public IProject getProject() {
        return ((IFile)this.impl.getRoot()).getProject();
    }

    @Override
    public InputStream getInputStream() throws CoreException, IOException {
        return this.impl.getJar().getInputStream(this.entry);
    }

    @Override
    public IBeanDefinition newBeanDefinition(IPath path) {
        path = new Path(this.entry.getName()).removeLastSegments(1).append(path);
        try {
            JarEntry newEntry = this.impl.getJar().getJarEntry(path.toString());
            if (newEntry != null && !newEntry.isDirectory()) {
                return new JarredBeanDefinition(this.impl, newEntry);
            }
        }
        catch (IOException e) {
            SpringImplActivator.traceError(e);
        }
        return null;
    }

    public String toString() {
        return this.entry.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof JarredBeanDefinition) {
            JarredBeanDefinition other = (JarredBeanDefinition)obj;
            return this.impl.equals(other.impl) && this.entry.getName().equals(other.entry.getName());
        }
        return false;
    }

    public int hashCode() {
        return this.impl.hashCode() + this.entry.getName().hashCode();
    }
}

