/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.emf.spring.impl.model;

import com.ibm.ccl.sca.composite.emf.spring.impl.Messages;
import com.ibm.ccl.sca.composite.emf.spring.impl.SpringImplActivator;
import com.ibm.ccl.sca.composite.emf.spring.impl.model.IBeanDefinition;
import com.ibm.ccl.sca.core.util.StatusUtil;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;

public class BeanDefinitionParser {
    private static XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();

    public static IStatus parse(IBeanDefinition beanDefinition, IBeanDefinitionParserDelegate delegate, IProgressMonitor monitor) {
        InputStream stream = null;
        XMLEventReader reader = null;
        try {
            stream = beanDefinition.getInputStream();
            reader = xmlInputFactory.createXMLEventReader(stream);
            while (reader.hasNext()) {
                XMLEvent event = reader.nextEvent();
                if (!delegate.parse(event, monitor)) break;
            }
            IStatus iStatus = delegate.getStatus();
            return iStatus;
        }
        catch (CoreException e) {
            IStatus iStatus = e.getStatus();
            return iStatus;
        }
        catch (Exception e) {
            IStatus iStatus = StatusUtil.errorStatus((String)Messages.ERR_PARSING_IMPL, (Throwable)e);
            return iStatus;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (XMLStreamException e) {
                    SpringImplActivator.traceError(e);
                }
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    SpringImplActivator.traceError(e);
                }
            }
        }
    }

    public static interface IBeanDefinitionParserDelegate {
        public boolean parse(XMLEvent var1, IProgressMonitor var2);

        public IStatus getStatus();
    }
}

