/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.emf.spring.impl.model;

import com.ibm.ccl.sca.composite.emf.spring.impl.SpringImplActivator;
import com.ibm.ccl.sca.composite.emf.spring.impl.model.IBeanDefinition;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class BeanDefinition
implements IBeanDefinition {
    private IFile file;

    BeanDefinition(IFile file) {
        this.file = file;
    }

    @Override
    public IProject getProject() {
        return this.file.getProject();
    }

    @Override
    public InputStream getInputStream() throws CoreException, IOException {
        return this.file.getContents();
    }

    private IBeanDefinition findOnClasspath(IPath path) throws JavaModelException {
        IJavaProject javaProject = JavaCore.create((IProject)this.file.getProject());
        String[] stringArray = javaProject.getRequiredProjectNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            IProject project = this.file.getWorkspace().getRoot().getProject(name);
            IFile newFile = project.getFile(path);
            if (newFile.exists()) {
                return new BeanDefinition(newFile);
            }
            ++n2;
        }
        return null;
    }

    @Override
    public IBeanDefinition newBeanDefinition(IPath path) {
        IFile newFile = this.file.getParent().getFile(path);
        if (newFile.exists()) {
            return new BeanDefinition(newFile);
        }
        try {
            if (this.file.getProject().hasNature("org.eclipse.jdt.core.javanature")) {
                return this.findOnClasspath(newFile.getProjectRelativePath());
            }
        }
        catch (CoreException e) {
            SpringImplActivator.traceError((Exception)((Object)e));
        }
        return null;
    }

    public String toString() {
        return this.file.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BeanDefinition) {
            return this.file.equals((Object)((BeanDefinition)obj).file);
        }
        return false;
    }

    public int hashCode() {
        return this.file.hashCode();
    }
}

