/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.emf.spring.impl;

import com.ibm.ccl.sca.facets.core.impltype.ImplTypeAction;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class SpringImplTypeAddAction
implements ImplTypeAction {
    private static final String BIN_FOLDER = "bin";
    private static final String SOURCE_FOLDER = "src";

    public void execute(IProject project) {
        try {
            IProjectDescription projDesc = project.getDescription();
            if (!projDesc.hasNature("org.eclipse.jdt.core.javanature")) {
                this.addJavaNature(project);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private void addJavaNature(IProject project) {
        try {
            IProjectDescription projectDesc = project.getDescription();
            projectDesc.setNatureIds(new String[]{"org.eclipse.jdt.core.javanature", "org.eclipse.wst.common.project.facet.core.nature"});
            project.setDescription(projectDesc, null);
            IJavaProject javaProj = JavaCore.create((IProject)project);
            IPath binPath = project.getFullPath().append(BIN_FOLDER);
            javaProj.setOutputLocation(binPath, null);
            SpringImplTypeAddAction.createFolder((IContainer)project, SOURCE_FOLDER);
            IClasspathEntry[] defEntries = this.createRawClasspath(project, SOURCE_FOLDER);
            javaProj.setRawClasspath(defEntries, null);
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private IClasspathEntry[] createRawClasspath(IProject project, String sourceEntry) {
        IClasspathEntry[] defEntries = new IClasspathEntry[]{JavaCore.newSourceEntry((IPath)project.getFullPath().append(sourceEntry))};
        IClasspathEntry jreEntry = JavaCore.newContainerEntry((IPath)new Path("org.eclipse.jdt.launching.JRE_CONTAINER"));
        IClasspathEntry[] jreEntries = new IClasspathEntry[]{jreEntry};
        IClasspathEntry[] newEntries = new IClasspathEntry[defEntries.length + jreEntries.length];
        System.arraycopy(defEntries, 0, newEntries, 0, defEntries.length);
        System.arraycopy(jreEntries, 0, newEntries, defEntries.length, jreEntries.length);
        return newEntries;
    }

    public static IFolder createFolder(IContainer container, String folderName) {
        IFolder folder = container.getFolder((IPath)new Path(folderName));
        if (!folder.exists()) {
            try {
                folder.create(true, true, null);
                return folder;
            }
            catch (CoreException ce) {
                ce.printStackTrace();
                return null;
            }
        }
        return folder;
    }
}

