/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.emf.jms.extensibility.ui;

import com.ibm.ccl.sca.composite.emf.jms.Messages;
import com.ibm.ccl.sca.composite.emf.sca.SCAPackage;
import com.ibm.ccl.sca.internal.ui.common.controls.emf.CellEditorsFactory;
import com.ibm.ccl.sca.internal.ui.common.controls.emf.TableControlWidget;
import com.ibm.ccl.sca.internal.ui.common.controls.emf.data.ContainerListener;
import com.ibm.ccl.sca.internal.ui.common.controls.emf.data.EMFCollectionContainer;
import com.ibm.ccl.sca.internal.ui.common.controls.emf.data.EMFContainer;
import com.ibm.ccl.sca.internal.ui.common.controls.emf.data.EMFReferenceContainer;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxViewerCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;

public class JMSPropertyTableControlWidget
extends TableControlWidget {
    private EMFCollectionContainer collection;
    private static final String[] propertyTypes = new String[]{"string", "byte", "short", "int", "long", "float", "double"};

    public JMSPropertyTableControlWidget(EMFCollectionContainer container) {
        super(container, new String[]{Messages.JMSBindingDetailsPropertiesPage_20, Messages.JMSBindingDetailsPropertiesPage_21, Messages.JMSBindingDetailsPropertiesPage_22}, new EAttribute[]{SCAPackage.eINSTANCE.getBindingProperty_Name(), SCAPackage.eINSTANCE.getBindingProperty_Type(), SCAPackage.eINSTANCE.getBindingProperty_Value()}, new int[]{60, 60, 200});
        this.collection = container;
        this.setCellEditorsFactory(new JMSCellFactory());
        this.setNewContainerListener(new ContainerListener(){

            public void notify(EMFContainer container) {
                JMSPropertyTableControlWidget.this.handleNewContainer(container);
            }
        });
    }

    private void handleNewContainer(EMFContainer container) {
        EMFReferenceContainer refContainer = (EMFReferenceContainer)container;
        String nextProp = this.findNextPopertyString();
        refContainer.setAttribute(SCAPackage.eINSTANCE.getBindingProperty_Name(), (Object)nextProp);
    }

    private String findNextPopertyString() {
        String propString;
        int propIndex = 1;
        String result = null;
        while (true) {
            propString = "prop" + propIndex;
            boolean foundProp = false;
            for (EObject child : this.collection.getChildren()) {
                String propName = (String)child.eGet((EStructuralFeature)SCAPackage.eINSTANCE.getBindingProperty_Name());
                if (!propName.equals(propString)) continue;
                foundProp = true;
                break;
            }
            if (!foundProp) break;
            ++propIndex;
        }
        result = propString;
        return result;
    }

    private class ComboContentProvider
    implements IStructuredContentProvider {
        private ComboContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            Object[] result = null;
            if (inputElement instanceof String[]) {
                result = (String[])inputElement;
            }
            return result;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class JMSCellFactory
    implements CellEditorsFactory {
        private JMSCellFactory() {
        }

        public CellEditor[] createCellEditors(Composite parent) {
            CellEditor[] cellEditors = new CellEditor[3];
            ComboBoxViewerCellEditor comboEditor = new ComboBoxViewerCellEditor(parent);
            cellEditors[0] = new TextCellEditor(parent);
            cellEditors[1] = comboEditor;
            cellEditors[2] = new TextCellEditor(parent);
            comboEditor.setLabelProvider((IBaseLabelProvider)new LabelProvider());
            comboEditor.setContenProvider((IStructuredContentProvider)new ComboContentProvider());
            comboEditor.setInput((Object)propertyTypes);
            return cellEditors;
        }
    }
}

