/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.ui.custom.extensibility.implementation.jee;

import com.ibm.ccl.sca.composite.emf.jee.impl.JEEImplActivator;
import com.ibm.ccl.sca.composite.ui.custom.util.ScaUtil;
import com.ibm.ccl.sca.core.util.PlatformUtil;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class JEEUtil {
    public static List<IProject> getJEE_EARsInWorkspace() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<IProject> result = new ArrayList<IProject>();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (JEEUtil.isAppProj(project)) {
                result.add(project);
            }
            ++n2;
        }
        return result;
    }

    public static boolean isValidEAR(String earName) {
        IProject earProj = ResourcesPlugin.getWorkspace().getRoot().getProject(earName);
        IProject thisProj = ScaUtil.getIFile().getProject();
        IProject[] refedProjs = null;
        boolean result = false;
        try {
            IProject[] iProjectArray = refedProjs = thisProj.getReferencedProjects();
            int n = refedProjs.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                if (project.getName().equals(earProj.getName())) {
                    result = true;
                    break;
                }
                ++n2;
            }
        }
        catch (CoreException exc) {
            JEEImplActivator.traceError((Exception)((Object)exc));
        }
        return result;
    }

    public static String[] getEARNamesInWorkspace() {
        List<IProject> earProjects = JEEUtil.getJEE_EARsInWorkspace();
        String[] earNames = new String[earProjects.size()];
        int index = 0;
        while (index < earNames.length) {
            earNames[index] = earProjects.get(index).getName();
            ++index;
        }
        return earNames;
    }

    public static IProject getProjectFromEObject(EObject rootObject) {
        Path rootPath = new Path(rootObject.eResource().getURI().toString());
        return PlatformUtil.getProjectFromResourcePath((IPath)rootPath);
    }

    public static boolean isEJBProj(IProject project) {
        IVirtualComponent projectComp = ComponentCore.createComponent((IProject)project);
        return projectComp != null && JavaEEProjectUtilities.isJEEComponent((IVirtualComponent)projectComp) && JavaEEProjectUtilities.isEJBComponent((IVirtualComponent)projectComp);
    }

    public static boolean isWebProj(IProject project) {
        IVirtualComponent projectComp = ComponentCore.createComponent((IProject)project);
        return projectComp != null && JavaEEProjectUtilities.isJEEComponent((IVirtualComponent)projectComp) && JavaEEProjectUtilities.isDynamicWebComponent((IVirtualComponent)projectComp);
    }

    public static boolean isAppProj(IProject project) {
        IVirtualComponent projectComp = ComponentCore.createComponent((IProject)project);
        return projectComp != null && JavaEEProjectUtilities.isJEEComponent((IVirtualComponent)projectComp) && JavaEEProjectUtilities.isEARProject((IProject)project);
    }
}

