/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.emf.jee.impl.tuscany;

import com.ibm.ccl.sca.composite.emf.jee.impl.JEEImplActivator;
import com.ibm.ccl.sca.composite.emf.jee.impl.Messages;
import com.ibm.ccl.sca.composite.emf.jee.impl.tuscany.SCAJEEImplementation;
import com.ibm.ccl.sca.core.model.ISCAArtifact;
import com.ibm.ccl.sca.core.model.ISCAArtifactResolver;
import com.ibm.ccl.sca.core.model.SCAModelResolver;
import com.ibm.ccl.sca.core.tracing.SCATrace;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.implementation.jee.JEEImplementation;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;

public class JEEImplementationResolver
implements ISCAArtifactResolver {
    private static final String TYPE_ID = "com.ibm.ccl.sca.jee.implementation.jee";
    private static final String TRACE_COMPONENT = "model/resolver/jee";
    private IProject parentProject;
    List<String> resolvedEARs = new ArrayList<String>();
    IStatus status = null;

    public JEEImplementationResolver(ISCAArtifact<?> context) {
        this(context.getParent());
    }

    public JEEImplementationResolver(IProject project) {
        this.parentProject = project;
    }

    public List<? extends ISCAArtifact<?>> resolve(Object modelObject, IProgressMonitor monitor) throws CoreException {
        String ear;
        this.status = Status.OK_STATUS;
        ArrayList<SCAJEEImplementation> artifacts = new ArrayList<SCAJEEImplementation>();
        String archive = ((JEEImplementation)modelObject).getArchive();
        if (archive == null || (archive = archive.trim()).length() == 0) {
            return artifacts;
        }
        if (archive.endsWith(".ear") && (ear = archive.substring(0, archive.length() - 4)).length() > 0) {
            IProject[] referencedProjects;
            if (this.resolvedEARs.contains(ear)) {
                return artifacts;
            }
            SCATrace.trace((Plugin)JEEImplActivator.getDefault(), (String)TRACE_COMPONENT, (int)2, (String)("Resolving archive: " + archive));
            IProject[] iProjectArray = referencedProjects = this.parentProject.getReferencedProjects();
            int n = referencedProjects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                if (project.getName().equals(ear) && JavaEEProjectUtilities.isEARProject((IProject)project)) {
                    SCATrace.trace((Plugin)JEEImplActivator.getDefault(), (String)TRACE_COMPONENT, (int)2, (String)("Found EAR project: " + project));
                    artifacts.add(new SCAJEEImplementation(project));
                    break;
                }
                ++n2;
            }
            this.resolvedEARs.add(ear);
        }
        if (artifacts.size() == 0) {
            SCAModelResolver.ResolutionStatus resolutionStatus = new SCAModelResolver.ResolutionStatus(4, Messages.bind((String)Messages.ERR_UNRESOLVED_EAR, (Object)archive), (Object)archive);
            resolutionStatus.setType(TYPE_ID);
            this.status = resolutionStatus;
        }
        SCATrace.trace((Plugin)JEEImplActivator.getDefault(), (String)TRACE_COMPONENT, (int)2, (String)("EAR projects found: " + artifacts.size()));
        return artifacts;
    }

    public List<? extends ISCAArtifact<?>> resolve(QName qname, IProgressMonitor monitor) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public IStatus getStatus() {
        return this.status;
    }
}

