/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.emf.jee.impl.reflection;

import com.ibm.ccl.sca.composite.emf.jee.impl.JEEImplActivator;
import com.ibm.ccl.sca.composite.emf.jee.impl.Messages;
import com.ibm.ccl.sca.composite.emf.jee.impl.tuscany.JEEImplementationResolver;
import com.ibm.ccl.sca.composite.emf.jee.impl.tuscany.SCAJEEImplementation;
import com.ibm.ccl.sca.core.model.ISCAArtifact;
import com.ibm.ccl.sca.core.model.ISCAComposite;
import com.ibm.ccl.sca.core.util.StatusUtil;
import com.ibm.ccl.sca.creation.core.extension.IExtensibleReflectImplementationCommand;
import com.ibm.ccl.sca.internal.creation.core.command.reflection.ReflectCompositeImplementationCommand;
import java.util.Collections;
import java.util.List;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ComponentProperty;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.implementation.jee.JEEImplementation;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;

public class ReflectJEEImplementationCommand
implements IExtensibleReflectImplementationCommand {
    private IProject project;
    private Component component;
    private List<ISCAArtifact<?>> resolvedArtifacts;
    private ReflectCompositeImplementationCommand command = null;

    public void setProject(IProject project) {
        this.project = project;
    }

    public void setComponent(Component component) {
        this.component = component;
    }

    public void setResolvedArtifacts(List<ISCAArtifact<?>> artifacts) {
        this.resolvedArtifacts = artifacts;
    }

    private ISCAArtifact<?> findArtifact(String archive) {
        for (ISCAArtifact<?> artifact : this.resolvedArtifacts) {
            if (!(artifact instanceof SCAJEEImplementation) || !(String.valueOf(artifact.getParent().getName()) + ".ear").equals(archive)) continue;
            return artifact;
        }
        return null;
    }

    private ISCAArtifact<?> resolveArtifact(JEEImplementation impl, IProgressMonitor monitor) {
        try {
            JEEImplementationResolver resolver = new JEEImplementationResolver(this.project);
            List<ISCAArtifact<?>> artifacts = resolver.resolve(impl, monitor);
            if (resolver.getStatus().isOK()) {
                return artifacts.get(0);
            }
        }
        catch (CoreException e) {
            JEEImplActivator.traceError((Exception)((Object)e));
        }
        return null;
    }

    private Composite getApplicationComposite(IResource resource) {
        Object adapted = resource.getAdapter(ISCAArtifact.class);
        if (adapted instanceof ISCAComposite) {
            try {
                return (Composite)((ISCAComposite)adapted).getModelObject();
            }
            catch (CoreException e) {
                JEEImplActivator.traceError((Exception)((Object)e));
            }
        }
        return null;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        JEEImplementation impl = (JEEImplementation)this.component.getImplementation();
        ISCAArtifact<?> artifact = null;
        if (this.resolvedArtifacts != null) {
            String archive = impl.getArchive();
            if (archive != null && (archive = archive.trim()).length() > 0) {
                artifact = this.findArtifact(archive);
            }
        } else {
            artifact = this.resolveArtifact(impl, monitor);
        }
        if (artifact == null) {
            return StatusUtil.errorStatus((String)Messages.ERR_CANNOT_LOAD_IMPL_FOR_REFLECTION);
        }
        IResource resource = (IResource)artifact.getResources().get(1);
        if (!resource.exists()) {
            return StatusUtil.errorStatus((String)Messages.ERR_CANNOT_LOAD_IMPL_FOR_REFLECTION);
        }
        Composite composite = this.getApplicationComposite(resource);
        if (composite == null) {
            return StatusUtil.errorStatus((String)Messages.ERR_CANNOT_LOAD_IMPL_FOR_REFLECTION);
        }
        this.command = new ReflectCompositeImplementationCommand(composite);
        return this.command.execute(monitor, info);
    }

    public List<ComponentService> getServices() {
        if (this.command == null) {
            return Collections.emptyList();
        }
        return this.command.getServices();
    }

    public List<ComponentReference> getReferences() {
        if (this.command == null) {
            return Collections.emptyList();
        }
        return this.command.getReferences();
    }

    public List<ComponentProperty> getProperties() {
        if (this.command == null) {
            return Collections.emptyList();
        }
        return this.command.getProperties();
    }
}

