/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.emf.ejb.extensiblity.ui;

import com.ibm.ccl.sca.composite.emf.ejb.EJBSessionBeanBinding;

public class EJBURIProcessor {
    private EJBSessionBeanBinding binding;
    private String hostName = "";
    private String port = "";
    private String keyString = "";
    private String pathToHome = "";

    public static String getURIString(String hostName, String port, String keyString, String pathToHome) {
        if (hostName.equals("") && port.equals("") && keyString.equals("")) {
            return "corbaname:iiop:#" + pathToHome;
        }
        return "corbaname:iiop:" + hostName + ":" + port + "/" + keyString + "#" + pathToHome;
    }

    public EJBURIProcessor(EJBSessionBeanBinding binding) {
        this.binding = binding;
    }

    public boolean process() {
        if (this.binding == null) {
            return false;
        }
        this.hostName = "";
        this.port = "";
        this.keyString = "";
        this.pathToHome = "";
        String string = this.binding.getUri();
        if (string == null) {
            return false;
        }
        if (string.startsWith("corbaname:iiop:")) {
            int endFormatProtocolIndex = "corbaname:iiop:".length() - 1;
            int sepIndex = string.indexOf("#");
            if (sepIndex > endFormatProtocolIndex) {
                String hostPortKeyString = string.substring(endFormatProtocolIndex + 1, sepIndex);
                this.processHostPortKeyString(hostPortKeyString);
                this.pathToHome = string.substring(sepIndex + 1, string.length());
            }
            return true;
        }
        return false;
    }

    private boolean processHostPortKeyString(String string) {
        int colonIndex = string.indexOf(":");
        if (colonIndex > -1) {
            this.hostName = string.substring(0, colonIndex);
            int slashIndex = string.indexOf("/");
            if (slashIndex > colonIndex + 1) {
                this.port = string.substring(colonIndex + 1, slashIndex);
            }
            if (slashIndex + 1 < string.length()) {
                this.keyString = string.substring(slashIndex + 1, string.length());
            }
            return true;
        }
        return false;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getPort() {
        return this.port;
    }

    public String getKeyString() {
        return this.keyString;
    }

    public String getPathToHome() {
        return this.pathToHome;
    }
}

