/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.emf.ejb.extensiblity.ui;

import com.ibm.ccl.sca.composite.emf.ejb.EJBSessionBeanBinding;
import com.ibm.ccl.sca.composite.emf.ejb.Messages;
import com.ibm.ccl.sca.composite.emf.ejb.extensiblity.ui.EJBLinkNameProcessor;
import com.ibm.ccl.sca.composite.emf.ejb.extensiblity.ui.EJBURIProcessor;
import com.ibm.ccl.sca.composite.emf.ejb.extensiblity.ui.actions.EditBindingEJBURIAction;
import com.ibm.ccl.sca.composite.emf.ejb.extensiblity.ui.actions.EditBindingLinkNameAction;
import com.ibm.ccl.sca.composite.ui.custom.actions.SCABaseAction;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class EJBNameServiceControls {
    private EJBSessionBeanBinding ejbBinding;
    private Label ejbLinkName;
    private Label uriName;
    private Label linkJarNameLabel;
    private Label linkNameLabel;
    private Label uriHostNameLabel;
    private Label uriPortLabel;
    private Label uriKeyStringLabel;
    private Label uriPathToHomeLabel;
    private Text linkJarNameText;
    private Text linkNameText;
    private Text uriHostNameText;
    private Text uriPortText;
    private Text uriKeyStringText;
    private Text uriPathToHomeText;
    private Button defaultCheckBox;
    private Label previewLabel;
    private Text previewText;
    private Composite client;
    private FormToolkit toolkit;
    private EJBDetailsCustomListener textListener = new EJBDetailsCustomListener();
    private EJBButtonListener buttonListener = new EJBButtonListener();
    private EJBPreviewListener previewListener = new EJBPreviewListener();

    public EJBNameServiceControls(Composite client, FormToolkit toolkit) {
        this.client = client;
        this.toolkit = toolkit;
    }

    public void dispose() {
    }

    protected IWorkbenchPart getWorkbenchPart() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
    }

    public void setEJBBinding(EJBSessionBeanBinding binding) {
        this.ejbBinding = binding;
    }

    public void createControls() {
        this.defaultCheckBox = this.toolkit.createButton(this.client, Messages.LABEL_DEFAULT_EJB, 32);
        this.defaultCheckBox.setSelection(false);
        this.defaultCheckBox.addSelectionListener((SelectionListener)this.buttonListener);
        this.toolkit.createLabel(this.client, "");
        Composite ejbComposite = this.toolkit.createComposite(this.client);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        ejbComposite.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        gd.horizontalIndent = 10;
        ejbComposite.setLayoutData((Object)gd);
        this.ejbLinkName = this.toolkit.createLabel(ejbComposite, Messages.LABEL_EJB_LINK_NAME);
        GridData labelGridData = new GridData();
        labelGridData.horizontalSpan = 2;
        this.ejbLinkName.setLayoutData((Object)labelGridData);
        String indent = "   ";
        this.linkJarNameLabel = this.toolkit.createLabel(ejbComposite, String.valueOf(indent) + Messages.LABEL_JAR);
        this.linkJarNameText = this.toolkit.createText(ejbComposite, "", 4);
        gd = new GridData(770);
        gd.widthHint = 10;
        this.linkJarNameText.setLayoutData((Object)gd);
        this.linkNameLabel = this.toolkit.createLabel(ejbComposite, String.valueOf(indent) + Messages.LABEL_NAME);
        this.linkNameText = this.toolkit.createText(ejbComposite, "", 4);
        gd = new GridData(770);
        gd.widthHint = 10;
        this.linkNameText.setLayoutData((Object)gd);
        this.uriName = this.toolkit.createLabel(ejbComposite, Messages.LABEL_URI);
        labelGridData = new GridData();
        labelGridData.horizontalSpan = 2;
        this.uriName.setLayoutData((Object)labelGridData);
        this.uriHostNameLabel = this.toolkit.createLabel(ejbComposite, String.valueOf(indent) + Messages.LABEL_HOSTNAME);
        this.uriHostNameText = this.toolkit.createText(ejbComposite, "", 4);
        gd = new GridData(770);
        gd.widthHint = 10;
        this.uriHostNameText.setLayoutData((Object)gd);
        this.uriPortLabel = this.toolkit.createLabel(ejbComposite, String.valueOf(indent) + Messages.LABEL_PORT);
        this.uriPortText = this.toolkit.createText(ejbComposite, "", 4);
        gd = new GridData(770);
        gd.widthHint = 10;
        this.uriPortText.setLayoutData((Object)gd);
        this.uriKeyStringLabel = this.toolkit.createLabel(ejbComposite, String.valueOf(indent) + Messages.LABEL_KEY_STRING);
        this.uriKeyStringText = this.toolkit.createText(ejbComposite, "", 4);
        gd = new GridData(770);
        gd.widthHint = 10;
        this.uriKeyStringText.setLayoutData((Object)gd);
        this.uriPathToHomeLabel = this.toolkit.createLabel(ejbComposite, String.valueOf(indent) + Messages.LABEL_PATH_TO_HOME);
        this.uriPathToHomeText = this.toolkit.createText(ejbComposite, "", 4);
        gd = new GridData(770);
        gd.widthHint = 10;
        this.uriPathToHomeText.setLayoutData((Object)gd);
        this.previewLabel = this.toolkit.createLabel(ejbComposite, String.valueOf(indent) + Messages.LABEL_URI_PREVIEW);
        this.toolkit.createLabel(ejbComposite, "");
        this.previewText = this.toolkit.createText(ejbComposite, "", 578);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.heightHint = 70;
        gd.horizontalIndent = 10;
        this.previewText.setLayoutData((Object)gd);
        ejbComposite.setTabList(new Control[]{this.ejbLinkName, this.linkJarNameText, this.linkNameText, this.uriName, this.uriHostNameText, this.uriPortText, this.uriKeyStringText, this.uriPathToHomeText, this.previewText});
        this.toolkit.paintBordersFor(ejbComposite);
        this.addAllListeners();
    }

    private void handlePreviewChanged() {
        EditBindingEJBURIAction action = new EditBindingEJBURIAction(this.getWorkbenchPart(), this.ejbBinding, this.previewText.getText());
        action.run();
    }

    public void initializeControls() {
        this.refresh();
    }

    public void refresh() {
        this.removeAllListeners();
        this.previewText.setText("");
        EJBLinkNameProcessor linkProcessor = new EJBLinkNameProcessor(this.ejbBinding);
        boolean linkProcessSuccess = linkProcessor.process();
        if (linkProcessSuccess) {
            this.linkJarNameText.setText(linkProcessor.getJarName());
            this.linkNameText.setText(linkProcessor.getName());
        } else {
            this.linkJarNameText.setText("");
            this.linkNameText.setText("");
        }
        EJBURIProcessor uriProcessor = new EJBURIProcessor(this.ejbBinding);
        boolean uriProcessSuccess = uriProcessor.process();
        if (uriProcessSuccess) {
            this.uriHostNameText.setText(uriProcessor.getHostName());
            this.uriPortText.setText(uriProcessor.getPort());
            this.uriKeyStringText.setText(uriProcessor.getKeyString());
            this.uriPathToHomeText.setText(uriProcessor.getPathToHome());
        } else {
            this.uriHostNameText.setText("");
            this.uriPortText.setText("");
            this.uriKeyStringText.setText("");
            this.uriPathToHomeText.setText("");
        }
        this.refreshPreviewString();
        if (this.uriFieldsEmpty() && this.ejbLinkFieldsEmpty()) {
            this.defaultCheckBox.setSelection(true);
            this.toggleEnableNameAndURIControls(false);
        } else {
            this.defaultCheckBox.setSelection(false);
            this.toggleEnableNameAndURIControls(true);
        }
        this.addAllListeners();
    }

    private void refreshPreviewString() {
        if (this.ejbBinding != null) {
            String previewString = this.ejbBinding.getUri();
            if (previewString == null) {
                previewString = "";
            }
            this.previewText.setText(previewString);
        }
    }

    private void applyEJBLinkNameValue() {
        String completeString = EJBLinkNameProcessor.getEJBLinkNameString(this.linkJarNameText.getText(), this.linkNameText.getText());
        boolean update = true;
        if (this.ejbBinding.getEjbLinkName() == null) {
            if (this.ejbLinkFieldsEmpty()) {
                update = false;
            }
        } else if (this.ejbBinding.getEjbLinkName().equals(completeString)) {
            update = false;
        }
        if (update) {
            EditBindingLinkNameAction action = new EditBindingLinkNameAction(this.getWorkbenchPart(), this.ejbBinding, completeString);
            action.run();
        }
    }

    private void applyURIValue() {
        String hostName = this.uriHostNameText.getText().trim();
        String port = this.uriPortText.getText().trim();
        String keyString = this.uriKeyStringText.getText().trim();
        String pathToHome = this.uriPathToHomeText.getText().trim();
        String completeString = EJBURIProcessor.getURIString(hostName, port, keyString, pathToHome);
        String currentURI = this.ejbBinding.getUri();
        boolean update = true;
        if (currentURI == null) {
            if (this.uriFieldsEmpty()) {
                update = false;
            }
        } else if (currentURI.equals(completeString)) {
            update = false;
        }
        if (update) {
            EditBindingEJBURIAction action = new EditBindingEJBURIAction(this.getWorkbenchPart(), this.ejbBinding, completeString);
            action.run();
        }
    }

    private boolean ejbLinkFieldsEmpty() {
        if (!this.linkJarNameText.getText().equals("")) {
            return false;
        }
        return this.linkNameText.getText().equals("");
    }

    private boolean uriFieldsEmpty() {
        if (!this.uriHostNameText.getText().equals("")) {
            return false;
        }
        if (!this.uriPortText.getText().equals("")) {
            return false;
        }
        if (!this.uriKeyStringText.getText().equals("")) {
            return false;
        }
        return this.uriPathToHomeText.getText().equals("");
    }

    private void toggleEnableNameAndURIControls(boolean enable) {
        this.ejbLinkName.setEnabled(enable);
        this.uriName.setEnabled(enable);
        this.previewLabel.setEnabled(enable);
        this.previewText.setEnabled(enable);
        this.linkJarNameLabel.setEnabled(enable);
        this.linkNameLabel.setEnabled(enable);
        this.uriHostNameLabel.setEnabled(enable);
        this.uriPortLabel.setEnabled(enable);
        this.uriKeyStringLabel.setEnabled(enable);
        this.uriPathToHomeLabel.setEnabled(enable);
        this.linkJarNameText.setEnabled(enable);
        this.linkNameText.setEnabled(enable);
        this.uriHostNameText.setEnabled(enable);
        this.uriPortText.setEnabled(enable);
        this.uriKeyStringText.setEnabled(enable);
        this.uriPathToHomeText.setEnabled(enable);
    }

    public void addAllListeners() {
        this.previewText.addModifyListener((ModifyListener)this.previewListener);
        this.addListeners(this.linkJarNameText);
        this.addListeners(this.linkNameText);
        this.addListeners(this.uriHostNameText);
        this.addListeners(this.uriPortText);
        this.addListeners(this.uriKeyStringText);
        this.addListeners(this.uriPathToHomeText);
    }

    public void removeAllListeners() {
        this.previewText.removeModifyListener((ModifyListener)this.previewListener);
        this.removeListeners(this.linkJarNameText);
        this.removeListeners(this.linkNameText);
        this.removeListeners(this.uriHostNameText);
        this.removeListeners(this.uriPortText);
        this.removeListeners(this.uriKeyStringText);
        this.removeListeners(this.uriPathToHomeText);
    }

    private void addListeners(Text control) {
        control.addModifyListener((ModifyListener)this.textListener);
    }

    private void removeListeners(Text control) {
        control.removeModifyListener((ModifyListener)this.textListener);
    }

    private class EJBButtonListener
    implements SelectionListener {
        private EJBButtonListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.widget == EJBNameServiceControls.this.defaultCheckBox) {
                if (EJBNameServiceControls.this.defaultCheckBox.getSelection()) {
                    EJBNameServiceControls.this.toggleEnableNameAndURIControls(false);
                    SCABaseAction action = new EditBindingLinkNameAction(EJBNameServiceControls.this.getWorkbenchPart(), EJBNameServiceControls.this.ejbBinding, null);
                    action.run();
                    action = new EditBindingEJBURIAction(EJBNameServiceControls.this.getWorkbenchPart(), EJBNameServiceControls.this.ejbBinding, null);
                    action.run();
                } else {
                    EJBNameServiceControls.this.toggleEnableNameAndURIControls(true);
                    EJBNameServiceControls.this.applyEJBLinkNameValue();
                    EJBNameServiceControls.this.applyURIValue();
                }
                EJBNameServiceControls.this.refreshPreviewString();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    private class EJBDetailsCustomListener
    implements ModifyListener {
        private EJBDetailsCustomListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (e.widget == EJBNameServiceControls.this.linkJarNameText && !EJBNameServiceControls.this.linkJarNameText.isDisposed()) {
                EJBNameServiceControls.this.applyEJBLinkNameValue();
            } else if (e.widget == EJBNameServiceControls.this.linkNameText && !EJBNameServiceControls.this.linkNameText.isDisposed()) {
                EJBNameServiceControls.this.applyEJBLinkNameValue();
            } else if (e.widget == EJBNameServiceControls.this.uriHostNameText && !EJBNameServiceControls.this.uriHostNameText.isDisposed()) {
                EJBNameServiceControls.this.applyURIValue();
                EJBNameServiceControls.this.refreshPreviewString();
            } else if (e.widget == EJBNameServiceControls.this.uriPortText && !EJBNameServiceControls.this.uriPortText.isDisposed()) {
                EJBNameServiceControls.this.applyURIValue();
                EJBNameServiceControls.this.refreshPreviewString();
            } else if (e.widget == EJBNameServiceControls.this.uriKeyStringText && !EJBNameServiceControls.this.uriKeyStringText.isDisposed()) {
                EJBNameServiceControls.this.applyURIValue();
                EJBNameServiceControls.this.refreshPreviewString();
            } else if (e.widget == EJBNameServiceControls.this.uriPathToHomeText && !EJBNameServiceControls.this.uriPathToHomeText.isDisposed()) {
                EJBNameServiceControls.this.applyURIValue();
                EJBNameServiceControls.this.refreshPreviewString();
            }
        }
    }

    private class EJBPreviewListener
    implements ModifyListener {
        private EJBPreviewListener() {
        }

        public void modifyText(ModifyEvent e) {
            EJBNameServiceControls.this.handlePreviewChanged();
        }
    }
}

