/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.emf.ejb.extensiblity.ui;

import com.ibm.ccl.sca.composite.emf.ejb.EJBSessionBeanBinding;
import com.ibm.ccl.sca.composite.emf.ejb.Messages;
import com.ibm.ccl.sca.composite.emf.ejb.extensiblity.ui.EJBLinkNameProcessor;
import com.ibm.ccl.sca.composite.emf.ejb.extensiblity.ui.EJBURIProcessor;
import com.ibm.ccl.sca.composite.emf.ejb.extensiblity.ui.actions.EditBindingEJBURIAction;
import com.ibm.ccl.sca.composite.emf.ejb.extensiblity.ui.actions.EditBindingLinkNameAction;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class EJBNameReferenceControls {
    private EJBSessionBeanBinding ejbBinding;
    private Label linkJarNameLabel;
    private Label linkNameLabel;
    private Text linkJarNameText;
    private Text linkNameText;
    private Button uriRadioButton;
    private Button linkNameRadioButton;
    private Label uriHostNameLabel;
    private Label uriPortLabel;
    private Label uriKeyStringLabel;
    private Label uriPathToHomeLabel;
    private Text uriHostNameText;
    private Text uriPortText;
    private Text uriKeyStringText;
    private Text uriPathToHomeText;
    private Label previewLabel;
    private Text previewText;
    private Composite client;
    private FormToolkit toolkit;
    private EJBDetailsCustomListener textListener = new EJBDetailsCustomListener();
    private EJBSelectionListener selectionListener = new EJBSelectionListener();
    private EJBPreviewListener previewListener = new EJBPreviewListener();

    public EJBNameReferenceControls(Composite client, FormToolkit toolkit) {
        this.client = client;
        this.toolkit = toolkit;
    }

    public void dispose() {
    }

    protected IWorkbenchPart getWorkbenchPart() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
    }

    public void setEJBBinding(EJBSessionBeanBinding binding) {
        this.ejbBinding = binding;
    }

    public void createControls() {
        this.linkNameRadioButton = this.toolkit.createButton(this.client, Messages.LABEL_EJB_LINK_NAME, 16);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        this.linkNameRadioButton.setLayoutData((Object)gd);
        String indent = "   ";
        this.linkJarNameLabel = this.toolkit.createLabel(this.client, String.valueOf(indent) + Messages.LABEL_JAR);
        this.linkJarNameText = this.toolkit.createText(this.client, "", 4);
        gd = new GridData(770);
        gd.widthHint = 10;
        this.linkJarNameText.setLayoutData((Object)gd);
        this.linkNameLabel = this.toolkit.createLabel(this.client, String.valueOf(indent) + Messages.LABEL_NAME);
        this.linkNameText = this.toolkit.createText(this.client, "", 4);
        gd = new GridData(770);
        gd.widthHint = 10;
        this.linkNameText.setLayoutData((Object)gd);
        this.uriRadioButton = this.toolkit.createButton(this.client, Messages.LABEL_URI, 16);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.uriRadioButton.setLayoutData((Object)gd);
        this.uriHostNameLabel = this.toolkit.createLabel(this.client, String.valueOf(indent) + Messages.LABEL_HOSTNAME);
        this.uriHostNameText = this.toolkit.createText(this.client, "", 4);
        gd = new GridData(770);
        gd.widthHint = 10;
        this.uriHostNameText.setLayoutData((Object)gd);
        this.uriPortLabel = this.toolkit.createLabel(this.client, String.valueOf(indent) + Messages.LABEL_PORT);
        this.uriPortText = this.toolkit.createText(this.client, "", 4);
        gd = new GridData(770);
        gd.widthHint = 10;
        this.uriPortText.setLayoutData((Object)gd);
        this.uriKeyStringLabel = this.toolkit.createLabel(this.client, String.valueOf(indent) + Messages.LABEL_KEY_STRING);
        this.uriKeyStringText = this.toolkit.createText(this.client, "", 4);
        gd = new GridData(770);
        gd.widthHint = 10;
        this.uriKeyStringText.setLayoutData((Object)gd);
        this.uriPathToHomeLabel = this.toolkit.createLabel(this.client, String.valueOf(indent) + Messages.LABEL_PATH_TO_HOME);
        this.uriPathToHomeText = this.toolkit.createText(this.client, "", 4);
        gd = new GridData(770);
        gd.widthHint = 10;
        this.uriPathToHomeText.setLayoutData((Object)gd);
        this.previewLabel = this.toolkit.createLabel(this.client, String.valueOf(indent) + Messages.LABEL_URI_PREVIEW);
        this.toolkit.createLabel(this.client, "");
        this.previewText = this.toolkit.createText(this.client, "", 578);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.heightHint = 70;
        gd.horizontalIndent = 10;
        this.previewText.setLayoutData((Object)gd);
    }

    private void handlePreviewChanged() {
        EditBindingEJBURIAction action = new EditBindingEJBURIAction(this.getWorkbenchPart(), this.ejbBinding, this.previewText.getText());
        action.run();
    }

    public void initializeControls() {
        this.removeAllListeners();
        boolean selectLink = false;
        EJBLinkNameProcessor linkProcessor = new EJBLinkNameProcessor(this.ejbBinding);
        boolean linkProcessSuccess = linkProcessor.process();
        EJBURIProcessor uriProcessor = new EJBURIProcessor(this.ejbBinding);
        boolean uriProcessSuccess = uriProcessor.process();
        if (linkProcessSuccess && !uriProcessSuccess) {
            selectLink = true;
        }
        if (selectLink) {
            this.linkNameRadioButton.setSelection(true);
            this.uriRadioButton.setSelection(false);
            this.enableURIControls(false);
        } else {
            this.linkNameRadioButton.setSelection(false);
            this.uriRadioButton.setSelection(true);
            this.enableURIControls(true);
        }
        this.refresh();
        this.addAllListeners();
    }

    public void refresh() {
        this.removeAllListeners();
        EJBLinkNameProcessor linkProcessor = new EJBLinkNameProcessor(this.ejbBinding);
        boolean linkProcessSuccess = linkProcessor.process();
        if (linkProcessSuccess) {
            this.linkJarNameText.setText(linkProcessor.getJarName());
            this.linkNameText.setText(linkProcessor.getName());
        } else {
            this.linkJarNameText.setText("");
            this.linkNameText.setText("");
        }
        EJBURIProcessor uriProcessor = new EJBURIProcessor(this.ejbBinding);
        boolean uriProcessSuccess = uriProcessor.process();
        if (uriProcessSuccess) {
            this.uriHostNameText.setText(uriProcessor.getHostName());
            this.uriPortText.setText(uriProcessor.getPort());
            this.uriKeyStringText.setText(uriProcessor.getKeyString());
            this.uriPathToHomeText.setText(uriProcessor.getPathToHome());
        } else {
            this.uriHostNameText.setText("");
            this.uriPortText.setText("");
            this.uriKeyStringText.setText("");
            this.uriPathToHomeText.setText("");
        }
        this.refreshPreviewString();
        this.addAllListeners();
    }

    private void enableURIControls(boolean enable) {
        this.previewLabel.setEnabled(enable);
        this.previewText.setEnabled(enable);
        this.uriHostNameLabel.setEnabled(enable);
        this.uriPortLabel.setEnabled(enable);
        this.uriKeyStringLabel.setEnabled(enable);
        this.uriPathToHomeLabel.setEnabled(enable);
        this.uriHostNameText.setEnabled(enable);
        this.uriPortText.setEnabled(enable);
        this.uriKeyStringText.setEnabled(enable);
        this.uriPathToHomeText.setEnabled(enable);
        this.linkJarNameLabel.setEnabled(!enable);
        this.linkNameLabel.setEnabled(!enable);
        this.linkJarNameText.setEnabled(!enable);
        this.linkNameText.setEnabled(!enable);
    }

    private void refreshPreviewString() {
        if (this.ejbBinding != null) {
            String previewString = this.ejbBinding.getUri();
            if (previewString == null) {
                previewString = "";
            }
            this.previewText.setText(previewString);
        }
    }

    private void applyEJBLinkNameValue() {
        String completeString = EJBLinkNameProcessor.getEJBLinkNameString(this.linkJarNameText.getText(), this.linkNameText.getText());
        boolean update = true;
        if (this.ejbBinding.getEjbLinkName() == null) {
            if (this.ejbLinkFieldsEmpty()) {
                update = false;
            }
        } else if (this.ejbBinding.getEjbLinkName().equals(completeString)) {
            update = false;
        }
        if (update) {
            EditBindingLinkNameAction action = new EditBindingLinkNameAction(this.getWorkbenchPart(), this.ejbBinding, completeString);
            action.run();
        }
    }

    private void applyURIValue() {
        String hostName = this.uriHostNameText.getText().trim();
        String port = this.uriPortText.getText().trim();
        String keyString = this.uriKeyStringText.getText().trim();
        String pathToHome = this.uriPathToHomeText.getText().trim();
        String completeString = EJBURIProcessor.getURIString(hostName, port, keyString, pathToHome);
        String currentURI = this.ejbBinding.getUri();
        boolean update = true;
        if (currentURI == null) {
            if (this.uriFieldsEmpty()) {
                update = false;
            }
        } else if (currentURI.equals(completeString)) {
            update = false;
        }
        if (update) {
            EditBindingEJBURIAction action = new EditBindingEJBURIAction(this.getWorkbenchPart(), this.ejbBinding, completeString);
            action.run();
            this.refreshPreviewString();
        }
    }

    private boolean ejbLinkFieldsEmpty() {
        if (!this.linkJarNameText.getText().equals("")) {
            return false;
        }
        return this.linkNameText.getText().equals("");
    }

    private boolean uriFieldsEmpty() {
        if (!this.uriHostNameText.getText().equals("")) {
            return false;
        }
        if (!this.uriPortText.getText().equals("")) {
            return false;
        }
        if (!this.uriKeyStringText.getText().equals("")) {
            return false;
        }
        return this.uriPathToHomeText.getText().equals("");
    }

    public void addAllListeners() {
        this.previewText.addModifyListener((ModifyListener)this.previewListener);
        this.uriRadioButton.addSelectionListener((SelectionListener)this.selectionListener);
        this.linkNameRadioButton.addSelectionListener((SelectionListener)this.selectionListener);
        this.addListeners(this.linkJarNameText);
        this.addListeners(this.linkNameText);
        this.addListeners(this.uriHostNameText);
        this.addListeners(this.uriPortText);
        this.addListeners(this.uriKeyStringText);
        this.addListeners(this.uriPathToHomeText);
    }

    public void removeAllListeners() {
        this.previewText.removeModifyListener((ModifyListener)this.previewListener);
        this.uriRadioButton.removeSelectionListener((SelectionListener)this.selectionListener);
        this.linkNameRadioButton.removeSelectionListener((SelectionListener)this.selectionListener);
        this.removeListeners(this.linkJarNameText);
        this.removeListeners(this.linkNameText);
        this.removeListeners(this.uriHostNameText);
        this.removeListeners(this.uriPortText);
        this.removeListeners(this.uriKeyStringText);
        this.removeListeners(this.uriPathToHomeText);
    }

    private void addListeners(Text control) {
        control.addModifyListener((ModifyListener)this.textListener);
    }

    private void removeListeners(Text control) {
        control.removeModifyListener((ModifyListener)this.textListener);
    }

    private class EJBDetailsCustomListener
    implements ModifyListener {
        private EJBDetailsCustomListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (e.widget == EJBNameReferenceControls.this.linkJarNameText && !EJBNameReferenceControls.this.linkJarNameText.isDisposed()) {
                EJBNameReferenceControls.this.applyEJBLinkNameValue();
            } else if (e.widget == EJBNameReferenceControls.this.linkNameText && !EJBNameReferenceControls.this.linkNameText.isDisposed()) {
                EJBNameReferenceControls.this.applyEJBLinkNameValue();
            } else if (e.widget == EJBNameReferenceControls.this.uriHostNameText && !EJBNameReferenceControls.this.uriHostNameText.isDisposed()) {
                EJBNameReferenceControls.this.applyURIValue();
            } else if (e.widget == EJBNameReferenceControls.this.uriPortText && !EJBNameReferenceControls.this.uriPortText.isDisposed()) {
                EJBNameReferenceControls.this.applyURIValue();
            } else if (e.widget == EJBNameReferenceControls.this.uriKeyStringText && !EJBNameReferenceControls.this.uriKeyStringText.isDisposed()) {
                EJBNameReferenceControls.this.applyURIValue();
            } else if (e.widget == EJBNameReferenceControls.this.uriPathToHomeText && !EJBNameReferenceControls.this.uriPathToHomeText.isDisposed()) {
                EJBNameReferenceControls.this.applyURIValue();
            }
        }
    }

    private class EJBPreviewListener
    implements ModifyListener {
        private EJBPreviewListener() {
        }

        public void modifyText(ModifyEvent e) {
            EJBNameReferenceControls.this.handlePreviewChanged();
        }
    }

    private class EJBSelectionListener
    extends SelectionAdapter {
        private EJBSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (EJBNameReferenceControls.this.linkNameRadioButton.getSelection()) {
                EJBNameReferenceControls.this.applyEJBLinkNameValue();
                EditBindingEJBURIAction action = new EditBindingEJBURIAction(EJBNameReferenceControls.this.getWorkbenchPart(), EJBNameReferenceControls.this.ejbBinding, null);
                action.run();
                EJBNameReferenceControls.this.enableURIControls(false);
            } else if (EJBNameReferenceControls.this.uriRadioButton.getSelection()) {
                EJBNameReferenceControls.this.applyURIValue();
                EditBindingLinkNameAction action = new EditBindingLinkNameAction(EJBNameReferenceControls.this.getWorkbenchPart(), EJBNameReferenceControls.this.ejbBinding, null);
                action.run();
                EJBNameReferenceControls.this.enableURIControls(true);
            }
            EJBNameReferenceControls.this.refreshPreviewString();
        }
    }
}

