/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.emf.ejb.extensiblity.ui;

import com.ibm.ccl.sca.composite.emf.ejb.BeanType;
import com.ibm.ccl.sca.composite.emf.ejb.EJBSessionBeanBinding;
import com.ibm.ccl.sca.composite.emf.ejb.Messages;
import com.ibm.ccl.sca.composite.emf.ejb.VersionValue;
import com.ibm.ccl.sca.composite.emf.ejb.extensiblity.ui.EJBNameReferenceControls;
import com.ibm.ccl.sca.composite.emf.ejb.extensiblity.ui.EJBNameServiceControls;
import com.ibm.ccl.sca.composite.emf.ejb.extensiblity.ui.actions.EditBindingHomeInterfaceAction;
import com.ibm.ccl.sca.composite.emf.ejb.extensiblity.ui.actions.EditBindingSessionTypeAction;
import com.ibm.ccl.sca.composite.emf.ejb.extensiblity.ui.actions.EditBindingVersionAction;
import com.ibm.ccl.sca.composite.emf.sca.ComponentReference;
import com.ibm.ccl.sca.composite.emf.sca.Reference;
import com.ibm.ccl.sca.composite.ui.custom.extensibility.binding.base.controls.DelayedTextModifyListener;
import com.ibm.ccl.sca.composite.ui.custom.extensibility.binding.sca.SCABindingDetailsPropertiesPage;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.widgets.ScrolledPageBook;

public class EJBBindingDetailsPropertiesPage
extends SCABindingDetailsPropertiesPage {
    private Label homeInterfaceLabel;
    private Text homeInterfaceText;
    private CCombo sessionTypeCombo;
    private Label ejbVersionComboLabel;
    private CCombo ejbVersionCombo;
    private ScrolledPageBook ejbPageBook;
    private EJBNameServiceControls serviceControls;
    private EJBNameReferenceControls referenceControls;
    private boolean uriAndLinkMExclusive = false;
    private EJBDetailsCustomListener textListener = new EJBDetailsCustomListener();
    private EJBSelectionListener selectionListener = new EJBSelectionListener();
    private Map<String, String> stateMap = new HashMap<String, String>();
    Composite ejbClient;

    public EJBBindingDetailsPropertiesPage() {
        for (BeanType beanType : BeanType.VALUES) {
            String literal = beanType.getLiteral();
            if (literal.equals("stateless")) {
                this.stateMap.put(Messages.LABEL_EJB_BINDING_STATELESS, literal);
                continue;
            }
            if (!literal.equals("stateful")) continue;
            this.stateMap.put(Messages.LABEL_EJB_BINDING_STATEFUL, literal);
        }
    }

    public boolean setFormInput(Object input) {
        this.uriAndLinkMExclusive = input instanceof Reference || input instanceof ComponentReference;
        return super.setFormInput(input);
    }

    public void dispose() {
        if (this.serviceControls != null) {
            this.serviceControls.dispose();
        }
        if (this.referenceControls != null) {
            this.referenceControls.dispose();
        }
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        super.selectionChanged(part, selection);
        this.serviceControls.setEJBBinding((EJBSessionBeanBinding)this.binding);
        this.referenceControls.setEJBBinding((EJBSessionBeanBinding)this.binding);
        this.serviceControls.initializeControls();
        this.referenceControls.initializeControls();
    }

    protected void doCreateContents(Composite parent) {
        this.createNameAndIdentitySection(parent);
        this.createPolicySetsAndIntentsSection(parent);
        this.addAllListeners();
    }

    protected void createEJBSection(Composite parent) {
        Composite client = this.createNewSection(parent, Messages.LABEL_EJB_CONFIG, SECTION_STYLE, 2);
        this.toolkit.createLabel(client, Messages.LABEL_HOME_INTF);
        this.homeInterfaceText = this.toolkit.createText(client, "", 4);
        GridData gd = new GridData(770);
        this.homeInterfaceText.setLayoutData((Object)gd);
        this.toolkit.createLabel(client, Messages.LABEL_SESSION_TYPE);
        this.sessionTypeCombo = this.createCCombo(client, 0x800000);
        this.sessionTypeCombo.setEditable(false);
        gd = new GridData(770);
        this.sessionTypeCombo.setLayoutData((Object)gd);
        Iterator<String> stateIt = this.stateMap.keySet().iterator();
        while (stateIt.hasNext()) {
            this.sessionTypeCombo.add(stateIt.next());
        }
        this.sessionTypeCombo.select(0);
        this.toolkit.createLabel(client, Messages.LABEL_EJB_VERSION);
        this.ejbVersionCombo = this.createCCombo(client, 0x800000);
        this.ejbVersionCombo.setEditable(false);
        gd = new GridData(770);
        gd.widthHint = 10;
        this.ejbVersionCombo.setLayoutData((Object)gd);
        for (VersionValue value : VersionValue.VALUES) {
            this.ejbVersionCombo.add(value.getName());
        }
        this.ejbVersionCombo.select(0);
    }

    protected Composite createNameAndIdentitySection(Composite parent) {
        Composite client = super.createNameAndIdentitySection(parent, Messages.LABEL_NAME_AND_EJB_CONFIGURATION);
        this.toolkit.createLabel(client, Messages.LABEL_SESSION_TYPE);
        this.sessionTypeCombo = this.createCCombo(client, 0x800000);
        this.sessionTypeCombo.setEditable(false);
        GridData gd = new GridData(770);
        this.sessionTypeCombo.setLayoutData((Object)gd);
        this.ejbVersionComboLabel = this.toolkit.createLabel(client, Messages.LABEL_EJB_VERSION);
        this.ejbVersionCombo = this.createCCombo(client, 0x800000);
        this.ejbVersionCombo.setEditable(false);
        gd = new GridData(770);
        gd.widthHint = 10;
        this.ejbVersionCombo.setLayoutData((Object)gd);
        for (VersionValue value : VersionValue.VALUES) {
            this.ejbVersionCombo.add(value.getName());
        }
        this.ejbVersionCombo.select(0);
        this.homeInterfaceLabel = this.toolkit.createLabel(client, Messages.LABEL_HOME_INTF);
        this.homeInterfaceText = this.toolkit.createText(client, "", 4);
        gd = new GridData(770);
        this.homeInterfaceText.setLayoutData((Object)gd);
        Iterator<String> stateIt = this.stateMap.keySet().iterator();
        while (stateIt.hasNext()) {
            this.sessionTypeCombo.add(stateIt.next());
        }
        this.sessionTypeCombo.select(0);
        this.ejbClient = client;
        this.ejbPageBook = this.toolkit.createPageBook(client, 0);
        GridLayout gl = new GridLayout();
        gl.marginWidth = 0;
        this.ejbPageBook.setLayout((Layout)gl);
        gd = new GridData(1808);
        Point size = this.homeInterfaceLabel.computeSize(-1, -1);
        gd.minimumHeight = size.y * 21;
        gd.horizontalSpan = 2;
        this.ejbPageBook.setLayoutData((Object)gd);
        Composite referenceComp = this.ejbPageBook.createPage((Object)"REFERENCE");
        Composite serviceComp = this.ejbPageBook.createPage((Object)"SERVICE");
        gl = new GridLayout();
        gl.marginWidth = 0;
        gl.marginRight = 1;
        gl.numColumns = 2;
        referenceComp.setLayout((Layout)gl);
        gl = new GridLayout();
        gl.marginWidth = 0;
        gl.marginRight = 1;
        gl.numColumns = 2;
        serviceComp.setLayout((Layout)gl);
        gd = new GridData(1808);
        referenceComp.setLayoutData((Object)gd);
        gd = new GridData(1808);
        serviceComp.setLayoutData((Object)gd);
        this.serviceControls = new EJBNameServiceControls(serviceComp, this.toolkit);
        this.referenceControls = new EJBNameReferenceControls(referenceComp, this.toolkit);
        this.serviceControls.createControls();
        this.referenceControls.createControls();
        this.toolkit.paintBordersFor(serviceComp);
        this.toolkit.paintBordersFor(referenceComp);
        this.toolkit.createLabel(client, "");
        return parent;
    }

    protected void createURIControls(Composite parent) {
    }

    public void refresh() {
        VersionValue versionValue;
        super.refresh();
        this.removeAllListeners();
        this.homeInterfaceText.setText("");
        EJBSessionBeanBinding ejbBinding = (EJBSessionBeanBinding)this.binding;
        String homeValue = ejbBinding.getHomeInterface();
        if (homeValue != null && homeValue.length() > 0) {
            this.homeInterfaceText.setText(homeValue);
        }
        if (ejbBinding.getSessionType() != null) {
            String sessionTypeValue = ejbBinding.getSessionType().getLiteral();
            this.selectStateComboItem(this.sessionTypeCombo, sessionTypeValue);
        }
        if ((versionValue = ejbBinding.getEjbVersion()) != null) {
            this.selectComboItem(this.ejbVersionCombo, versionValue.getName());
        }
        if (this.uriAndLinkMExclusive) {
            this.ejbPageBook.showPage((Object)"REFERENCE");
            this.referenceControls.refresh();
            this.homeInterfaceLabel.setEnabled(false);
            this.homeInterfaceText.setEnabled(false);
            this.ejbVersionComboLabel.setVisible(false);
            this.ejbVersionCombo.setVisible(false);
        } else {
            this.ejbPageBook.showPage((Object)"SERVICE");
            this.serviceControls.refresh();
            this.homeInterfaceLabel.setEnabled(true);
            this.ejbVersionComboLabel.setEnabled(true);
            this.homeInterfaceText.setEnabled(true);
            this.ejbVersionCombo.setEnabled(true);
            this.ejbVersionComboLabel.setVisible(true);
            this.ejbVersionCombo.setVisible(true);
        }
        if (versionValue != null) {
            this.enableDisableHomeInterface(versionValue.getName().equals(VersionValue.EJB2.getName()) && !this.uriAndLinkMExclusive);
        }
        Composite parentForPageBook = this.ejbPageBook.getParent();
        parentForPageBook.layout();
        parentForPageBook.redraw();
        this.addAllListeners();
    }

    private void selectStateComboItem(CCombo combo, String stringValue) {
        String value = "";
        for (String item : this.stateMap.keySet()) {
            String mapValue = this.stateMap.get(item);
            if (!stringValue.equals(mapValue)) continue;
            value = item;
            break;
        }
        this.selectComboItem(combo, value);
    }

    private void selectComboItem(CCombo combo, String value) {
        String[] comboItems = combo.getItems();
        int i = 0;
        while (i < comboItems.length) {
            if (comboItems[i].equals(value)) {
                combo.select(i);
                break;
            }
            ++i;
        }
    }

    private void enableDisableHomeInterface(boolean enable) {
        this.homeInterfaceLabel.setEnabled(enable);
        this.homeInterfaceText.setEnabled(enable);
        String text = null;
        if (enable) {
            text = this.homeInterfaceText.getText();
        }
        EditBindingHomeInterfaceAction action = new EditBindingHomeInterfaceAction(this.getWorkbenchPart(), this.binding, text);
        action.run();
    }

    private void addAllListeners() {
        this.homeInterfaceText.addListener(16, (Listener)this.textListener);
        this.homeInterfaceText.addListener(2, (Listener)this.textListener);
        this.ejbVersionCombo.addSelectionListener((SelectionListener)this.selectionListener);
        this.sessionTypeCombo.addSelectionListener((SelectionListener)this.selectionListener);
    }

    private void removeAllListeners() {
        this.homeInterfaceText.removeListener(16, (Listener)this.textListener);
        this.homeInterfaceText.removeListener(2, (Listener)this.textListener);
        this.ejbVersionCombo.removeSelectionListener((SelectionListener)this.selectionListener);
        this.sessionTypeCombo.removeSelectionListener((SelectionListener)this.selectionListener);
    }

    private class EJBDetailsCustomListener
    extends DelayedTextModifyListener {
        private EJBDetailsCustomListener() {
        }

        protected void executeHandleEvent(Event event) {
            if (event.widget == EJBBindingDetailsPropertiesPage.this.homeInterfaceText && !EJBBindingDetailsPropertiesPage.this.homeInterfaceText.isDisposed()) {
                String text = EJBBindingDetailsPropertiesPage.this.homeInterfaceText.getText();
                EditBindingHomeInterfaceAction action = new EditBindingHomeInterfaceAction(EJBBindingDetailsPropertiesPage.this.getWorkbenchPart(), EJBBindingDetailsPropertiesPage.this.binding, text);
                action.run();
            }
        }
    }

    private class EJBSelectionListener
    extends SelectionAdapter {
        private EJBSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.widget == EJBBindingDetailsPropertiesPage.this.ejbVersionCombo) {
                String selection = EJBBindingDetailsPropertiesPage.this.ejbVersionCombo.getItem(EJBBindingDetailsPropertiesPage.this.ejbVersionCombo.getSelectionIndex());
                EditBindingVersionAction action = new EditBindingVersionAction(EJBBindingDetailsPropertiesPage.this.getWorkbenchPart(), EJBBindingDetailsPropertiesPage.this.binding, selection);
                action.run();
                EJBBindingDetailsPropertiesPage.this.enableDisableHomeInterface(selection.equals(VersionValue.EJB2.getName()));
                String homeText = "";
                if (EJBBindingDetailsPropertiesPage.this.homeInterfaceText.isEnabled()) {
                    homeText = EJBBindingDetailsPropertiesPage.this.homeInterfaceText.getText();
                }
                EditBindingHomeInterfaceAction action2 = new EditBindingHomeInterfaceAction(EJBBindingDetailsPropertiesPage.this.getWorkbenchPart(), EJBBindingDetailsPropertiesPage.this.binding, homeText);
                action2.run();
            } else if (e.widget == EJBBindingDetailsPropertiesPage.this.sessionTypeCombo) {
                String selection = EJBBindingDetailsPropertiesPage.this.sessionTypeCombo.getItem(EJBBindingDetailsPropertiesPage.this.sessionTypeCombo.getSelectionIndex());
                String value = (String)EJBBindingDetailsPropertiesPage.this.stateMap.get(selection);
                EditBindingSessionTypeAction action = new EditBindingSessionTypeAction(EJBBindingDetailsPropertiesPage.this.getWorkbenchPart(), EJBBindingDetailsPropertiesPage.this.binding, value);
                action.run();
            }
        }
    }
}

