/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.ui.custom.extensibility.implementation.ejb.view;

import com.ibm.ccl.sca.core.util.PlatformUtil;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.javaee.application.Application;
import org.eclipse.jst.javaee.application.Module;
import org.eclipse.jst.javaee.ejb.EJBJar;
import org.eclipse.jst.javaee.ejb.EnterpriseBeans;
import org.eclipse.jst.javaee.ejb.EntityBean;
import org.eclipse.jst.javaee.ejb.MessageDrivenBean;
import org.eclipse.jst.javaee.ejb.SessionBean;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class EJBUtil {
    public static List<IProject> getJEE_EJBsInWorkspace() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<IProject> result = new ArrayList<IProject>();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (EJBUtil.isEJBProj(project)) {
                result.add(project);
            }
            ++n2;
        }
        return result;
    }

    public static EnterpriseBeans getBeans(IProject project) {
        IModelProvider provider = ModelProviderManager.getModelProvider((IProject)project);
        Object modelObject = provider.getModelObject();
        return ((EJBJar)modelObject).getEnterpriseBeans();
    }

    public static List<IProject> getProjectsFromJarNames(List<String> projectJarNames) {
        ArrayList<IProject> projects = new ArrayList<IProject>();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        for (String projectName : projectJarNames) {
            IProject project;
            if (projectName.endsWith(".jar")) {
                projectName = projectName.substring(0, projectName.length() - 4);
            }
            if (!(project = root.getProject(projectName)).exists() || !EJBUtil.isEJBProj(project)) continue;
            projects.add(project);
        }
        return projects;
    }

    public static List<String> getEJBProjsInEar(IProject earProj) {
        ArrayList<String> result = new ArrayList<String>();
        IModelProvider provider = ModelProviderManager.getModelProvider((IProject)earProj);
        Object modelObject = provider.getModelObject();
        Application appEar = (Application)modelObject;
        List modules = appEar.getModules();
        for (Module module : modules) {
            String ejbName = module.getEjb();
            if (ejbName == null || ejbName.isEmpty()) continue;
            result.add(ejbName);
        }
        return result;
    }

    public static IProject getProjectFromEObject(EObject rootObject) {
        Path rootPath = new Path(rootObject.eResource().getURI().toString());
        return PlatformUtil.getProjectFromResourcePath((IPath)rootPath);
    }

    public static boolean isEJBProj(IProject project) {
        IVirtualComponent projectComp = ComponentCore.createComponent((IProject)project);
        return projectComp != null && JavaEEProjectUtilities.isJEEComponent((IVirtualComponent)projectComp) && JavaEEProjectUtilities.isEJBComponent((IVirtualComponent)projectComp);
    }

    public static boolean isAppProj(IProject project) {
        IVirtualComponent projectComp = ComponentCore.createComponent((IProject)project);
        return projectComp != null && JavaEEProjectUtilities.isJEEComponent((IVirtualComponent)projectComp) && JavaEEProjectUtilities.isEARProject((IProject)project);
    }

    public static String getBeanName(Object selection) {
        String ejbName = "";
        if (selection instanceof SessionBean) {
            ejbName = ((SessionBean)selection).getEjbName();
        } else if (selection instanceof EntityBean) {
            ejbName = ((EntityBean)selection).getEjbName();
        } else if (selection instanceof MessageDrivenBean) {
            ejbName = ((MessageDrivenBean)selection).getEjbName();
        }
        return ejbName;
    }

    public static String getLinkName(String projectName, Object bean) {
        if (!projectName.endsWith(".jar")) {
            projectName = String.valueOf(projectName) + ".jar";
        }
        return String.valueOf(projectName) + "#" + EJBUtil.getBeanName(bean);
    }
}

