/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.ui.custom.extensibility.implementation.ejb.view;

import com.ibm.ccl.sca.composite.emf.ejb.impl.Messages;
import com.ibm.ccl.sca.composite.ui.custom.extensibility.implementation.ejb.view.EJBContentProvider;
import com.ibm.ccl.sca.composite.ui.custom.extensibility.implementation.ejb.view.EJBLabelProvider;
import com.ibm.ccl.sca.composite.ui.custom.extensibility.implementation.ejb.view.EJBProject;
import com.ibm.ccl.sca.composite.ui.custom.extensibility.implementation.ejb.view.EJBRoot;
import com.ibm.ccl.sca.composite.ui.custom.extensibility.implementation.ejb.view.EJBUtil;
import com.ibm.ccl.sca.core.bean.IDataBean;
import com.ibm.ccl.sca.core.bean.NullObject;
import com.ibm.ccl.sca.ui.contributions.ISelectionDialog;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jst.javaee.ejb.EntityBean;
import org.eclipse.jst.javaee.ejb.MessageDrivenBean;
import org.eclipse.jst.javaee.ejb.SessionBean;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;

public class EJBSelectionDialog
extends TitleAreaDialog
implements ISelectionDialog {
    private TreeViewer treeViewer;
    private Object selection;
    private EJBProject project;
    private IProject rootProject;

    public EJBSelectionDialog(Shell parentShell, IProject rootProject) {
        super(parentShell);
        this.rootProject = rootProject;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.EJBSelectionDialog_0);
    }

    protected Point getInitialSize() {
        return new Point(500, 500);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.EJBSelectionDialog_1);
        this.setMessage(Messages.EJBSelectionDialog_2);
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite child = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 10;
        child.setLayout((Layout)layout);
        child.setLayoutData((Object)new GridData(1808));
        Tree tree = new Tree(child, 2052);
        GridData data = new GridData(1808);
        tree.setLayoutData((Object)data);
        tree.setFont(parent.getFont());
        this.treeViewer = new TreeViewer(tree);
        this.treeViewer.setContentProvider((IContentProvider)new EJBContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new EJBLabelProvider());
        this.treeViewer.setInput((Object)new EJBRoot(this.rootProject));
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                EJBSelectionDialog.this.handleSelectionChanged();
            }
        });
        Composite buttonComposite = new Composite(child, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        buttonComposite.setLayout((Layout)layout);
        Button expandAll = new Button(buttonComposite, 8);
        Button collapseAll = new Button(buttonComposite, 8);
        expandAll.setText(Messages.EJBSelectionDialog_3);
        collapseAll.setText(Messages.EJBSelectionDialog_4);
        expandAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EJBSelectionDialog.this.treeViewer.expandAll();
            }
        });
        collapseAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EJBSelectionDialog.this.treeViewer.collapseAll();
            }
        });
        return child;
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.enableOk(false);
        return control;
    }

    private void handleSelectionChanged() {
        Object selection = ((IStructuredSelection)this.treeViewer.getSelection()).getFirstElement();
        boolean selectionIsABean = selection instanceof SessionBean || selection instanceof EntityBean || selection instanceof MessageDrivenBean;
        this.enableOk(selectionIsABean);
    }

    protected void okPressed() {
        this.selection = ((IStructuredSelection)this.treeViewer.getSelection()).getFirstElement();
        this.project = (EJBProject)this.treeViewer.getTree().getSelection()[0].getParentItem().getParentItem().getData();
        super.okPressed();
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10);
    }

    private void enableOk(boolean enabled) {
        this.getButton(0).setEnabled(enabled);
    }

    public EJBProject getProject() {
        return this.project;
    }

    public Object getSelection() {
        return this.selection;
    }

    public IDataBean getDataBean() {
        NullObject dataBean = new NullObject(){

            public String getID() {
                return "implementation.ejb";
            }

            public String serialize() {
                return EJBUtil.getLinkName(EJBSelectionDialog.this.getProject().getName(), EJBSelectionDialog.this.getSelection());
            }

            public Object getProperty(String key) {
                return EJBSelectionDialog.this.getSelection();
            }
        };
        return dataBean;
    }
}

