/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.ui.custom.extensibility.implementation.ejb.view;

import com.ibm.ccl.sca.composite.ui.custom.extensibility.implementation.ejb.view.BeanList;
import com.ibm.ccl.sca.composite.ui.custom.extensibility.implementation.ejb.view.EJBUtil;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jst.javaee.ejb.EnterpriseBeans;
import org.eclipse.jst.javaee.ejb.EntityBean;
import org.eclipse.jst.javaee.ejb.MessageDrivenBean;
import org.eclipse.jst.javaee.ejb.SessionBean;

public class EJBProject {
    private List<SessionBean> sessionBeans = new ArrayList<SessionBean>();
    private List<EntityBean> entityBeans = new ArrayList<EntityBean>();
    private List<MessageDrivenBean> messageBeans = new ArrayList<MessageDrivenBean>();
    private String name;

    public EJBProject(IProject project) {
        EnterpriseBeans enterpriseBeans = EJBUtil.getBeans(project);
        this.name = project.getName();
        if (enterpriseBeans != null) {
            List sBeans = enterpriseBeans.getSessionBeans();
            List eBeans = enterpriseBeans.getEntityBeans();
            List mBeans = enterpriseBeans.getMessageDrivenBeans();
            if (sBeans != null && sBeans.size() > 0) {
                this.sessionBeans.addAll(sBeans);
            }
            if (eBeans != null && eBeans.size() > 0) {
                this.entityBeans.addAll(eBeans);
            }
            if (mBeans != null && mBeans.size() > 0) {
                this.messageBeans.addAll(mBeans);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean hasBeans() {
        return this.sessionBeans.size() + this.entityBeans.size() + this.messageBeans.size() > 0;
    }

    public List<SessionBean> getSessionBeans() {
        return this.sessionBeans;
    }

    public List<EntityBean> getEntityBeans() {
        return this.entityBeans;
    }

    public List<MessageDrivenBean> getMessageBeans() {
        return this.messageBeans;
    }

    public BeanList[] getBeanList() {
        ArrayList<BeanList<Object>> result = new ArrayList<BeanList<Object>>();
        if (this.sessionBeans.size() > 0) {
            result.add(new BeanList<SessionBean>(0, this.sessionBeans));
        }
        if (this.entityBeans.size() > 0) {
            result.add(new BeanList<EntityBean>(1, this.entityBeans));
        }
        if (this.messageBeans.size() > 0) {
            result.add(new BeanList<MessageDrivenBean>(2, this.messageBeans));
        }
        return result.toArray(new BeanList[0]);
    }
}

