/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.emf.ejb.impl.newcomposite;

import com.ibm.ccl.sca.composite.emf.ejb.impl.EJBImplActivator;
import com.ibm.ccl.sca.composite.emf.ejb.impl.Messages;
import com.ibm.ccl.sca.composite.ui.custom.extensibility.implementation.ejb.view.EJBUtil;
import com.ibm.ccl.sca.core.model.ISCAArtifact;
import com.ibm.ccl.sca.core.model.ISCAComposite;
import com.ibm.ccl.sca.core.plugin.SCAToolsCorePlugin;
import com.ibm.ccl.sca.creation.ui.extension.ICompositeWizardExtension;
import com.ibm.ccl.sca.internal.ui.navigator.node.ComponentNode;
import com.ibm.ccl.sca.internal.ui.navigator.node.NamespaceNode;
import com.ibm.ccl.sca.ui.navigator.ISCANode;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;

public class DistinguishedSCAComposite
implements ICompositeWizardExtension {
    public String getCompositeNameDefault(IProject project, IStructuredSelection selection) {
        return "application";
    }

    public boolean getCompositeNameEnabled() {
        return false;
    }

    public boolean canCreateNewProjects() {
        return false;
    }

    public IProject getDefaultProject(IStructuredSelection selection) {
        Object element;
        IProject initialProject = null;
        if (selection instanceof TreeSelection) {
            Object element2 = ((TreeSelection)selection).getFirstElement();
            if (element2 instanceof ICompilationUnit) {
                ICompilationUnit icu = (ICompilationUnit)element2;
                IType javaType = null;
                try {
                    javaType = icu.getTypes()[0];
                }
                catch (Exception exc) {
                    EJBImplActivator.traceError(exc);
                }
                if (javaType != null) {
                    initialProject = javaType.getJavaProject().getProject();
                }
            } else if (element2 instanceof IFile) {
                IFile file = (IFile)element2;
                initialProject = file.getProject();
            } else if (element2 instanceof ISCANode) {
                ISCANode node = (ISCANode)element2;
                initialProject = node.getProject();
            } else if (element2 instanceof ISCAArtifact) {
                ISCAArtifact artifact = (ISCAArtifact)element2;
                initialProject = artifact.getParent();
            } else if (element2 instanceof IProject) {
                initialProject = (IProject)element2;
            }
        } else if (selection != null && (element = selection.getFirstElement()) instanceof IProject) {
            initialProject = (IProject)element;
        }
        if (initialProject != null && !EJBUtil.isAppProj(initialProject)) {
            initialProject = null;
        }
        return initialProject;
    }

    public String getPath(IProject project, String compositeName, String oldPath) {
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        IVirtualFolder folder = component.getRootFolder().getFolder((IPath)new Path("META-INF"));
        IPath newPath = folder.getWorkspaceRelativePath();
        newPath = newPath.append(compositeName).addFileExtension("composite");
        return newPath.toString();
    }

    public boolean getPathEnabled() {
        return false;
    }

    public String getNamespaceDefault(IProject project, IStructuredSelection selection) {
        String defaultNamespace = null;
        if (selection instanceof TreeSelection) {
            Object element = ((TreeSelection)selection).getFirstElement();
            if (element instanceof IFile) {
                ISCAComposite composite;
                IFile file = (IFile)element;
                if (file.getFileExtension().equals("composite") && (composite = (ISCAComposite)file.getAdapter(ISCAArtifact.class)) != null) {
                    defaultNamespace = composite.getName().getNamespaceURI();
                }
            } else if (element instanceof ISCANode) {
                ISCANode node = (ISCANode)element;
                if (node instanceof NamespaceNode) {
                    defaultNamespace = ((NamespaceNode)node).getNamespace();
                } else if (node instanceof ComponentNode) {
                    ISCAComposite composite = (ISCAComposite)node.getParent();
                    defaultNamespace = composite.getName().getNamespaceURI();
                }
            } else if (element instanceof ISCAArtifact && element instanceof ISCAComposite) {
                defaultNamespace = ((ISCAComposite)element).getName().getNamespaceURI();
            }
        }
        if (defaultNamespace == null) {
            defaultNamespace = SCAToolsCorePlugin.getInstance().getPreferences().getNamespace(project);
        }
        return defaultNamespace;
    }

    public boolean getNamespaceEnabled() {
        return true;
    }

    public IStatus validate(String location, String compositeName, String namespace) {
        return Status.OK_STATUS;
    }

    public IStatus validateProject(IProject project) {
        IStatus result = Status.OK_STATUS;
        if (!EJBUtil.isAppProj(project)) {
            result = new Status(4, "id", Messages.bind((String)Messages.DistinguishedSCAComposite_0, (Object)project.getName()));
        }
        return result;
    }
}

