/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.pli.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class CICSTXUtil {
    public static final String copyright = "Licensed Materials - Property of IBM\ncom.ibm.ccl.pli\nCopyright IBM Corporation 2007. All Rights Reserved.\nNote to U.S. Government Users Restricted Rights:  Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp. ";
    private static final String CICSNLS = "CICSNLS";
    private static final String CICSPATH = "CICSPATH";
    private static final String LIB = "LIB";
    private static final String NLSPATH = "NLSPATH";
    private static final String PATH_SEPARATOR = System.getProperty("file.separator");
    private static final String VERSIONFILE = "etc" + PATH_SEPARATOR + "Version";
    private static final String VERSIONPREFIX = "TXSeries 6";
    private static final int RELEASE = 2;
    private static final int DOT = 46;
    private static final String CICSINCLUDE = "include";
    private static final String CICS31OPT = "PP(MACRO,CICS('CTS31'),MACRO) SYSTEM(CICS)";
    private static final String CICS32OPT = "PP(MACRO,CICS('CTS32'),MACRO) SYSTEM(CICS)";

    private CICSTXUtil() {
    }

    public static boolean isCICSTXInstalled() {
        boolean installed;
        block34: {
            String versionFile;
            File verFile;
            installed = false;
            String cicspath = System.getenv(CICSPATH);
            if (cicspath != null && cicspath.trim().length() > 0 && (verFile = new File(versionFile = String.valueOf(cicspath.trim()) + PATH_SEPARATOR + VERSIONFILE)).exists()) {
                BufferedReader verBufReader;
                FileReader verFileReader;
                block36: {
                    block33: {
                        verFileReader = null;
                        verBufReader = null;
                        try {
                            verFileReader = new FileReader(verFile);
                            verBufReader = new BufferedReader(verFileReader);
                            String firstLine = verBufReader.readLine();
                            if (firstLine == null || !firstLine.startsWith(VERSIONPREFIX) || firstLine.length() < VERSIONPREFIX.length() + 3) break block33;
                            int dotPos = firstLine.indexOf(46, VERSIONPREFIX.length() + 1);
                            if (dotPos == -1) {
                                dotPos = firstLine.length();
                            }
                            String r = firstLine.substring(VERSIONPREFIX.length() + 1, dotPos);
                            try {
                                if (Integer.parseInt(r) >= 2) {
                                    installed = true;
                                }
                            }
                            catch (NumberFormatException numberFormatException) {}
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            if (verBufReader != null) {
                                try {
                                    verBufReader.close();
                                    verBufReader = null;
                                    verFileReader = null;
                                }
                                catch (IOException iOException) {}
                            }
                            if (verFileReader != null) {
                                try {
                                    verFileReader.close();
                                    verBufReader = null;
                                    verFileReader = null;
                                }
                                catch (IOException iOException) {}
                            }
                            break block34;
                        }
                        catch (IOException iOException) {
                            block35: {
                                try {
                                    if (verBufReader == null) break block35;
                                }
                                catch (Throwable throwable) {
                                    if (verBufReader != null) {
                                        try {
                                            verBufReader.close();
                                            verBufReader = null;
                                            verFileReader = null;
                                        }
                                        catch (IOException iOException2) {}
                                    }
                                    if (verFileReader != null) {
                                        try {
                                            verFileReader.close();
                                            verBufReader = null;
                                            verFileReader = null;
                                        }
                                        catch (IOException iOException3) {}
                                    }
                                    throw throwable;
                                }
                                try {
                                    verBufReader.close();
                                    verBufReader = null;
                                    verFileReader = null;
                                }
                                catch (IOException iOException4) {}
                            }
                            if (verFileReader != null) {
                                try {
                                    verFileReader.close();
                                    verBufReader = null;
                                    verFileReader = null;
                                }
                                catch (IOException iOException5) {}
                            }
                            break block34;
                        }
                    }
                    if (verBufReader == null) break block36;
                    try {
                        verBufReader.close();
                        verBufReader = null;
                        verFileReader = null;
                    }
                    catch (IOException iOException) {}
                }
                if (verFileReader != null) {
                    try {
                        verFileReader.close();
                        verBufReader = null;
                        verFileReader = null;
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return installed;
    }

    public static String getCICSIncludePath() {
        String cicspath = System.getenv(CICSPATH);
        if (cicspath != null && cicspath.trim().length() > 0) {
            return String.valueOf(cicspath.trim()) + PATH_SEPARATOR + CICSINCLUDE;
        }
        return "";
    }

    private static void addenv(List vars, String name) {
        String env = System.getenv(name);
        if (env != null && env.trim().length() > 0) {
            vars.add(String.valueOf(name) + "=" + env);
        }
    }

    public static List getCICSEnvVars() {
        ArrayList vars = new ArrayList();
        CICSTXUtil.addenv(vars, CICSNLS);
        CICSTXUtil.addenv(vars, CICSPATH);
        CICSTXUtil.addenv(vars, LIB);
        CICSTXUtil.addenv(vars, NLSPATH);
        return vars;
    }

    public static String getOptionForCICS31() {
        return CICS31OPT;
    }

    public static String getOptionForCICS32() {
        return CICS32OPT;
    }
}

