/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.pli.importer;

import com.ibm.ccl.pli.plugin.PliPlugin;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.logging.Level;

public class RunCommandWin32 {
    private static final String DLLLOC = "importer\\dll\\RunCommand.dll";
    private static final String DLLFRAGMENTID = "com.ibm.ccl.pli.win32";
    private static boolean dllLoaded;

    static {
        String dllLocation = String.valueOf(PliPlugin.getPluginLocation(DLLFRAGMENTID)) + DLLLOC;
        File dll = new File(dllLocation);
        if (dll.exists()) {
            try {
                System.load(dllLocation);
                dllLoaded = true;
            }
            catch (UnsatisfiedLinkError e) {
                dllLoaded = false;
                PliPlugin.getDefault().writeMsg(Level.SEVERE, "RunCommandWin32<init> : Dll not loaded :" + dllLocation, e);
                throw e;
            }
        } else {
            dllLoaded = false;
            PliPlugin.getDefault().writeMsg(Level.SEVERE, "RunCommandWin32<init> : Dll not found :" + dllLocation, new FileNotFoundException());
        }
    }

    public native int runCommand(String var1, String var2, String var3, String[] var4, String[] var5, boolean var6);

    public int runCommand(String command, String parameters, String workingDir, String[] envArray, boolean isTracingOn) {
        String[] envVarNames = new String[envArray.length];
        String[] envVarValues = new String[envArray.length];
        int index = 0;
        while (index < envArray.length) {
            int pos = envArray[index].indexOf("=");
            if (pos == -1) {
                IllegalArgumentException e = new IllegalArgumentException();
                PliPlugin.getDefault().writeMsg(Level.SEVERE, "RunCommandWin32#runCommand : An invalid environment var:" + envArray[index], e);
                throw e;
            }
            envVarNames[index] = envArray[index].substring(0, pos);
            envVarValues[index] = envArray[index].substring(pos + 1);
            ++index;
        }
        int jniret = this.runCommand(command, parameters, workingDir, envVarNames, envVarValues, isTracingOn);
        if (jniret == 0) {
            IllegalStateException e = new IllegalStateException();
            PliPlugin.getDefault().writeMsg(Level.SEVERE, "RunCommandWin32#runCommand : JNI invocation error", e);
        }
        return jniret;
    }

    public static boolean isJNILoaded() {
        return dllLoaded;
    }
}

