/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.pli.importer;

import com.ibm.ccl.pli.PLIClassifier;
import com.ibm.ccl.pli.PLIComposedType;
import com.ibm.ccl.pli.PLIElement;
import com.ibm.ccl.pli.PLIIntegerType;
import com.ibm.ccl.pli.PLISimpleType;
import com.ibm.ccl.pli.impl.PLIElementImpl;
import com.ibm.ccl.pli.impl.PLIFloatTypeImpl;
import com.ibm.ccl.pli.impl.PLIIntegerTypeImpl;
import com.ibm.ccl.pli.importer.IPliPreferenceConstants;
import com.ibm.ccl.pli.importer.ParseSyntaxErrorsFromAdata;
import com.ibm.ccl.pli.importer.PliException;
import com.ibm.ccl.pli.importer.PliPreferenceStore;
import com.ibm.ccl.pli.importer.RunCommandWin32;
import com.ibm.ccl.pli.plugin.PliPlugin;
import com.ibm.ccl.pli.plugin.PliResources;
import com.ibm.ccl.pli.util.CICSTXUtil;
import com.ibm.etools.typedescriptor.BaseTDType;
import com.ibm.etools.typedescriptor.FloatValue;
import com.ibm.etools.typedescriptor.InstanceTDBase;
import com.ibm.etools.typedescriptor.SimpleInstanceTD;
import com.ibm.etools.typedescriptor.impl.FloatTDImpl;
import com.ibm.etools.typedescriptor.impl.IntegerTDImpl;
import com.ibm.etools.typedescriptor.impl.PlatformCompilerInfoImpl;
import com.ibm.etools.typedescriptor.impl.StringTDImpl;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class PliSourceResourceWin
extends XMIResourceImpl
implements IPliPreferenceConstants {
    public static final String copyright = "Licensed Materials - Property of IBM\ncom.ibm.ccl.pli\nCopyright IBM Corporation 2004, 2007. All Rights Reserved.\nNote to U.S. Government Users Restricted Rights:  Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp. ";
    private static final String EX_DESC_XMI_FILE_NOT_FOUND = PliResources.EX_DESC_XMI_FILE_NOT_FOUND;
    private static final String EX_DESC_SYNTAX_ERRORS_FOUND = PliResources.EX_DESC_SYNTAX_ERRORS_FOUND;
    private static final String EX_DESC_MISSING_TEMPLATE_FILE = PliResources.EX_DESC_MISSING_TEMPLATE_FILE;
    private static final String WRAPPER_TEMPLATE_FILE = "wrapper.template";
    private static final String WRAPPER_DUMMY_NAME = "wrapper";
    private static final String WRAPPER_DUMMY_EXT = "pli";
    private static final String REPLACE_STRING = "{0}";
    private String PathForPliMiniCompiler;
    private AbstractList lastErrors = null;
    private boolean bProcessedIMS;
    private List resourcesList;
    private boolean needCopySyntaxfile;

    public PliSourceResourceWin(URI arg) {
        super(arg);
        this.localInit();
    }

    public PliSourceResourceWin() {
        super(null);
        this.localInit();
    }

    private void localInit() {
        this.PathForPliMiniCompiler = String.valueOf(PliPlugin.getPluginLocation("com.ibm.ccl.pli.win32")) + "importer/";
        this.bProcessedIMS = false;
    }

    public AbstractList getLastErrors() {
        return this.lastErrors;
    }

    public void doLoad(InputStream inputStream, Map options) throws IOException {
        try {
            this.doInternalLoad(inputStream, options);
        }
        catch (InterruptedException interruptedException) {
            try {
                Thread.currentThread().interrupt();
                this.localInit();
                this.doInternalLoad(inputStream, options);
            }
            catch (InterruptedException e1) {
                Thread.currentThread().interrupt();
                PliPlugin.getDefault().writeMsg(Level.SEVERE, "*** PliSourceResourceWin.doLoad(...): Catch InterruptedException.", e1);
                throw new PliException(e1);
            }
            catch (CoreException e1) {
                PliPlugin.getDefault().writeMsg(Level.SEVERE, "*** PliSourceResourceWin.doLoad(...): Catch inner CoreException.", e1);
                throw new PliException((Exception)((Object)e1));
            }
        }
        catch (CoreException e) {
            PliPlugin.getDefault().writeMsg(Level.SEVERE, "*** PliSourceResourceWin.doLoad(...): Catch outer CoreException.", e);
            throw new PliException((Exception)((Object)e));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doInternalLoad(InputStream inputStream, Map options) throws PliException, IOException, InterruptedException, CoreException {
        boolean bDebugFlag_STAY_WORKING_FOLDER;
        File tmpdir;
        block57: {
            this.lastErrors = null;
            tmpdir = null;
            bDebugFlag_STAY_WORKING_FOLDER = false;
            try {
                block59: {
                    PliException pe;
                    boolean postErrorsToProblemsView;
                    boolean bFullProgram;
                    Path absPath;
                    Map pliOptions;
                    block58: {
                        File adtFile;
                        ParseSyntaxErrorsFromAdata errs;
                        AbstractList errList;
                        String p;
                        String targetName;
                        pliOptions = this.getPliOption(options);
                        if (PliPlugin.getDefault().isDEBUG_FINE()) {
                            bDebugFlag_STAY_WORKING_FOLDER = true;
                        }
                        Vector<String> envs = new Vector<String>();
                        Vector<String> opts = new Vector<String>();
                        String srcfile = this.getTargetFileName(this.getURI());
                        absPath = new Path(srcfile);
                        String lastSegment = absPath.lastSegment();
                        String ext = absPath.getFileExtension();
                        String targetPath = absPath.removeLastSegments(1).toOSString();
                        bFullProgram = true;
                        if (ext == null) {
                            targetName = lastSegment;
                        } else if (ext.length() == 0) {
                            targetName = lastSegment.substring(0, lastSegment.length() - 1);
                        } else {
                            targetName = lastSegment.substring(0, lastSegment.length() - ext.length() - 1);
                            int i = 0;
                            while (i < FILE_EXTENSION.length) {
                                if (ext.equalsIgnoreCase(FILE_EXTENSION[i])) {
                                    int srctype = (Integer)pliOptions.get(PRE_PLI_EXTENSION[i]);
                                    switch (srctype) {
                                        case 0: {
                                            bFullProgram = true;
                                            break;
                                        }
                                        case 1: {
                                            bFullProgram = false;
                                            break;
                                        }
                                    }
                                    break;
                                }
                                ++i;
                            }
                        }
                        tmpdir = this.createTempFolder();
                        this.updateOptionsListByMap(opts, pliOptions);
                        String sysLib = targetPath;
                        String wrapperFileName = "";
                        if (!bFullProgram) {
                            String lineSeparator = System.getProperty("line.separator");
                            File wrapperTemplate = new File(this.PathForPliMiniCompiler, WRAPPER_TEMPLATE_FILE);
                            if (!wrapperTemplate.exists()) {
                                PliPlugin.getDefault().writeMsg(Level.SEVERE, "*** PliSourceResourceWin.doInternalLoad(...): Missing template file.");
                                throw new PliException(EX_DESC_MISSING_TEMPLATE_FILE);
                            }
                            File wrapper = new File(tmpdir, "wrapper.pli");
                            if (wrapper.exists()) {
                                wrapper.delete();
                            }
                            wrapperFileName = wrapper.getAbsolutePath();
                            BufferedReader rd = new BufferedReader(new FileReader(wrapperTemplate));
                            BufferedWriter wr = new BufferedWriter(new FileWriter(wrapper));
                            while (true) {
                                if (!rd.ready()) break;
                                String line = rd.readLine();
                                int idx = line.indexOf(REPLACE_STRING);
                                if (idx >= 0) {
                                    wr.write(line.substring(0, idx));
                                    wr.write(targetName);
                                    wr.write(line.substring(idx + REPLACE_STRING.length()));
                                } else {
                                    wr.write(line);
                                }
                                wr.write(lineSeparator);
                            }
                            wr.flush();
                            rd.close();
                            wr.close();
                            srcfile = wrapper.toString();
                            targetName = WRAPPER_DUMMY_NAME;
                            StringBuffer extStr = new StringBuffer();
                            extStr.append("INC(EXT(");
                            extStr.append("'");
                            extStr.append(ext);
                            extStr.append("'");
                            int i = 1;
                            while (true) {
                                if (i >= FILE_EXTENSION.length) {
                                    extStr.append(",'.'))");
                                    opts.add(extStr.toString());
                                    break;
                                }
                                if (!FILE_EXTENSION[i].equalsIgnoreCase(ext)) {
                                    extStr.append(",");
                                    extStr.append("'");
                                    extStr.append(FILE_EXTENSION[i]);
                                    extStr.append("'");
                                }
                                ++i;
                            }
                        }
                        Path binpath = new Path(this.PathForPliMiniCompiler);
                        if (CICSTXUtil.isCICSTXInstalled() && pliOptions.containsKey("com.ibm.ccl.pli.PLI_CICS_VERSION") && !((String)pliOptions.get("com.ibm.ccl.pli.PLI_CICS_VERSION")).equals("NOCICS")) {
                            envs.addAll(CICSTXUtil.getCICSEnvVars());
                            String path = System.getenv("path");
                            if (path == null || path.trim().length() == 0) {
                                path = System.getenv("PATH");
                            }
                            if (path == null || path.trim().length() == 0) {
                                envs.add("path=" + binpath.toOSString());
                            } else {
                                envs.add("path=" + binpath.toOSString() + IPliPreferenceConstants.PATH_SEPARATOR + path);
                            }
                        } else {
                            envs.add("path=" + binpath.toOSString());
                        }
                        String addIncudeFilesLocations = PliPlugin.getAdditionalIncludeFilesLocations();
                        if (addIncudeFilesLocations != null && addIncudeFilesLocations.trim().length() > 0) {
                            sysLib = sysLib.length() == 0 ? addIncudeFilesLocations.trim() : String.valueOf(sysLib) + IPliPreferenceConstants.PATH_SEPARATOR + addIncudeFilesLocations.trim();
                        }
                        if (pliOptions.containsKey("com.ibm.ccl.pli.PLI_SYSLIB") && (p = (String)pliOptions.get("com.ibm.ccl.pli.PLI_SYSLIB")) != null && p.trim().length() > 0) {
                            sysLib = sysLib.length() == 0 ? p.trim() : String.valueOf(sysLib) + IPliPreferenceConstants.PATH_SEPARATOR + p.trim();
                        }
                        if (CICSTXUtil.isCICSTXInstalled() && pliOptions.containsKey("com.ibm.ccl.pli.PLI_CICS_VERSION") && !((String)pliOptions.get("com.ibm.ccl.pli.PLI_CICS_VERSION")).equals("NOCICS") && (p = CICSTXUtil.getCICSIncludePath()) != null && p.trim().length() > 0) {
                            sysLib = sysLib.length() == 0 ? p.trim() : String.valueOf(sysLib) + IPliPreferenceConstants.PATH_SEPARATOR + p.trim();
                        }
                        if (sysLib.length() > 0) {
                            envs.add("IBM.SYSLIB=" + sysLib);
                        }
                        String[] envsAry = this.createStringArray(envs);
                        String PLI_OPTION = this.getPliOptionString(opts);
                        String compiler = "\"" + binpath.toOSString() + "pli.exe\"";
                        String parameters = "\"" + srcfile + "\" " + PLI_OPTION;
                        String cmd = String.valueOf(compiler) + " " + parameters;
                        PliPlugin.getDefault().writeMsg(Level.FINE, "*** PliSourceResourceWin.doInternalLoad(...): Call PL/I compiler.");
                        PliPlugin.getDefault().writeMsg(Level.FINE, "*** PliSourceResourceWin.doInternalLoad(...): Command = [" + cmd + "]");
                        if (envsAry != null) {
                            int i = 0;
                            while (i < envsAry.length) {
                                PliPlugin.getDefault().writeMsg(Level.FINE, "*** PliSourceResourceWin.doInternalLoad(...): envs[" + i + "] = [" + envsAry[i] + "]");
                                ++i;
                            }
                        }
                        PliPlugin.getDefault().writeMsg(Level.FINE, "*** PliSourceResourceWin.doInternalLoad(...): working folder= [" + tmpdir + "]");
                        boolean importDone = false;
                        if (PliPlugin.getDefault().isDEBUG_USEJNI()) {
                            RunCommandWin32 comwin32 = new RunCommandWin32();
                            if (RunCommandWin32.isJNILoaded() && comwin32.runCommand(compiler, parameters, tmpdir.getPath(), envsAry, PliPlugin.getDefault().isDEBUG_FINE()) != 0) {
                                importDone = true;
                            }
                        }
                        if (!importDone) {
                            int rc;
                            block56: {
                                Iterator itor;
                                Process proc = Runtime.getRuntime().exec(cmd, envsAry, tmpdir);
                                ProcessWatcher pw = new ProcessWatcher(proc);
                                rc = 0;
                                try {
                                    rc = pw.waitFor();
                                    break block56;
                                }
                                catch (InterruptedException e) {
                                    PliPlugin.getDefault().writeMsg(Level.SEVERE, "*** PliSourceResourceWin.doInternalLoad(...): Fail to ProcessWatcher#waitFor.");
                                    PliPlugin.getDefault().writeMsg(Level.SEVERE, "*** ProcessWatcher : STDOUT.");
                                    itor = pw.getStdoutResult().iterator();
                                }
                                while (true) {
                                    if (!itor.hasNext()) break;
                                    PliPlugin.getDefault().writeMsg(Level.SEVERE, "   [" + itor.next().toString() + "]");
                                }
                                PliPlugin.getDefault().writeMsg(Level.SEVERE, "*** ProcessWatcher : STDERR.");
                                itor = pw.getStderrResult().iterator();
                                while (true) {
                                    if (!itor.hasNext()) {
                                        throw e;
                                    }
                                    PliPlugin.getDefault().writeMsg(Level.SEVERE, "   [" + itor.next().toString() + "]");
                                }
                            }
                            PliPlugin.getDefault().writeMsg(Level.FINE, "*** PliSourceResourceWin.doInternalLoad(...): Load ADATA file. rc=" + rc);
                        }
                        if ((errList = (errs = new ParseSyntaxErrorsFromAdata(adtFile = new File(String.valueOf(tmpdir.getAbsolutePath()) + "/" + targetName + ".adt"), postErrorsToProblemsView = ((Boolean)pliOptions.get("com.ibm.ccl.pli.PLI_POSTERRORS_TO_PROBLEMS_VIEW")).booleanValue())).getErrorMessagesVector()) != null && errList.size() > 0) {
                            this.lastErrors = new Vector(errList);
                        }
                        this.resourcesList = errs.getResourceVector();
                        if (wrapperFileName != null && this.resourcesList.contains(wrapperFileName)) {
                            this.resourcesList.remove(wrapperFileName);
                        }
                        if (this.needCopySyntaxfile) {
                            File syntaxFile = new File(String.valueOf(tmpdir.getAbsolutePath()) + "/" + targetName + ".xml");
                            if (syntaxFile.exists()) {
                                String fileName = ((String)pliOptions.get("com.ibm.ccl.pli.PLI_ERROR_FEEDBACK_FILE_PATH")).trim();
                                File desFile = new File(fileName);
                                PliSourceResourceWin.copyFile(syntaxFile, desFile);
                            } else {
                                PliPlugin.getDefault().writeMsg(Level.SEVERE, "*** PliSourceResourceWin.doInternalLoad(...): File [" + syntaxFile.toString() + "] not found.");
                            }
                        }
                        if (errs.hasErrors()) break block58;
                        PliPlugin.getDefault().writeMsg(Level.FINE, "*** PliSourceResourceWin.doInternalLoad(...): There is no error.");
                        PliPlugin.getDefault().writeMsg(Level.FINE, "*** PliSourceResourceWin.doInternalLoad(...): Load XMI file.");
                        File xmiFile = new File(String.valueOf(tmpdir.getAbsolutePath()) + "/" + targetName + ".xmi");
                        if (xmiFile.exists() && xmiFile.isFile()) {
                            this.loadXMI(xmiFile.getAbsolutePath());
                            this.doPostLoad(pliOptions);
                            List ele = this.getPliTopElements();
                            if (!ele.isEmpty()) break block57;
                            break block59;
                        } else {
                            PliException ex = new PliException(EX_DESC_XMI_FILE_NOT_FOUND);
                            PliPlugin.getDefault().writeMsg(Level.SEVERE, "*** PliSourceResourceWin.doInternalLoad(...): File [" + xmiFile.toString() + "] not found.", ex);
                            if (this.lastErrors == null) throw ex;
                            if (this.lastErrors.size() <= 0) throw ex;
                            ex.setErrorMessagesVector(this.lastErrors);
                            throw ex;
                        }
                    }
                    PliPlugin.getDefault().writeMsg(Level.SEVERE, "*** PliSourceResourceWin.doInternalLoad(...): Syntax errors found.");
                    IFile typesFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)absPath);
                    if (typesFile == null) {
                        PliPlugin.getDefault().writeMsg(Level.FINE, "*** PliSourceResource.doInternalLoad(...): Syntax errors found in a non IFile. Check in the syntaxerrors.xml file.");
                        pe = new PliException(EX_DESC_SYNTAX_ERRORS_FOUND);
                        pe.setMessageNote(this.getMessageNote(pliOptions, bFullProgram));
                        pe.setErrorMessagesVector(this.lastErrors);
                        throw pe;
                    }
                    typesFile.getParent().refreshLocal(2, null);
                    if (postErrorsToProblemsView && PlatformUI.isWorkbenchRunning()) {
                        PliPlugin.getDefault().writeMsg(Level.FINE, "*** PliSourceResourceWin.doInternalLoad(...): Workbench is running");
                        this.openProblemsView();
                    } else {
                        PliPlugin.getDefault().writeMsg(Level.FINE, "*** PliSourceResourceWin.doInternalLoad(...): Workbench is not running. Importer is running in Batch mode");
                    }
                    pe = new PliException(EX_DESC_SYNTAX_ERRORS_FOUND);
                    pe.setMessageNote(this.getMessageNote(pliOptions, bFullProgram));
                    pe.setErrorMessagesVector(this.lastErrors);
                    PliPlugin.getDefault().writeMsg(Level.SEVERE, "*** PliSourceResource.doInternalLoad(...): Syntax errors found. Check in the task list.", pe);
                    throw pe;
                }
                PliPlugin.getDefault().writeMsg(Level.SEVERE, "*** PliSourceResource.doInternalLoad(...): No language elements.");
                PliException ce = new PliException(EX_DESC_SYNTAX_ERRORS_FOUND);
                ce.setMessageNote(this.getNoElementsFoundMessageNote());
                throw ce;
            }
            catch (Throwable throwable) {
                if (tmpdir == null) throw throwable;
                if (bDebugFlag_STAY_WORKING_FOLDER) {
                    PliPlugin.getDefault().writeMsg(Level.FINE, "*** PliSourceResourceWin.doInternalLoad(...): DEBUG MODE, Don't delete working folder.");
                    throw throwable;
                }
                this.deleteFileWithChildren(tmpdir);
                throw throwable;
            }
        }
        if (tmpdir == null) return;
        if (bDebugFlag_STAY_WORKING_FOLDER) {
            PliPlugin.getDefault().writeMsg(Level.FINE, "*** PliSourceResourceWin.doInternalLoad(...): DEBUG MODE, Don't delete working folder.");
            return;
        }
        this.deleteFileWithChildren(tmpdir);
    }

    private void doPostLoad(Map options) {
        HashMap<Integer, FloatValue> fpfs = new HashMap<Integer, FloatValue>();
        fpfs.put(new Integer(0), FloatValue.IEEE_NON_EXTENDED_LITERAL);
        fpfs.put(new Integer(1), FloatValue.IBM390_HEX_LITERAL);
        FloatValue fpt = (FloatValue)fpfs.get((Integer)options.get("com.ibm.ccl.pli.PLI_FLOATING_POINT_FORMAT"));
        String codepage = (String)options.get("com.ibm.ccl.pli.PLI_CODEPAGE");
        String endian = (String)options.get("com.ibm.ccl.pli.PLI_ENDIAN");
        Boolean ims = (Boolean)options.get("com.ibm.ccl.pli.PLI_IMS_SUPPORT");
        Boolean bigEndian = new Boolean(endian.equals("Big"));
        Iterator itor = this.getContents().iterator();
        int n = 0;
        while (itor.hasNext()) {
            Object flt;
            Object i;
            Object obj = itor.next();
            if (obj instanceof PlatformCompilerInfoImpl) {
                PlatformCompilerInfoImpl p = (PlatformCompilerInfoImpl)obj;
                p.setDefaultBigEndian(bigEndian);
                p.setDefaultCodepage(codepage);
                p.setDefaultFloatType(fpt);
            } else if (obj instanceof IntegerTDImpl) {
                i = (IntegerTDImpl)obj;
                i.setBigEndian(bigEndian);
            } else if (obj instanceof PLIIntegerTypeImpl) {
                i = (PLIIntegerTypeImpl)obj;
                ((PLIIntegerTypeImpl)i).setBigEndian(bigEndian);
            } else if (obj instanceof FloatTDImpl) {
                flt = (FloatTDImpl)obj;
                flt.setBigEndian(bigEndian);
                flt.setFloatType(fpt);
            } else if (obj instanceof PLIFloatTypeImpl) {
                flt = (PLIFloatTypeImpl)obj;
                ((PLIFloatTypeImpl)flt).setBigEndian(bigEndian);
            } else if (obj instanceof StringTDImpl) {
                StringTDImpl st = (StringTDImpl)obj;
                st.setCodepage(codepage);
            } else if (obj instanceof PLIElementImpl && ims.booleanValue() && this.findLengthItem((PLIElementImpl)obj)) {
                this.bProcessedIMS = false;
                this.processIMS((PLIElementImpl)obj);
            }
            ++n;
        }
    }

    private void processIMS(PLIElementImpl pli) {
        InstanceTDBase ti = pli.getInstanceTDBase();
        boolean hasAdjusted = false;
        if (ti != null && ti.isSetOffset()) {
            int offset = Integer.parseInt(ti.getOffset());
            if (ti.getAttributeInBit().booleanValue()) {
                if (offset > 0) {
                    offset -= 16;
                }
            } else if (offset > 0) {
                offset -= 2;
            }
            ti.setOffset(Integer.toString(offset));
        }
        if (!this.bProcessedIMS) {
            if (ti.isSetContentSize()) {
                ti.setContentSize(Integer.toString(Integer.parseInt(ti.getContentSize()) - 2));
                hasAdjusted = true;
            }
            if (ti.isSetSize()) {
                ti.setSize(Integer.toString(Integer.parseInt(ti.getSize()) - 2));
                hasAdjusted = true;
            }
        }
        TreeIterator i = pli.getSharedType().eAllContents();
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof PLIElementImpl)) continue;
            this.processIMS((PLIElementImpl)o);
        }
        if (!this.bProcessedIMS && this.isLL(pli, hasAdjusted)) {
            PLIClassifier e;
            this.bProcessedIMS = true;
            if (ti instanceof SimpleInstanceTD) {
                BaseTDType btd = ((SimpleInstanceTD)ti).getSharedType();
                btd.setWidth(2);
            }
            if ((e = pli.getSharedType()) instanceof PLIIntegerType) {
                ((PLIIntegerType)e).setPrecision(new Integer(15));
            }
        }
    }

    private boolean findLengthItem(PLIElementImpl pli) {
        if (this.isLL(pli, false)) {
            return true;
        }
        TreeIterator ti = pli.getSharedType().eAllContents();
        while (ti.hasNext()) {
            Object o = ti.next();
            if (!(o instanceof PLIElementImpl) || !this.findLengthItem((PLIElementImpl)o)) continue;
            return true;
        }
        return false;
    }

    private boolean isLL(PLIElement pli, boolean hasAdjusted) {
        InstanceTDBase ti;
        PLIClassifier cst = pli.getSharedType();
        return cst instanceof PLIIntegerType && (ti = pli.getInstanceTDBase()).getOffset().equals("0") && (!hasAdjusted && ti.getContentSize().equals("4") || hasAdjusted && ti.getContentSize().equals("2"));
    }

    private void updateOptionsListByMap(Vector opts, Map pliOptions) {
        String cicsver;
        String str;
        boolean b;
        int v;
        boolean b2;
        String fileName;
        String xmlOpt = "";
        if (pliOptions.containsKey("com.ibm.ccl.pli.PLI_ERROR_FEEDBACK_FILE_PATH") && (fileName = ((String)pliOptions.get("com.ibm.ccl.pli.PLI_ERROR_FEEDBACK_FILE_PATH")).trim()).length() > 0) {
            xmlOpt = ",xml";
            this.needCopySyntaxfile = true;
        }
        opts.add("xinfo(xmi,syn" + xmlOpt + ") nc");
        if (pliOptions.containsKey("com.ibm.ccl.pli.PLI_DBCS") && (b2 = ((Boolean)pliOptions.get("com.ibm.ccl.pli.PLI_DBCS")).booleanValue())) {
            opts.add("DBCS");
        }
        if (pliOptions.containsKey("com.ibm.ccl.pli.PLI_GRAPHIC") && (b = ((Boolean)pliOptions.get("com.ibm.ccl.pli.PLI_GRAPHIC")).booleanValue())) {
            opts.add("GRAPHIC");
        }
        Vector<String> limitsOpt = new Vector<String>();
        if (pliOptions.containsKey("com.ibm.ccl.pli.PLI_LIMITS_NAME") && (v = ((Integer)pliOptions.get("com.ibm.ccl.pli.PLI_LIMITS_NAME")).intValue()) != 100) {
            limitsOpt.add("NAME(" + v + ")");
        }
        if (pliOptions.containsKey("com.ibm.ccl.pli.PLI_LIMITS_EXTNAME") && (v = ((Integer)pliOptions.get("com.ibm.ccl.pli.PLI_LIMITS_EXTNAME")).intValue()) != 7) {
            limitsOpt.add("EXTNAME(" + v + ")");
        }
        if (pliOptions.containsKey("com.ibm.ccl.pli.PLI_LIMITS_FIXEDBIN")) {
            v = (Integer)pliOptions.get("com.ibm.ccl.pli.PLI_LIMITS_FIXEDBIN");
            switch (v) {
                case 2: {
                    limitsOpt.add("FIXEDBIN(31,63)");
                    break;
                }
                case 1: {
                    limitsOpt.add("FIXEDBIN(63)");
                    break;
                }
                case 0: {
                    limitsOpt.add("FIXEDBIN(31)");
                    break;
                }
            }
        }
        if (pliOptions.containsKey("com.ibm.ccl.pli.PLI_LIMITS_FIXEDDEC")) {
            v = (Integer)pliOptions.get("com.ibm.ccl.pli.PLI_LIMITS_FIXEDDEC");
            switch (v) {
                case 2: {
                    limitsOpt.add("FIXEDDEC(15,31)");
                    break;
                }
                case 1: {
                    limitsOpt.add("FIXEDDEC(31)");
                    break;
                }
                case 0: {
                    limitsOpt.add("FIXEDDEC(15)");
                    break;
                }
            }
        }
        if (limitsOpt.size() > 0) {
            StringBuffer limitsStr = new StringBuffer();
            limitsStr.append("LIMITS(");
            Iterator itorLimits = limitsOpt.iterator();
            boolean bFirst = true;
            while (itorLimits.hasNext()) {
                if (bFirst) {
                    bFirst = false;
                } else {
                    limitsStr.append(",");
                }
                limitsStr.append((String)itorLimits.next());
            }
            limitsStr.append(")");
            opts.add(limitsStr.toString());
        }
        if (pliOptions.containsKey("com.ibm.ccl.pli.PLI_MARGIN_LEFT") && pliOptions.containsKey("com.ibm.ccl.pli.PLI_MARGIN_RIGHT")) {
            int ml = (Integer)pliOptions.get("com.ibm.ccl.pli.PLI_MARGIN_LEFT");
            int mr = (Integer)pliOptions.get("com.ibm.ccl.pli.PLI_MARGIN_RIGHT");
            if (ml != 2 || mr != 72) {
                opts.add("MARGINS(" + ml + "," + mr + ")");
            }
        }
        if (pliOptions.containsKey("com.ibm.ccl.pli.PLI_MACRO") && (b = ((Boolean)pliOptions.get("com.ibm.ccl.pli.PLI_MACRO")).booleanValue())) {
            opts.add("MACRO");
        }
        if (pliOptions.containsKey("com.ibm.ccl.pli.PLI_SYSPARM") && (str = (String)pliOptions.get("com.ibm.ccl.pli.PLI_SYSPARM")) != null && str.length() > 0) {
            opts.add("SYSPARM(" + str + ")");
        }
        if (pliOptions.containsKey("com.ibm.ccl.pli.PLI_BLANK") && (str = (String)pliOptions.get("com.ibm.ccl.pli.PLI_BLANK")) != null && str.length() > 0) {
            opts.add("BLANK(" + str + ")");
        }
        if (pliOptions.containsKey("com.ibm.ccl.pli.PLI_CURRENCY") && (str = (String)pliOptions.get("com.ibm.ccl.pli.PLI_CURRENCY")) != null && str.length() > 0) {
            opts.add("CURRENCY(" + str + ")");
        }
        if (pliOptions.containsKey("com.ibm.ccl.pli.PLI_NOT") && (str = (String)pliOptions.get("com.ibm.ccl.pli.PLI_NOT")) != null && str.length() > 0) {
            opts.add("NOT(" + str + ")");
        }
        if (pliOptions.containsKey("com.ibm.ccl.pli.PLI_OR") && (str = (String)pliOptions.get("com.ibm.ccl.pli.PLI_OR")) != null && str.length() > 0) {
            opts.add("OR(" + str + ")");
        }
        if (pliOptions.containsKey("com.ibm.ccl.pli.PLI_NAMES_TYPE")) {
            v = (Integer)pliOptions.get("com.ibm.ccl.pli.PLI_NAMES_TYPE");
            switch (v) {
                case 1: {
                    opts.add("NAMES(" + pliOptions.get("com.ibm.ccl.pli.PLI_NAMES_SINGLE_TEXT") + ")");
                    break;
                }
                case 2: {
                    opts.add("NAMES(" + pliOptions.get("com.ibm.ccl.pli.PLI_NAMES_DOUBLE_TEXT_1") + "," + pliOptions.get("com.ibm.ccl.pli.PLI_NAMES_DOUBLE_TEXT_2") + ")");
                    break;
                }
            }
        }
        if (pliOptions.containsKey("com.ibm.ccl.pli.PLI_NATLANG") && !(str = (String)pliOptions.get("com.ibm.ccl.pli.PLI_NATLANG")).equalsIgnoreCase(NATLANG[3][0])) {
            opts.add("NATLANG(" + str + ")");
        }
        if (pliOptions.containsKey("com.ibm.ccl.pli.PLI_CICS_VERSION") && !((String)pliOptions.get("com.ibm.ccl.pli.PLI_CICS_VERSION")).equals("NOCICS") && (cicsver = (String)pliOptions.get("com.ibm.ccl.pli.PLI_CICS_VERSION")) != null) {
            if (cicsver.equals("31")) {
                opts.add(CICSTXUtil.getOptionForCICS31());
            } else if (cicsver.equals("32")) {
                opts.add(CICSTXUtil.getOptionForCICS32());
            }
        }
    }

    private String getPliOptionString(Vector opts) {
        StringBuffer result = new StringBuffer();
        boolean isFirst = true;
        Iterator itor = opts.iterator();
        result.append("(");
        while (itor.hasNext()) {
            if (!isFirst) {
                result.append(' ');
            } else {
                isFirst = false;
            }
            result.append(itor.next().toString());
        }
        result.append(")");
        return result.toString();
    }

    private String getTargetFileName(URI uri) {
        String uriFileString = "";
        if (uri.isFile()) {
            uriFileString = uri.toFileString();
        } else {
            String PLATFORM = "platform";
            String RESOURCE = "resource";
            if (uri.scheme().equals(PLATFORM) && uri.segment(0).equals(RESOURCE)) {
                String f = URI.decode((String)uri.path());
                f = f.substring(PLATFORM.length() + 1);
                IFile ifile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(f));
                uriFileString = ifile.getLocation().toOSString();
            }
        }
        String targetFileName = null;
        Path absPath = new Path(uriFileString);
        if (this.isRFile((IPath)absPath)) {
            PliPlugin.getDefault().writeMsg(Level.FINE, "*** PliSourceResourceWin.doLoad(...): Selected file is a remote file [" + uriFileString.toString() + "]");
            targetFileName = uriFileString;
        } else {
            String resourceFileString = null;
            IFile typesFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)absPath);
            if (typesFile == null) {
                resourceFileString = absPath.toOSString();
                PliPlugin.getDefault().writeMsg(Level.FINE, "*** PliSourceResourceWin.doLoad(...): File is not an IFile = " + absPath.toString());
            } else {
                resourceFileString = typesFile.getLocation().toOSString();
                PliPlugin.getDefault().writeMsg(Level.FINE, "*** PliSourceResourceWin.doLoad(...): Selected IFile = " + typesFile);
            }
            PliPlugin.getDefault().writeMsg(Level.FINE, "*** PliSourceResourceWin.doLoad(...): resource file = " + resourceFileString);
            targetFileName = resourceFileString;
        }
        return targetFileName;
    }

    private Map getPliOption(Map options) {
        Set keys;
        HashMap pliOption = PliPreferenceStore.getValues();
        if (options != null && (keys = options.keySet()) != null) {
            for (Object k : keys) {
                Object src = options.get(k);
                if (src != null && pliOption.containsKey(k)) {
                    Object dst = pliOption.get(k);
                    if (dst == null || src.getClass().isInstance(dst)) {
                        pliOption.put(k, src);
                        continue;
                    }
                    PliPlugin.getDefault().writeMsg(Level.FINE, "*** PliSourceResourceWin.getPliOption(...): Invalid type of the value. key = " + k);
                    continue;
                }
                PliPlugin.getDefault().writeMsg(Level.FINE, "*** PliSourceResourceWin.getPliOption(...): Original map does not contain the key(" + k + ")");
            }
        }
        return pliOption;
    }

    private void deleteFileWithChildren(File f) {
        File[] childlen;
        if (f.isDirectory() && (childlen = f.listFiles()) != null) {
            int i = 0;
            while (i < childlen.length) {
                this.deleteFileWithChildren(childlen[i]);
                ++i;
            }
        }
        f.delete();
    }

    private void loadXMI(String fullPath) throws IOException {
        URI uriOfXmiFile = URI.createFileURI((String)fullPath);
        Resource.Factory rf = Resource.Factory.Registry.INSTANCE.getFactory(uriOfXmiFile);
        XMLResource importerResource = (XMLResource)rf.createResource(uriOfXmiFile);
        importerResource.load(null);
        EList loadedContents = importerResource.getContents();
        for (EObject eobj : loadedContents) {
            String id = importerResource.getID(eobj);
            this.setID(eobj, id);
        }
        this.getContents().addAll((Collection)loadedContents);
    }

    private boolean isRFile(IPath p) {
        return p.isUNC() && p.segment(0).equalsIgnoreCase("ffssash");
    }

    private File createTempFolder() throws PliException {
        String tmpFolderName;
        File tmpFolder;
        String baseLocation = String.valueOf(PliPlugin.getDefault().getStateLocation().toOSString()) + "/";
        do {
            tmpFolderName = new Long(new Date().getTime()).toString();
        } while ((tmpFolder = new File(String.valueOf(baseLocation) + tmpFolderName)).exists());
        if (!tmpFolder.mkdir()) {
            PliException ex = new PliException("_Error_Creating_Folder");
            PliPlugin.getDefault().writeMsg(Level.SEVERE, "*** PliSourceResourceWin.doLoad(...): Creation of Directory " + tmpFolder.getName() + " Failed", ex);
            throw ex;
        }
        PliPlugin.getDefault().writeMsg(Level.FINE, "*** PliSourceResourceWin.doLoad(...): Created Directory " + tmpFolder.getName() + " Successfully");
        return tmpFolder;
    }

    private String[] createStringArray(AbstractCollection c) {
        String[] ary = null;
        if (!c.isEmpty()) {
            Iterator itor = c.iterator();
            ary = new String[c.size()];
            int idx = 0;
            while (itor.hasNext()) {
                Object o = itor.next();
                ary[idx] = o.toString();
                ++idx;
            }
        }
        return ary;
    }

    private void openProblemsView() {
        if (PlatformUI.isWorkbenchRunning()) {
            Display display = PlatformUI.getWorkbench().getDisplay();
            if (display != null) {
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        IWorkbenchWindow[] windows = PliPlugin.getDefault().getWorkbench().getWorkbenchWindows();
                        if (windows != null) {
                            int i = 0;
                            while (i < windows.length) {
                                IWorkbenchPage page = windows[i].getActivePage();
                                if (page != null) {
                                    IViewPart problemsView = page.findView("org.eclipse.ui.views.ProblemView");
                                    try {
                                        if (problemsView == null) {
                                            page.showView("org.eclipse.ui.views.ProblemView");
                                            IWorkbenchPart activePart = page.getActivePart();
                                            page.activate(activePart);
                                            break;
                                        }
                                        page.showView("org.eclipse.ui.views.ProblemView", null, 2);
                                        break;
                                    }
                                    catch (PartInitException e) {
                                        PliPlugin.getDefault().writeMsg(Level.SEVERE, "*** PliSourceResourceWin.openProblemsView(): Unable to open the Problems view.", e);
                                    }
                                }
                                ++i;
                            }
                        }
                    }
                });
            } else {
                PliPlugin.getDefault().writeMsg(Level.INFO, "*** PliSourceResourceWin.openProblemsView(): Unable to access Display.", new IllegalStateException());
            }
        } else {
            PliPlugin.getDefault().writeMsg(Level.INFO, "*** PliSourceResourceWin.openProblemsView(): Unable to access PlatformUI.", new IllegalStateException());
        }
    }

    public List getResourcesList() {
        return this.resourcesList;
    }

    private static void copyFile(File srcFile, File desFile) {
        block29: {
            FilterOutputStream output;
            block31: {
                BufferedInputStream input = null;
                output = null;
                try {
                    input = new BufferedInputStream(new FileInputStream(srcFile));
                    output = new BufferedOutputStream(new FileOutputStream(desFile));
                    byte[] buffer = new byte[8192];
                    int read = 0;
                    while ((read = input.read(buffer)) != -1) {
                        ((BufferedOutputStream)output).write(buffer, 0, read);
                    }
                }
                catch (FileNotFoundException e) {
                    PliPlugin.getDefault().writeMsg(Level.SEVERE, "*** PliSourceResourceWin.copyFile(...): File not found.", e);
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (output != null) {
                        try {
                            output.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block29;
                }
                catch (IOException e) {
                    block30: {
                        try {
                            PliPlugin.getDefault().writeMsg(Level.SEVERE, "*** PliSourceResourceWin.copyFile(...): I/O exception", e);
                            if (input == null) break block30;
                        }
                        catch (Throwable throwable) {
                            if (input != null) {
                                try {
                                    input.close();
                                }
                                catch (IOException iOException) {}
                            }
                            if (output != null) {
                                try {
                                    output.close();
                                }
                                catch (IOException iOException) {}
                            }
                            throw throwable;
                        }
                        try {
                            input.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (output != null) {
                        try {
                            output.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block29;
                }
                if (input == null) break block31;
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private String getNoElementsFoundMessageNote() {
        String fileName = this.getURI().lastSegment();
        Object[] obj = new Object[]{fileName};
        String errMsg = String.valueOf(PliResources._UI_Syntax_Errors_Found_For_IFile_Reason_Label) + "\n" + NLS.bind((String)PliResources._UI_Syntax_Errors_Found_For_IFile_NoDataReason1, (Object[])obj) + "\n";
        errMsg = String.valueOf(errMsg) + NLS.bind((String)PliResources._UI_Syntax_Errors_Found_For_IFile_NoDataReason2, (Object[])obj);
        errMsg = String.valueOf(errMsg) + PliResources._UI_Syntax_Errors_Found_For_IFile_MoreInfo;
        return errMsg;
    }

    private String getMessageNote(Map pliOptions, boolean bFullProgram) {
        String fileName = this.getURI().lastSegment();
        String cfr_ignored_0 = "." + this.getURI().fileExtension();
        Object[] obj = new Object[]{fileName};
        Object[] viewName = new Object[]{pliOptions.get("com.ibm.ccl.pli.PRE_CPLI_ERRORS_VIEW_NAME")};
        String errMsg = String.valueOf(PliResources._UI_Syntax_Errors_Found_For_IFile_Reason_Label) + "\n" + NLS.bind((String)PliResources._UI_Syntax_Errors_Found_For_IFile_Reason1, (Object[])viewName) + "\n";
        errMsg = bFullProgram ? String.valueOf(errMsg) + NLS.bind((String)PliResources._UI_Syntax_Errors_Found_For_IFile_Reason2a, (Object[])obj) : String.valueOf(errMsg) + NLS.bind((String)PliResources._UI_Syntax_Errors_Found_For_IFile_Reason2b, (Object[])obj);
        errMsg = String.valueOf(errMsg) + PliResources._UI_Syntax_Errors_Found_For_IFile_MoreInfo;
        return errMsg;
    }

    private List getPliTopElements() {
        ArrayList<PLIElement> eleList = new ArrayList<PLIElement>();
        for (Object possibleType : this.getContents()) {
            PLIClassifier childClassifier;
            if (!(possibleType instanceof PLIElement) || !((childClassifier = ((PLIElement)possibleType).getSharedType()) instanceof PLIComposedType) && !(childClassifier instanceof PLISimpleType)) continue;
            eleList.add((PLIElement)possibleType);
        }
        return eleList;
    }

    private class ProcessWatcher {
        private Process proc;
        private StreamWatcher swStdout;
        private StreamWatcher swStderr;

        private ProcessWatcher(Process p) {
            this.proc = p;
            this.swStdout = new StreamWatcher(this.proc.getInputStream());
            this.swStderr = new StreamWatcher(this.proc.getErrorStream());
        }

        private int waitFor() throws InterruptedException {
            int result = 0;
            try {
                try {
                    result = this.proc.waitFor();
                }
                catch (InterruptedException e) {
                    PliPlugin.getDefault().writeMsg(Level.SEVERE, "*** ProcessWatcher.waitFor(...): Fail to execute PL/I importer.", e);
                    throw e;
                }
            }
            finally {
                this.swStdout.waitFor();
                this.swStderr.waitFor();
                this.proc.destroy();
                this.swStdout = null;
                this.swStderr = null;
                this.proc = null;
            }
            return result;
        }

        protected AbstractList getStdoutResult() {
            return this.swStdout.getOutputs();
        }

        protected AbstractList getStderrResult() {
            return this.swStderr.getOutputs();
        }
    }

    private class StreamWatcher
    implements Runnable {
        private BufferedReader reader;
        private boolean bRunning = true;
        private boolean bFinished = false;
        private Vector<String> outputs = new Vector();

        private StreamWatcher(InputStream is) {
            this.reader = new BufferedReader(new InputStreamReader(is));
            Thread t = new Thread(this);
            t.start();
        }

        private void waitFor() {
            if (this.bRunning) {
                this.bRunning = false;
                try {
                    while (!this.bFinished) {
                        Thread.sleep(100L);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }

        private AbstractList getOutputs() {
            return this.outputs;
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [13[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private void readFromStream() {
            try {
                while (this.reader.ready()) {
                    this.outputs.add(this.reader.readLine());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

