/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.pli.importer;

import com.ibm.ccl.pli.importer.IPliPreferenceConstants;
import com.ibm.ccl.pli.plugin.PliPlugin;
import com.ibm.ccl.pli.plugin.PliResources;
import java.util.HashMap;
import java.util.logging.Level;
import org.eclipse.jface.preference.IPreferenceStore;

public class PliPreferenceStore
implements IPliPreferenceConstants {
    public static final String copyright = "Licensed Materials - Property of IBM\ncom.ibm.ccl.pli\nCopyright IBM Corporation 2004, 2007. All Rights Reserved.\nNote to U.S. Government Users Restricted Rights:  Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp. ";
    public static final HashMap defaultValues = new HashMap();
    static final int PROPERTY_TYPE_BOOLEAN = 0;
    static final int PROPERTY_TYPE_INT = 1;
    static final int PROPERTY_TYPE_STRING = 2;

    static {
        defaultValues.put("com.ibm.ccl.pli.PLI_DBCS", new Boolean(false));
        defaultValues.put("com.ibm.ccl.pli.PLI_GRAPHIC", new Boolean(false));
        defaultValues.put("com.ibm.ccl.pli.PLI_LIMITS_NAME", new Integer(100));
        defaultValues.put("com.ibm.ccl.pli.PLI_LIMITS_EXTNAME", new Integer(7));
        defaultValues.put("com.ibm.ccl.pli.PLI_LIMITS_FIXEDBIN", new Integer(2));
        defaultValues.put("com.ibm.ccl.pli.PLI_LIMITS_FIXEDDEC", new Integer(2));
        defaultValues.put("com.ibm.ccl.pli.PLI_MARGIN_LEFT", new Integer(2));
        defaultValues.put("com.ibm.ccl.pli.PLI_MARGIN_RIGHT", new Integer(72));
        defaultValues.put("com.ibm.ccl.pli.PLI_MACRO", new Boolean(false));
        defaultValues.put("com.ibm.ccl.pli.PLI_SYSPARM", "");
        defaultValues.put("com.ibm.ccl.pli.PLI_BLANK", "");
        defaultValues.put("com.ibm.ccl.pli.PLI_CURRENCY", "");
        defaultValues.put("com.ibm.ccl.pli.PLI_NOT", "");
        defaultValues.put("com.ibm.ccl.pli.PLI_OR", "");
        defaultValues.put("com.ibm.ccl.pli.PLI_NAMES_TYPE", new Integer(0));
        defaultValues.put("com.ibm.ccl.pli.PLI_NAMES_SINGLE_TEXT", "'#@$'");
        defaultValues.put("com.ibm.ccl.pli.PLI_NAMES_DOUBLE_TEXT_1", "'#@$'");
        defaultValues.put("com.ibm.ccl.pli.PLI_NAMES_DOUBLE_TEXT_2", "'#@$'");
        defaultValues.put("com.ibm.ccl.pli.PLI_NATLANG", NATLANG[3][0]);
        int i = 0;
        while (i < PRE_PLI_EXTENSION.length) {
            defaultValues.put(PRE_PLI_EXTENSION[i], new Integer(DEFAULT_FILETYPE[i]));
            ++i;
        }
        defaultValues.put("com.ibm.ccl.pli.PRE_PLI_DEBUG_STAY_FOLDER", new Boolean(false));
        defaultValues.put("com.ibm.ccl.pli.PLI_PLATFORM_SELECTION", new Integer(0));
        defaultValues.put("com.ibm.ccl.pli.PLI_CODEPAGE", "ISO-8859-1");
        defaultValues.put("com.ibm.ccl.pli.PLI_FLOATING_POINT_FORMAT", new Integer(0));
        defaultValues.put("com.ibm.ccl.pli.PLI_ENDIAN", "Little");
        defaultValues.put("com.ibm.ccl.pli.PLI_IMS_SUPPORT", new Boolean(false));
        defaultValues.put("com.ibm.ccl.pli.PLI_SYSLIB", "");
        defaultValues.put("com.ibm.ccl.pli.PLI_POSTERRORS_TO_PROBLEMS_VIEW", new Boolean(true));
        defaultValues.put("com.ibm.ccl.pli.PRE_CPLI_ERRORS_VIEW_NAME", PliResources._UI_Syntax_Errors_View_Name);
        defaultValues.put("com.ibm.ccl.pli.PLI_ERROR_FEEDBACK_FILE_PATH", "");
        defaultValues.put("com.ibm.ccl.pli.PLI_CICS_VERSION", "NOCICS");
    }

    public static HashMap getValues() {
        PliPlugin p = PliPlugin.getDefault();
        IPreferenceStore store = null;
        if (p != null) {
            store = p.getPreferenceStore();
        }
        if (store == null) {
            return (HashMap)defaultValues.clone();
        }
        HashMap map = (HashMap)defaultValues.clone();
        PliPreferenceStore.updateMapInteger(map, store, "com.ibm.ccl.pli.PLI_PLATFORM_SELECTION");
        PliPreferenceStore.updateMapString(map, store, "com.ibm.ccl.pli.PLI_CODEPAGE");
        PliPreferenceStore.updateMapInteger(map, store, "com.ibm.ccl.pli.PLI_FLOATING_POINT_FORMAT");
        PliPreferenceStore.updateMapString(map, store, "com.ibm.ccl.pli.PLI_ENDIAN");
        PliPreferenceStore.updateMapBoolean(map, store, "com.ibm.ccl.pli.PLI_DBCS");
        PliPreferenceStore.updateMapBoolean(map, store, "com.ibm.ccl.pli.PLI_GRAPHIC");
        PliPreferenceStore.updateMapInteger(map, store, "com.ibm.ccl.pli.PLI_LIMITS_NAME");
        PliPreferenceStore.updateMapInteger(map, store, "com.ibm.ccl.pli.PLI_LIMITS_EXTNAME");
        PliPreferenceStore.updateMapInteger(map, store, "com.ibm.ccl.pli.PLI_LIMITS_FIXEDBIN");
        PliPreferenceStore.updateMapInteger(map, store, "com.ibm.ccl.pli.PLI_LIMITS_FIXEDDEC");
        PliPreferenceStore.updateMapInteger(map, store, "com.ibm.ccl.pli.PLI_MARGIN_LEFT");
        PliPreferenceStore.updateMapInteger(map, store, "com.ibm.ccl.pli.PLI_MARGIN_RIGHT");
        PliPreferenceStore.updateMapBoolean(map, store, "com.ibm.ccl.pli.PLI_MACRO");
        PliPreferenceStore.updateMapString(map, store, "com.ibm.ccl.pli.PLI_SYSPARM");
        PliPreferenceStore.updateMapString(map, store, "com.ibm.ccl.pli.PLI_BLANK");
        PliPreferenceStore.updateMapString(map, store, "com.ibm.ccl.pli.PLI_CURRENCY");
        PliPreferenceStore.updateMapString(map, store, "com.ibm.ccl.pli.PLI_NOT");
        PliPreferenceStore.updateMapString(map, store, "com.ibm.ccl.pli.PLI_OR");
        PliPreferenceStore.updateMapInteger(map, store, "com.ibm.ccl.pli.PLI_NAMES_TYPE");
        PliPreferenceStore.updateMapString(map, store, "com.ibm.ccl.pli.PLI_NAMES_SINGLE_TEXT");
        PliPreferenceStore.updateMapString(map, store, "com.ibm.ccl.pli.PLI_NAMES_DOUBLE_TEXT_1");
        PliPreferenceStore.updateMapString(map, store, "com.ibm.ccl.pli.PLI_NAMES_DOUBLE_TEXT_2");
        PliPreferenceStore.updateMapString(map, store, "com.ibm.ccl.pli.PLI_NATLANG");
        int i = 0;
        while (i < PRE_PLI_EXTENSION.length) {
            PliPreferenceStore.updateMapInteger(map, store, PRE_PLI_EXTENSION[i]);
            ++i;
        }
        PliPreferenceStore.updateMapBoolean(map, store, "com.ibm.ccl.pli.PLI_IMS_SUPPORT");
        PliPreferenceStore.updateMapBoolean(map, store, "com.ibm.ccl.pli.PRE_PLI_DEBUG_STAY_FOLDER");
        PliPreferenceStore.updateMapString(map, store, "com.ibm.ccl.pli.PLI_SYSLIB");
        PliPreferenceStore.updateMapBoolean(map, store, "com.ibm.ccl.pli.PLI_POSTERRORS_TO_PROBLEMS_VIEW");
        PliPreferenceStore.updateMapString(map, store, "com.ibm.ccl.pli.PLI_ERROR_FEEDBACK_FILE_PATH");
        PliPreferenceStore.updateMapString(map, store, "com.ibm.ccl.pli.PLI_CICS_VERSION");
        return map;
    }

    private static void updateMapBoolean(HashMap map, IPreferenceStore store, String key) {
        boolean value = store.getBoolean(key);
        map.put(key, new Boolean(value));
    }

    private static void updateMapInteger(HashMap map, IPreferenceStore store, String key) {
        int value = store.getInt(key);
        map.put(key, new Integer(value));
    }

    private static void updateMapString(HashMap map, IPreferenceStore store, String key) {
        String value = store.getString(key);
        map.put(key, value);
    }

    public static void storeValues(HashMap map) {
        PliPlugin p = PliPlugin.getDefault();
        IPreferenceStore store = null;
        if (p != null) {
            store = p.getPreferenceStore();
        }
        if (store == null) {
            PliPlugin.getDefault().writeMsg(Level.SEVERE, "*** PliPreferenceStore.storeValues(...): Cannot get an instance of PL/I preference store.");
            return;
        }
        for (String key : map.keySet()) {
            try {
                switch (PliPreferenceStore.getPropertyType(key)) {
                    case 0: {
                        boolean b = (Boolean)map.get(key);
                        store.setValue(key, b);
                        break;
                    }
                    case 1: {
                        int v = (Integer)map.get(key);
                        store.setValue(key, v);
                        break;
                    }
                    default: {
                        String s = (String)map.get(key);
                        store.setValue(key, s);
                        break;
                    }
                }
            }
            catch (Exception ex) {
                PliPlugin.getDefault().writeMsg(Level.SEVERE, "*** PliPreferenceStore.storeValues(...): Fail to store the value(" + key + ").", ex);
            }
        }
    }

    static int getPropertyType(String key) {
        if (key.equals("com.ibm.ccl.pli.PLI_DBCS") || key.equals("com.ibm.ccl.pli.PLI_GRAPHIC") || key.equals("com.ibm.ccl.pli.PLI_MACRO") || key.equals("com.ibm.ccl.pli.PRE_PLI_DEBUG_STAY_FOLDER") || key.equals("com.ibm.ccl.pli.PLI_IMS_SUPPORT") || key.equals("com.ibm.ccl.pli.PLI_POSTERRORS_TO_PROBLEMS_VIEW")) {
            return 0;
        }
        if (key.equals("com.ibm.ccl.pli.PLI_LIMITS_NAME") || key.equals("com.ibm.ccl.pli.PLI_LIMITS_EXTNAME") || key.equals("com.ibm.ccl.pli.PLI_LIMITS_FIXEDBIN") || key.equals("com.ibm.ccl.pli.PLI_LIMITS_FIXEDDEC") || key.equals("com.ibm.ccl.pli.PLI_MARGIN_LEFT") || key.equals("com.ibm.ccl.pli.PLI_MARGIN_RIGHT") || key.equals("com.ibm.ccl.pli.PLI_NAMES_TYPE")) {
            return 1;
        }
        if (key.equals("com.ibm.ccl.pli.PLI_PLATFORM_SELECTION") || key.equals("com.ibm.ccl.pli.PLI_FLOATING_POINT_FORMAT")) {
            return 1;
        }
        int i = 0;
        while (i < PRE_PLI_EXTENSION.length) {
            if (key.equals(PRE_PLI_EXTENSION[i])) {
                return 1;
            }
            ++i;
        }
        return 2;
    }

    public static HashMap getDefaultValues() {
        return (HashMap)defaultValues.clone();
    }
}

