/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.pli2xsd.typesimport;

import com.ibm.adapter.framework.BaseException;
import com.ibm.ccl.pli.PLIElement;
import com.ibm.ccl.pli.PLIFixedLengthString;
import com.ibm.ccl.pli.PLIFloatType;
import com.ibm.ccl.pli.PLIIntegerType;
import com.ibm.ccl.pli.PLIPackedType;
import com.ibm.ccl.pli.PLIPictureStringType;
import com.ibm.ccl.pli.PLIPictureType;
import com.ibm.ccl.pli.PLIPointerType;
import com.ibm.ccl.pli.PLISimpleType;
import com.ibm.ccl.pli.PLIVariableLengthString;
import com.ibm.ccl.pli.StringTypeValues;
import com.ibm.ccl.pli2xsd.MessageResource;
import com.ibm.ccl.pli2xsd.Pli2XSDPlugin;
import com.ibm.ccl.pli2xsd.util.GeneralUtil;
import com.ibm.icu.text.UTF16;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceFactoryRegistryImpl;
import org.eclipse.xsd.XSDComplexTypeContent;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDCompositor;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDFractionDigitsFacet;
import org.eclipse.xsd.XSDLengthFacet;
import org.eclipse.xsd.XSDMaxLengthFacet;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaContent;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTotalDigitsFacet;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.impl.XSDSchemaImpl;

public class XsdHelper {
    public static final String copyright = "(c) Copyright IBM Corporation 2001.";
    private static XsdHelper thisInstance;
    protected XSDFactory xsdFactory;
    protected Map pathXsdPair = new HashMap();
    private static HashMap rangeLookup;

    static {
        rangeLookup = new HashMap();
        rangeLookup.put("byte", new String[]{"-128", "128"});
        rangeLookup.put("short", new String[]{"-32768", "32767"});
        rangeLookup.put("unsignedShort", new String[]{"0", "65535"});
        rangeLookup.put("int", new String[]{"-2147483648", "2147483647"});
        rangeLookup.put("unsignedInt", new String[]{"0", "4294967295"});
        rangeLookup.put("long", new String[]{"-9223372036854775808", "9223372036854775807"});
        rangeLookup.put("unsignedLong", new String[]{"0", "18446744073709551615"});
    }

    public static String[] getDataTypeValueRange(String dataType) {
        return (String[])rangeLookup.get(dataType);
    }

    XsdHelper() {
        this.xsdFactory = XSDFactory.eINSTANCE;
    }

    public void addComplexTypeOrGroupToSchema(XSDSchemaContent schemaContent, XSDSchema schema, boolean overwriteTypes) throws BaseException {
        EList schemaContents = schema.getContents();
        int pos = this.indexInContentsList((List)schemaContents, schemaContent);
        if (!(pos < 0 || pos >= 0 && overwriteTypes)) {
            String errorMsg = MessageResource._ERROR_error_types_name_collision;
            String name = "";
            if (schemaContent instanceof XSDComplexTypeDefinition) {
                name = ((XSDComplexTypeDefinition)schemaContent).getName();
            } else if (schemaContent instanceof XSDModelGroupDefinition) {
                name = ((XSDModelGroupDefinition)schemaContent).getName();
            }
            Status status = new Status(4, Pli2XSDPlugin.getPluginID(), 4, String.valueOf(errorMsg) + ": " + name, null);
            throw new BaseException((IStatus)status);
        }
        new GeneralUtil().replaceOrAppendToList((List)schemaContents, schemaContent, pos);
    }

    private int countLength(String picStr) {
        int len = picStr.length();
        int leftBracketPos = -1;
        boolean firstDollar = true;
        int i = 0;
        while (i < picStr.length()) {
            int c = UTF16.charAt((String)picStr, (int)i);
            if (c == 86 || c == 118 || c == 83 || c == 115 || c == 43 || c == 45 || c == 46 || c == 44 || c == 66 || c == 98 || c == 47) {
                --len;
            } else if (c == 67 || c == 99 || c == 68 || c == 100) {
                len -= 2;
            } else if (c == 36 && firstDollar) {
                --len;
                firstDollar = false;
            } else if (c == 40) {
                --len;
                leftBracketPos = i;
            } else if (c == 41) {
                int n;
                --len;
                len -= i - leftBracketPos - 1;
                int size = Integer.parseInt(picStr.substring(leftBracketPos + 1, i));
                if ((n = UTF16.charAt((String)picStr, (int)(++i))) == 46 || n == 44 || n == 66 || n == 98 || n == 47) {
                    --len;
                } else if (n == 57 || n == 42 || n == 90 || n == 122 || n == 65 || n == 97 || n == 88 || n == 120) {
                    len += size - 1;
                } else if (n == 36) {
                    if (size > 1) {
                        len += size - 2;
                    } else if (size == 1) {
                        --len;
                    }
                }
            }
            i += UTF16.getCharCount((int)c);
        }
        return len;
    }

    public XSDModelGroupDefinition createGroupDef(String name, String modelGroupType, XSDSchema xsdSchema) {
        XSDModelGroupDefinition group = this.xsdFactory.createXSDModelGroupDefinition();
        group.setName(name);
        group.setTargetNamespace(xsdSchema.getTargetNamespace());
        XSDModelGroup modelGroup = this.xsdFactory.createXSDModelGroup();
        modelGroup.setCompositor(XSDCompositor.get((String)modelGroupType));
        group.setModelGroup(modelGroup);
        return group;
    }

    public String createGroupNameFromRefID(String refID, String topTypeName) {
        String str = refID.substring(refID.indexOf(":") + 1);
        str = String.valueOf(topTypeName) + str.substring(str.indexOf("/"));
        return str.replace('/', '_').toLowerCase();
    }

    public XSDParticle createGroupRefParticle(XSDModelGroupDefinition group) {
        XSDModelGroupDefinition groupRef = this.xsdFactory.createXSDModelGroupDefinition();
        groupRef.setResolvedModelGroupDefinition(group);
        XSDParticle groupRefPart = this.xsdFactory.createXSDParticle();
        groupRefPart.setContent((XSDParticleContent)groupRef);
        return groupRefPart;
    }

    public XSDComplexTypeDefinition createComplexTypeWithModelGroup(String ctName, String groupType) {
        XSDComplexTypeDefinition ct = this.xsdFactory.createXSDComplexTypeDefinition();
        ct.setName(ctName);
        XSDParticle part = this.xsdFactory.createXSDParticle();
        ct.setContent((XSDComplexTypeContent)part);
        XSDModelGroup modelGroup = this.xsdFactory.createXSDModelGroup();
        modelGroup.setCompositor(XSDCompositor.get((String)groupType));
        part.setContent((XSDParticleContent)modelGroup);
        return ct;
    }

    public XSDParticle createComplexTypeParticle(String eleName, String ctName, XSDSchema schema) {
        XSDParticle particle = this.xsdFactory.createXSDParticle();
        XSDElementDeclaration elementDec = this.xsdFactory.createXSDElementDeclaration();
        elementDec.setName(eleName);
        particle.setContent((XSDParticleContent)elementDec);
        elementDec.setTypeDefinition((XSDTypeDefinition)this.getXSDTypeForComplex(schema, ctName));
        return particle;
    }

    public XSDParticle createXsdElementPartWithComplexType(String eleName, int groupType, XSDModelGroup modelGroup) {
        XSDParticle elementPart = this.xsdFactory.createXSDParticle();
        XSDElementDeclaration element = this.xsdFactory.createXSDElementDeclaration();
        element.setName(eleName);
        elementPart.setContent((XSDParticleContent)element);
        XSDComplexTypeDefinition complexType = this.xsdFactory.createXSDComplexTypeDefinition();
        modelGroup.setCompositor(XSDCompositor.get((int)groupType));
        XSDParticle groupPart = this.xsdFactory.createXSDParticle();
        groupPart.setContent((XSDParticleContent)modelGroup);
        complexType.setContent((XSDComplexTypeContent)groupPart);
        element.setAnonymousTypeDefinition((XSDTypeDefinition)complexType);
        return elementPart;
    }

    public static synchronized XsdHelper getInstance() {
        if (thisInstance == null) {
            thisInstance = new XsdHelper();
        }
        return thisInstance;
    }

    public static synchronized XsdHelper getNewInstance() {
        return new XsdHelper();
    }

    public XSDModelGroup getModelGroup(XSDSchemaContent type) {
        if (type instanceof XSDComplexTypeDefinition) {
            return this.getModelGroup((XSDComplexTypeDefinition)type);
        }
        if (type instanceof XSDModelGroupDefinition) {
            return this.getModelGroup((XSDModelGroupDefinition)type);
        }
        return null;
    }

    public XSDModelGroup getModelGroup(XSDComplexTypeDefinition compType) {
        return (XSDModelGroup)((XSDParticle)compType.getContent()).getContent();
    }

    public XSDModelGroup getModelGroup(XSDModelGroupDefinition groupType) {
        return groupType.getModelGroup();
    }

    public List getModelGroupContents(XSDSchemaContent type) {
        if (type instanceof XSDComplexTypeDefinition) {
            return this.getModelGroupContents((XSDComplexTypeDefinition)type);
        }
        if (type instanceof XSDModelGroupDefinition) {
            return this.getModelGroupContents((XSDModelGroupDefinition)type);
        }
        return null;
    }

    public List getModelGroupContents(XSDComplexTypeDefinition ct) {
        return ((XSDModelGroup)((XSDParticle)ct.getContent()).getContent()).getContents();
    }

    public List getModelGroupContents(XSDModelGroupDefinition group) {
        return group.getModelGroup().getContents();
    }

    public String getNameForXSDSchemaContent(XSDSchemaContent con) {
        if (con instanceof XSDElementDeclaration) {
            return ((XSDElementDeclaration)con).getName();
        }
        if (con instanceof XSDSimpleTypeDefinition) {
            return ((XSDSimpleTypeDefinition)con).getName();
        }
        if (con instanceof XSDComplexTypeDefinition) {
            return ((XSDComplexTypeDefinition)con).getName();
        }
        if (con instanceof XSDModelGroupDefinition) {
            return ((XSDModelGroupDefinition)con).getName();
        }
        return null;
    }

    public XSDSchema getXsdSchemaFromXsdIFile(IFile xsdSchemaFile) {
        Resource.Factory factory = ResourceFactoryRegistryImpl.INSTANCE.getFactory(URI.createFileURI((String)xsdSchemaFile.getLocation().toOSString()));
        Resource resource = factory.createResource(URI.createFileURI((String)xsdSchemaFile.getLocation().toOSString()));
        EList list = resource.getContents();
        int i = 0;
        while (i < list.size()) {
            Object candidate = list.get(i);
            if (candidate instanceof XSDSchema) {
                return (XSDSchema)candidate;
            }
            ++i;
        }
        return null;
    }

    public XSDSimpleTypeDefinition getXSDSimpleType(PLISimpleType pliSimType, XSDSchema schema) {
        XSDSimpleTypeDefinition xsdSimType = this.xsdFactory.createXSDSimpleTypeDefinition();
        if (pliSimType instanceof PLIPictureType) {
            this.setRestrictionAndLengthFacet(schema, xsdSimType, this.expandPictureString(((PLIPictureType)pliSimType).getPictureString()), "string");
        } else if (pliSimType instanceof PLIPictureStringType) {
            this.setRestrictionAndLengthFacet(schema, xsdSimType, this.expandPictureString(((PLIPictureStringType)pliSimType).getPictureString()), "string");
        } else if (pliSimType instanceof PLIFixedLengthString) {
            PLIFixedLengthString fixedString = (PLIFixedLengthString)pliSimType;
            int length = fixedString.getLength();
            StringTypeValues type = fixedString.getType();
            if (type.getValue() == 3 || type.getValue() == 2) {
                this.setRestrictionAndLengthFacet(schema, xsdSimType, length * 2, "hexBinary", false);
            } else if (type.getValue() == 0) {
                if (length % 8 == 0) {
                    if (fixedString.getVarying().getValue() == 2 || fixedString.getVarying().getValue() == 3) {
                        this.setRestrictionAndLengthFacet(schema, xsdSimType, length, "hexBinary", false);
                    } else {
                        this.setRestrictionAndLengthFacet(schema, xsdSimType, length / 8, "hexBinary", false);
                    }
                }
            } else {
                this.setRestrictionAndLengthFacet(schema, xsdSimType, length, "string", true);
            }
        } else if (pliSimType instanceof PLIVariableLengthString) {
            PLIVariableLengthString varLengthString = (PLIVariableLengthString)pliSimType;
            if (varLengthString.getLengthToAllocate() != null) {
                int length = new Integer(varLengthString.getLengthToAllocate());
                this.setRestrictionAndLengthFacet(schema, xsdSimType, length, "string", true);
            }
        } else if (pliSimType instanceof PLIIntegerType) {
            if (((PLIIntegerType)pliSimType).getMode().getValue() == 0) {
                PLIIntegerType pliIntType = (PLIIntegerType)pliSimType;
                Integer precision = pliIntType.getPrecision();
                Integer scale = pliIntType.getScale();
                boolean signed = pliIntType.isSigned();
                if (scale != 0) {
                    this.setRestrictionForDecimal(schema, xsdSimType, precision, scale, "decimal");
                } else if (signed) {
                    if (precision <= 7) {
                        this.setXsdSimpleType(xsdSimType, schema, "byte");
                    } else if (precision > 7 && precision <= 15) {
                        this.setXsdSimpleType(xsdSimType, schema, "short");
                    } else if (precision > 15 && precision <= 31) {
                        this.setXsdSimpleType(xsdSimType, schema, "int");
                    } else if (precision > 31 && precision <= 63) {
                        this.setXsdSimpleType(xsdSimType, schema, "long");
                    } else {
                        this.setRestrictionForInteger(schema, xsdSimType, precision, "int");
                    }
                } else if (precision <= 8) {
                    this.setXsdSimpleType(xsdSimType, schema, "unsignedByte");
                } else if (precision > 8 && precision <= 16) {
                    this.setXsdSimpleType(xsdSimType, schema, "unsignedShort");
                } else if (precision > 16 && precision <= 32) {
                    this.setXsdSimpleType(xsdSimType, schema, "unsignedInt");
                } else if (precision > 32 && precision <= 64) {
                    this.setXsdSimpleType(xsdSimType, schema, "unsignedLong");
                } else {
                    this.setRestrictionForInteger(schema, xsdSimType, precision, "int");
                }
            }
        } else if (pliSimType instanceof PLIFloatType) {
            PLIFloatType type = (PLIFloatType)pliSimType;
            if (type.getBase().getValue() == 0) {
                if (type.getMode().getValue() == 0) {
                    if (type.getPrecision() > 21) {
                        this.setXsdSimpleType(xsdSimType, schema, "double");
                    } else {
                        this.setXsdSimpleType(xsdSimType, schema, "float");
                    }
                }
            } else if (type.getMode().getValue() == 0) {
                if (type.getPrecision() > 6) {
                    this.setXsdSimpleType(xsdSimType, schema, "double");
                } else {
                    this.setXsdSimpleType(xsdSimType, schema, "float");
                }
            }
        } else if (pliSimType instanceof PLIPackedType) {
            if (((PLIPackedType)pliSimType).getMode().getValue() == 0) {
                PLIPackedType pliPackedType = (PLIPackedType)pliSimType;
                Integer precision = pliPackedType.getPrecision();
                Integer scale = pliPackedType.getScale();
                if (scale != 0) {
                    this.setRestrictionPackedDecimal(schema, xsdSimType, precision, scale, "decimal");
                } else {
                    this.setRestrictionPackedInteger(schema, xsdSimType, precision, "int");
                }
            }
        } else if (pliSimType instanceof PLIPointerType) {
            int size = Integer.valueOf(((PLIElement)((PLIPointerType)pliSimType).getTypedElement().get(0)).getInstanceTDBase().getSize());
            this.setRestrictionAndLengthFacet(schema, xsdSimType, size, "hexBinary", true);
        }
        return xsdSimType;
    }

    public XSDSimpleTypeDefinition getXSDTypeForComplex(XSDSchema schema, String itemName) {
        XSDSimpleTypeDefinition simType = XSDSchemaImpl.getSchemaForSchema((String)"http://www.w3.org/2001/XMLSchema").resolveSimpleTypeDefinition("http://www.w3.org/2001/XMLSchema", itemName);
        simType.setTargetNamespace(schema.getTargetNamespace());
        return simType;
    }

    private void setXsdSimpleType(XSDSimpleTypeDefinition xsdSimType, XSDSchema schema, String type) {
        XSDSimpleTypeDefinition simType = XSDSchemaImpl.getSchemaForSchema((String)schema.getSchemaForSchemaNamespace()).resolveSimpleTypeDefinition("http://www.w3.org/2001/XMLSchema", type);
        xsdSimType.setBaseTypeDefinition(simType);
    }

    public void removeTypeFromSchema(XSDSchema xsdSchema, Object type) {
        EList contentList = xsdSchema.getContents();
        contentList.remove(type);
    }

    public void initializeSchema(XSDSchema schema, IFile xsdFile, String targetNS) {
        Map prefixNSMap;
        if (targetNS == null) {
            String xsdName = null;
            xsdName = xsdFile == null ? "dumXsdFileName.xsd" : xsdFile.getName();
            xsdName = xsdName.substring(0, xsdName.lastIndexOf("."));
            targetNS = "http://www." + xsdName + ".com/schemas/" + xsdName + "Interface";
        }
        if (schema.getTargetNamespace() == null) {
            schema.setTargetNamespace(targetNS);
        }
        if (!(prefixNSMap = schema.getQNamePrefixToNamespaceMap()).containsValue("http://www.w3.org/2001/XMLSchema")) {
            prefixNSMap.put(schema.getSchemaForSchemaQNamePrefix(), "http://www.w3.org/2001/XMLSchema");
        }
        if (!prefixNSMap.containsValue(schema.getTargetNamespace())) {
            prefixNSMap.put("xsd1", schema.getTargetNamespace());
        }
    }

    public int indexInContentsList(List list, Object newEle) {
        int index;
        block4: {
            block5: {
                index = -1;
                if (!(newEle instanceof XSDModelGroupDefinition)) break block5;
                XSDModelGroupDefinition newGroup = (XSDModelGroupDefinition)newEle;
                int i = 0;
                while (i < list.size()) {
                    XSDModelGroupDefinition group;
                    Object obj = list.get(i);
                    if (obj instanceof XSDModelGroupDefinition && (group = (XSDModelGroupDefinition)obj).getName().equals(newGroup.getName())) {
                        index = i;
                        break block4;
                    }
                    ++i;
                }
                break block4;
            }
            if (!(newEle instanceof XSDComplexTypeDefinition)) break block4;
            XSDComplexTypeDefinition newCT = (XSDComplexTypeDefinition)newEle;
            int i = 0;
            while (i < list.size()) {
                XSDComplexTypeDefinition ct;
                Object obj = list.get(i);
                if (obj instanceof XSDComplexTypeDefinition && (ct = (XSDComplexTypeDefinition)obj).getName().equals(newCT.getName())) {
                    index = i;
                    break;
                }
                ++i;
            }
        }
        return index;
    }

    private void setRestrictionAndLengthFacet(XSDSchema schema, XSDSimpleTypeDefinition xsdSimType, String picStr, String base) {
        XSDFactory xsdFactory = XSDFactory.eINSTANCE;
        XSDLengthFacet lenFacet = xsdFactory.createXSDLengthFacet();
        XSDSimpleTypeDefinition simType = XSDSchemaImpl.getSchemaForSchema((String)schema.getSchemaForSchemaNamespace()).resolveSimpleTypeDefinition("http://www.w3.org/2001/XMLSchema", base);
        xsdSimType.setBaseTypeDefinition(simType);
        lenFacet.setLexicalValue(new Integer(this.countLength(picStr)).toString());
        xsdSimType.getFacetContents().add((Object)lenFacet);
    }

    private void setRestrictionAndLengthFacet(XSDSchema schema, XSDSimpleTypeDefinition xsdSimType, int length, String base, boolean maxLength) {
        if (maxLength) {
            XSDFactory xsdFactory = XSDFactory.eINSTANCE;
            XSDMaxLengthFacet lenFacet = xsdFactory.createXSDMaxLengthFacet();
            XSDSimpleTypeDefinition simType = XSDSchemaImpl.getSchemaForSchema((String)schema.getSchemaForSchemaNamespace()).resolveSimpleTypeDefinition("http://www.w3.org/2001/XMLSchema", base);
            xsdSimType.setBaseTypeDefinition(simType);
            lenFacet.setLexicalValue(new Integer(length).toString());
            xsdSimType.getFacetContents().add((Object)lenFacet);
        } else {
            XSDFactory xsdFactory = XSDFactory.eINSTANCE;
            XSDLengthFacet lenFacet = xsdFactory.createXSDLengthFacet();
            XSDSimpleTypeDefinition simType = XSDSchemaImpl.getSchemaForSchema((String)schema.getSchemaForSchemaNamespace()).resolveSimpleTypeDefinition("http://www.w3.org/2001/XMLSchema", base);
            xsdSimType.setBaseTypeDefinition(simType);
            lenFacet.setLexicalValue(new Integer(length).toString());
            xsdSimType.getFacetContents().add((Object)lenFacet);
        }
    }

    private void setRestrictionForDecimal(XSDSchema schema, XSDSimpleTypeDefinition xsdSimType, Integer precision, Integer scale, String base) {
        XSDFactory xsdFactory = XSDFactory.eINSTANCE;
        XSDTotalDigitsFacet totalDigits = xsdFactory.createXSDTotalDigitsFacet();
        XSDFractionDigitsFacet fractionDigits = xsdFactory.createXSDFractionDigitsFacet();
        XSDSimpleTypeDefinition simType = XSDSchemaImpl.getSchemaForSchema((String)schema.getSchemaForSchemaNamespace()).resolveSimpleTypeDefinition("http://www.w3.org/2001/XMLSchema", base);
        xsdSimType.setBaseTypeDefinition(simType);
        totalDigits.setLexicalValue(precision.toString());
        fractionDigits.setLexicalValue(scale.toString());
        xsdSimType.getFacetContents().add((Object)totalDigits);
        xsdSimType.getFacetContents().add((Object)fractionDigits);
    }

    private void setRestrictionForInteger(XSDSchema schema, XSDSimpleTypeDefinition xsdSimType, Integer precision, String base) {
        XSDFactory xsdFactory = XSDFactory.eINSTANCE;
        XSDTotalDigitsFacet totalDigits = xsdFactory.createXSDTotalDigitsFacet();
        XSDSimpleTypeDefinition simType = XSDSchemaImpl.getSchemaForSchema((String)schema.getSchemaForSchemaNamespace()).resolveSimpleTypeDefinition("http://www.w3.org/2001/XMLSchema", base);
        xsdSimType.setBaseTypeDefinition(simType);
        totalDigits.setLexicalValue(precision.toString());
        xsdSimType.getFacetContents().add((Object)totalDigits);
    }

    private void setRestrictionPackedDecimal(XSDSchema schema, XSDSimpleTypeDefinition xsdSimType, Integer precision, Integer scale, String base) {
        XSDFactory xsdFactory = XSDFactory.eINSTANCE;
        XSDTotalDigitsFacet totalDigits = xsdFactory.createXSDTotalDigitsFacet();
        XSDFractionDigitsFacet fractionDigits = xsdFactory.createXSDFractionDigitsFacet();
        XSDSimpleTypeDefinition simType = XSDSchemaImpl.getSchemaForSchema((String)schema.getSchemaForSchemaNamespace()).resolveSimpleTypeDefinition("http://www.w3.org/2001/XMLSchema", base);
        xsdSimType.setBaseTypeDefinition(simType);
        totalDigits.setLexicalValue(precision.toString());
        fractionDigits.setLexicalValue(scale.toString());
        xsdSimType.getFacetContents().add((Object)totalDigits);
        xsdSimType.getFacetContents().add((Object)fractionDigits);
    }

    private void setRestrictionPackedInteger(XSDSchema schema, XSDSimpleTypeDefinition xsdSimType, Integer precision, String base) {
        XSDFactory xsdFactory = XSDFactory.eINSTANCE;
        XSDTotalDigitsFacet totalDigits = xsdFactory.createXSDTotalDigitsFacet();
        XSDSimpleTypeDefinition simType = XSDSchemaImpl.getSchemaForSchema((String)schema.getSchemaForSchemaNamespace()).resolveSimpleTypeDefinition("http://www.w3.org/2001/XMLSchema", base);
        xsdSimType.setBaseTypeDefinition(simType);
        totalDigits.setLexicalValue(precision.toString());
        xsdSimType.getFacetContents().add((Object)totalDigits);
    }

    public XSDSchemaContent getThisXsdType(String path) {
        return this.getThisXsdType(path, null);
    }

    public XSDSchemaContent getThisXsdType(String path, Map elementSwapMap) {
        XSDElementDeclaration eleDec;
        XSDTypeDefinition type;
        if (path.indexOf(":") >= 0) {
            path = GeneralUtil.getPathFromRefID(path);
        }
        Object val = this.pathXsdPair.get(path);
        if (elementSwapMap != null && elementSwapMap.containsKey(val)) {
            val = elementSwapMap.get(val);
        }
        if (val instanceof XSDElementDeclaration && (type = (eleDec = (XSDElementDeclaration)val).getTypeDefinition()) != null && type instanceof XSDComplexTypeDefinition) {
            XSDComplexTypeDefinition ct = (XSDComplexTypeDefinition)type;
            List ctContents = this.getModelGroupContents(ct);
            XSDModelGroupDefinition groupRef = (XSDModelGroupDefinition)((XSDParticle)ctContents.get(0)).getContent();
            return groupRef.getResolvedModelGroupDefinition();
        }
        return (XSDSchemaContent)val;
    }

    public void putPathXsdPair(String str, Object def) {
        this.pathXsdPair.put(str, def);
    }

    public Map getPathXsdPair() {
        return this.pathXsdPair;
    }

    public int getVirtualDecimalPointLocation(String sPicString) {
        int virtualDecimalLocation = 0;
        if (sPicString.indexOf(80) == -1) {
            int virtualDecimalIndex = sPicString.indexOf(86);
            virtualDecimalLocation = virtualDecimalIndex == -1 ? 0 : sPicString.length() - virtualDecimalIndex - 1;
        } else {
            int firstCharacter = 32;
            int numberOfNines = 0;
            int numberOfPs = 0;
            int i = 0;
            while (i < sPicString.length()) {
                if (sPicString.charAt(i) == '9') {
                    if (firstCharacter == 32) {
                        firstCharacter = 57;
                    }
                    ++numberOfNines;
                } else if (sPicString.charAt(i) == 'P') {
                    if (firstCharacter == 32) {
                        firstCharacter = 80;
                    }
                    ++numberOfPs;
                }
                ++i;
            }
            virtualDecimalLocation = firstCharacter == 80 ? numberOfNines + numberOfPs : numberOfPs * -1;
        }
        return virtualDecimalLocation;
    }

    private String expandPictureString(String compressed) {
        while (true) {
            String expandStr = "";
            int startIndex = compressed.indexOf("(");
            if (startIndex == -1) break;
            int endIndex = compressed.indexOf(")");
            String expandChar = compressed.substring(endIndex + 1, endIndex + 2);
            int numberOfChars = new Integer(compressed.substring(startIndex + 1, endIndex));
            int i = 0;
            while (i < numberOfChars) {
                expandStr = String.valueOf(expandStr) + expandChar;
                ++i;
            }
            compressed = String.valueOf(compressed.substring(0, startIndex)) + expandStr + compressed.substring(endIndex + 2);
        }
        return compressed;
    }
}

