 /********************************************************************/
 /*                                                                  */
 /*  PL/I Include file: SQLCA.CPY                                    */
 /*                                                                  */
 /* This file is installed in the \IBMPLIW\INCLUDE\ directory.       */
 /*                                                                  */
 /*                                                                  */
 /*  NAME - SQLCA.CPY                                                */
 /*                                                                  */
 /*  DESCRIPTION                                                     */
 /*                                                                  */
 /*    External Include file for SQLCA                               */
 /*                                                                  */
 /*    (C) Copyright IBM Corp. 1994, 1997. All Rights Reserved.      */
 /*    US Government Users Restricted Rights-- Use, duplication or   */
 /*    disclosure restricted by GSA ADP Schedule Contract with       */
 /*    IBM Corp.                                                     */
 /*  Licensed Materials - Property of IBM                            */
 /*                                                                  */
 /*  Function = Include File defining SQLCA without define structure */
 /*                                                                  */
 /*  NOTE:                                                           */
 /*    Use EITHER this file OR sqlca_t.cpy                           */
 /*                                                                  */
 /*  Operating System = Windows                                      */
 /*                                                                  */
 /*                                                                  */
 /*  DISCLAIMER OF WARRANTIES                                        */
 /*    The following enclosed code is sample code created by IBM   */
 /*    Corporation. This sample code is not part of any standard     */
 /*    IBM product and is provided to you solely for the purpose of  */
 /*    assisting you in the development of your applications.  The   */
 /*    code is provided "AS IS", without warranty of any kind.       */
 /*    IBM shall not be liable for any damages arising out of your   */
 /*    use of the sample code, even if IBM has been advised of the   */
 /*    possibility of such damages.                                  */
 /*                                                                  */
 /********************************************************************/
 /*
 %dcl #SQLCA_INC char ext;
 %if #SQLCA_INC = '' %then %do;
 %#SQLCA_INC = 'Y';
 */
 /* SQL Communication Area - SQLCA */

  Dcl
    1 sqlca,
       2 sqlcaid     char(8),              /* Eyecatcher = 'SQLCA   '*/
       2 sqlcabc     fixed binary(31),  /* SQLCA size in bytes = 136 */
       2 sqlcode     fixed binary(31),            /* SQL return code */
       2 sqlerrm     char(70) var,           /* Error message tokens */
       2 sqlerrp     char(8),              /* Diagnostic information */
       2 sqlerrd(6)  fixed binary(31),     /* Diagnostic information */
       2 sqlwarn,                                   /* Warning flags */
        3 sqlwarn0  char(1),
        3 sqlwarn1  char(1),
        3 sqlwarn2  char(1),
        3 sqlwarn3  char(1),
        3 sqlwarn4  char(1),
        3 sqlwarn5  char(1),
        3 sqlwarn6  char(1),
        3 sqlwarn7  char(1),
      2 sqlext,
        3 sqlwarn8  char(1),
        3 sqlwarn9  char(1),
        3 sqlwarna  char(1),
        3 sqlstate  char(5);       /* State corresponding to SQLCODE */


 /* sqlerrd tokens updated when compound SQL statements processed */
 /* PL/I note: sqlca.sqlerrd is 1 based */

 dcl SQL_CMP_NA_ERRORS               fixed bin(31) value(1 + 1);
 dcl SQL_CMP_ROWS_AFFECTED           fixed bin(31) value(2 + 1);
 dcl SQL_CMP_STMTS_COMPLETED         fixed bin(31) value(3 + 1);
 dcl SQL_CMP_REF_INT_ROWS            fixed bin(31) value(4 + 1);


 /* sqlerrd tokens updated when CONNECT statements processed */
 /* PL/I note: sqlca.sqlerrd is 1 based */

 dcl SQL_CON_DB_APP2DB_CONVFACTOR    fixed bin(31) value(0 + 1);
 dcl SQL_CON_DB_DB2APP_CONVFACTOR    fixed bin(31) value(1 + 1);
 dcl SQL_CON_DB_UPDATEABILITY_IN_UOW fixed bin(31) value(2 + 1);
 dcl SQL_CONNECT_DB_COMMIT_TYPE      fixed bin(31) value(3 + 1);


 /* Values returned for sqlerrd[SQL_CONNECT_DB_UPDATEABILITY_IN_UOW]*/

 dcl SQL_DB_UPDATEABLE               fixed bin(31) value(1);
 dcl SQL_DB_READ_ONLY                fixed bin(31) value(2);


 /* Values returned for sqlerrd[SQL_CONNECT_DB_COMMIT_TYPE]       */

 dcl SQL_DB_ONE_PHASE_COMMIT         fixed bin(31) value(1);
 dcl SQL_DB_ONE_PHASE_READ_ONLY      fixed bin(31) value(2);
 dcl SQL_DB_TWO_PHASE_COMMIT         fixed bin(31) value(3);

 /*%end;*/ /* #SQLCA_INC */

