package com.ibm.infrastructure;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Locale;

public class ErrorMsgManager {
	
	public static String getErrorMsg(Locale locale){
		
	
 		return Messages.getString("ErrorMsg.generic", locale); //$NON-NLS-1$
	}
	
	public static InputStream getXMLErrorMessage(Locale locale){
		
		System.out.println(getErrorMsg(locale));
		
		StringBuffer result= new StringBuffer();
		result.append("<error>");
		result.append("<message>");
		result.append(getErrorMsg(locale));
		result.append("</message>");
		result.append("</error>");
		
		try{
			return new ByteArrayInputStream(result.toString().getBytes("UTF-8"));
		}
        catch(Exception e){
        	e.printStackTrace();
        	return null;
        }		
	}

}
