/****************************************************************************************/
//                                                                                       //
//        Retrieves a feed from a URL by using com.ibm.feedreader.parseFeed              //
//                                                                                       //
//                                                                                       //
/****************************************************************************************/


        ///GLOBAL VARIABLES///
        
       

        var MaxWaitTime    = 60000;  //Maximum time to wait for feed (Milliseconds)
        var MaxFeedResults = 5;      //Maximum number of feeds to retrieve
       
        var http_request;
        var RequestorNode;
		
		var RequestedURL;
		var TOPIC_SERVLET    ="topic";
		var pathToPlugin     ="";
		var pluginName       ="com.ibm.ccl.feedreader";
		var pathToFeedReader ="topic/com.ibm.ccl.feedreader/parseFeed?url=";
		var timer            ="";
		var errorOther       ="Error retrieving feed";  

        function getWebFeed(url,loc) {

 			    RequestedURL=url;
				RequestorNode = loc;
				  
                if (!isWebFeedOpen(loc)){  //No feed, create one!
					
					
					//Display spinner
					  displaySpinner(loc,true);
					  										    					  
					//Capture the path to the plugin - from the current page - into a global variable  
      	              setPathtoPluginFromDoc();
					  
			        //Extract the http://server:port/<help_system_root_context>/ portion from the href	
			   
			          var pageHref = window.location.href;
					
					  /* Trim the location of the current page until the first instance of the "topic" 
					   * string, which refers to the help system's topic Servlet
					   */
					  
				      var EHSRootcontext = pageHref.substring(0, pageHref.indexOf(TOPIC_SERVLET)); 
				      
					  //Encode the URL				
					  url = escape(url);
					
					  //var fullHref = httpPrefix + serverHostAndPort + "/" + EHSRootcontext + "/" + pathToFeedReader + url;
					  var fullHref = EHSRootcontext + pathToFeedReader + url;
				     
					  
                      http_request = false;
					  
					 //Retrieve Feed and invoke writeContents()	

                      if (window.XMLHttpRequest) { // Mozilla, Safari,...
                          http_request = new XMLHttpRequest();
                        if (http_request.overrideMimeType) {
                          http_request.overrideMimeType('text/xml');
                        }
                      } else if (window.ActiveXObject) { // IE
                        try {
                        http_request = new ActiveXObject("Msxml2.XMLHTTP");
                      } catch (e) {
                        try {
                        http_request = new ActiveXObject("Microsoft.XMLHTTP");
                       } catch (e) {}
                      }
                    }

                     if (!http_request) {
                       alert('Giving up! Unable to create an XMLHTTP instance');
                    return false;
                    }
                                         
                       //Set a timeout for the http request and call abort
                       timer = setTimeout(function(){                      
                          http_request.abort();
                          }, MaxWaitTime );  
                       
                       http_request.onreadystatechange = writeContents; 
                       
					   
                       http_request.open('GET', fullHref, true);
                       http_request.send(null);
					
				}
				else{  //Remove Existing Feed!
					
					 removeWebFeed(loc);
				}
              
            }

            function writeContents() {


                if (http_request.readyState == 4) {
                    if (http_request.status == 200 || http_request.status == 304) {

                           clearTimeout(timer); 
						   //Remove spinner
						   displaySpinner(RequestorNode,false);
						   
                    	   //Capture feed in a string
                    	   var xmlstr = http_request.responseText;					
														
						  //Load the response from the server
						   var xmlobject ="";

        					// Mozilla and Netscape browsers
             				if (document.implementation.createDocument) {
           		  				var parser = new DOMParser();
           		  				xmlobject = parser.parseFromString(xmlstr, "text/xml");
           						// MSIE
         					} else if (window.ActiveXObject){
                 				xmlobject = new ActiveXObject("Microsoft.XMLDOM");
                 				xmlobject.async="false";
                 				xmlobject.loadXML(xmlstr);
         					}
						   
						   if (isError(xmlobject))				   	  
						   	 displayError(xmlobject,RequestorNode);						   	   	 
						   else
						     writeFeed(xmlobject,RequestorNode);
						  

                    } 
                    else{
						
					   //TODO: Test timeout	
					   clearTimeout(timer); 	  
					   displaySpinner(RequestorNode,false);	
                       displayErrorMessage(errorOther, RequestorNode); 
                    }
                }

            }

function writeFeed(xmlobject,loc){
    /* 
         * STEPS
         * 
         * (1) Add the <div class="webfeed-list-div">  child.
         * 
         *      <div class="webfeed-list-div">
         *        <ul class="webfeed-link-list">
         * 		   <li><a target="_blank" href="http://example.com/article.html" >Item 1 title</a></li>
         * 		   <li><a target="_blank" href="http://example.com/article.html" >Item 1 title</a></li>
         * 		   <li><a target="_blank" href="http://example.com/article.html" >Item 1 title</a></li>
         * 		  </ul>
         * 		  <p class="webfeed-subscribe"><a target="_blank" href="http://example.com/rss">XML</a></p>
         * 		</div>
         *
         * (2) Modify class attribute on <a class="webfeed-link".. to <a class="webfeed-link-open" to indicate that is open
         * 
         */


     
       // (1) Adding the <div class="webfeed-list-div">  child.
         
		
	  //Get the DIV tag
   		 var DIVParent = loc.parentNode.parentNode;     //<div class="webfeed">
   			 

	     var DIVResponse = document.createElement("div");
		 	 DIVResponse.setAttribute("class","webfeed-list-div");
			 DIVResponse.style.padding='10px';
		
		     
  		 var response= document.createElement("ul");
 		 response.setAttribute("class","webfeed-link-list");
		 response.style.listStyleType = 'none';
		 	 
	      
         // get a reference to the root-element "rss"
         var root = xmlobject.getElementsByTagName('result')[0];
		 
         // get reference to "title" element
         var items = root.getElementsByTagName("item");
      
		 var itemDisplayLimit = (items.length >= MaxFeedResults)? MaxFeedResults :items.length;   //Limit item display list to $MaxFeedResults items
	
         for (var numItem=0; numItem < itemDisplayLimit ;  numItem++){

               var itemTitles       = items[numItem].getElementsByTagName("title");
               var itemLinks        = items[numItem].getElementsByTagName("link");
              
               var itemTitle        = itemTitles[0].firstChild.nodeValue;
               var itemLink         = itemLinks[0].firstChild.nodeValue;
           

               //Compose a new list item element to hold the item's title and link

               var newListItem  = document.createElement("li");
			   newListItem.style.padding=            '0px 0px 0px 20px';

			   newListItem.style.backgroundImage=    'url(' + pathToPlugin + "/images/bullet-arrow.png" +  ')';
			   newListItem.style.backgroundRepeat=   'no-repeat';
			   newListItem.style.backgroundPosition= '0px 5px';
			   newListItem.style.lineHeight=         '24px';
			   newListItem.style.fontSize=           '.9em';
			   	   
               var newLink      = document.createElement("a");
			       newLink.style.textDecoration= 'none';
				   
                   newLink.setAttribute('target','_blank');
                   newLink.setAttribute('href',itemLink);
				   		   

               var itemTitleText = document.createTextNode(itemTitle);
             
                   newLink.appendChild(itemTitleText);
                   newListItem.appendChild(newLink);
				   response.appendChild(newListItem);

         }
             //<p> element at the end of list item

               var para = document.createElement("p");
			   	   para.style.marginLeft ='40px';
				   para.style.marginBottom = '0px';
	               para.style.fontSize ='.8em';
                   para.setAttribute("class","webfeed-subscribe");

               var linkToFeedSrc = document.createElement("a");
			   	   linkToFeedSrc.style.paddingLeft ='16px';	  
				   linkToFeedSrc.style.backgroundImage=  'url(' + pathToPlugin + "/images/rss_feed_sm_obj.gif" +  ')';
	               linkToFeedSrc.style.backgroundRepeat= 'no-repeat';
	               linkToFeedSrc.style.backgroundPosition= 'left';
	               linkToFeedSrc.style.textDecoration= 'none';
			   
                   linkToFeedSrc.setAttribute("target","_blank");	 
                   linkToFeedSrc.setAttribute("href",RequestedURL);
				   
			   var textNode = document.createTextNode("XML");   
		           linkToFeedSrc.appendChild(textNode);
				   
                   para.appendChild(linkToFeedSrc);
   
			   DIVResponse.appendChild(response);
			   DIVResponse.appendChild(para);
               DIVParent.appendChild(DIVResponse);
			   
			 
			   // (2) Modifying class attribute on <a class="webfeed-link".. to <a class="webfeed-link-open" to indicate is open
     
	 			//Change attribute of <a> tag
		     	  loc.setAttribute("class","webfeed-link-open"); 	   
				  loc.style.backgroundImage= 'url(' + pathToPlugin + "/images/widget-open-rollover.gif" +  ')';      
}
function displayError(xmlobject, loc){

 
   	     var DIVParent = loc.parentNode.parentNode;     //<div class="webfeed">
	     var DIVResponse = document.createElement("div");
		 	 DIVResponse.setAttribute("class","webfeed-list-div");
			 DIVResponse.style.padding='10px';
			 
	      var response= document.createElement("div");
 		      response.setAttribute("class","webfeed-error");
		      response.style.marginLeft = '40px';
		      
		      
		 // get a reference to the root-element "error"
         var root = xmlobject.getElementsByTagName('error')[0];		 
         // get reference to "message" element
         var message = root.getElementsByTagName("message");
		
    			  
			  
		  var itemTitleText = document.createTextNode(message[0].firstChild.nodeValue);
		      response.appendChild(itemTitleText);
		  
		      DIVResponse.appendChild(response);
		      DIVParent.appendChild(DIVResponse);
			  		       		 
		   //Modifying class attribute on <a class="webfeed-link".. to <a class="webfeed-link-open" to indicate is open
     
             //<p> element at the end of list item

               var para = document.createElement("p");
			   	   para.style.marginLeft ='40px';
			   	   para.style.marginBottom = '0px';
	               para.style.fontSize ='.8em';
                   para.setAttribute("class","webfeed-subscribe");
					  
               var linkToFeedSrc = document.createElement("a");
			   	   linkToFeedSrc.style.paddingLeft ='16px';	  
				   linkToFeedSrc.style.backgroundImage=  'url(' + pathToPlugin + "/images/rss_feed_sm_obj.gif" +  ')';
	               linkToFeedSrc.style.backgroundRepeat= 'no-repeat';
	               linkToFeedSrc.style.backgroundPosition= 'left';
	               linkToFeedSrc.style.textDecoration= 'none';
			   
                   linkToFeedSrc.setAttribute("target","_blank");	 
                   linkToFeedSrc.setAttribute("href",RequestedURL);
				   
			   var textNode = document.createTextNode("XML");   
		           linkToFeedSrc.appendChild(textNode);
				   
                   para.appendChild(linkToFeedSrc);
   
			   DIVResponse.appendChild(response);
			   DIVResponse.appendChild(para);
               DIVParent.appendChild(DIVResponse);

			   // (2) Modifying class attribute on <a class="webfeed-link".. to <a class="webfeed-link-open" to indicate is open
     
	 			//Change attribute of <a> tag
		     	  loc.setAttribute("class","webfeed-link-open"); 	   
				  loc.style.backgroundImage= 'url(' + pathToPlugin + "/images/widget-open-rollover.gif" +  ')';
			 
}

/***************************************************************************************************************************************/
//  Displays error messages in the specified DOM location. This function takes the string error message and a DOM location as          //
//  arguments.                                                                                                                         //
//                                                                                                                                     //
/****************************************************************************************************************************************/
function displayErrorMessage(err, loc){

 
   	     var DIVParent = loc.parentNode.parentNode;     //<div class="webfeed">
	     var DIVResponse = document.createElement("div");
		 	 DIVResponse.setAttribute("class","webfeed-list-div");
			 DIVResponse.style.padding='10px';
			 
	      var response= document.createElement("div");
 		      response.setAttribute("class","webfeed-error");
		      response.style.marginLeft = '40px';
		      
		      
		  var itemTitleText = document.createTextNode(err);
		      response.appendChild(itemTitleText);
		  
		      DIVResponse.appendChild(response);
		      DIVParent.appendChild(DIVResponse);
			  		       		 
		   //Modifying class attribute on <a class="webfeed-link".. to <a class="webfeed-link-open" to indicate is open
     
             //<p> element at the end of list item

               var para = document.createElement("p");
			   	   para.style.marginLeft ='40px';
			   	   para.style.marginBottom = '0px';
	               para.style.fontSize ='.8em';
                   para.setAttribute("class","webfeed-subscribe");
					  
               var linkToFeedSrc = document.createElement("a");
			   	   linkToFeedSrc.style.paddingLeft ='16px';	  
				   linkToFeedSrc.style.backgroundImage=  'url(' + pathToPlugin + "/images/rss_feed_sm_obj.gif" +  ')';
	               linkToFeedSrc.style.backgroundRepeat= 'no-repeat';
	               linkToFeedSrc.style.backgroundPosition= 'left';
	               linkToFeedSrc.style.textDecoration= 'none';
			   
                   linkToFeedSrc.setAttribute("target","_blank");	 
                   linkToFeedSrc.setAttribute("href",RequestedURL);
				   
			   var textNode = document.createTextNode("XML");   
		           linkToFeedSrc.appendChild(textNode);
				   
                   para.appendChild(linkToFeedSrc);
   
			   DIVResponse.appendChild(response);
			   DIVResponse.appendChild(para);
               DIVParent.appendChild(DIVResponse);

			   // (2) Modifying class attribute on <a class="webfeed-link".. to <a class="webfeed-link-open" to indicate is open
     
	 			//Change attribute of <a> tag
		     	  loc.setAttribute("class","webfeed-link-open"); 	   
				  loc.style.backgroundImage= 'url(' + pathToPlugin + "/images/widget-open-rollover.gif" +  ')';
			 
}
/***************************************************************************************************************************************/
//                                                                                                                                     //
//   Removes existing feed div tag node  <div class="webfeed-list-div">                                                                //
//                                                                                                                                     //
//                                                                                                                                     //
/****************************************************************************************************************************************/
     
function removeWebFeed(loc){
		
	    /* 
         * STEPS
         * 
         * (1) Remove the <div class="webfeed-list-div">  child.
         * 
         * (2) Modify class attribute on <a class="webfeed-link-open".. to <a class="webfeed-link" to indicate that there is no feed
         * 
         */	
		
	 //(1) Removing the <div class="webfeed-list-div">  child.
	 
	 var lastNode = loc.parentNode.parentNode.lastChild;     //<div class="webfeed-list-div">

	 var ParentNode = loc.parentNode.parentNode;
         ParentNode.removeChild(lastNode);
	 
	
	 // (2) Modifying class attribute on <a class="webfeed-link-open".. to <a class="webfeed-link" to indicate that there is no feed
      
	     //Change attribute of <a> tag
		   loc.setAttribute("class","webfeed-link");    
		   loc.style.backgroundImage= 'url(' + pathToPlugin + "/images/widget-closed-rollover.gif" +  ')';
}

function isError(xmlobj){
      return (xmlobj.getElementsByTagName('error')[0] == null)?false:true;	 
}

/***************************************************************************************************************************************/
//  Checks whether a feed is being displayed at the current node                                                                       //
//                                                                                                                                     //
/****************************************************************************************************************************************/

function isWebFeedOpen(loc){
	
	 if (loc.getAttribute("class") == "webfeed-link-open")//Feed exists
	 	return true;
	 else
	 	return false;
	 	
}

/***************************************************************************************************************************************/
//                                                                                                                                     //
//   Capture the path to the plugin relative to the current loaded page in a global variable. The variable will be used to resolve     //
//   path to resources in the feedreader plugin                                                                                        //
//                                                                                                                                     //
/****************************************************************************************************************************************/

function setPathtoPluginFromDoc(){
 
   pathToPlugin="";
   var pathCurrentPage = window.location.pathname;
   var directoriesToPage = pathCurrentPage.split("/");
   var numDirectories = directoriesToPage.length - 3;
     for (var it=1; it < numDirectories; it++){
	  	  pathToPlugin += "../";
	 }			  
	 pathToPlugin += pluginName;
					  
}

/***************************************************************************************************************************************/
//                                                                                                                                     //
//  Displays a spinner next to the specified node location while request is being processed                                            //
//  needs to be called when the request is finished with the parameters displaySpinner(loc,false,"")                                   //
//                                                                                                                                     //
/****************************************************************************************************************************************/

function displaySpinner(loc,doShow){

         //
          var parentElement = loc.parentNode.parentNode;  //Place spinner as child of  <div class="webfeed">	  
          
		  /*
		   * Creating the following markup
		   * div class="spinner-div">&nbsp;</div>
		   * 
		   */
			 		 
          var SpinnerElement;

          if(doShow){
                
				      SpinnerElement = document.createElement("div");
					  
					  SpinnerElement.style.margin='14px 0px 0px 45px';
					  SpinnerElement.style.padding= '20px';		
					  SpinnerElement.style.backgroundImage=   'url(' + pathToPlugin + "/images/spinner.gif" +  ')';
					  SpinnerElement.style.backgroundRepeat= 'no-repeat';
					  SpinnerElement.style.backgroundPosition= 'top left';
	
		    		  SpinnerElement.setAttribute("class", "spinner-div");
	    		  var textNode = document.createTextNode(" ");
		   			  SpinnerElement.appendChild(textNode);
					  
					  parentElement.appendChild(SpinnerElement);
					  
				//Force GIFs to refresh in IE. Not sure we need this workaround
                //setTimeout("document.images[0].src =" + "\"" + imgsrc + "\"", 2);
                  
               
          }
          else{

              SpinnerElement = parentElement.lastChild;
              if ( SpinnerElement.nodeValue != "#text"){
                  if(SpinnerElement.nodeName == "DIV")
                    parentElement.removeChild(SpinnerElement);
              }
          }
}