/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.discovery.ui.wizards;

import com.ibm.adapter.framework.BaseException;
import com.ibm.adapter.framework.IPublishingSet;
import com.ibm.adapter.framework.IResourceWriter;
import com.ibm.ccl.discovery.ui.api.IDiscoveryFlowModel;
import com.ibm.ccl.discovery.ui.internal.utilities.DiscUIHelper;
import com.ibm.ccl.discovery.ui.plugin.DiscUIPlugin;
import com.ibm.ccl.discovery.ui.wizards.DiscWizard;
import com.ibm.ccl.discovery.ui.wizards.ResolutionPropertiesPage;
import com.ibm.propertygroup.IPropertyGroup;
import com.ibm.propertygroup.ui.plugin.PropertyUIMessageBundle;
import com.ibm.propertygroup.ui.wizards.MessageBundleWizardDynamicPage_PropertyGroup;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;

public class PublishingPropertiesPage
extends MessageBundleWizardDynamicPage_PropertyGroup {
    protected IResourceWriter writer_ = null;
    protected IPublishingSet publishingSet_ = null;
    protected boolean hasResolutionProperties_ = false;

    public PublishingPropertiesPage(String name, PropertyUIMessageBundle newBundle) {
        super(name, newBundle);
        this.initPageTitle();
    }

    protected void initPageTitle() {
        this.setTitle(this.messageBundle_.getMessage("DISC_UI_WIZARD_PUBLISH_PROPS_PAGE_TITLE"));
        this.setDescription(this.messageBundle_.getMessage("DISC_UI_WIZARD_PUBLISH_PROPS_PAGE_DESC"));
        this.setImageDescriptor(this.messageBundle_.getImageDescriptor(this.messageBundle_.getMessage("ICON_DISC_WIZARD_PUBLISH_PROPS_PAGE")));
    }

    public void initPage(IResourceWriter writer, IPublishingSet publishingSet, IPropertyGroup publishingProperties) {
        this.writer_ = writer;
        this.publishingSet_ = publishingSet;
        this.FirstOpens_ = true;
        IDiscoveryFlowModel model = ((DiscWizard)this.getWizard()).getFlowModel();
        if (model != null && this.firstOpens()) {
            try {
                publishingProperties.populateFromString(model.getPublishingPropertiesPagePropertyGroup());
                ((DiscWizard)this.getWizard()).restoreSensitiveProperties(publishingProperties, model);
            }
            catch (CoreException exc) {
                DiscUIPlugin.getInstance().getLog().log(exc.getStatus());
            }
            this.firstOpens(false);
        }
        this.displayPage(publishingProperties);
        this.isModified(true);
    }

    public boolean canFlipToNextPage() {
        boolean isComplete = this.isPageComplete();
        boolean publishCheck = false;
        try {
            publishCheck = this.publishingSet_.publishCheck();
        }
        catch (BaseException ie) {
            DiscUIHelper.getDiscUIHelper().showExceptionMessage(ie, this.getShell(), this.messageBundle_.getMessage("WIZARD_WIN_ERRTITLE"), DiscUIHelper.getDiscUIHelper().getMessageFromCoreException((CoreException)((Object)ie)));
            return false;
        }
        catch (Exception e) {
            DiscUIHelper.getDiscUIHelper().showExceptionMessage(e, this.getShell(), this.messageBundle_.getMessage("WIZARD_WIN_ERRTITLE"), e.getMessage());
            return false;
        }
        if (!publishCheck) {
            return isComplete;
        }
        return false;
    }

    public boolean determinePageCompletion() {
        boolean isComplete = super.determinePageCompletion();
        if (!isComplete) {
            return isComplete;
        }
        boolean publishCheck = false;
        try {
            publishCheck = this.publishingSet_.publishCheck();
        }
        catch (BaseException ie) {
            DiscUIHelper.getDiscUIHelper().showExceptionMessage(ie, this.getShell(), this.messageBundle_.getMessage("WIZARD_WIN_ERRTITLE"), DiscUIHelper.getDiscUIHelper().getMessageFromCoreException((CoreException)((Object)ie)));
            return false;
        }
        catch (Exception e) {
            DiscUIHelper.getDiscUIHelper().showExceptionMessage(e, this.getShell(), this.messageBundle_.getMessage("WIZARD_WIN_ERRTITLE"), e.getMessage());
            return false;
        }
        IWizard wizard = this.getWizard();
        if (wizard instanceof DiscWizard) {
            ((DiscWizard)wizard).setCanFinish(isComplete && publishCheck);
        }
        return isComplete;
    }

    public void isModified(boolean newValue) {
        super.isModified(newValue);
        if (newValue) {
            this.setWizardCanFinish(false);
            this.hasResolutionProperties_ = false;
            this.setPageComplete(this.determinePageCompletion());
        }
    }

    public IWizardPage getNextPage() {
        MessageBundleWizardDynamicPage_PropertyGroup nextPage = this;
        DiscWizard wizard = (DiscWizard)this.getWizard();
        if (this.isModified()) {
            try {
                if (this.publishingSet_.publishCheck()) {
                    nextPage = null;
                }
                this.hasResolutionProperties_ = true;
                IPropertyGroup resolutionProperties = this.publishingSet_.createResolutionProperties();
                this.publishingSet_.applyResolutionProperties(resolutionProperties);
                ResolutionPropertiesPage resolutionPropsPage = wizard.getResolutionPropertiesPage();
                nextPage = resolutionPropsPage;
                resolutionPropsPage.initPage(this.writer_, this.publishingSet_, resolutionProperties);
            }
            catch (BaseException ie) {
                DiscUIHelper.getDiscUIHelper().showExceptionMessage(ie, this.getShell(), this.messageBundle_.getMessage("WIZARD_WIN_ERRTITLE"), DiscUIHelper.getDiscUIHelper().getMessageFromCoreException((CoreException)((Object)ie)));
                return nextPage;
            }
            catch (Exception e) {
                DiscUIHelper.getDiscUIHelper().showExceptionMessage(e, this.getShell(), this.messageBundle_.getMessage("WIZARD_WIN_ERRTITLE"), e.getMessage());
                return nextPage;
            }
        } else {
            nextPage = this.hasResolutionProperties_ ? wizard.getResolutionPropertiesPage() : null;
        }
        this.isModified(false);
        return nextPage;
    }

    public void setVisible(boolean visible) {
        String msg = this.getMessage();
        super.setVisible(visible);
        if (visible && this.FirstOpens_ && this.getWizard().canFinish() && msg != null) {
            this.setMessage(msg);
        }
    }
}

