/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.discovery.ui.wizards;

import com.ibm.adapter.framework.BaseException;
import com.ibm.adapter.framework.IDiscoveryAgent;
import com.ibm.ccl.discovery.ui.internal.data.DiscoveryConnection;
import com.ibm.ccl.discovery.ui.internal.messages.DiscUIMessageBundle;
import com.ibm.ccl.discovery.ui.internal.utilities.DiscUIHelper;
import com.ibm.ccl.discovery.ui.wizards.DiscWizard;
import com.ibm.ccl.discovery.ui.wizards.DiscWizard_CategoryPage;
import com.ibm.ccl.discovery.ui.wizards.DiscWizard_InitializePage;
import com.ibm.propertygroup.ui.internal.utilities.IPropertyUIWidgetFactory;
import com.ibm.propertygroup.ui.plugin.PropertyUIMessageBundle;
import com.ibm.propertygroup.ui.wizards.MessageBundleWizardPage;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaModelStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.wizards.BuildPathDialogAccess;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.osgi.framework.Bundle;

public class DiscWizard_ProjectConfigPage
extends MessageBundleWizardPage
implements Listener {
    protected Label treeViewerTitle_ = null;
    protected TreeViewer treeViewer_ = null;
    protected Button addJARButton_ = null;
    protected Button addEJARButton_ = null;
    protected Button addVariableButton_ = null;
    protected Button removeButton_ = null;
    protected IJavaProject javaProject_;
    protected ClassPathElementContentProvider cProvider_;
    protected ClassPathElementLabelProvider lProvider_;
    protected boolean isPreviousPageModified_ = true;
    protected ArrayList inputList_ = new ArrayList();

    public DiscWizard_ProjectConfigPage(String name, DiscUIMessageBundle newBundle) {
        super(name, (PropertyUIMessageBundle)newBundle);
        this.initPageTitle();
    }

    protected void initPageTitle() {
        this.setTitle(this.messageBundle_.getMessage("DISC_UI_WIZARD_PROJECTCONFIG_PAGE_TITLE"));
        this.setDescription(this.messageBundle_.getMessage("DISC_UI_WIZARD_PROJECTCONFIG_PAGE_DESC"));
        this.setImageDescriptor(this.messageBundle_.getImageDescriptor(this.messageBundle_.getMessage("ICON_DISC_WIZARD_PROJECTCONFIG_PAGE")));
    }

    public Composite createContents(IPropertyUIWidgetFactory factory, Composite parent) {
        Composite main = factory.createComposite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        main.setLayout((Layout)layout);
        main.setLayoutData((Object)new GridData(1808));
        this.treeViewerTitle_ = this.createTreeViewerTitle(factory, main);
        this.treeViewer_ = this.createTreeViewer(factory, main);
        this.addJARButton_ = this.createButton(factory, this.messageBundle_.getMessage("DISC_UI_WIZARD_BUTTON_ADD_JARS"), main);
        this.addEJARButton_ = this.createButton(factory, this.messageBundle_.getMessage("DISC_UI_WIZARD_BUTTON_ADD_EXTERNAL_JARS"), main);
        this.addVariableButton_ = this.createButton(factory, this.messageBundle_.getMessage("DISC_UI_WIZARD_BUTTON_ADD_VARIABLE"), main);
        Label separator = factory.createSeparator(main, 256);
        separator.setVisible(false);
        this.removeButton_ = this.createButton(factory, this.messageBundle_.getMessage("DISC_UI_WIZARD_BUTTON_REMOVE_1"), main);
        this.removeButton_.setEnabled(false);
        this.initTreeViewer(this.treeViewer_);
        return main;
    }

    protected Label createTreeViewerTitle(IPropertyUIWidgetFactory factory, Composite parent) {
        Label label = factory.createLabel(parent, this.messageBundle_.getMessage("DISC_UI_WIZARD_LABEL_LIBRARIES"), 64);
        GridData gd = new GridData();
        gd.horizontalSpan = ((GridLayout)parent.getLayout()).numColumns;
        label.setLayoutData((Object)gd);
        return label;
    }

    protected TreeViewer createTreeViewer(IPropertyUIWidgetFactory factory, Composite parent) {
        Tree tree = factory.createTree(parent, 2 | factory.getBorderStyle());
        TreeViewer viewer = factory.createTreeViewer(tree);
        GridData gd = new GridData(1808);
        gd.verticalSpan = 5;
        tree.setLayoutData((Object)gd);
        ViewerSorter sorter = this.getViewerSorter();
        if (sorter != null) {
            viewer.setSorter(sorter);
        }
        return viewer;
    }

    protected ViewerSorter getViewerSorter() {
        return new CPListElementSorter();
    }

    protected Button createButton(IPropertyUIWidgetFactory factory, String text, Composite parent) {
        Button button = factory.createButton(parent, text, 0x1000008);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        button.setLayoutData((Object)gd);
        button.addListener(13, (Listener)this);
        return button;
    }

    protected void initTreeViewer(TreeViewer treeViewer) {
        treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DiscWizard_ProjectConfigPage.this.handleTreeSelectionChanged(event);
            }
        });
        this.lProvider_ = new ClassPathElementLabelProvider((DiscUIMessageBundle)this.messageBundle_);
        this.cProvider_ = new ClassPathElementContentProvider();
        treeViewer.setLabelProvider((IBaseLabelProvider)this.lProvider_);
        treeViewer.setContentProvider((IContentProvider)this.cProvider_);
    }

    public void initPage(IProject project) {
        this.inputList_.clear();
        this.isModified(false);
        if (project != null) {
            boolean projectExists;
            boolean bl = projectExists = project.exists() && project.getFile(".classpath").exists();
            if (projectExists) {
                this.javaProject_ = JavaCore.create((IProject)project);
                this.inputList_ = this.getExistingEntries(this.javaProject_);
            }
        }
        this.treeViewer_.setInput((Object)this.inputList_);
        this.setPageComplete(this.validatePage());
    }

    protected ArrayList getExistingEntries(IJavaProject javaProject) {
        IClasspathEntry[] classpathEntries = javaProject.readRawClasspath();
        ArrayList<ClassPathElement> newClassPath = new ArrayList<ClassPathElement>();
        int i = 0;
        while (i < classpathEntries.length) {
            IClasspathEntry curr = classpathEntries[i];
            ClassPathElement element = this.createClassPathElement(javaProject, curr);
            if (element != null) {
                newClassPath.add(element);
            }
            ++i;
        }
        return newClassPath;
    }

    protected void handleTreeSelectionChanged(SelectionChangedEvent e) {
        StructuredSelection selection = (StructuredSelection)this.treeViewer_.getSelection();
        if (selection != null && !selection.isEmpty()) {
            Object[] objects = selection.toArray();
            boolean enabled = true;
            int i = 0;
            while (i < objects.length) {
                ClassPathElement element;
                int kind;
                if (objects[i] instanceof ClassPathElement && ((kind = (element = (ClassPathElement)objects[i]).getEntryKind()) != 1 && kind != 4 || element.isChild())) {
                    enabled = false;
                    break;
                }
                ++i;
            }
            this.removeButton_.setEnabled(enabled);
        } else {
            this.removeButton_.setEnabled(false);
        }
    }

    public void dispose() {
        super.dispose();
        if (this.cProvider_ != null) {
            this.cProvider_.dispose();
        }
        if (this.lProvider_ != null) {
            this.lProvider_.dispose();
        }
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    public void handleEvent(final Event event) {
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            @Override
            public void run() {
                if (event.widget == DiscWizard_ProjectConfigPage.this.addJARButton_) {
                    DiscWizard_ProjectConfigPage.this.performAddJARs();
                } else if (event.widget == DiscWizard_ProjectConfigPage.this.addEJARButton_) {
                    DiscWizard_ProjectConfigPage.this.performAddExternalJARs();
                } else if (event.widget == DiscWizard_ProjectConfigPage.this.addVariableButton_) {
                    DiscWizard_ProjectConfigPage.this.performAddVariable();
                } else if (event.widget == DiscWizard_ProjectConfigPage.this.removeButton_) {
                    DiscWizard_ProjectConfigPage.this.performRemove();
                }
                DiscWizard_ProjectConfigPage.this.setPageComplete(DiscWizard_ProjectConfigPage.this.validatePage());
            }
        });
    }

    protected void performAddJARs() {
        ArrayList<Object> resources = new ArrayList<Object>();
        int i = 0;
        while (i < this.inputList_.size()) {
            IResource resource;
            ClassPathElement element = (ClassPathElement)this.inputList_.get(i);
            if (element.getEntryKind() == 1 && (resource = element.getResource()) instanceof IFile) {
                resources.add(resource.getFullPath());
            }
            ++i;
        }
        IWorkspaceRoot root = this.javaProject_.getProject().getWorkspace().getRoot();
        IPath[] selected = BuildPathDialogAccess.chooseJAREntries((Shell)this.getShell(), (IPath)this.javaProject_.getPath(), (IPath[])resources.toArray(new IPath[resources.size()]));
        resources.clear();
        if (selected != null) {
            int i2 = 0;
            while (i2 < selected.length) {
                IResource resource = root.findMember(selected[i2]);
                if (resource instanceof IFile) {
                    ClassPathElement cpe = new ClassPathElement(this.javaProject_, null, 1, selected[i2]);
                    cpe.setResource(resource);
                    resources.add(cpe);
                }
                ++i2;
            }
            this.addToInputList(resources);
        }
    }

    protected void performAddExternalJARs() {
        IPath[] selected = BuildPathDialogAccess.chooseExternalJAREntries((Shell)this.getShell());
        if (selected != null) {
            ArrayList<ClassPathElement> elements = new ArrayList<ClassPathElement>();
            int i = 0;
            while (i < selected.length) {
                elements.add(new ClassPathElement(this.javaProject_, null, 1, selected[i]));
                ++i;
            }
            this.addToInputList(elements);
        }
    }

    protected void performAddVariable() {
        ArrayList<Object> variables = new ArrayList<Object>();
        int i = 0;
        while (i < this.inputList_.size()) {
            ClassPathElement element = (ClassPathElement)this.inputList_.get(i);
            if (element.getEntryKind() == 4) {
                variables.add(element.getPath());
            }
            ++i;
        }
        IPath[] selected = BuildPathDialogAccess.chooseVariableEntries((Shell)this.getShell(), (IPath[])variables.toArray(new IPath[variables.size()]));
        variables.clear();
        if (selected != null) {
            int i2 = 0;
            while (i2 < selected.length) {
                variables.add(new ClassPathElement(this.javaProject_, null, 4, selected[i2]));
                ++i2;
            }
            this.addToInputList(variables);
        }
    }

    protected void addToInputList(ArrayList elements) {
        ArrayList addingElements = new ArrayList();
        int i = 0;
        while (i < elements.size()) {
            Object element = elements.get(i);
            if (!addingElements.contains(element)) {
                addingElements.add(element);
            }
            if (!this.inputList_.contains(element)) {
                this.inputList_.add(element);
                this.isModified(true);
            }
            ++i;
        }
        this.treeViewer_.getTree().setFocus();
        this.treeViewer_.refresh();
        this.treeViewer_.setSelection((ISelection)new StructuredSelection(addingElements), true);
    }

    protected void performRemove() {
        StructuredSelection selection = (StructuredSelection)this.treeViewer_.getSelection();
        if (selection != null && !selection.isEmpty()) {
            this.inputList_.removeAll(selection.toList());
            this.treeViewer_.refresh();
        }
    }

    public boolean isPreviousPageModified() {
        return this.isPreviousPageModified_;
    }

    public void isPreviousPageModified(boolean modified) {
        this.isPreviousPageModified_ = modified;
    }

    public boolean performPageFinish(DiscWizard wizard) {
        try {
            wizard.getContainer().run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    if (DiscWizard_ProjectConfigPage.this.inputList_.size() > 0) {
                        monitor.beginTask("", 4);
                        monitor.subTask(DiscWizard_ProjectConfigPage.this.messageBundle_.getMessage("DISC_UI_WIZARD_MSG_ADDING_TO_BUILD_PATH"));
                        monitor.worked(1);
                        IClasspathEntry[] classpathEntries = DiscWizard_ProjectConfigPage.this.javaProject_.readRawClasspath();
                        ArrayList<IClasspathEntry> nonConfigurableEntries = new ArrayList<IClasspathEntry>();
                        int i = 0;
                        while (i < classpathEntries.length) {
                            if (!DiscWizard_ProjectConfigPage.this.isConfigurableEntry(classpathEntries[i].getEntryKind())) {
                                nonConfigurableEntries.add(classpathEntries[i]);
                            }
                            ++i;
                        }
                        monitor.worked(1);
                        i = 0;
                        while (i < DiscWizard_ProjectConfigPage.this.inputList_.size()) {
                            IClasspathEntry cpEntry = ((ClassPathElement)DiscWizard_ProjectConfigPage.this.inputList_.get(i)).getClassPathEntry();
                            nonConfigurableEntries.add(cpEntry);
                            ++i;
                        }
                        IClasspathEntry[] ceArray = new IClasspathEntry[nonConfigurableEntries.size()];
                        nonConfigurableEntries.toArray(ceArray);
                        try {
                            DiscWizard_ProjectConfigPage.this.javaProject_.setRawClasspath(ceArray, DiscWizard_ProjectConfigPage.this.javaProject_.getOutputLocation(), (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                        }
                        catch (JavaModelException jme) {
                            throw new InvocationTargetException(jme);
                        }
                        monitor.subTask(DiscWizard_ProjectConfigPage.this.messageBundle_.getMessage("DISC_UI_WIZARD_MSG_UPDATING_REGISTRIES"));
                        DiscUIHelper.getDiscUIHelper().waitForBuildJobs(1);
                        monitor.worked(1);
                    }
                }
            });
            return true;
        }
        catch (InvocationTargetException itc) {
            if (itc.getCause() instanceof BaseException) {
                DiscUIHelper.getDiscUIHelper().showExceptionMessage(itc.getCause(), this.getShell(), this.messageBundle_.getMessage("WIZARD_WIN_ERRTITLE"), DiscUIHelper.getDiscUIHelper().getMessageFromCoreException((CoreException)((Object)((BaseException)itc.getCause()))));
            } else {
                DiscUIHelper.getDiscUIHelper().showExceptionMessage(itc.getCause(), this.getShell(), this.messageBundle_.getMessage("WIZARD_WIN_ERRTITLE"), itc.getCause().getMessage());
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception e) {
            DiscUIHelper.getDiscUIHelper().showExceptionMessage(e, this.getShell(), this.messageBundle_.getMessage("WIZARD_WIN_ERRTITLE"), e.getMessage());
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean validatePage() {
        this.hasMessage_ = false;
        IClasspathEntry[] entries = new IClasspathEntry[this.inputList_.size()];
        int i = 0;
        while (i < this.inputList_.size()) {
            entries[i] = ((ClassPathElement)this.inputList_.get(i)).getClassPathEntry();
            ++i;
        }
        try {
            IJavaModelStatus status = JavaConventions.validateClasspath((IJavaProject)this.javaProject_, (IClasspathEntry[])entries, (IPath)this.javaProject_.getOutputLocation());
            switch (status.getSeverity()) {
                case 4: {
                    this.setErrorMessage(status.getMessage());
                    return false;
                }
                case 2: {
                    this.setMessage(status.getMessage(), 2);
                    this.hasMessage_ = true;
                    break;
                }
                case 1: {
                    this.setMessage(status.getMessage(), 1);
                    this.hasMessage_ = true;
                    break;
                }
            }
        }
        catch (JavaModelException jme) {
            this.setErrorMessage(jme.getMessage());
            return false;
        }
        this.cleanMessage();
        return true;
    }

    protected ClassPathElement createClassPathElement(IJavaProject project, IClasspathEntry entry) {
        ClassPathElement element = null;
        if (this.isConfigurableEntry(entry.getEntryKind())) {
            element = new ClassPathElement(project, entry, entry.getEntryKind(), entry.getPath());
        }
        return element;
    }

    protected boolean isConfigurableEntry(int entryKind) {
        switch (entryKind) {
            case 1: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    protected boolean isArchivePath(IPath path) {
        String ext = path.getFileExtension();
        return ext != null && ext.length() != 0 && (ext.equalsIgnoreCase("jar") || ext.equalsIgnoreCase("zip"));
    }

    public IWizardPage getNextPage() {
        DiscWizard wizard = (DiscWizard)this.getWizard();
        if (this.isModified()) {
            if (!this.performPageFinish(wizard)) {
                return this;
            }
            this.isModified(false);
        }
        DiscWizard_CategoryPage prevPage = wizard.getCategoryPage();
        DiscWizard_InitializePage nextPage = wizard.getDiscInitializePage();
        prevPage.setConfigurableProject(null);
        if (this.isPreviousPageModified()) {
            IDiscoveryAgent agent = prevPage.getDiscoveryAgent();
            String subKey = null;
            if (prevPage.selectedObject_ instanceof DiscoveryConnection) {
                subKey = ((DiscoveryConnection)prevPage.selectedObject_).getName();
            }
            nextPage.initPage(agent, agent.getMetaData().getDisplayName(), subKey, wizard.getContext());
            this.isPreviousPageModified(false);
        }
        return nextPage;
    }

    protected class CPListElementSorter
    extends ViewerSorter {
        private static final int LIBRARY = 0;
        private static final int VARIABLE = 1;
        private static final int CONTAINER = 2;
        private static final int OTHER = 3;

        protected CPListElementSorter() {
        }

        public int category(Object obj) {
            if (obj instanceof ClassPathElement) {
                ClassPathElement element = (ClassPathElement)obj;
                switch (element.getEntryKind()) {
                    case 1: {
                        return 0;
                    }
                    case 4: {
                        return 1;
                    }
                    case 5: {
                        return 2;
                    }
                }
            }
            return 3;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            IBaseLabelProvider prov;
            int cat2;
            int cat1 = this.category(e1);
            if (cat1 != (cat2 = this.category(e2))) {
                return cat1 - cat2;
            }
            if (viewer instanceof ContentViewer && (prov = ((ContentViewer)viewer).getLabelProvider()) instanceof ILabelProvider) {
                ILabelProvider lprov = (ILabelProvider)prov;
                String name1 = lprov.getText(e1);
                String name2 = lprov.getText(e2);
                return this.getComparator().compare(name1, name2);
            }
            return 0;
        }
    }

    protected class ClassPathElement {
        protected IJavaProject javaProject_;
        IClasspathEntry entry_;
        protected int kind_;
        protected IPath path_;
        protected IResource resource_ = null;
        protected ArrayList children_;
        protected boolean isChild_ = false;

        public ClassPathElement(IJavaProject project, IClasspathEntry entry, int kind, IPath path) {
            this.javaProject_ = project;
            this.entry_ = entry;
            this.kind_ = kind;
            this.path_ = path.isAbsolute() ? path : path.makeAbsolute();
            switch (this.kind_) {
                case 5: {
                    try {
                        IClasspathContainer container = JavaCore.getClasspathContainer((IPath)path, (IJavaProject)project);
                        if (container == null) break;
                        IClasspathEntry[] entries = container.getClasspathEntries();
                        int i = 0;
                        while (i < entries.length) {
                            ClassPathElement curr;
                            IClasspathEntry ice = entries[i];
                            if (ice != null && (curr = DiscWizard_ProjectConfigPage.this.createClassPathElement(project, ice)) != null) {
                                if (this.children_ == null) {
                                    this.children_ = new ArrayList();
                                }
                                curr.isChild_ = true;
                                this.children_.add(curr);
                            }
                            ++i;
                        }
                    }
                    catch (JavaModelException javaModelException) {}
                    break;
                }
                case 1: {
                    IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                    this.resource_ = root.findMember(path);
                    if (this.resource_ != null || DiscWizard_ProjectConfigPage.this.isArchivePath(path) || !root.getWorkspace().validatePath(path.toString(), 2).isOK() || !root.getProject(path.segment(0)).exists()) break;
                    this.resource_ = root.getFolder(path);
                }
            }
        }

        public ArrayList getChildren() {
            return this.children_;
        }

        public int getEntryKind() {
            return this.kind_;
        }

        public IResource getResource() {
            return this.resource_;
        }

        public void setResource(IResource resource) {
            this.resource_ = resource;
        }

        public IJavaProject getJavaProject() {
            return this.javaProject_;
        }

        public IClasspathEntry getClassPathEntry() {
            if (this.entry_ == null) {
                switch (this.kind_) {
                    case 4: {
                        this.entry_ = JavaCore.newVariableEntry((IPath)this.path_, null, null);
                        break;
                    }
                    default: {
                        this.entry_ = JavaCore.newLibraryEntry((IPath)this.path_, null, null);
                    }
                }
            }
            return this.entry_;
        }

        public IPath getPath() {
            return this.path_;
        }

        public boolean isChild() {
            return this.isChild_;
        }

        public boolean equals(Object arg0) {
            if (arg0 != null && arg0.getClass().equals(this.getClass())) {
                ClassPathElement element = (ClassPathElement)arg0;
                if (element.path_ != null) {
                    return element.path_.equals((Object)this.path_);
                }
            }
            return super.equals(arg0);
        }
    }

    protected class ClassPathElementContentProvider
    implements ITreeContentProvider {
        protected ClassPathElementContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            ArrayList children;
            if (parentElement instanceof Collection) {
                return ((Collection)parentElement).toArray();
            }
            if (parentElement instanceof ClassPathElement && (children = ((ClassPathElement)parentElement).getChildren()) != null) {
                return children.toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    protected class ClassPathElementLabelProvider
    implements ILabelProvider {
        private DiscUIMessageBundle bundle_;
        private Hashtable allocatedImages_ = new Hashtable();

        public ClassPathElementLabelProvider(DiscUIMessageBundle bundle) {
            this.bundle_ = bundle;
        }

        public Image getImage(Object element) {
            if (element instanceof ClassPathElement) {
                ClassPathElement cpe = (ClassPathElement)element;
                switch (cpe.getEntryKind()) {
                    case 1: {
                        IResource res = cpe.getResource();
                        if (res == null) {
                            return this.getIcon(this.bundle_.getMessage("ICON_DISC_WIZARD_IMAGE_LIBRARY_JAR_OBJECT"));
                        }
                        if (res instanceof IFile) {
                            return this.getIcon(this.bundle_.getMessage("ICON_DISC_WIZARD_IMAGE_JAR_OBJECT"));
                        }
                        return this.getIcon(this.bundle_.getMessage("ICON_DISC_WIZARD_IMAGE_PACKAGE_ROOT_OBJ"));
                    }
                    case 5: {
                        return this.getIcon(this.bundle_.getMessage("ICON_DISC_WIZARD_IMAGE_CP_LIBRARY_OBJ"));
                    }
                    case 4: {
                        return this.getIcon("org.eclipse.jdt.ui.envvar_obj.gif");
                    }
                }
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof ClassPathElement) {
                ClassPathElement cpe = (ClassPathElement)element;
                IPath path = cpe.getPath();
                switch (cpe.getEntryKind()) {
                    case 1: {
                        IResource resource = cpe.getResource();
                        if (DiscWizard_ProjectConfigPage.this.isArchivePath(path)) {
                            IPath appendedPath = path.removeLastSegments(1);
                            String appended = resource == null ? appendedPath.toOSString() : appendedPath.makeRelative().toString();
                            return new StringBuffer(path.lastSegment()).append(" - ").append(appended).toString();
                        }
                        return path.makeRelative().toString();
                    }
                    case 5: {
                        try {
                            IClasspathContainer container = JavaCore.getClasspathContainer((IPath)path, (IJavaProject)cpe.getJavaProject());
                            if (container != null) {
                                return container.getDescription();
                            }
                            ClasspathContainerInitializer initializer = JavaCore.getClasspathContainerInitializer((String)path.segment(0));
                            if (initializer != null) {
                                return initializer.getDescription(path, cpe.getJavaProject());
                            }
                        }
                        catch (JavaModelException javaModelException) {}
                        return path.toString();
                    }
                    case 4: {
                        String name = path.makeRelative().toString();
                        IPath entryPath = JavaCore.getClasspathVariable((String)path.segment(0));
                        if (entryPath != null) {
                            String appended = entryPath.append(path.removeFirstSegments(1)).toOSString();
                            return new StringBuffer(name).append(" - ").append(appended).toString();
                        }
                        return name;
                    }
                }
            }
            return element == null ? "" : element.toString();
        }

        public Image getIcon(String iconPath) {
            if (iconPath != null) {
                Image im = (Image)this.allocatedImages_.get(iconPath);
                if (im != null) {
                    return im;
                }
                im = iconPath.equals("org.eclipse.jdt.ui.envvar_obj.gif") ? JavaUI.getSharedImages().getImageDescriptor(iconPath).createImage() : this.getImageDescriptor(iconPath).createImage();
                this.allocatedImages_.put(iconPath, im);
                return im;
            }
            return null;
        }

        public ImageDescriptor getImageDescriptor(String name) {
            try {
                int index = name.indexOf("/");
                String id = name.substring(0, index);
                String path = name.substring(index + 1, name.length());
                Bundle bundle = Platform.getBundle((String)id);
                URL installURL = bundle.getEntry("/");
                URL imageURL = new URL(installURL, path);
                return ImageDescriptor.createFromURL((URL)imageURL);
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
            Enumeration ims = this.allocatedImages_.elements();
            while (ims.hasMoreElements()) {
                Image i = (Image)ims.nextElement();
                if (i.isDisposed()) continue;
                i.dispose();
            }
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

