/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.discovery.ui.wizards;

import com.ibm.adapter.framework.BaseException;
import com.ibm.adapter.framework.IDiscoveryAgent;
import com.ibm.adapter.framework.IEnvironment;
import com.ibm.adapter.framework.IPublishingSet;
import com.ibm.adapter.framework.IResultNode;
import com.ibm.adapter.framework.IResultNodeSelection;
import com.ibm.adapter.framework.spi.BaseResultNode;
import com.ibm.ccl.discovery.ui.api.IDiscoveryFlowModel;
import com.ibm.ccl.discovery.ui.handlers.IFlowModelContentHandler;
import com.ibm.ccl.discovery.ui.internal.data.DiscoveryConnection;
import com.ibm.ccl.discovery.ui.internal.data.DiscoveryFlowModel;
import com.ibm.ccl.discovery.ui.internal.messages.DiscUIMessageBundle;
import com.ibm.ccl.discovery.ui.internal.utilities.DiscUIHelper;
import com.ibm.ccl.discovery.ui.plugin.DiscUIPlugin;
import com.ibm.ccl.discovery.ui.wizards.DiscWizard_CategoryPage;
import com.ibm.ccl.discovery.ui.wizards.DiscWizard_InitializePage;
import com.ibm.ccl.discovery.ui.wizards.DiscWizard_ParametersPage;
import com.ibm.ccl.discovery.ui.wizards.DiscWizard_ProjectConfigPage;
import com.ibm.ccl.discovery.ui.wizards.DiscWizard_QueryPage;
import com.ibm.ccl.discovery.ui.wizards.DiscWizard_ResourceWriterInitiailzePropertiesPage;
import com.ibm.ccl.discovery.ui.wizards.PublishingObjectConfigurationParametersPage;
import com.ibm.ccl.discovery.ui.wizards.PublishingPropertiesPage;
import com.ibm.ccl.discovery.ui.wizards.ResolutionPropertiesPage;
import com.ibm.ccl.discpub.ui.core.internal.environment.UICoreImportEnvironment;
import com.ibm.propertygroup.IPropertyDescriptor;
import com.ibm.propertygroup.IPropertyGroup;
import com.ibm.propertygroup.ISingleValuedProperty;
import com.ibm.propertygroup.ui.wizards.MessageBundleWizard;
import com.ibm.propertygroup.ui.wizards.MessageBundleWizardDynamicPage;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DiscWizard
extends MessageBundleWizard {
    protected UICoreImportEnvironment environment_;
    protected IDiscoveryAgent agentParameter_ = null;
    protected boolean isAgentInitialized_ = false;
    protected QName[] wrwQNames_;
    protected IPath[] classifications_;
    protected Object[] context_ = null;
    protected ArrayList configList_;
    protected DiscWizard_CategoryPage categoryPage_;
    protected DiscWizard_ProjectConfigPage projectConfigPage_;
    protected DiscWizard_InitializePage initializePage_;
    protected DiscWizard_QueryPage queryPage_;
    protected DiscWizard_ParametersPage parametersPage_;
    protected DiscWizard_ResourceWriterInitiailzePropertiesPage writerInitPropsPage_;
    protected PublishingObjectConfigurationParametersPage pubObjectConfigParamPage_;
    protected PublishingPropertiesPage publishingPropertiesPage_;
    protected ResolutionPropertiesPage resolutionPropertiesPage_;
    protected IPublishingSet publishingSet_ = null;
    protected URI writerURI_ = null;
    protected IDiscoveryFlowModel flowModel_ = null;

    public DiscWizard() {
        this(null);
    }

    public DiscWizard(DiscUIMessageBundle newBundle) {
        this(newBundle, null, false);
    }

    public DiscWizard(DiscUIMessageBundle newBundle, ArrayList configList) {
        this(newBundle, null, false);
        this.configList_ = configList;
    }

    public DiscWizard(DiscUIMessageBundle newBundle, IDiscoveryAgent agent, boolean isAgentInitialized) {
        this.setNeedsProgressMonitor(true);
        this.messageBundle_ = newBundle;
        this.agentParameter_ = agent;
        this.isAgentInitialized_ = isAgentInitialized;
        this.doInit();
    }

    protected void doInit() {
        if (this.messageBundle_ == null) {
            this.messageBundle_ = new DiscUIMessageBundle(null);
        }
        this.environment_ = new UICoreImportEnvironment(this.getDataPersistPlugin().getBundle().getSymbolicName());
        this.setWindowTitle(this.messageBundle_.getMessage("WIZARD_WIN_TITLE"));
        this.classifications_ = new IPath[]{new Path("WID")};
    }

    public void init(IWorkbench desktop, IStructuredSelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.context_ = selection.toArray();
        }
    }

    public void createPageControls(Composite container) {
        super.createPageControls(container);
        if (this.agentParameter_ != null) {
            if (!this.isAgentInitialized_) {
                DiscWizard_InitializePage page = this.getDiscInitializePage();
                page.initPage(this.agentParameter_, this.getContext());
                page.updatePageSize(false);
            } else {
                this.getDiscQueryPage().initPage(this.agentParameter_, null);
            }
        }
    }

    public void addPages() {
        ArrayList<IWizardPage> pages = this.createWizardPages();
        Object sPage = null;
        if (this.agentParameter_ != null) {
            sPage = !this.isAgentInitialized_ ? this.getDiscInitializePage() : this.getDiscQueryPage();
        }
        int i = 0;
        while (i < pages.size()) {
            block6: {
                IWizardPage page;
                block5: {
                    page = pages.get(i);
                    if (sPage == null) break block5;
                    if (!sPage.equals(page) && !sPage.getName().equals(page.getName())) break block6;
                    sPage = null;
                }
                this.addPage(page);
            }
            ++i;
        }
    }

    protected ArrayList<IWizardPage> createWizardPages() {
        return this.createDiscoveryPages();
    }

    protected ArrayList<IWizardPage> createDiscoveryPages() {
        ArrayList<IWizardPage> pages = new ArrayList<IWizardPage>();
        if (this.getFlowModel() == null) {
            this.categoryPage_ = this.getCategoryPage();
            if (this.categoryPage_ != null) {
                pages.add((IWizardPage)this.categoryPage_);
            }
            this.projectConfigPage_ = this.getDiscProjectConfigPage();
            if (this.projectConfigPage_ != null) {
                pages.add((IWizardPage)this.projectConfigPage_);
            }
        }
        this.initializePage_ = this.getDiscInitializePage();
        if (this.initializePage_ != null) {
            pages.add((IWizardPage)this.initializePage_);
        }
        this.queryPage_ = this.getDiscQueryPage();
        if (this.queryPage_ != null) {
            pages.add((IWizardPage)this.queryPage_);
        }
        this.parametersPage_ = this.getDiscParametersPage();
        if (this.parametersPage_ != null) {
            pages.add((IWizardPage)this.parametersPage_);
        }
        this.writerInitPropsPage_ = this.getResourceWriterInitiailzePropertiesPage();
        if (this.writerInitPropsPage_ != null) {
            pages.add((IWizardPage)this.writerInitPropsPage_);
        }
        this.pubObjectConfigParamPage_ = this.getPublishingObjectConfigurationParametersPage();
        if (this.pubObjectConfigParamPage_ != null) {
            pages.add((IWizardPage)this.pubObjectConfigParamPage_);
        }
        this.publishingPropertiesPage_ = this.getPublishingPropertiesPage();
        if (this.publishingPropertiesPage_ != null) {
            pages.add((IWizardPage)this.publishingPropertiesPage_);
        }
        this.resolutionPropertiesPage_ = this.getResolutionPropertiesPage();
        if (this.resolutionPropertiesPage_ != null) {
            pages.add((IWizardPage)this.resolutionPropertiesPage_);
        }
        return pages;
    }

    public DiscWizard_CategoryPage getCategoryPage() {
        if (this.categoryPage_ == null) {
            this.categoryPage_ = new DiscWizard_CategoryPage("com.ibm.ccl.discovery.ui.wizards.DiscWizard_CategoryPage", (DiscUIMessageBundle)this.messageBundle_);
            if (this.configList_ != null) {
                this.categoryPage_.showTopology(false);
                this.categoryPage_.setTreeViewInput(this.configList_);
            }
        }
        return this.categoryPage_;
    }

    public DiscWizard_ProjectConfigPage getDiscProjectConfigPage() {
        if (this.projectConfigPage_ == null) {
            this.projectConfigPage_ = new DiscWizard_ProjectConfigPage("com.ibm.ccl.discovery.ui.wizards.DiscWizard_ProjectConfigPage", (DiscUIMessageBundle)this.messageBundle_);
        }
        return this.projectConfigPage_;
    }

    public DiscWizard_InitializePage getDiscInitializePage() {
        if (this.initializePage_ == null) {
            this.initializePage_ = new DiscWizard_InitializePage("com.ibm.ccl.discovery.ui.wizards.DiscWizard_InitializePage", (DiscUIMessageBundle)this.messageBundle_);
        }
        return this.initializePage_;
    }

    public DiscWizard_QueryPage getDiscQueryPage() {
        if (this.queryPage_ == null) {
            this.queryPage_ = new DiscWizard_QueryPage("com.ibm.ccl.discovery.ui.wizards.DiscWizard_QueryPage", (DiscUIMessageBundle)this.messageBundle_);
        }
        return this.queryPage_;
    }

    public DiscWizard_ParametersPage getDiscParametersPage() {
        if (this.parametersPage_ == null) {
            this.parametersPage_ = new DiscWizard_ParametersPage("com.ibm.ccl.discovery.ui.wizards.DiscWizard_ParametersPage", (DiscUIMessageBundle)this.messageBundle_);
        }
        return this.parametersPage_;
    }

    public DiscWizard_ResourceWriterInitiailzePropertiesPage getResourceWriterInitiailzePropertiesPage() {
        if (this.writerInitPropsPage_ == null) {
            this.writerInitPropsPage_ = new DiscWizard_ResourceWriterInitiailzePropertiesPage("com.ibm.ccl.discovery.ui.wizards.DiscWizard_ResourceWriterInitiailzePropertiesPage", (DiscUIMessageBundle)this.messageBundle_);
        }
        return this.writerInitPropsPage_;
    }

    public PublishingObjectConfigurationParametersPage getPublishingObjectConfigurationParametersPage() {
        if (this.pubObjectConfigParamPage_ == null) {
            this.pubObjectConfigParamPage_ = new PublishingObjectConfigurationParametersPage("com.ibm.ccl.discovery.ui.wizards.PublishingObjectConfigurationParametersPage", (DiscUIMessageBundle)this.messageBundle_);
        }
        return this.pubObjectConfigParamPage_;
    }

    public PublishingPropertiesPage getPublishingPropertiesPage() {
        if (this.publishingPropertiesPage_ == null) {
            this.publishingPropertiesPage_ = new PublishingPropertiesPage("com.ibm.ccl.discovery.ui.wizards.PublishingPropertiesPage", (DiscUIMessageBundle)this.messageBundle_);
        }
        return this.publishingPropertiesPage_;
    }

    public ResolutionPropertiesPage getResolutionPropertiesPage() {
        if (this.resolutionPropertiesPage_ == null) {
            this.resolutionPropertiesPage_ = new ResolutionPropertiesPage("com.ibm.ccl.discovery.ui.wizards.ResolutionPropertiesPage", (DiscUIMessageBundle)this.messageBundle_);
        }
        return this.resolutionPropertiesPage_;
    }

    protected boolean performWizardFinish() {
        final boolean[] status = new boolean[]{true};
        try {
            this.getContainer().run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    try {
                        monitor.beginTask("", 3);
                        monitor.subTask(DiscWizard.this.messageBundle_.getMessage("DISC_UI_WIZARD_MSG_GENERATING"));
                        monitor.worked(1);
                        status[0] = DiscWizard.this.performGeneration(monitor);
                        if (!status[0]) {
                            return;
                        }
                        monitor.worked(1);
                        monitor.subTask(DiscWizard.this.messageBundle_.getMessage("DISC_UI_WIZARD_MSG_SAVING_DATA"));
                        status[0] = DiscWizard.this.performSavingPageData(monitor);
                        monitor.worked(1);
                    }
                    catch (BaseException ie) {
                        DiscUIHelper.getDiscUIHelper().showExceptionMessage(ie, DiscWizard.this.getShell(), DiscWizard.this.messageBundle_.getMessage("WIZARD_WIN_ERRTITLE"), DiscUIHelper.getDiscUIHelper().getMessageFromCoreException((CoreException)((Object)ie)));
                        status[0] = false;
                    }
                    catch (Exception e) {
                        DiscUIHelper.getDiscUIHelper().showExceptionMessage(e, DiscWizard.this.getShell(), DiscWizard.this.messageBundle_.getMessage("WIZARD_WIN_ERRTITLE"), e.getMessage());
                        status[0] = false;
                    }
                }
            });
        }
        catch (Exception e) {
            DiscUIHelper.getDiscUIHelper().showExceptionMessage(e, this.getShell(), this.messageBundle_.getMessage("WIZARD_WIN_ERRTITLE"), e.getMessage());
            status[0] = false;
        }
        return status[0];
    }

    protected boolean performGeneration(IProgressMonitor monitor) throws Exception {
        DiscWizard_QueryPage page = this.getDiscQueryPage();
        if (page != null) {
            this.writerURI_ = page.getResourceWriter().performWrite((IEnvironment)this.environment_, this.getPublishingSet());
            this.serializeDiscoveryFlow(this.writerURI_);
        }
        return true;
    }

    protected boolean performSavingPageData(IProgressMonitor monitor) {
        IWizardPage[] pages = this.getPages();
        int i = 0;
        while (i < pages.length) {
            MessageBundleWizardDynamicPage page;
            if (pages[i] instanceof MessageBundleWizardDynamicPage && !(page = (MessageBundleWizardDynamicPage)pages[i]).firstOpens()) {
                page.saveToStore(monitor);
            }
            ++i;
        }
        return true;
    }

    public QName[] getWorkspaceResourceWriter() {
        return this.wrwQNames_;
    }

    public void setWorkspaceResourceWriter(QName[] newWRWs) {
        this.wrwQNames_ = newWRWs;
    }

    public UICoreImportEnvironment getImportEnvironment() {
        return this.environment_;
    }

    public IPath[] getClassifications() {
        return this.classifications_;
    }

    public void setClassifications(IPath[] classifications) {
        this.classifications_ = classifications;
    }

    public AbstractUIPlugin getDataPersistPlugin() {
        return DiscUIPlugin.getInstance();
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page.equals((Object)this.categoryPage_)) {
            return this.getPageNextToCategoryPage(this.categoryPage_);
        }
        return super.getNextPage(page);
    }

    protected IWizardPage getWizardNextPage(IWizardPage page) {
        return super.getNextPage(page);
    }

    protected IWizardPage getPageNextToCategoryPage(DiscWizard_CategoryPage page) {
        Object nextPage;
        IProject project;
        boolean isModified = page.isModified();
        if (isModified) {
            if (page.agent_ != null) {
                try {
                    page.agent_.close();
                }
                catch (Exception exception) {}
                page.agent_ = null;
            }
            page.isModified(false);
        }
        if ((project = page.hasConfigurableProject()) == null) {
            nextPage = this.getDiscInitializePage();
            if (isModified) {
                IDiscoveryAgent agent = page.getDiscoveryAgent();
                String subKey = null;
                if (page.selectedObject_ instanceof DiscoveryConnection) {
                    subKey = ((DiscoveryConnection)page.selectedObject_).getName();
                }
                ((DiscWizard_InitializePage)((Object)nextPage)).initPage(agent, agent.getMetaData().getDisplayName(), subKey, this.getContext());
            }
        } else {
            nextPage = this.getDiscProjectConfigPage();
            if (isModified) {
                ((DiscWizard_ProjectConfigPage)((Object)nextPage)).isPreviousPageModified(isModified);
                ((DiscWizard_ProjectConfigPage)((Object)nextPage)).initPage(project);
            }
        }
        return nextPage;
    }

    public Object[] getContext() {
        return this.context_;
    }

    public IPublishingSet getPublishingSet() {
        return this.publishingSet_;
    }

    public void setPublishingSet(IPublishingSet publishingSet) {
        this.publishingSet_ = publishingSet;
    }

    public void serializeDiscoveryFlow(URI writerURI) {
        if (this.getDiscoveryFlowModelSerializationFileName(writerURI) == null) {
            return;
        }
        IDiscoveryFlowModel flowModel = this.getFlowModel();
        if (flowModel == null) {
            flowModel = this.getDefaultDiscoveryFlowModel();
        }
        IWizardPage page = this.getStartingPage();
        while (page != null) {
            this.serializePage(page, flowModel);
            page = page.getNextPage();
        }
        this.writeDiscoveryFlowModelToDisk(flowModel, writerURI);
    }

    public void serializePage(IWizardPage page, IDiscoveryFlowModel flowModel) {
        if (page instanceof DiscWizard_InitializePage) {
            DiscWizard_InitializePage currPage = (DiscWizard_InitializePage)page;
            IPropertyGroup pg = currPage.getPropertyGroup();
            flowModel.setInitializePagePropertyGroup(pg.convertToString());
            this.storeSensitiveProperties(pg, flowModel);
        } else if (page instanceof DiscWizard_QueryPage) {
            DiscWizard_QueryPage currPage = (DiscWizard_QueryPage)page;
            IPropertyGroup pg = currPage.getQueryFilterProps();
            String pgString = null;
            if (pg != null) {
                pgString = pg.convertToString();
            }
            flowModel.setQueryPageLastQueryPropertyGroup(pgString);
            Map<String, String> locationPGMap = flowModel.getQueryPageLocationToConfigurationParameterMap();
            locationPGMap.clear();
            IResultNodeSelection selection = currPage.getResultNodeSelection();
            IResultNode[] nodes = selection.getSelection();
            int i = 0;
            while (i < nodes.length) {
                pg = ((BaseResultNode)nodes[i]).getActiveConfigurationParameters();
                pgString = null;
                if (pg != null) {
                    pgString = pg.convertToString();
                    this.storeSensitiveProperties(pg, flowModel);
                }
                locationPGMap.put(nodes[i].getLocation(), pgString);
                ++i;
            }
        } else if (page instanceof DiscWizard_ParametersPage) {
            DiscWizard_ParametersPage currPage = (DiscWizard_ParametersPage)page;
            IPropertyGroup pg = currPage.getPropertyGroup();
            flowModel.setParametersPagePropertyGroup(pg.convertToString());
            this.storeSensitiveProperties(pg, flowModel);
        } else if (page instanceof PublishingObjectConfigurationParametersPage) {
            PublishingObjectConfigurationParametersPage currPage = (PublishingObjectConfigurationParametersPage)page;
            IPropertyGroup pg = currPage.getPropertyGroup();
            flowModel.setPublishingObjectConfigurationParametersPagePropertyGroup(pg.convertToString());
            this.storeSensitiveProperties(pg, flowModel);
        } else if (page instanceof PublishingPropertiesPage) {
            PublishingPropertiesPage currPage = (PublishingPropertiesPage)page;
            IPropertyGroup pg = currPage.getPropertyGroup();
            flowModel.setPublishingPropertiesPagePropertyGroup(pg.convertToString());
            this.storeSensitiveProperties(pg, flowModel);
        }
    }

    public IDiscoveryFlowModel getFlowModel() {
        return this.flowModel_;
    }

    public void setFlowModel(IDiscoveryFlowModel flowModel) {
        this.flowModel_ = flowModel;
    }

    public IDiscoveryFlowModel getDefaultDiscoveryFlowModel() {
        return new DiscoveryFlowModel();
    }

    public String getDiscoveryFlowModelSerializationFileName(URI writerURI) {
        return null;
    }

    public void storeSensitiveProperties(IPropertyGroup pg, IDiscoveryFlowModel flowModel) {
        ArrayList<ISingleValuedProperty> sensitivePropList = new ArrayList<ISingleValuedProperty>();
        this.findSensitiveProperties(pg, sensitivePropList);
        for (ISingleValuedProperty singleValuedProperty : sensitivePropList) {
            flowModel.storeSensitiveProperty(singleValuedProperty);
        }
    }

    public void restoreSensitiveProperties(IPropertyGroup pg, IDiscoveryFlowModel flowModel) {
        ArrayList<ISingleValuedProperty> sensitivePropList = new ArrayList<ISingleValuedProperty>();
        this.findSensitiveProperties(pg, sensitivePropList);
        for (ISingleValuedProperty singleValuedProperty : sensitivePropList) {
            flowModel.restoreSensitiveProperty(singleValuedProperty);
        }
    }

    public void findSensitiveProperties(IPropertyGroup pg, ArrayList<ISingleValuedProperty> sensitivePropList) {
        IPropertyDescriptor[] desc = pg.getProperties();
        int i = 0;
        while (i < desc.length) {
            ISingleValuedProperty prop;
            if (desc[i] instanceof IPropertyGroup) {
                this.findSensitiveProperties((IPropertyGroup)desc[i], sensitivePropList);
            } else if (desc[i] instanceof ISingleValuedProperty && (prop = (ISingleValuedProperty)desc[i]).getPropertyType().isSensitive()) {
                sensitivePropList.add(prop);
            }
            ++i;
        }
    }

    public static IDiscoveryFlowModel restoreDiscoveryFlowModelFromDisk(IFile modelFile, URL schemaURL, IFlowModelContentHandler handler) throws SAXException, ParserConfigurationException, CoreException, IOException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = schemaFactory.newSchema(schemaURL);
        SAXParserFactory parserFactory = SAXParserFactory.newInstance();
        parserFactory.setNamespaceAware(true);
        parserFactory.setValidating(true);
        parserFactory.setSchema(schema);
        SAXParser parser = parserFactory.newSAXParser();
        InputStream is = modelFile.getContents(true);
        parser.parse(is, (DefaultHandler)handler);
        is.close();
        return handler.getFlowModel();
    }

    public static URL getFlowModelSchema() {
        URL[] entries = FileLocator.findEntries((Bundle)DiscUIPlugin.getInstance().getBundle(), (IPath)new Path("schemas/FlowModel.xsd"));
        if (entries.length != 0) {
            return entries[0];
        }
        return null;
    }

    public void writeDiscoveryFlowModelToDisk(IDiscoveryFlowModel flowModel, URI writerURI) {
        String fileName = this.getDiscoveryFlowModelSerializationFileName(writerURI);
        if (fileName == null) {
            return;
        }
        try {
            DiscWizard.writeToDisk(flowModel, fileName);
        }
        catch (Exception exc) {
            DiscUIHelper.getDiscUIHelper().showExceptionMessage(exc, this.getShell(), this.messageBundle_.getMessage("WIZARD_WIN_ERRTITLE"), exc.getLocalizedMessage());
        }
    }

    public static void writeToDisk(IDiscoveryFlowModel flowModel, String fileName) throws FactoryConfigurationError, FileNotFoundException, XMLStreamException, CoreException {
        IFile[] wsFiles;
        String value;
        String key;
        XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
        FileOutputStream fos = new FileOutputStream(fileName);
        XMLStreamWriter writer = outputFactory.createXMLStreamWriter(fos, "UTF-8");
        String ns = "http://discovery.ccl.ibm.com/FlowModel";
        String prefix = "tns";
        writer.setDefaultNamespace(ns);
        writer.setPrefix(prefix, ns);
        writer.writeStartDocument("UTF-8", "1.0");
        writer.writeCharacters("\n");
        writer.writeStartElement(prefix, "flowModel", ns);
        writer.writeNamespace(prefix, ns);
        writer.writeCharacters("\n");
        writer.writeCharacters("\t");
        writer.writeStartElement(prefix, "resourceAdapter", ns);
        if (flowModel.getConnectorProjectName() != null) {
            writer.writeAttribute("connectorProject", flowModel.getConnectorProjectName());
        }
        if (flowModel.getAdapterDisplayName() != null) {
            writer.writeAttribute("displayName", flowModel.getAdapterDisplayName());
        }
        if (flowModel.getEisType() != null) {
            writer.writeAttribute("eisType", flowModel.getEisType());
        }
        if (flowModel.getAdapterVersion() != null) {
            writer.writeAttribute("version", flowModel.getAdapterVersion());
        }
        writer.writeEndElement();
        writer.writeCharacters("\n");
        writer.writeCharacters("\t");
        writer.writeStartElement(prefix, "isOutbound", ns);
        writer.writeCharacters(Boolean.toString(flowModel.isOutbound()));
        writer.writeEndElement();
        writer.writeCharacters("\n");
        writer.writeCharacters("\t");
        writer.writeStartElement(prefix, "initializePage", ns);
        writer.writeAttribute("pgString", flowModel.getInitializePagePropertyGroup());
        writer.writeEndElement();
        writer.writeCharacters("\n");
        if (flowModel.getQueryPageLastQueryPropertyGroup() != null) {
            writer.writeCharacters("\t");
            writer.writeStartElement(prefix, "lastQuery", ns);
            writer.writeAttribute("pgString", flowModel.getQueryPageLastQueryPropertyGroup());
            writer.writeEndElement();
            writer.writeCharacters("\n");
        }
        writer.writeCharacters("\t");
        writer.writeStartElement(prefix, "queryPageLocationToPGMap", ns);
        writer.writeCharacters("\n");
        for (Map.Entry<String, String> entry : flowModel.getQueryPageLocationToConfigurationParameterMap().entrySet()) {
            key = entry.getKey();
            value = entry.getValue() == null ? "" : entry.getValue();
            writer.writeCharacters("\t\t");
            writer.writeStartElement(prefix, "mapEntry", ns);
            writer.writeAttribute("key", key);
            writer.writeAttribute("pgString", value);
            writer.writeEndElement();
            writer.writeCharacters("\n");
        }
        writer.writeCharacters("\t");
        writer.writeEndElement();
        writer.writeCharacters("\n");
        if (flowModel.getParametersPagePropertyGroup() != null) {
            writer.writeCharacters("\t");
            writer.writeStartElement(prefix, "parametersPage", ns);
            writer.writeAttribute("pgString", flowModel.getParametersPagePropertyGroup());
            writer.writeEndElement();
            writer.writeCharacters("\n");
        }
        writer.writeCharacters("\t");
        writer.writeStartElement(prefix, "publishingObjectConfigParamsPage", ns);
        writer.writeAttribute("pgString", flowModel.getPublishingObjectConfigurationParametersPagePropertyGroup());
        writer.writeEndElement();
        writer.writeCharacters("\n");
        writer.writeCharacters("\t");
        writer.writeStartElement(prefix, "publishingPropertiesPage", ns);
        writer.writeAttribute("pgString", flowModel.getPublishingPropertiesPagePropertyGroup());
        writer.writeEndElement();
        writer.writeCharacters("\n");
        if (!flowModel.getSensitivePropertyMap().isEmpty()) {
            writer.writeCharacters("\t");
            writer.writeStartElement(prefix, "sensitivePropMap", ns);
            writer.writeCharacters("\n");
            for (Map.Entry<String, String> entry : flowModel.getSensitivePropertyMap().entrySet()) {
                key = entry.getKey();
                value = entry.getValue() == null ? "" : entry.getValue();
                writer.writeCharacters("\t\t");
                writer.writeStartElement(prefix, "sensitiveMapEntry", ns);
                writer.writeAttribute("key", key);
                writer.writeAttribute("value", value);
                writer.writeEndElement();
                writer.writeCharacters("\n");
            }
            writer.writeCharacters("\t");
            writer.writeEndElement();
            writer.writeCharacters("\n");
        }
        writer.writeEndElement();
        writer.writeCharacters("\n");
        writer.writeEndDocument();
        writer.flush();
        writer.close();
        IFile[] iFileArray = wsFiles = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)new Path(fileName));
        int n = wsFiles.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file = iFileArray[n2];
            file.refreshLocal(2, null);
            file.setCharset("UTF-8", null);
            ++n2;
        }
    }
}

