/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.discovery.ui.providers;

import com.ibm.ccl.discovery.ui.api.IDiscoveryAgentUIElement;
import com.ibm.ccl.discovery.ui.api.IDiscoveryAgentUIViewElement;
import com.ibm.ccl.discovery.ui.internal.messages.MessageResource;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;

public class DiscoveryAgentUIElementLabelProvider
implements ILabelProvider {
    private Hashtable allocatedImages_ = new Hashtable();

    public Image getImage(Object element) {
        if (element instanceof IDiscoveryAgentUIElement) {
            return this.getIcon(((IDiscoveryAgentUIElement)element).getTreeNodeIconPath());
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof IDiscoveryAgentUIViewElement) {
            IDiscoveryAgentUIViewElement ele = (IDiscoveryAgentUIViewElement)element;
            StringBuffer str = new StringBuffer(ele.getDisplayName());
            if (ele.isConnected()) {
                return str.append(MessageResource.DISC_UI_VIEW_LABEL_CONNECTED).toString();
            }
            return str.toString();
        }
        if (element instanceof IDiscoveryAgentUIElement) {
            return ((IDiscoveryAgentUIElement)element).getDisplayName();
        }
        return element == null ? "" : element.toString();
    }

    public Image getIcon(String iconPath) {
        if (iconPath != null) {
            Image im = (Image)this.allocatedImages_.get(iconPath);
            if (im != null) {
                return im;
            }
            im = this.getImageDescriptor(iconPath).createImage();
            this.allocatedImages_.put(iconPath, im);
            return im;
        }
        return null;
    }

    public ImageDescriptor getImageDescriptor(String name) {
        try {
            int index = name.indexOf("/");
            String id = name.substring(0, index);
            String path = name.substring(index + 1, name.length());
            Bundle bundle = Platform.getBundle((String)id);
            URL installURL = bundle.getEntry("/");
            URL imageURL = new URL(installURL, path);
            return ImageDescriptor.createFromURL((URL)imageURL);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
        Enumeration ims = this.allocatedImages_.elements();
        while (ims.hasMoreElements()) {
            Image i = (Image)ims.nextElement();
            if (i.isDisposed()) continue;
            i.dispose();
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

