/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.discovery.ui.internal.providers;

import com.ibm.adapter.framework.IResultNode;
import com.ibm.adapter.framework.ISearchTree;
import com.ibm.adapter.framework.ui.ITreeImageProvider;
import com.ibm.adapter.framework.ui.ImageProviderRegistry;
import com.ibm.ccl.discovery.ui.internal.messages.DiscUIMessageBundle;
import com.ibm.ccl.discovery.ui.internal.providers.MetaDataObjectContentProvider;
import com.ibm.propertygroup.ui.internal.utilities.PropertyUIOverlayIcon;
import com.ibm.propertygroup.ui.plugin.PropertyUIMessageBundle;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class MetaDataObjectLabelProvider
implements ILabelProvider {
    private Hashtable allocatedImages_ = new Hashtable();
    private MetaDataObjectContentProvider contentProvider_ = null;
    private PropertyUIMessageBundle messageBundle_;
    private boolean showFiltered_ = true;
    private TreeViewer treeViewer_;
    private ITreeImageProvider imageProvider_ = null;

    public MetaDataObjectLabelProvider(MetaDataObjectContentProvider contentProvider, TreeViewer treeViewer) {
        this(contentProvider, treeViewer, true);
    }

    public MetaDataObjectLabelProvider(MetaDataObjectContentProvider contentProvider, TreeViewer treeViewer, boolean showFiltered) {
        this.contentProvider_ = contentProvider;
        this.treeViewer_ = treeViewer;
        this.showFiltered_ = showFiltered;
        this.messageBundle_ = contentProvider != null ? contentProvider.getMessageBundle() : new DiscUIMessageBundle(null);
    }

    public Image getImage(Object element) {
        if (element instanceof IResultNode) {
            URL url;
            IResultNode resultNode = (IResultNode)element;
            String baseImage = null;
            Image retImage = null;
            if (this.imageProvider_ != null && (url = this.imageProvider_.getImagePath(resultNode)) != null && (retImage = resultNode.isSelectable() ? this.getImageFromURL(url) : this.getOverlayImageFromURL(url, this.messageBundle_.getMessage("ICON_DISC_WIZARD_OVERLAY_IMAGE_NONSELECTABLE"))) != null) {
                return retImage;
            }
            baseImage = resultNode.getType() == IResultNode.IResultNodeType.OBJECT ? this.messageBundle_.getMessage("ICON_DISC_WIZARD_IMAGE_METADATA_OBJECT") : (resultNode.getType() == IResultNode.IResultNodeType.FOLDER ? this.messageBundle_.getMessage("ICON_DISC_WIZARD_IMAGE_METADATA_FOLDER") : (resultNode.getType() == IResultNode.IResultNodeType.IN_OUT_PARAMETER ? this.messageBundle_.getMessage("ICON_DISC_WIZARD_IMAGE_METADATA_INOUT_PARAMETER") : (resultNode.getType() == IResultNode.IResultNodeType.IN_PARAMETER ? this.messageBundle_.getMessage("ICON_DISC_WIZARD_IMAGE_METADATA_IN_PARAMETER") : (resultNode.getType() == IResultNode.IResultNodeType.OPERATION ? this.messageBundle_.getMessage("ICON_DISC_WIZARD_IMAGE_METADATA_OPERATION") : (resultNode.getType() == IResultNode.IResultNodeType.OUT_PARAMETER ? this.messageBundle_.getMessage("ICON_DISC_WIZARD_IMAGE_METADATA_OUT_PARAMETER") : (resultNode.getType() == IResultNode.IResultNodeType.PROPERTY ? this.messageBundle_.getMessage("ICON_DISC_WIZARD_IMAGE_METADATA_PROPERTY") : this.messageBundle_.getMessage("ICON_DISC_WIZARD_IMAGE_METADATA_OBJECT")))))));
            if (resultNode.isSelectable()) {
                retImage = this.getImage(baseImage);
            } else {
                retImage = this.getOverlayImage(baseImage, this.messageBundle_.getMessage("ICON_DISC_WIZARD_OVERLAY_IMAGE_NONSELECTABLE"));
                if (this.treeViewer_ instanceof CheckboxTreeViewer) {
                    ((CheckboxTreeViewer)this.treeViewer_).setGrayed(element, true);
                }
            }
            return retImage;
        }
        if (element instanceof String) {
            return this.getImage(this.messageBundle_.getMessage("ICON_DISC_WIZARD_IMAGE_INFORMATION_OBJECT"));
        }
        return null;
    }

    public Image getImage(String iconPath) {
        Image im = (Image)this.allocatedImages_.get(iconPath);
        if (im != null) {
            return im;
        }
        im = this.messageBundle_.getImageDescriptor(iconPath).createImage();
        this.allocatedImages_.put(iconPath, im);
        return im;
    }

    public Image getImageFromURL(URL iconURL) {
        if (iconURL != null) {
            Image im = (Image)this.allocatedImages_.get(iconURL.toString());
            if (im != null) {
                return im;
            }
            im = ImageDescriptor.createFromURL((URL)iconURL).createImage();
            this.allocatedImages_.put(iconURL.toString(), im);
            return im;
        }
        return null;
    }

    public Image getOverlayImage(String iconPath, String overlayPath) {
        StringBuffer key = new StringBuffer(iconPath).append(":").append(overlayPath);
        Image image = (Image)this.allocatedImages_.get(key.toString());
        if (image != null) {
            return image;
        }
        Image retImage = this.getImage(iconPath);
        Image overlay = this.getImage(overlayPath);
        retImage = new PropertyUIOverlayIcon(retImage, overlay).createImage();
        this.allocatedImages_.put(key, retImage);
        return retImage;
    }

    public Image getOverlayImageFromURL(URL iconURL, String overlayPath) {
        if (iconURL != null && overlayPath != null) {
            String key = new StringBuffer(iconURL.toString()).append(":").append(overlayPath).toString();
            Image image = (Image)this.allocatedImages_.get(key);
            if (image != null) {
                return image;
            }
            Image retImage = this.getImageFromURL(iconURL);
            Image overlay = this.getImage(overlayPath);
            retImage = new PropertyUIOverlayIcon(retImage, overlay).createImage();
            this.allocatedImages_.put(key, retImage);
            return retImage;
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof IResultNode) {
            IResultNode resultNode = (IResultNode)element;
            String name = resultNode.getName();
            if (name != null) {
                if (!this.showFiltered_ || this.contentProvider_ == null) {
                    return name;
                }
                if (!this.contentProvider_.hasFilter(resultNode)) {
                    return name;
                }
                return new StringBuffer(name).append(" (").append(this.messageBundle_.getMessage("DISC_UI_WIZARD_MSG_SEARCH_QUERY_FILTERED")).append(")").toString();
            }
        } else {
            if (element instanceof String) {
                return (String)element;
            }
            if (element instanceof IWorkbenchAdapter) {
                return ((IWorkbenchAdapter)element).getLabel(element);
            }
        }
        return "";
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
        Enumeration ims = this.allocatedImages_.elements();
        while (ims.hasMoreElements()) {
            Image i = (Image)ims.nextElement();
            if (i.isDisposed()) continue;
            i.dispose();
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void setSearchTree(ISearchTree searchTree) {
        this.imageProvider_ = ImageProviderRegistry.instance().getImageProviderForSearchTree(searchTree.getClass().getName());
    }
}

