/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpmn20.util;

import com.ibm.bpmn20.BaseElement;
import com.ibm.bpmn20.Bpmn20Factory;
import com.ibm.bpmn20.Bpmn20Package;
import com.ibm.bpmn20.Definitions;
import com.ibm.bpmn20.Import;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xml.type.XMLTypeFactory;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternalBpmnUtil {
    private static final String QNAME_SUFFIX = "QName";
    private static final int QNAME_SUFFIX_LEN = "QName".length();
    private static final Map<EClass, Map<EReference, EAttribute>> qNamedReferencesMap = new HashMap<EClass, Map<EReference, EAttribute>>();

    static {
        Map map = Collections.emptyMap();
        qNamedReferencesMap.put(Bpmn20Package.eINSTANCE.getExtension(), map);
    }

    public static final void setQNameReference(BaseElement referencer, BaseElement referenced, EStructuralFeature reference) {
        Import bpmnImport;
        if (reference.getEType() != XMLTypePackage.Literals.QNAME) {
            return;
        }
        if (referenced == null) {
            referencer.eUnset(reference);
            return;
        }
        Definitions referencedDefs = InternalBpmnUtil.getDefinitions(referenced);
        if (referencedDefs == null) {
            throw new IllegalArgumentException("Cannot create QName reference to a ReusableElement not contained by a Definitions implementation");
        }
        Definitions referencerDefs = InternalBpmnUtil.getDefinitions(referencer);
        if (referencerDefs == null) {
            throw new IllegalArgumentException("Cannot add QName reference in an Element not contained by a Definitions implementation");
        }
        QName referenceQName = XMLTypeFactory.eINSTANCE.createQName(referencedDefs.getTargetNamespace(), referenced.getId());
        if (referencerDefs != referencedDefs && (bpmnImport = InternalBpmnUtil.getMatchingImport(referencer, referenced, referenceQName)) == null) {
            URI referencerURI = referencer.eResource().getURI();
            URI referencedURI = referenced.eResource().getURI();
            if (!referencedURI.isRelative()) {
                referencedURI = referencedURI.deresolve(referencerURI);
            }
            bpmnImport = Bpmn20Factory.eINSTANCE.createImport();
            bpmnImport.setImportType("http://www.omg.org/bpmn20");
            bpmnImport.setNamespace(referencedDefs.getTargetNamespace());
            bpmnImport.setLocation(referencedURI.toString());
            referencerDefs.getImport().add((Object)bpmnImport);
        }
        if (reference.isMany()) {
            List refValues = (List)referencer.eGet(reference);
            refValues.add(referenceQName);
        } else {
            referencer.eSet(reference, referenceQName);
        }
    }

    public static final void setQNameReference(BaseElement referencer, Object referenced, EStructuralFeature reference) {
        throw new UnsupportedOperationException("Cannot set a QName reference to an arbitrary referenced object without a scheme for generating the QName!");
    }

    public static <T extends BaseElement> T resolveQNameReference(BaseElement referencer, QName referenceQName) {
        Definitions referencerDefs = InternalBpmnUtil.getDefinitions(referencer);
        if (referencerDefs == null) {
            return null;
        }
        if (referencerDefs.getTargetNamespace().equals(referenceQName.getNamespaceURI().toString())) {
            return (T)((BaseElement)referencer.eResource().getEObject(referenceQName.getLocalPart()));
        }
        URI referenceURI = InternalBpmnUtil.createReferenceURI(referencer, referenceQName);
        if (referenceURI == null) {
            return null;
        }
        ResourceSet rSet = referencer.eResource().getResourceSet();
        if (rSet == null) {
            return null;
        }
        return (T)((BaseElement)rSet.getEObject(referenceURI, true));
    }

    private static URI createReferenceURI(BaseElement referencer, QName referenceQName) {
        if (referencer == null || referenceQName == null) {
            return null;
        }
        Import matchingImport = InternalBpmnUtil.getMatchingImport(referencer, null, referenceQName);
        if (matchingImport == null) {
            return null;
        }
        if (matchingImport.getLocation() == null) {
            return URI.createURI((String)matchingImport.getNamespace()).appendFragment(referenceQName.getLocalPart());
        }
        URI locationURI = URI.createURI((String)matchingImport.getLocation());
        locationURI = locationURI.resolve(referencer.eResource().getURI());
        return locationURI.appendFragment(referenceQName.getLocalPart());
    }

    public static Import getMatchingImport(BaseElement referencer, BaseElement referenced, QName referenceQName) {
        if (referencer == null || referenceQName == null) {
            return null;
        }
        Definitions referencerDefs = InternalBpmnUtil.getDefinitions(referencer);
        if (referencerDefs == null) {
            return null;
        }
        Import bpmnImport = null;
        for (Import i : referencerDefs.getImport()) {
            if (!InternalBpmnUtil.matches(i, referencer, referenced, referenceQName)) continue;
            bpmnImport = i;
            break;
        }
        return bpmnImport;
    }

    private static boolean matches(Import bpmnImport, BaseElement referencer, BaseElement referenced, QName referenceQName) {
        if (referenced == null) {
            return InternalBpmnUtil.matches(bpmnImport, referencer, referenceQName);
        }
        if (!"http://www.omg.org/bpmn20".equals(bpmnImport.getImportType())) {
            return false;
        }
        Resource referencerResource = referencer.eResource();
        Resource referencedResource = referenced.eResource();
        if (referencerResource == null || referencedResource == null) {
            return false;
        }
        URI referencerResourceURI = referencer.eResource().getURI();
        URI referencedResourceURI = referenced.eResource().getURI();
        if (bpmnImport.getNamespace() == null) {
            return false;
        }
        if (!bpmnImport.getNamespace().equals(referenceQName.getNamespaceURI())) {
            return false;
        }
        if (bpmnImport.getLocation() == null) {
            return bpmnImport.getNamespace().equals(referencedResourceURI.toString());
        }
        URI importLocationURI = URI.createURI((String)bpmnImport.getLocation());
        if (!referencedResourceURI.equals((Object)(importLocationURI = importLocationURI.resolve(referencerResourceURI)))) {
            throw new IllegalStateException("Illegal state in model:  An import exists for target namespace: " + bpmnImport.getNamespace() + " but its location: " + importLocationURI.toString() + "doesn't match that of the referenced element: " + referencedResourceURI.toString());
        }
        return true;
    }

    public static boolean matches(Import bpmnImport, BaseElement referencer, QName referenceQName) {
        if (bpmnImport == null || referenceQName == null) {
            return false;
        }
        if (bpmnImport.getNamespace() == null) {
            return false;
        }
        return bpmnImport.getNamespace().equals(referenceQName.getNamespaceURI());
    }

    public static final QName generateQName(Object other) {
        throw new UnsupportedOperationException("Can't create a QName for an arbitrary Object without knowing the scheme to do so!");
    }

    public static final QName generateQName(BaseElement other) {
        if (other == null) {
            return null;
        }
        Definitions defs = InternalBpmnUtil.getDefinitions(other);
        if (defs == null) {
            throw new IllegalArgumentException("Cannot create QName reference to a ReusableElement not contained by a Definitions implementation");
        }
        QName name = XMLTypeFactory.eINSTANCE.createQName(defs.getTargetNamespace(), other.getId());
        return name;
    }

    public static final Definitions getDefinitions(BaseElement other) {
        if (other == null) {
            return null;
        }
        Definitions defs = null;
        BaseElement parent = other;
        while (parent != null) {
            if (parent instanceof Definitions) {
                defs = (Definitions)parent;
                break;
            }
            parent = parent.eContainer();
        }
        return defs;
    }

    public static final Map<EReference, EAttribute> getQNamedReferences(EClass eClass) {
        if (!Bpmn20Package.eINSTANCE.equals(eClass.getEPackage())) {
            return Collections.emptyMap();
        }
        Map<EReference, EAttribute> eRefs = qNamedReferencesMap.get(eClass);
        if (eRefs == null) {
            eRefs = new HashMap<EReference, EAttribute>();
            qNamedReferencesMap.put(eClass, eRefs);
            for (EAttribute aAttribute : eClass.getEAllAttributes()) {
                EStructuralFeature eFeature;
                if (aAttribute.getEType() != XMLTypePackage.Literals.QNAME || !((eFeature = eClass.getEStructuralFeature(InternalBpmnUtil.getCorrespondingEreferenceName(aAttribute))) instanceof EReference)) continue;
                eRefs.put((EReference)eFeature, aAttribute);
            }
        }
        return eRefs;
    }

    private static String getCorrespondingEreferenceName(EAttribute aAttribute) {
        String aAttributeName = aAttribute.getName();
        if (!aAttributeName.endsWith(QNAME_SUFFIX)) {
            throw new IllegalArgumentException("A QNAMED EAttribute's name does not end with QName : " + aAttributeName + " in " + aAttribute.getContainerClass().getName());
        }
        return aAttributeName.substring(0, aAttributeName.length() - QNAME_SUFFIX_LEN);
    }
}

