/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.was7.policyset.ui.widgets;

import com.ibm.ast.ws.jaxws.emitter.collector.ServiceData;
import com.ibm.ast.ws.jaxws.emitter.util.ProjectDescriptionRegistry;
import com.ibm.ast.ws.policyset.ui.common.CommonPolicyUtils;
import com.ibm.ast.ws.was7.policyset.ui.command.ReadServicePolicyAttachmentsCommand;
import com.ibm.ast.ws.was7.policyset.ui.common.BindingObject;
import com.ibm.ast.ws.was7.policyset.ui.common.CollectorUtils;
import com.ibm.ast.ws.was7.policyset.ui.common.EndPointObject;
import com.ibm.ast.ws.was7.policyset.ui.common.PolicyUtils;
import com.ibm.ast.ws.was7.policyset.ui.plugin.Activator;
import com.ibm.ast.ws.was7.policyset.ui.tables.EndPointConfigurationTable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.jst.ws.internal.consumption.common.FacetUtils;
import org.eclipse.jst.ws.internal.ui.common.UIUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleWidgetDataContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;
import org.eclipse.wst.ws.service.policy.IServicePolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerSidePolicyAttachmentWidget
extends SimpleWidgetDataContributor {
    private Listener statusListener_;
    private String INFOPOP_SSATT_PAGE = "SSATT0003";
    private String INFOPOP_SSATT_PROJECT_COMBO = "SSATT0001";
    private Combo application;
    private Map<String, IServicePolicy> allPolicySets;
    private Map<String, IServicePolicy> policySets;
    private Map<String, BindingObject> bindings;
    private String INFOPOP_SSATT_ENDPOINT_GROUP = "SSATT0002";
    private EndPointConfigurationTable table;
    private Map<String, IProject> projectsMap;
    private IProject project;
    private ServiceData serviceData;

    public WidgetDataEvents addControls(Composite parent, Listener statusListener) {
        this.statusListener_ = statusListener;
        UIUtils uiUtils = Activator.getUiUtils();
        this.projectsMap = new HashMap<String, IProject>();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.INFOPOP_SSATT_PAGE);
        Composite composite = uiUtils.createComposite(parent, 2);
        this.application = uiUtils.createCombo(composite, Activator.getMessage("LABEL_APPLICATION"), Activator.getMessage("TOOLTIP_SSATT_PROJECT_COMBO"), this.INFOPOP_SSATT_PROJECT_COMBO, 2060);
        this.application.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ServerSidePolicyAttachmentWidget.this.project == null || !ServerSidePolicyAttachmentWidget.this.project.getName().equals(ServerSidePolicyAttachmentWidget.this.application.getText())) {
                    ServerSidePolicyAttachmentWidget.this.project = (IProject)ServerSidePolicyAttachmentWidget.this.projectsMap.get(ServerSidePolicyAttachmentWidget.this.application.getText());
                    ServerSidePolicyAttachmentWidget.this.refreshTable();
                }
            }
        });
        IProject[] iProjectArray = FacetUtils.getAllProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject p = iProjectArray[n2];
            if (CollectorUtils.getServiceDataFromProject(p).length != 0) {
                if (J2EEUtils.isEARComponent((IProject)p)) {
                    this.projectsMap.put(p.getName(), p);
                } else if (ProjectDescriptionRegistry.getInstance().isSupportedServiceProject(p)) {
                    this.projectsMap.put(p.getName(), p);
                }
            }
            ++n2;
        }
        Group endPointGroup = uiUtils.createGroup(parent, Activator.getMessage("LABEL_APPLICATION"), Activator.getMessage("TOOLTIP_SSATT_ENDPOINT_GROUP"), this.INFOPOP_SSATT_ENDPOINT_GROUP, 2, -1, -1);
        GridData griddata = new GridData(1808);
        endPointGroup.setLayoutData((Object)griddata);
        this.table = new EndPointConfigurationTable((Composite)endPointGroup, this.statusListener_, new String[]{Activator.getMessage("LABEL_COL_ENDPOINT"), Activator.getMessage("LABEL_COL_POLICYSET_ATTACHED"), Activator.getMessage("LABEL_COL_BINDING_ATTACHED")});
        this.table.setBindings(this.bindings);
        return this;
    }

    private void refreshTable() {
        if (this.policySets == null || this.bindings == null || this.application.getItemCount() == 0) {
            return;
        }
        if (!ProjectDescriptionRegistry.getInstance().isUnmanagedProject(this.project)) {
            this.project = CommonPolicyUtils.getContaingEarProject((IProject)this.project);
        }
        this.policySets = PolicyUtils.getSupportedPolicySets(this.project, this.allPolicySets);
        this.table.setApplication(this.project);
        this.table.setPolicySets(this.policySets);
        ReadServicePolicyAttachmentsCommand readAttachmentsCommand = new ReadServicePolicyAttachmentsCommand();
        readAttachmentsCommand.setPolicySets(this.policySets);
        readAttachmentsCommand.setBindings(this.bindings);
        readAttachmentsCommand.setProject(this.project);
        readAttachmentsCommand.execute((IProgressMonitor)new NullProgressMonitor(), null);
        this.table.setReferences(readAttachmentsCommand.getReferences());
        ServiceData[] services = CollectorUtils.getServiceDataFromProject(this.project);
        ServiceData[] allServices = new ServiceData[services.length + 1];
        allServices[0] = null;
        int i = 0;
        while (i < services.length) {
            allServices[i + 1] = services[i];
            ++i;
        }
        this.table.setServiceData(allServices);
        this.table.setSelectedServiceData(this.serviceData);
        this.statusListener_.handleEvent(null);
    }

    public IStatus getStatus() {
        if (this.application.getItemCount() == 0) {
            return new Status(4, "com.ibm.ast.ws.was7.policyset.ui", 0, Activator.getMessage("ERROR_NO_WEBSEVICE_EARS"), null);
        }
        if (this.project == null) {
            return new Status(4, "com.ibm.ast.ws.was7.policyset.ui", 0, Activator.getMessage("ERROR_WEB_SERVICE_WITH_NO_CONTAINER"), null);
        }
        return Status.OK_STATUS;
    }

    public List<EndPointObject> getReferences() {
        return this.table.getReferences();
    }

    public IProject getProject() {
        return this.project;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setServiceData(ServiceData serviceData) {
        if (serviceData == null) {
            this.application.removeAll();
            for (IProject p : this.projectsMap.values()) {
                this.application.add(p.getName());
            }
            if (this.application.getItemCount() <= 0) return;
            this.application.select(0);
            this.project = this.projectsMap.get(this.application.getText());
            this.refreshTable();
            return;
        } else {
            this.serviceData = serviceData;
            this.project = serviceData.getProject();
            if (!ProjectDescriptionRegistry.getInstance().isUnmanagedProject(this.project)) {
                this.project = CommonPolicyUtils.getContaingEarProject((IProject)serviceData.getProject());
            }
            this.application.setItems(new String[]{this.project.getName()});
            this.application.select(0);
            this.refreshTable();
        }
    }

    public boolean getHasPolicysets() {
        return this.application.getItemCount() > 0 && !this.getReferences().isEmpty();
    }

    public void setPolicySets(Map<String, IServicePolicy> policySets) {
        this.policySets = policySets;
        this.allPolicySets = this.policySets;
    }

    public void setBindings(Map<String, BindingObject> bindings) {
        this.bindings = bindings;
        if (this.table != null) {
            this.table.setBindings(bindings);
        }
        this.refreshTable();
    }

    public Map<String, IServicePolicy> getPolicySets() {
        return this.policySets;
    }

    public Map<String, BindingObject> getBindings() {
        return this.bindings;
    }
}

