/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.was7.policyset.ui.widgets;

import com.ibm.ast.ws.jaxws.emitter.collector.ClientData;
import com.ibm.ast.ws.policyset.ui.common.CommonPolicyUtils;
import com.ibm.ast.ws.was7.policyset.ui.common.BindingObject;
import com.ibm.ast.ws.was7.policyset.ui.common.CollectorUtils;
import com.ibm.ast.ws.was7.policyset.ui.common.PolicyUtils;
import com.ibm.ast.ws.was7.policyset.ui.common.WSPolicyClientControlReferenceObject;
import com.ibm.ast.ws.was7.policyset.ui.common.WSPolicyControlReferenceObject;
import com.ibm.ast.ws.was7.policyset.ui.plugin.Activator;
import com.ibm.ast.ws.was7.policyset.ui.tables.ClientPolicySharingConfigurationTable;
import com.ibm.ast.ws.was7.policyset.ui.tables.PolicySharingConfigurationTable;
import com.ibm.ccl.ws.finder.core.FinderCore;
import com.ibm.ccl.ws.finder.core.WSInfo;
import com.ibm.ws.wspolicy.PolicyConstants;
import com.ibm.ws.wspolicy.admin.client.WSPolicyClientControlHelper;
import com.ibm.ws.wspolicy.admin.client.WSPolicyClientControlHelperFactory;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.bind.JAXBException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.jst.ws.internal.ui.common.UIUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleWidgetDataContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientSidePolicySharingWidget
extends SimpleWidgetDataContributor {
    private Listener statusListener_;
    private ClientData clientData;
    private Map<String, WSPolicyControlReferenceObject> clientWSPolicyControlReferences = new HashMap<String, WSPolicyControlReferenceObject>();
    private String clientPolicyControlFilename;
    private String INFOPOP_CSPSW_PAGE_ONE = "CSPSW0001";
    private String INFOPOP_CSPSW_PROJECT_COMBO = "CSPSW0002";
    private Combo project;
    private IProject clientProject;
    private Map<String, IProject> projectsMap;
    private Map<String, BindingObject> bindings;
    private String INFOPOP_CSPSW_TABLE = "CSPSW0003";
    PolicySharingConfigurationTable table_;

    public WidgetDataEvents addControls(Composite parent, Listener statusListener) {
        this.statusListener_ = statusListener;
        UIUtils uiUtils = Activator.getUiUtils();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.ast.ws.was7.policyset.ui." + this.INFOPOP_CSPSW_PAGE_ONE);
        this.projectsMap = new HashMap<String, IProject>();
        Composite composite = uiUtils.createComposite(parent, 2);
        this.project = uiUtils.createCombo(composite, Activator.getMessage("LABEL_APPLICATION"), Activator.getMessage("TOOLTIP_CSATT_PROJECT_COMBO"), this.INFOPOP_CSPSW_PROJECT_COMBO, 2060);
        this.project.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ClientSidePolicySharingWidget.this.clientProject == null || !ClientSidePolicySharingWidget.this.clientProject.getName().equals(ClientSidePolicySharingWidget.this.project.getText())) {
                    ClientSidePolicySharingWidget.this.clientProject = (IProject)ClientSidePolicySharingWidget.this.projectsMap.get(ClientSidePolicySharingWidget.this.project.getText());
                    ClientSidePolicySharingWidget.this.refreshPageSettings();
                }
                ClientSidePolicySharingWidget.this.statusListener_.handleEvent(null);
            }
        });
        List infos = FinderCore.getWebServiceRegistry().getWebServices("jaxws.client");
        ArrayList<IProject> processed = new ArrayList<IProject>();
        for (WSInfo info : infos) {
            IProject project = info.getProject();
            if (processed.contains(project)) continue;
            IVirtualComponent[] referencingEARs = J2EEUtils.getReferencingEARComponents((IProject)project);
            if (PolicyUtils.isSupportedClientProject(project, referencingEARs)) {
                if (J2EEUtils.isJavaComponent((IProject)project)) {
                    this.projectsMap.put(project.getName(), project);
                } else {
                    IVirtualComponent[] iVirtualComponentArray = referencingEARs;
                    int n = referencingEARs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IVirtualComponent component = iVirtualComponentArray[n2];
                        IProject ear = component.getProject();
                        if (!this.projectsMap.containsKey(ear.getName())) {
                            this.projectsMap.put(ear.getName(), ear);
                        }
                        ++n2;
                    }
                }
            }
            processed.add(project);
        }
        this.table_ = new ClientPolicySharingConfigurationTable(parent, statusListener, new String[]{Activator.getMessage("LABEL_SERVICE_NAME_NO_COLON"), Activator.getMessage("LABEL_POLICY_ACQUISITION")});
        this.table_.setClient(true);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.table_, "com.ibm.ast.ws.was7.policyset.ui." + this.INFOPOP_CSPSW_TABLE);
        return this;
    }

    private String formatDisplayName(ClientData data) {
        if (data == null) {
            return null;
        }
        return "{" + data.getTargetNamespace() + "}" + data.getName();
    }

    private String formatDisplayName(String resource) {
        String displayName = resource.replaceFirst("WebService:/", "");
        if (displayName.endsWith("/")) {
            displayName = displayName.substring(0, displayName.length() - 1);
        }
        return displayName.equals("") ? Activator.getMessage("LABEL_ALL_SERVICES") : displayName;
    }

    private void refreshPageSettings() {
        if (this.clientProject == null || this.bindings == null) {
            return;
        }
        this.clientWSPolicyControlReferences.clear();
        ClientData[] clientDataArray = CollectorUtils.getClientDataFromProject(this.clientProject);
        int n = clientDataArray.length;
        int n2 = 0;
        while (n2 < n) {
            ClientData client = clientDataArray[n2];
            String displayName = this.formatDisplayName(client);
            WSPolicyClientControlReferenceObject refObject = null;
            if (this.clientWSPolicyControlReferences.get(displayName) != null) {
                refObject = (WSPolicyClientControlReferenceObject)this.clientWSPolicyControlReferences.get(displayName);
                refObject.reset();
            } else {
                refObject = new WSPolicyClientControlReferenceObject();
            }
            refObject.setResource("WebService:/" + displayName);
            this.clientWSPolicyControlReferences.put(displayName, refObject);
            ++n2;
        }
        WSPolicyClientControlReferenceObject earLevelReferenceObject = new WSPolicyClientControlReferenceObject();
        earLevelReferenceObject.setResource("WebService:/");
        this.clientWSPolicyControlReferences.put(Activator.getMessage("LABEL_ALL_SERVICES"), earLevelReferenceObject);
        try {
            String outputFolder = CommonPolicyUtils.getOutputFolder((IProject)this.clientProject, (boolean)true).getLocation() + File.separator;
            this.clientPolicyControlFilename = String.valueOf(outputFolder) + "wsPolicyClientControl.xml";
            String clientPolicyAttachmentFilename = String.valueOf(outputFolder) + "clientPolicyAttachments.xml";
            WSPolicyClientControlHelper helper = WSPolicyClientControlHelperFactory.createHelper((String)this.clientPolicyControlFilename, (String)clientPolicyAttachmentFilename);
            if (helper == null || helper.getWSPolicyClientControlReferences() == null) {
                throw new IOException();
            }
            for (Properties p : helper.getWSPolicyClientControlReferencesProperties()) {
                String resource;
                String displayName;
                WSPolicyControlReferenceObject refObject;
                if (!p.containsKey(PolicyConstants.RESOURCE) || (refObject = this.clientWSPolicyControlReferences.get(displayName = this.formatDisplayName(resource = p.getProperty(PolicyConstants.RESOURCE)))) == null) continue;
                refObject.setResource(resource);
                if (p.containsKey(PolicyConstants.ACQUIRE_PROVIDER_POLICY_METHODS)) {
                    String acquisitionMethods = p.getProperty(PolicyConstants.ACQUIRE_PROVIDER_POLICY_METHODS);
                    if (acquisitionMethods.indexOf(PolicyConstants.HTTP_GET) != -1) {
                        refObject.setExportPolicyInWSDL(true);
                        refObject.setServiceEndpointURI(p.getProperty(PolicyConstants.HTTP_GET_TARGET_URI));
                        if (refObject.getServiceEndpointURI() != null && refObject.getServiceEndpointURI().startsWith(refObject.getResource())) {
                            refObject.setServiceEndpointURI(null);
                        }
                    } else {
                        refObject.setExportPolicyInWSDL(false);
                    }
                    if (acquisitionMethods.indexOf(PolicyConstants.WSMEX) != -1) {
                        refObject.setWsMexSupported(true);
                        refObject.setWsMexPolicySetName(p.getProperty(PolicyConstants.WS_MEX_POLICY_SET_NAME));
                        refObject.setWsMexPolicySetBinding(p.getProperty(PolicyConstants.WS_MEX_POLICY_SET_BINDING));
                    } else {
                        refObject.setWsMexSupported(false);
                    }
                }
                this.clientWSPolicyControlReferences.put(displayName, refObject);
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        catch (IOException iOException) {}
        this.table_.setReferences(this.clientWSPolicyControlReferences);
        this.table_.refreshTable();
        this.table_.selectClient(this.formatDisplayName(this.clientData));
    }

    public IStatus getStatus() {
        if (this.project.getItemCount() == 0) {
            return StatusUtils.errorStatus((String)Activator.getMessage("ERROR_NO_CLIENT_PROJECTS"));
        }
        if (J2EEUtils.isWebComponent((IProject)this.clientProject) && J2EEUtils.getReferencingEARComponents((IProject)this.clientProject).length == 0) {
            return StatusUtils.errorStatus((String)Activator.getMessage("ERROR_WEB_CLIENT_WITH_NO_CONTAINER"));
        }
        return Status.OK_STATUS;
    }

    public void setXmlFile(IFile xmlFile) {
    }

    public IProject getProject() {
        return this.clientProject;
    }

    public void setClientData(ClientData data) {
        if (data == null) {
            this.project.removeAll();
            for (String projectName : this.projectsMap.keySet()) {
                this.project.add(projectName);
            }
            if (this.clientProject == null) {
                this.project.select(0);
            } else {
                this.project.select(this.project.indexOf(this.clientProject.getName()));
            }
            this.clientProject = this.projectsMap.get(this.project.getText());
        } else {
            this.clientProject = CommonPolicyUtils.getContaingEarProject((IProject)data.getProject());
            if (this.project.getItemCount() == 0) {
                this.project.add(this.clientProject.getName());
            }
            this.project.select(this.project.indexOf(this.clientProject.getName()));
        }
        this.clientData = data;
        this.refreshPageSettings();
    }

    public ClientData getClientData() {
        return this.clientData;
    }

    public Map<String, WSPolicyControlReferenceObject> getClientWSPolicyControlReferences() {
        return this.clientWSPolicyControlReferences;
    }

    public boolean getShowAttachment() {
        return true;
    }

    public void setBindings(Map<String, BindingObject> bindings) {
        this.bindings = bindings;
        this.table_.setBindings(bindings);
        this.refreshPageSettings();
    }
}

