/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.was7.policyset.ui.widgets;

import com.ibm.ast.ws.jaxws.emitter.collector.ClientData;
import com.ibm.ast.ws.was7.policyset.ui.common.BindingObject;
import com.ibm.ast.ws.was7.policyset.ui.common.CollectorUtils;
import com.ibm.ast.ws.was7.policyset.ui.common.DefaultBindingObject;
import com.ibm.ast.ws.was7.policyset.ui.common.EndPointObject;
import com.ibm.ast.ws.was7.policyset.ui.common.PolicyUtils;
import com.ibm.ast.ws.was7.policyset.ui.common.WSPolicyControlReferenceObject;
import com.ibm.ast.ws.was7.policyset.ui.plugin.Activator;
import com.ibm.ast.ws.was7.policyset.ui.tables.BindingConfigurationTable;
import com.ibm.ast.ws.was7.policyset.ui.tables.EndPointConfigurationTable;
import com.ibm.ast.ws.was7.policyset.ui.types.PolicyType;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.internal.ui.common.UIUtils;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleWidgetDataContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;
import org.eclipse.wst.ws.service.policy.IServicePolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientSidePolicyAttachmentWidget
extends SimpleWidgetDataContributor {
    private String INFOPOP_CSATT_PAGE = "CSATT0004";
    private Listener statusListener_;
    private String INFOPOP_CSATT_ENDPOINT_GROUPE = "CSATT0002";
    private EndPointConfigurationTable table;
    private String INFOPOP_CSATT_BINDING_GROUPE = "CSATT0003";
    private BindingConfigurationTable tableBindingConfig;
    private Map<String, IServicePolicy> policySets;
    private Map<String, BindingObject> bindings;
    private IProject clientProject;

    public WidgetDataEvents addControls(Composite parent, Listener statusListener) {
        this.statusListener_ = statusListener;
        UIUtils uiUtils = Activator.getUiUtils();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.INFOPOP_CSATT_PAGE);
        Group endPointGroup = uiUtils.createGroup(parent, Activator.getMessage("LABEL_APPLICATION"), Activator.getMessage("TOOLTIP_CSATT_ENDPOINT_GROUPE"), this.INFOPOP_CSATT_ENDPOINT_GROUPE, 2, -1, -1);
        GridData griddata = new GridData(1808);
        endPointGroup.setLayoutData((Object)griddata);
        this.table = new EndPointConfigurationTable((Composite)endPointGroup, this.statusListener_, new String[]{Activator.getMessage("LABEL_COL_ENDPOINT"), Activator.getMessage("LABEL_COL_POLICY_APPLIED"), Activator.getMessage("LABEL_COL_POLICYSET_ATTACHED"), Activator.getMessage("LABEL_COL_BINDING_ATTACHED")});
        Group bindingConfigGroup = uiUtils.createGroup(parent, Activator.getMessage("LABEL_BINDING_CONFIGURATION"), Activator.getMessage("TOOLTIP_CSATT_BINDING_GROUPE"), this.INFOPOP_CSATT_BINDING_GROUPE, 2, -1, -1);
        bindingConfigGroup.setLayoutData((Object)griddata);
        this.tableBindingConfig = new BindingConfigurationTable((Composite)bindingConfigGroup, this.statusListener_, new String[]{Activator.getMessage("LABEL_COL_POLICY_TYPE"), Activator.getMessage("LABEL_COL_BINDING")});
        this.table.setPolicySets(this.policySets);
        this.table.setBindings(this.bindings);
        return this;
    }

    public IStatus getStatus() {
        this.tableBindingConfig.setReferences(this.table.getSelectedEndPointObject());
        IStatus status = this.checkDuplicateBindingSelection(this.table.getReferences());
        if (status.getSeverity() == 4) {
            return status;
        }
        return this.checkCompleteBindingConfig(this.table.getReferences());
    }

    private IStatus checkCompleteBindingConfig(List<EndPointObject> ref) {
        for (EndPointObject object : ref) {
            if (object.getAttachedBinding() == null || object.getBindingConfigObjects() == null || object.getAttachedBinding() instanceof DefaultBindingObject) continue;
            for (PolicyType type : object.getBindingConfigObjects().values()) {
                if (type.isMigrated()) {
                    return StatusUtils.warningStatus((String)Activator.getMessage("WARN_BINDING_CONFIG_MIGRATION"));
                }
                if (type.validateConfiguration().equals(Activator.getMessage("NOT_LOADED"))) {
                    return StatusUtils.warningStatus((String)Activator.getMessage("ERROR_CANNOT_LOAD_BINDING_CONFIG", new String[]{type.getName()}));
                }
                if (!type.validateConfiguration().equals(Activator.getMessage("NOT_CONFIGURED"))) continue;
                return StatusUtils.warningStatus((String)Activator.getMessage("ERROR_NO_COMPLETE_BINDING_CONFIG", new String[]{type.getName()}));
            }
        }
        return Status.OK_STATUS;
    }

    private IStatus checkDuplicateBindingSelection(List<EndPointObject> ref) {
        int i = 0;
        while (i < ref.size()) {
            EndPointObject object1 = ref.get(i);
            if (object1.getAttachedPolicySet() != null && object1.getAttachedBinding() != null) {
                int j = i;
                while (j < ref.size()) {
                    EndPointObject object2 = ref.get(j);
                    if (object2.getAttachedPolicySet() != null && object2.getAttachedBinding() != null && object1.getAttachedBinding().equals(object2.getAttachedBinding()) && object1.getAttachedBinding().getNamedBinding() == null && !object1.getAttachedPolicySet().getDescriptor().getShortName().equals(object2.getAttachedPolicySet().getDescriptor().getShortName())) {
                        return StatusUtils.errorStatus((String)Activator.getMessage("ERROR_CONFLICTING_BINDINGS"));
                    }
                    ++j;
                }
            }
            ++i;
        }
        return Status.OK_STATUS;
    }

    public List<EndPointObject> getReferences() {
        return this.table.getReferences();
    }

    public void setReferences(List<EndPointObject> references) {
        this.table.setReferences(references);
    }

    public void setClientWSPolicyControlReferences(Map<String, WSPolicyControlReferenceObject> clientWSPolicyControlReferences) {
        this.table.setWSPolicyControlReferences(clientWSPolicyControlReferences);
    }

    public void setPolicySets(Map<String, IServicePolicy> policySets) {
        this.policySets = policySets;
        if (this.clientProject != null) {
            policySets = PolicyUtils.getSupportedPolicySets(this.clientProject, policySets);
        }
        this.table.setPolicySets(policySets);
    }

    public Map<String, BindingObject> getBindings() {
        return this.bindings;
    }

    public void setBindings(Map<String, BindingObject> bindings) {
        this.bindings = bindings;
        this.table.setBindings(bindings);
    }

    public void setProject(IProject clientProject) {
        this.clientProject = clientProject;
        ClientData[] clients = CollectorUtils.getClientDataFromProject(clientProject);
        ClientData[] allClients = new ClientData[clients.length + 1];
        allClients[0] = null;
        int i = 0;
        while (i < clients.length) {
            allClients[i + 1] = clients[i];
            ++i;
        }
        this.table.setClientData(allClients);
        this.table.setApplication(clientProject);
        if (this.policySets != null) {
            this.policySets = PolicyUtils.getSupportedPolicySets(clientProject, this.policySets);
            this.table.setPolicySets(this.policySets);
        }
    }

    public void setClientData(ClientData selectedClientData) {
        this.table.setSelectedClientData(selectedClientData);
    }
}

