/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.was7.policyset.ui.types;

import com.ibm.ast.ws.policyset.ui.common.BasicAuthentication;
import com.ibm.ast.ws.policyset.ui.common.DefaultSymmetricDerivedKeyObject;
import com.ibm.ast.ws.policyset.ui.common.DerivedKeyInfoObject;
import com.ibm.ast.ws.policyset.ui.common.EncryptionOutBoundSecurityBindingObject;
import com.ibm.ast.ws.policyset.ui.common.KeyStoreWithKey;
import com.ibm.ast.ws.policyset.ui.common.PropertyObject;
import com.ibm.ast.ws.policyset.ui.common.SecurityBindingObject;
import com.ibm.ast.ws.policyset.ui.common.SignatureSecurityBindingObject;
import com.ibm.ast.ws.policyset.ui.plugin.Activator;
import com.ibm.ast.ws.policyset.ui.tokens.AuthenticationToken;
import com.ibm.ast.ws.policyset.ui.tokens.CustomeAuthenticationToken;
import com.ibm.ast.ws.policyset.ui.tokens.KerberosProtectionToken;
import com.ibm.ast.ws.policyset.ui.tokens.LTPAPropAuthenticationToken;
import com.ibm.ast.ws.policyset.ui.tokens.ProtectionToken;
import com.ibm.ast.ws.policyset.ui.tokens.UserNameAuthenticationToken;
import com.ibm.ast.ws.policyset.ui.tokens.X509ProtectionToken;
import com.ibm.ast.ws.service.policy.ui.PolicySetUtils;
import com.ibm.ast.ws.was7.policyset.ui.common.EditorUtils;
import com.ibm.ast.ws.was7.policyset.ui.common.PolicyUtils;
import com.ibm.ast.ws.was7.policyset.ui.dialogs.WSSecurityBindingConfigurationDialog;
import com.ibm.ast.ws.was7.policyset.ui.migration.MigrateBindingConfigurationsUtils;
import com.ibm.ast.ws.was7.policyset.ui.tokens.LTPAAuthenticationToken;
import com.ibm.ast.ws.was7.policyset.ui.tokens.SAMLAsymmetricHOKProtectionToken;
import com.ibm.ast.ws.was7.policyset.ui.tokens.SAMLBearerProtectionToken;
import com.ibm.ast.ws.was7.policyset.ui.tokens.SAMLSymmetricHOKProtectionToken;
import com.ibm.ast.ws.was7.policyset.ui.tokens.SecureConversationToken;
import com.ibm.ast.ws.was7.policyset.ui.types.PolicyConfigUtil;
import com.ibm.ast.ws.was7.policyset.ui.types.PolicyType;
import com.ibm.ast.ws.was7.policyset.ui.types.WSFactoryUtils;
import com.ibm.ast.ws.was7.policyset.ui.validator.BindingXMLBadAttribute;
import com.ibm.ast.ws.was7.policyset.ui.validator.BindingXMLBadElement;
import com.ibm.ws.wssecurity.platform.websphere.util.WasPasswordUtil;
import com.ibm.xmlns.prod.websphere._200605.ws_securitypolicy_ext.WssCustomToken;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.BasicAuth;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.CallbackHandler;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.CertPathSettings;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.CertStoreList;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.CertStoreRef;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.CollectionCertStores;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.DataEncryptionKeyInfo;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.DerivedKeyInfo;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.EncryptionInfo;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.EncryptionPartReference;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.Key;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.KeyEncryptionKeyInfo;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.KeyInfo;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.KeyStore;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.ObjectFactory;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.OnlySignEntireHeadersAndBody;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.Properties;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.SecurityBinding;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.SecurityBindings;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.SecurityInboundBindingConfig;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.SecurityOutboundBindingConfig;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.SecurityTokenReference;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.SigningInfo;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.SigningKeyInfo;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.SigningPartReference;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.TimestampExpires;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.TokenConsumer;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.TokenGenerator;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.TokenReference;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.Transform;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.TrustAnchor;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.TrustAnchorRef;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.TrustAnyCertificate;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.X509Certificates;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.validation.internal.core.Message;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.ws.service.policy.IServicePolicy;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.NestedPolicyType;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.SecureConversationTokenType;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.TokenAssertionType;
import org.xmlsoap.schemas.ws._2004._09.policy.Policy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSSecurityPolicy
extends PolicyType {
    public static String WSSecuritySchemaId = "com.ibm.ast.ws.was61.policyset.ui.schema.WSSecurity";
    public static String PolicyTypeName = "WSSecurity";
    public static String PolicyContextPath = "org.oasis_open.docs.ws_sx.ws_securitypolicy._200512:org.xmlsoap.schemas.ws._2004._09.policy:com.ibm.xmlns.prod.websphere._200605.ws_securitypolicy_ext";
    public static String BindingContextPath = "com.ibm.xmlns.prod.websphere._200710.ws_securitybinding";
    public static String ApplicationBindingName = "application";
    public static String BootstrapBindingName = "bootstrap";
    private SignatureSecurityBindingObject generatorSymmetric = null;
    private SignatureSecurityBindingObject consumerSymmetric = null;
    private SignatureSecurityBindingObject SignOutbound;
    private SignatureSecurityBindingObject SignInbound;
    private boolean isInboundSignatureFound = false;
    private boolean isOutboundSignatureFound = false;
    private boolean isInboundEncryptionFound = false;
    private boolean isOutboundEncryptionFound = false;
    private String messageExpiryTime;
    private boolean onlySignEntireHeadersAndBodyBoot;
    private boolean onlySignEntireHeadersAndBodyApp;
    private EncryptionOutBoundSecurityBindingObject EncOutbound;
    private SecurityBindingObject EncInbound;
    private AuthenticationToken authenticationToken = null;
    private ProtectionToken initiatorSignatureToken = null;
    private ProtectionToken recipientSignatureToken = null;
    private ProtectionToken initiatorEncryptionToken = null;
    private ProtectionToken recipientEncryptionToken = null;
    private ProtectionToken initiatorSymmetricToken = null;
    private ProtectionToken recipientSymmatricToken = null;
    private WasPasswordUtil passUtil = new WasPasswordUtil();
    protected static JAXBContext jc;
    protected static JAXBContext bindingJAXB;
    protected static Unmarshaller u;
    protected static Unmarshaller bindingUnmarshaller;
    protected static Marshaller m;
    protected ObjectFactory bindingFactory;
    protected String CONTEXT_PATH = "org.oasis_open.docs.ws_sx.ws_securitypolicy._200512:org.xmlsoap.schemas.ws._2004._09.policy:com.ibm.xmlns.prod.websphere._200605.ws_securitypolicy_ext";
    protected IFile file;
    protected String schemaID;
    protected boolean isMigrated = false;
    private String unrecognizedTokenFound;
    private IPath bindingLocation;

    @Override
    public boolean isMigrated() {
        return this.isMigrated;
    }

    @Override
    protected Marshaller getMarshaller() throws JAXBException {
        if (jc == null) {
            jc = JAXBContext.newInstance((String)this.CONTEXT_PATH);
        }
        if (m == null) {
            m = jc.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)true);
        }
        return m;
    }

    @Override
    protected Unmarshaller getUnmarshaller() throws JAXBException {
        if (jc == null) {
            jc = JAXBContext.newInstance((String)this.CONTEXT_PATH);
        }
        if (u == null) {
            u = jc.createUnmarshaller();
        }
        return u;
    }

    protected Unmarshaller getBindingUnmarshaller() throws JAXBException {
        if (bindingJAXB == null) {
            bindingJAXB = JAXBContext.newInstance((String)BindingContextPath);
        }
        if (bindingUnmarshaller == null) {
            bindingUnmarshaller = bindingJAXB.createUnmarshaller();
        }
        return bindingUnmarshaller;
    }

    @Override
    public ArrayList<BindingXMLBadElement> validateBindingXML(IFile file, String schemaID) {
        this.file = file;
        this.schemaID = schemaID;
        ArrayList<BindingXMLBadElement> badElements = new ArrayList<BindingXMLBadElement>();
        try {
            Object binding = this.getBindingUnmarshaller().unmarshal((InputStream)new FileInputStream(file.getLocation().toFile()));
            for (SecurityBinding securityBinding : ((SecurityBindings)binding).getSecurityBinding()) {
                CallbackHandler handler;
                BindingXMLBadElement badElement;
                String tokenRef;
                String ref;
                SecurityOutboundBindingConfig outBoundConfig = securityBinding.getSecurityOutboundBindingConfig();
                SecurityInboundBindingConfig inBoundConfig = securityBinding.getSecurityInboundBindingConfig();
                if (outBoundConfig != null) {
                    CallbackHandler handler2;
                    BindingXMLBadElement badElement2;
                    String tokenRef2;
                    String ref2;
                    TimestampExpires expTime = outBoundConfig.getTimestampExpires();
                    if (expTime != null) {
                        try {
                            Integer time = new Integer(expTime.getExpires());
                            if (time == 0) {
                                BindingXMLBadElement badElement3 = new BindingXMLBadElement("timestampExpires");
                                BindingXMLBadAttribute badAttr = new BindingXMLBadAttribute("expires", expTime.getExpires());
                                badAttr.setMessage((IMessage)new Message("com.ibm.ast.ws.was7.policyset.ui.plugin", 1, "ERROR_INVALID_MESSAGE_EXP", new String[]{schemaID}, (Object)file));
                                badElement3.setAttribute(badAttr);
                                badElements.add(badElement3);
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            BindingXMLBadElement badElement4 = new BindingXMLBadElement("timestampExpires");
                            BindingXMLBadAttribute badAttr = new BindingXMLBadAttribute("expires", expTime.getExpires());
                            badAttr.setMessage((IMessage)new Message("com.ibm.ast.ws.was7.policyset.ui.plugin", 1, "ERROR_INVALID_MESSAGE_EXP", new String[]{schemaID}, (Object)file));
                            badElement4.setAttribute(badAttr);
                            badElements.add(badElement4);
                        }
                    }
                    for (SigningInfo signingInfo : outBoundConfig.getSigningInfo()) {
                        for (SigningKeyInfo signingKeyInfo : signingInfo.getSigningKeyInfo()) {
                            ref2 = signingKeyInfo.getReference();
                            for (KeyInfo keyInfo : outBoundConfig.getKeyInfo()) {
                                if (!keyInfo.getName().equals(ref2)) continue;
                                tokenRef2 = keyInfo.getTokenReference().getReference();
                                for (TokenGenerator tokenGenerator : outBoundConfig.getTokenGenerator()) {
                                    if (!tokenGenerator.getName().equals(tokenRef2)) continue;
                                    badElement2 = new BindingXMLBadElement("tokenGenerator");
                                    handler2 = tokenGenerator.getCallbackHandler();
                                    this.checkHandlerKeyStore(badElement2, "name", tokenGenerator.getName(), handler2, "CALLBACK_HANDLER_SETTINGS_INCOMPLETE", com.ibm.ast.ws.was7.policyset.ui.plugin.Activator.getMessage("DIGITAL_SIGNATURE"));
                                    if (badElement2.getAttributes().size() <= 0) continue;
                                    badElements.add(badElement2);
                                }
                            }
                        }
                    }
                    for (EncryptionInfo encInfo : outBoundConfig.getEncryptionInfo()) {
                        for (KeyEncryptionKeyInfo encKeyInfo : encInfo.getKeyEncryptionKeyInfo()) {
                            ref2 = encKeyInfo.getReference();
                            for (KeyInfo keyInfo : outBoundConfig.getKeyInfo()) {
                                if (!keyInfo.getName().equals(ref2)) continue;
                                tokenRef2 = keyInfo.getTokenReference().getReference();
                                for (TokenGenerator tokenGenerator : outBoundConfig.getTokenGenerator()) {
                                    if (!tokenGenerator.getName().equals(tokenRef2)) continue;
                                    badElement2 = new BindingXMLBadElement("tokenGenerator");
                                    handler2 = tokenGenerator.getCallbackHandler();
                                    this.checkHandlerKeyStore(badElement2, "name", tokenGenerator.getName(), handler2, "CALLBACK_HANDLER_SETTINGS_INCOMPLETE", com.ibm.ast.ws.was7.policyset.ui.plugin.Activator.getMessage("XML_ENCRYPTION"));
                                    if (badElement2.getAttributes().size() <= 0) continue;
                                    badElements.add(badElement2);
                                }
                            }
                        }
                    }
                }
                if (inBoundConfig == null) continue;
                for (SigningInfo signingInfo : inBoundConfig.getSigningInfo()) {
                    for (SigningKeyInfo signingKeyInfo : signingInfo.getSigningKeyInfo()) {
                        ref = signingKeyInfo.getReference();
                        for (KeyInfo keyInfo : inBoundConfig.getKeyInfo()) {
                            if (!keyInfo.getName().equals(ref)) continue;
                            tokenRef = keyInfo.getTokenReference().getReference();
                            for (TokenConsumer tokenConsumer : inBoundConfig.getTokenConsumer()) {
                                TrustAnchorRef trustAnchorRef;
                                if (!tokenConsumer.getName().equals(tokenRef)) continue;
                                badElement = new BindingXMLBadElement("tokenConsumer");
                                handler = tokenConsumer.getCallbackHandler();
                                if (handler.getCertPathSettings() == null || (trustAnchorRef = handler.getCertPathSettings().getTrustAnchorRef()) == null) continue;
                                String trustRef = trustAnchorRef.getReference();
                                for (TrustAnchor trustAnchor : inBoundConfig.getTrustAnchor()) {
                                    if (!trustAnchor.getName().equals(trustRef)) continue;
                                    this.checkTrustAnchorKeyStore(badElement, "name", tokenConsumer.getName(), trustAnchor, "CALLBACK_HANDLER_SETTINGS_INCOMPLETE", com.ibm.ast.ws.was7.policyset.ui.plugin.Activator.getMessage("DIGITAL_SIGNATURE"));
                                    if (badElement.getAttributes().size() <= 0) continue;
                                    badElements.add(badElement);
                                }
                            }
                        }
                    }
                }
                for (EncryptionInfo encInfo : inBoundConfig.getEncryptionInfo()) {
                    for (KeyEncryptionKeyInfo encKeyInfo : encInfo.getKeyEncryptionKeyInfo()) {
                        ref = encKeyInfo.getReference();
                        for (KeyInfo keyInfo : inBoundConfig.getKeyInfo()) {
                            if (!keyInfo.getName().equals(ref)) continue;
                            tokenRef = keyInfo.getTokenReference().getReference();
                            for (TokenConsumer tokenConsumer : inBoundConfig.getTokenConsumer()) {
                                if (!tokenConsumer.getName().equals(tokenRef)) continue;
                                badElement = new BindingXMLBadElement("tokenConsumer");
                                handler = tokenConsumer.getCallbackHandler();
                                this.checkHandlerKeyStore(badElement, "name", tokenConsumer.getName(), handler, "CALLBACK_HANDLER_SETTINGS_INCOMPLETE", com.ibm.ast.ws.was7.policyset.ui.plugin.Activator.getMessage("XML_ENCRYPTION"));
                                if (badElement.getAttributes().size() <= 0) continue;
                                badElements.add(badElement);
                            }
                        }
                    }
                }
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (UnmarshalException unmarshalException) {
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        return badElements;
    }

    private void checkTrustAnchorKeyStore(BindingXMLBadElement badElement, String name, String value, TrustAnchor trust, String message, String prefix) {
        KeyStore keyStore;
        if (trust.getKeyStore() != null && ((keyStore = trust.getKeyStore()).getType().length() == 0 || this.passUtil.passwordDecode(keyStore.getStorepass()).length() == 0 || keyStore.getPath().length() == 0)) {
            BindingXMLBadAttribute badAttr = new BindingXMLBadAttribute(name, value);
            badAttr.setMessage((IMessage)new Message("com.ibm.ast.ws.was7.policyset.ui.plugin", 1, message, new String[]{prefix}, (Object)this.file));
            badElement.setAttribute(badAttr);
        }
    }

    private void checkHandlerKeyStore(BindingXMLBadElement badElement, String name, String value, CallbackHandler handler, String message, String prefix) {
        if (handler.getKeyStore() != null) {
            Key key;
            KeyStore keyStore = handler.getKeyStore();
            if (keyStore.getType().length() == 0 || this.passUtil.passwordDecode(keyStore.getStorepass()).length() == 0 || keyStore.getPath().length() == 0) {
                BindingXMLBadAttribute badAttr = new BindingXMLBadAttribute(name, value);
                badAttr.setMessage((IMessage)new Message("com.ibm.ast.ws.was7.policyset.ui.plugin", 1, message, new String[]{prefix}, (Object)this.file));
                badElement.setAttribute(badAttr);
            } else if (handler.getKey() != null && ((key = handler.getKey()).getName() == null || key.getName().length() == 0 || key.getAlias().length() == 0)) {
                BindingXMLBadAttribute badAttr = new BindingXMLBadAttribute(name, value);
                badAttr.setMessage((IMessage)new Message("com.ibm.ast.ws.was7.policyset.ui.plugin", 1, message, new String[]{prefix}, (Object)this.file));
                badElement.setAttribute(badAttr);
            }
        }
    }

    @Override
    public IStatus saveBindingConfiguration(File location) {
        String pathname = PolicySetUtils.getPolicyPath((IServicePolicy)this.getServicePolicy());
        Policy policy = null;
        try {
            policy = (Policy)this.getUnmarshaller().unmarshal(new File(PolicyUtils.expandURL(pathname)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.unrecognizedTokenFound != null) {
            return Status.OK_STATUS;
        }
        this.bindingFactory = new ObjectFactory();
        SecurityBindings bindings = this.wsSecurityBindings(policy);
        try {
            this.writeWSSecurityBindings(bindings, location);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Status.OK_STATUS;
    }

    @Override
    public void readBindingConfiguration(IPath location) {
        this.bindingLocation = location;
        String pathname = PolicySetUtils.getPolicyPath((IServicePolicy)this.getServicePolicy());
        Policy policy = null;
        try {
            String policyPath = PolicyUtils.expandURL(pathname);
            policy = (Policy)this.getUnmarshaller().unmarshal(new File(policyPath));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.getTokenSpecificationNames(policy);
        this.getSignedParts(policy);
        this.getEncryptionParts(policy);
        if (this.isOutboundSignatureFound && this.initiatorSignatureToken != null) {
            this.SignOutbound = new SignatureSecurityBindingObject();
            this.SignOutbound.setToken(this.initiatorSignatureToken);
            this.SignOutbound.setDerivedKey(new DerivedKeyInfoObject());
        }
        if (this.isInboundSignatureFound && this.recipientSignatureToken != null) {
            this.SignInbound = new SignatureSecurityBindingObject();
            this.SignInbound.setToken(this.recipientSignatureToken);
            this.SignInbound.setDerivedKey(new DerivedKeyInfoObject());
        }
        if (this.isOutboundEncryptionFound && this.recipientEncryptionToken != null) {
            this.EncOutbound = new EncryptionOutBoundSecurityBindingObject();
            this.EncOutbound.setToken(this.recipientEncryptionToken);
            this.EncOutbound.setDerivedKey(new DerivedKeyInfoObject());
        }
        if (this.isInboundEncryptionFound && this.initiatorEncryptionToken != null) {
            this.EncInbound = new SecurityBindingObject();
            this.EncInbound.setToken(this.initiatorEncryptionToken);
            this.EncInbound.setDerivedKey(new DerivedKeyInfoObject());
        }
        if (this.initiatorSymmetricToken != null) {
            this.generatorSymmetric = new SignatureSecurityBindingObject();
            this.generatorSymmetric.setToken(this.initiatorSymmetricToken);
            this.generatorSymmetric.setDerivedKey((DerivedKeyInfoObject)new DefaultSymmetricDerivedKeyObject());
        }
        if (this.recipientSymmatricToken != null) {
            this.consumerSymmetric = new SignatureSecurityBindingObject();
            this.consumerSymmetric.setToken(this.recipientSymmatricToken);
            this.consumerSymmetric.setDerivedKey((DerivedKeyInfoObject)new DefaultSymmetricDerivedKeyObject());
        }
        if (location == null || this.unrecognizedTokenFound != null) {
            return;
        }
        try {
            Object securityBindings = PolicyUtils.readExistingBindingConfiguration(location, this.getName(), BindingContextPath);
            if (securityBindings == null) {
                return;
            }
            List bindings = ((SecurityBindings)securityBindings).getSecurityBinding();
            for (SecurityBinding securityBinding : bindings) {
                SecurityOutboundBindingConfig securityOutboundBindingConfig = securityBinding.getSecurityOutboundBindingConfig();
                boolean isApplicationSection = securityBinding.getName().equals(ApplicationBindingName);
                if (isApplicationSection) {
                    this.onlySignEntireHeadersAndBodyApp = securityBinding.getOnlySignEntireHeadersAndBody() != null;
                } else {
                    this.onlySignEntireHeadersAndBodyBoot = securityBinding.getOnlySignEntireHeadersAndBody() != null;
                }
                boolean isSymmetricApplicationSection = isApplicationSection && this.generatorSymmetric != null;
                List signingInfos = securityOutboundBindingConfig.getSigningInfo();
                List encryptionInfos = securityOutboundBindingConfig.getEncryptionInfo();
                List keyInfos = securityOutboundBindingConfig.getKeyInfo();
                List tokenGenerators = securityOutboundBindingConfig.getTokenGenerator();
                TimestampExpires expiry = securityOutboundBindingConfig.getTimestampExpires();
                if (expiry != null) {
                    this.messageExpiryTime = expiry.getExpires();
                }
                for (TokenGenerator tokenGenerator : tokenGenerators) {
                    CallbackHandler callbackHandler = tokenGenerator.getCallbackHandler();
                    if (callbackHandler == null) continue;
                    boolean tokenGeneratorHandled = false;
                    int k = 0;
                    while (k < keyInfos.size()) {
                        KeyInfo keyInfo = (KeyInfo)keyInfos.get(k);
                        if (tokenGenerator.getName().equalsIgnoreCase(keyInfo.getTokenReference().getReference())) {
                            ProtectionToken token;
                            int l = 0;
                            while (l < signingInfos.size()) {
                                SigningInfo signingInfo = (SigningInfo)signingInfos.get(l);
                                for (SigningKeyInfo SigningKeyInfo2 : signingInfo.getSigningKeyInfo()) {
                                    SignatureSecurityBindingObject secObject;
                                    SignatureSecurityBindingObject signatureSecurityBindingObject = secObject = isSymmetricApplicationSection ? this.generatorSymmetric : this.SignOutbound;
                                    if (!keyInfo.getName().equalsIgnoreCase(SigningKeyInfo2.getReference())) continue;
                                    token = secObject.getToken();
                                    if (token instanceof X509ProtectionToken) {
                                        ((X509ProtectionToken)token).setKeyStore(WSFactoryUtils.readKeyStore(callbackHandler));
                                    }
                                    token.setKeyInfoType(keyInfo.getType());
                                    secObject.setTransformAlgorithm(((Transform)((SigningPartReference)signingInfo.getSigningPartReference().get(0)).getTransform().get(0)).getAlgorithm());
                                    secObject.setOrder(signingInfo.getOrder());
                                    token.setCallBackHandler(callbackHandler.getClassname());
                                    token.setJAASConfig(tokenGenerator.getJAASConfig().getConfigName());
                                    secObject.setDerivedKey(this.readDerivedKeyInfo(keyInfo));
                                    for (Properties property : callbackHandler.getProperties()) {
                                        secObject.getToken().getProperties().add(new PropertyObject(property.getName(), property.getValue()));
                                    }
                                    tokenGeneratorHandled = true;
                                }
                                ++l;
                            }
                            int m = 0;
                            while (m < encryptionInfos.size()) {
                                SignatureSecurityBindingObject secObject = isSymmetricApplicationSection ? this.generatorSymmetric : this.EncOutbound;
                                EncryptionInfo encryptionInfo = (EncryptionInfo)encryptionInfos.get(m);
                                for (Properties property : encryptionInfo.getProperties()) {
                                    secObject.addProperty(new PropertyObject(property.getName(), property.getValue()));
                                }
                                for (KeyEncryptionKeyInfo encryptionKeyInfo : encryptionInfo.getKeyEncryptionKeyInfo()) {
                                    if (keyInfo.getName().equalsIgnoreCase(encryptionKeyInfo.getReference())) {
                                        token = secObject.getToken();
                                        if (token instanceof X509ProtectionToken) {
                                            ((X509ProtectionToken)token).setKeyStore(WSFactoryUtils.readKeyStore(callbackHandler));
                                        }
                                        token.setKeyInfoType(keyInfo.getType());
                                        callbackHandler.getKey().setKeypass(null);
                                        token.setCallBackHandler(callbackHandler.getClassname());
                                        token.setJAASConfig(tokenGenerator.getJAASConfig().getConfigName());
                                        secObject.setDerivedKey(this.readDerivedKeyInfo(keyInfo));
                                        for (Properties property : callbackHandler.getProperties()) {
                                            secObject.getToken().getProperties().add(new PropertyObject(property.getName(), property.getValue()));
                                        }
                                        tokenGeneratorHandled = true;
                                    }
                                    secObject.setOrder(encryptionInfo.getOrder());
                                }
                                ++m;
                            }
                        }
                        ++k;
                    }
                    if (this.authenticationToken == null || tokenGeneratorHandled) continue;
                    this.authenticationToken.setCallBackHandler(callbackHandler.getClassname());
                    this.authenticationToken.setJAASConfig(tokenGenerator.getJAASConfig().getConfigName());
                    if (this.authenticationToken instanceof LTPAAuthenticationToken) {
                        ((LTPAAuthenticationToken)this.authenticationToken).setTokenLocalName(tokenGenerator.getValueType().getLocalName());
                    }
                    if (callbackHandler.getBasicAuth() != null) {
                        BasicAuth basicAuth = callbackHandler.getBasicAuth();
                        BasicAuthentication basicAuthentication = new BasicAuthentication(basicAuth.getUserid(), this.passUtil.passwordDecode(basicAuth.getPassword()));
                        this.authenticationToken.setBasicAuth(basicAuthentication);
                    }
                    for (Properties property : tokenGenerator.getProperties()) {
                        this.authenticationToken.getProperties().add(new PropertyObject(property.getName(), property.getValue()));
                    }
                    for (Properties property : callbackHandler.getProperties()) {
                        this.authenticationToken.getProperties().add(new PropertyObject(property.getName(), property.getValue()));
                    }
                }
                SecurityInboundBindingConfig securityInboundBindingConfig = securityBinding.getSecurityInboundBindingConfig();
                signingInfos = securityInboundBindingConfig.getSigningInfo();
                encryptionInfos = securityInboundBindingConfig.getEncryptionInfo();
                keyInfos = securityInboundBindingConfig.getKeyInfo();
                List tokenConsumers = securityInboundBindingConfig.getTokenConsumer();
                for (TokenConsumer tokenConsumer : tokenConsumers) {
                    CallbackHandler callbackHandler = tokenConsumer.getCallbackHandler();
                    if (callbackHandler == null) continue;
                    int k = 0;
                    while (k < keyInfos.size()) {
                        KeyInfo keyInfo = (KeyInfo)keyInfos.get(k);
                        if (tokenConsumer.getName().equalsIgnoreCase(keyInfo.getTokenReference().getReference())) {
                            ProtectionToken token;
                            SignatureSecurityBindingObject secObject;
                            int l = 0;
                            while (l < signingInfos.size()) {
                                SigningInfo signingInfo = (SigningInfo)signingInfos.get(l);
                                for (SigningKeyInfo SigningKeyInfo3 : signingInfo.getSigningKeyInfo()) {
                                    SignatureSecurityBindingObject signatureSecurityBindingObject = secObject = isSymmetricApplicationSection ? this.consumerSymmetric : this.SignInbound;
                                    if (!keyInfo.getName().equalsIgnoreCase(SigningKeyInfo3.getReference())) continue;
                                    token = secObject.getToken();
                                    if (token instanceof X509ProtectionToken) {
                                        ((X509ProtectionToken)token).setKeyStore(WSFactoryUtils.readKeyStore(callbackHandler));
                                    }
                                    token.setKeyInfoType(keyInfo.getType());
                                    token.setCallBackHandler(callbackHandler.getClassname());
                                    token.setJAASConfig(tokenConsumer.getJAASConfig().getConfigName());
                                    secObject.setDerivedKey(this.readDerivedKeyInfo(keyInfo));
                                    secObject.setTransformAlgorithm(((Transform)((SigningPartReference)signingInfo.getSigningPartReference().get(0)).getTransform().get(0)).getAlgorithm());
                                    for (Properties property : callbackHandler.getProperties()) {
                                        secObject.addProperty(new PropertyObject(property.getName(), property.getValue()));
                                    }
                                }
                                ++l;
                            }
                            for (EncryptionInfo encryptionInfo : encryptionInfos) {
                                for (KeyEncryptionKeyInfo encryptionKeyInfo : encryptionInfo.getKeyEncryptionKeyInfo()) {
                                    Object object = secObject = isSymmetricApplicationSection ? this.consumerSymmetric : this.EncInbound;
                                    if (!keyInfo.getName().equalsIgnoreCase(encryptionKeyInfo.getReference())) continue;
                                    token = secObject.getToken();
                                    if (token instanceof X509ProtectionToken) {
                                        ((X509ProtectionToken)token).setKeyStore(WSFactoryUtils.readKeyStore(callbackHandler));
                                    }
                                    secObject.setDerivedKey(this.readDerivedKeyInfo(keyInfo));
                                    token.setKeyInfoType(keyInfo.getType());
                                    token.setCallBackHandler(callbackHandler.getClassname());
                                    token.setJAASConfig(tokenConsumer.getJAASConfig().getConfigName());
                                    for (Properties property : callbackHandler.getProperties()) {
                                        secObject.addProperty(new PropertyObject(property.getName(), property.getValue()));
                                    }
                                }
                            }
                        }
                        ++k;
                    }
                }
                List trustAnchors = securityInboundBindingConfig.getTrustAnchor();
                for (TrustAnchor trustAnchor : trustAnchors) {
                    KeyStore keyStore = trustAnchor.getKeyStore();
                    if (keyStore == null) continue;
                    com.ibm.ast.ws.policyset.ui.common.KeyStore newKeyStore = new com.ibm.ast.ws.policyset.ui.common.KeyStore(this.passUtil.passwordDecode(keyStore.getStorepass()), keyStore.getPath(), keyStore.getType());
                    ((X509ProtectionToken)this.SignInbound.getToken()).setKeyStore(newKeyStore);
                }
                CertStoreList certStoreList = securityInboundBindingConfig.getCertStoreList();
                if (certStoreList == null) continue;
                List collectionCertStores = certStoreList.getLdapCertStoresOrCollectionCertStores();
                int j = 0;
                while (j < collectionCertStores.size()) {
                    CollectionCertStores collectionCertStore = (CollectionCertStores)collectionCertStores.get(j);
                    List x509CertificatesOrCRLs = collectionCertStore.getX509CertificatesOrCRL();
                    int k = 0;
                    while (k < x509CertificatesOrCRLs.size()) {
                        X509Certificates x509Certificates = (X509Certificates)x509CertificatesOrCRLs.get(k);
                        if (x509Certificates != null) {
                            ((X509ProtectionToken)this.SignInbound.getToken()).setCertificatePathString(x509Certificates.getPath());
                        }
                        ++k;
                    }
                    ++j;
                }
            }
        }
        catch (UnmarshalException unmarshalException) {
            this.isMigrated = MigrateBindingConfigurationsUtils.migrate(location, this.getName(), this, this.passUtil);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getName() {
        return PolicyTypeName;
    }

    @Override
    public Dialog getConfigurationDialog(Shell shell) {
        if (this.unrecognizedTokenFound != null) {
            EditorUtils.offerToLaunchEditor(this.bindingLocation, this.unrecognizedTokenFound);
            return null;
        }
        return new WSSecurityBindingConfigurationDialog(shell, this);
    }

    @Override
    public String validateConfiguration() {
        if (this.generatorSymmetric != null && !this.generatorSymmetric.getToken().isValid()) {
            return com.ibm.ast.ws.was7.policyset.ui.plugin.Activator.getMessage("NOT_CONFIGURED");
        }
        if (!(this.isSignatureValid() && this.isEncryptionValid() && this.isAuthenticationValid())) {
            return com.ibm.ast.ws.was7.policyset.ui.plugin.Activator.getMessage("NOT_CONFIGURED");
        }
        return com.ibm.ast.ws.was7.policyset.ui.plugin.Activator.getMessage("CONFIGURED");
    }

    private boolean isSignatureValid() {
        return !(this.SignOutbound != null && !this.SignOutbound.getToken().isValid() || this.SignInbound != null && !this.SignInbound.getToken().isValid());
    }

    private boolean isEncryptionValid() {
        return !(this.EncOutbound != null && !this.EncOutbound.getToken().isValid() || this.EncInbound != null && !this.EncInbound.getToken().isValid());
    }

    private boolean isAuthenticationValid() {
        return this.authenticationToken == null || this.authenticationToken.isValid();
    }

    private void writeWSSecurityBindings(SecurityBindings securityBindings, File bindingLocation) throws Exception {
        IPath fileLocation = new Path(bindingLocation.getAbsolutePath()).append("bindings.xml");
        JAXBContext jc = JAXBContext.newInstance((String)BindingContextPath);
        Marshaller m = jc.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)true);
        FileOutputStream os = new FileOutputStream(fileLocation.toFile());
        m.marshal((Object)securityBindings, (OutputStream)os);
        ((OutputStream)os).close();
    }

    private SecurityBindings wsSecurityBindings(Policy qosPolicyInstance) {
        SecurityBindings securityBindings = this.bindingFactory.createSecurityBindings();
        SecurityBinding securityBinding = this.bindingFactory.createSecurityBinding();
        securityBinding.setName(ApplicationBindingName);
        SecurityOutboundBindingConfig securityOutboundBindingConfig = this.bindingFactory.createSecurityOutboundBindingConfig();
        securityBinding.setSecurityOutboundBindingConfig(securityOutboundBindingConfig);
        if (this.messageExpiryTime != null) {
            TimestampExpires expiry = this.bindingFactory.createTimestampExpires();
            expiry.setExpires(this.messageExpiryTime);
            securityOutboundBindingConfig.setTimestampExpires(expiry);
        }
        SecurityInboundBindingConfig securityInboundBindingConfig = this.bindingFactory.createSecurityInboundBindingConfig();
        securityBinding.setSecurityInboundBindingConfig(securityInboundBindingConfig);
        List policys = qosPolicyInstance.getPolicyOrAllOrExactlyOne();
        int j = 0;
        while (j < policys.size()) {
            if (policys.get(j) instanceof JAXBElement) {
                JAXBElement jaxbel = (JAXBElement)policys.get(j);
                QName name = jaxbel.getName();
                NestedPolicyType nestedPolicy = (NestedPolicyType)jaxbel.getValue();
                if (PolicyConfigUtil.supportingTokenQName.equals(name)) {
                    this.SupportingTokens(nestedPolicy, securityOutboundBindingConfig);
                } else if (PolicyConfigUtil.asymmetricBindingQName.equals(name)) {
                    this.AsymmetricBinding(nestedPolicy);
                } else if (PolicyConfigUtil.symmetricBindingQName.equals(name)) {
                    Object jaxbProtection = nestedPolicy.getPolicy().getPolicyOrAllOrExactlyOne().get(0);
                    NestedPolicyType protectionPolicy = (NestedPolicyType)((JAXBElement)jaxbProtection).getValue();
                    JAXBElement requiredToken = (JAXBElement)protectionPolicy.getPolicy().getPolicyOrAllOrExactlyOne().get(0);
                    String requiredTokenName = requiredToken.getName().getLocalPart();
                    Policy requiredTokenAssertionPolicy = null;
                    if (requiredTokenName.equals("SecureConversationToken")) {
                        SecureConversationTokenType required = (SecureConversationTokenType)requiredToken.getValue();
                        List list = required.getAny();
                        if (list != null && list.size() > 0) {
                            requiredTokenAssertionPolicy = (Policy)list.get(0);
                        }
                        if (requiredTokenAssertionPolicy != null) {
                            int b = 0;
                            while (b < requiredTokenAssertionPolicy.getPolicyOrAllOrExactlyOne().size()) {
                                JAXBElement jaxbBootstrap = (JAXBElement)requiredTokenAssertionPolicy.getPolicyOrAllOrExactlyOne().get(b);
                                if (jaxbBootstrap.getValue() instanceof NestedPolicyType) {
                                    NestedPolicyType bootstrapPolicy = (NestedPolicyType)jaxbBootstrap.getValue();
                                    List bootstrapPolicys = bootstrapPolicy.getPolicy().getPolicyOrAllOrExactlyOne();
                                    SecurityBinding bootstrapBinding = this.bootstrapBinding(bootstrapPolicys);
                                    securityBindings.getSecurityBinding().add(bootstrapBinding);
                                    break;
                                }
                                ++b;
                            }
                        }
                    }
                }
            }
            ++j;
        }
        j = 0;
        while (j < policys.size()) {
            if (policys.get(j) instanceof Policy) {
                Policy policy = (Policy)policys.get(j);
                String policyId = policy.getId();
                JAXBElement jaxbel = (JAXBElement)policy.getPolicyOrAllOrExactlyOne().get(0);
                QName name = jaxbel.getName();
                if (PolicyConfigUtil.signedPartsQName.equals(name) || PolicyConfigUtil.signedElementsQName.equals(name)) {
                    if (policyId.startsWith("request:")) {
                        if (this.generatorSymmetric == null) {
                            this.genAsymmetricSignatureOutbound(policyId, securityOutboundBindingConfig);
                        } else {
                            this.genSymmetricSignatureOutbound(policyId, securityOutboundBindingConfig);
                        }
                    } else if (policyId.startsWith("response:")) {
                        if (this.consumerSymmetric == null) {
                            this.genAsymmetricSignatureInbound(policyId, securityInboundBindingConfig);
                        } else {
                            this.genSymmetricSignatureInbound(policyId, securityInboundBindingConfig);
                        }
                    }
                }
                if (PolicyConfigUtil.encryptedPartsQName.equals(name) || PolicyConfigUtil.encryptedElementsQName.equals(name)) {
                    if (policyId.startsWith("request:")) {
                        if (this.generatorSymmetric == null) {
                            this.genAsymmetricEncryptionOutbound(policyId, securityOutboundBindingConfig);
                        } else {
                            this.genSymmetricEncryptionOutbound(policyId, securityOutboundBindingConfig);
                        }
                    } else if (policyId.startsWith("response:")) {
                        if (this.consumerSymmetric == null) {
                            this.genAsymmetricEncryptionInbound(policyId, securityInboundBindingConfig);
                        } else {
                            this.genSymmetricEncryptionInbound(policyId, securityInboundBindingConfig);
                        }
                    }
                }
            }
            ++j;
        }
        if (this.onlySignEntireHeadersAndBodyApp) {
            OnlySignEntireHeadersAndBody onlySign = this.bindingFactory.createOnlySignEntireHeadersAndBody();
            securityBinding.setOnlySignEntireHeadersAndBody(onlySign);
        }
        securityBindings.getSecurityBinding().add(securityBinding);
        return securityBindings;
    }

    private SecurityBinding bootstrapBinding(List<Object> policys) {
        SecurityBinding securityBinding = this.bindingFactory.createSecurityBinding();
        securityBinding.setName(BootstrapBindingName);
        if (this.onlySignEntireHeadersAndBodyBoot) {
            OnlySignEntireHeadersAndBody onlySign = this.bindingFactory.createOnlySignEntireHeadersAndBody();
            securityBinding.setOnlySignEntireHeadersAndBody(onlySign);
        }
        SecurityOutboundBindingConfig securityOutboundBindingConfig = this.bindingFactory.createSecurityOutboundBindingConfig();
        securityBinding.setSecurityOutboundBindingConfig(securityOutboundBindingConfig);
        SecurityInboundBindingConfig securityInboundBindingConfig = this.bindingFactory.createSecurityInboundBindingConfig();
        securityBinding.setSecurityInboundBindingConfig(securityInboundBindingConfig);
        int j = 0;
        while (j < policys.size()) {
            if (policys.get(j) instanceof Policy) {
                Policy policy = (Policy)policys.get(j);
                String policyId = policy.getId();
                JAXBElement jaxbel = (JAXBElement)policy.getPolicyOrAllOrExactlyOne().get(0);
                QName name = jaxbel.getName();
                if (PolicyConfigUtil.signedPartsQName.equals(name) || PolicyConfigUtil.signedElementsQName.equals(name)) {
                    if (policyId.startsWith("request:")) {
                        this.genAsymmetricSignatureOutbound(policyId, securityOutboundBindingConfig);
                    }
                    if (policyId.startsWith("response:")) {
                        this.genAsymmetricSignatureInbound(policyId, securityInboundBindingConfig);
                    }
                }
                if (PolicyConfigUtil.encryptedPartsQName.equals(name) || PolicyConfigUtil.encryptedElementsQName.equals(name)) {
                    if (policyId.startsWith("request:")) {
                        this.genAsymmetricEncryptionOutbound(policyId, securityOutboundBindingConfig);
                    }
                    if (policyId.startsWith("response:")) {
                        this.genAsymmetricEncryptionInbound(policyId, securityInboundBindingConfig);
                    }
                }
            }
            ++j;
        }
        return securityBinding;
    }

    private void SymmetricBinding(NestedPolicyType nestedPolicy) {
        try {
            Object object;
            SecureConversationTokenType required;
            JAXBElement requiredToken = null;
            int i = 0;
            while (i < nestedPolicy.getPolicy().getPolicyOrAllOrExactlyOne().size()) {
                JAXBElement jaxbProtection = (JAXBElement)nestedPolicy.getPolicy().getPolicyOrAllOrExactlyOne().get(i);
                if (jaxbProtection.getName().getLocalPart().equals("ProtectionToken")) {
                    requiredToken = (JAXBElement)((NestedPolicyType)jaxbProtection.getValue()).getPolicy().getPolicyOrAllOrExactlyOne().get(0);
                    break;
                }
                ++i;
            }
            if (requiredToken == null) {
                return;
            }
            Policy requiredTokenAssertionPolicy = null;
            if (requiredToken.getValue() instanceof SecureConversationTokenType) {
                required = (SecureConversationTokenType)requiredToken.getValue();
                List list = required.getAny();
                if (list != null && list.size() > 0) {
                    requiredTokenAssertionPolicy = (Policy)list.get(0);
                }
                if (requiredTokenAssertionPolicy != null) {
                    int b = 0;
                    while (b < requiredTokenAssertionPolicy.getPolicyOrAllOrExactlyOne().size()) {
                        JAXBElement jaxbBootstrap = (JAXBElement)requiredTokenAssertionPolicy.getPolicyOrAllOrExactlyOne().get(b);
                        if (jaxbBootstrap.getName().getLocalPart().equals("BootstrapPolicy")) {
                            JAXBElement assymetric = (JAXBElement)((NestedPolicyType)jaxbBootstrap.getValue()).getPolicy().getPolicyOrAllOrExactlyOne().get(0);
                            this.AsymmetricBinding((NestedPolicyType)assymetric.getValue());
                        }
                        ++b;
                    }
                }
                this.initiatorSymmetricToken = new SecureConversationToken(requiredToken.getName().getLocalPart(), requiredToken.getName().getNamespaceURI(), true);
                this.recipientSymmatricToken = new SecureConversationToken(requiredToken.getName().getLocalPart(), requiredToken.getName().getNamespaceURI(), false);
            } else if (requiredToken.getValue() instanceof TokenAssertionType && (object = (requiredTokenAssertionPolicy = (Policy)(required = (TokenAssertionType)requiredToken.getValue()).getAny().get(0)).getPolicyOrAllOrExactlyOne().get(0)) instanceof WssCustomToken) {
                String localName = ((WssCustomToken)object).getLocalname();
                Object genToken = new KerberosProtectionToken(localName, true);
                Object conToken = null;
                if (genToken.getTokenName() != null) {
                    conToken = new KerberosProtectionToken(localName, false);
                } else {
                    genToken = new SAMLSymmetricHOKProtectionToken(localName, true);
                    if (genToken.getTokenName() != null) {
                        conToken = new SAMLSymmetricHOKProtectionToken(localName, false);
                    } else {
                        this.unrecognizedTokenFound = localName;
                        return;
                    }
                }
                this.initiatorSymmetricToken = genToken;
                this.recipientSymmatricToken = conToken;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void AsymmetricBinding(NestedPolicyType nestedPolicy) {
        try {
            List assertions = nestedPolicy.getPolicy().getPolicyOrAllOrExactlyOne();
            int k = 0;
            while (k < assertions.size()) {
                JAXBElement anAssertion;
                String anAssertionName;
                Object potentialAssertion = assertions.get(k);
                if (potentialAssertion instanceof JAXBElement && ("InitiatorToken".equals(anAssertionName = (anAssertion = (JAXBElement)potentialAssertion).getName().getLocalPart()) || "InitiatorSignatureToken".equals(anAssertionName) || "InitiatorEncryptionToken".equals(anAssertionName) || "RecipientToken".equals(anAssertionName) || "RecipientSignatureToken".equals(anAssertionName) || "RecipientEncryptionToken".equals(anAssertionName))) {
                    NestedPolicyType np = (NestedPolicyType)anAssertion.getValue();
                    Object requiredTokenAssertion = np.getPolicy().getPolicyOrAllOrExactlyOne().get(0);
                    JAXBElement requiredToken = (JAXBElement)requiredTokenAssertion;
                    TokenAssertionType required = (TokenAssertionType)requiredToken.getValue();
                    Policy requiredTokenAssertionPolicy = (Policy)required.getAny().get(0);
                    Object object = requiredTokenAssertionPolicy.getPolicyOrAllOrExactlyOne().get(0);
                    if (object instanceof JAXBElement) {
                        JAXBElement tokenSpecification = (JAXBElement)object;
                        this.createProtectionTokens(anAssertionName, tokenSpecification.getName().getLocalPart());
                    }
                    if (object instanceof WssCustomToken) {
                        String localName = ((WssCustomToken)object).getLocalname();
                        this.createCustomProtectionTokens(anAssertionName, localName);
                    }
                }
                ++k;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createProtectionTokens(String name, String localPart) {
        KeyStoreWithKey outKeyStoreWithKey;
        if ("InitiatorToken".equals(name)) {
            this.initiatorSignatureToken = new X509ProtectionToken(localPart, true);
            ((X509ProtectionToken)this.initiatorSignatureToken).setKeyStore((com.ibm.ast.ws.policyset.ui.common.KeyStore)new KeyStoreWithKey());
            this.initiatorEncryptionToken = new X509ProtectionToken(localPart, false);
            ((X509ProtectionToken)this.initiatorEncryptionToken).setKeyStore((com.ibm.ast.ws.policyset.ui.common.KeyStore)new KeyStoreWithKey());
        }
        if ("InitiatorSignatureToken".equals(name)) {
            this.initiatorSignatureToken = new X509ProtectionToken(localPart, true);
            ((X509ProtectionToken)this.initiatorSignatureToken).setKeyStore((com.ibm.ast.ws.policyset.ui.common.KeyStore)new KeyStoreWithKey());
        }
        if ("InitiatorEncryptionToken".equals(name)) {
            this.initiatorEncryptionToken = new X509ProtectionToken(localPart, false);
            ((X509ProtectionToken)this.initiatorEncryptionToken).setKeyStore((com.ibm.ast.ws.policyset.ui.common.KeyStore)new KeyStoreWithKey());
        }
        if ("RecipientToken".equals(name)) {
            this.recipientSignatureToken = new X509ProtectionToken(localPart, false);
            ((X509ProtectionToken)this.recipientSignatureToken).setKeyStore(null);
            this.recipientEncryptionToken = new X509ProtectionToken(localPart, true);
            outKeyStoreWithKey = new KeyStoreWithKey();
            outKeyStoreWithKey.setKeyPassword(null);
            ((X509ProtectionToken)this.recipientEncryptionToken).setKeyStore((com.ibm.ast.ws.policyset.ui.common.KeyStore)outKeyStoreWithKey);
        }
        if ("RecipientSignatureToken".equals(name)) {
            this.recipientSignatureToken = new X509ProtectionToken(localPart, false);
            ((X509ProtectionToken)this.recipientSignatureToken).setKeyStore(null);
        }
        if ("RecipientEncryptionToken".equals(name)) {
            this.recipientEncryptionToken = new X509ProtectionToken(localPart, true);
            outKeyStoreWithKey = new KeyStoreWithKey();
            outKeyStoreWithKey.setKeyPassword(null);
            ((X509ProtectionToken)this.recipientEncryptionToken).setKeyStore((com.ibm.ast.ws.policyset.ui.common.KeyStore)outKeyStoreWithKey);
        }
    }

    private void createCustomProtectionTokens(String name, String localPart) {
        if ("InitiatorToken".equals(name)) {
            this.initiatorSignatureToken = new SAMLAsymmetricHOKProtectionToken(localPart, true);
            this.initiatorEncryptionToken = new SAMLAsymmetricHOKProtectionToken(localPart, false);
        }
        if ("InitiatorSignatureToken".equals(name)) {
            this.initiatorSignatureToken = new SAMLAsymmetricHOKProtectionToken(localPart, true);
        }
        if ("InitiatorEncryptionToken".equals(name)) {
            this.initiatorEncryptionToken = new SAMLAsymmetricHOKProtectionToken(localPart, false);
        }
        if ("RecipientToken".equals(name)) {
            this.recipientSignatureToken = new SAMLAsymmetricHOKProtectionToken(localPart, false);
            this.recipientEncryptionToken = new SAMLAsymmetricHOKProtectionToken(localPart, true);
        }
        if ("RecipientSignatureToken".equals(name)) {
            this.recipientSignatureToken = new SAMLAsymmetricHOKProtectionToken(localPart, false);
        }
        if ("RecipientEncryptionToken".equals(name)) {
            this.recipientEncryptionToken = new SAMLAsymmetricHOKProtectionToken(localPart, true);
        }
    }

    private void SupportingTokens(NestedPolicyType nestedPolicy, SecurityOutboundBindingConfig securityOutboundBindingConfig) {
        try {
            Policy supportingTokenPolicy = nestedPolicy.getPolicy();
            String policyId = supportingTokenPolicy.getId();
            this.authenticationOutput(policyId, securityOutboundBindingConfig);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void authenticationOutput(String policyId, SecurityOutboundBindingConfig securityOutboundBindingConfig) {
        TokenGenerator tokenGenerator = null;
        tokenGenerator = WSFactoryUtils.createSupportedTokenGenerator(this.bindingFactory, this.authenticationToken);
        SecurityTokenReference securityTokenReference = this.bindingFactory.createSecurityTokenReference();
        securityTokenReference.setReference(policyId);
        tokenGenerator.setSecurityTokenReference(securityTokenReference);
        securityOutboundBindingConfig.getTokenGenerator().add(tokenGenerator);
    }

    private void genSymmetricSignatureInbound(String policyId, SecurityInboundBindingConfig securityInboundBindingConfig) {
        SigningInfo signingInfo = this.bindingFactory.createSigningInfo();
        signingInfo.setName(policyId);
        SigningPartReference signingPartReference = this.bindingFactory.createSigningPartReference();
        signingPartReference.setReference(policyId);
        Transform transform = this.bindingFactory.createTransform();
        signingPartReference.getTransform().add(transform);
        signingInfo.getSigningPartReference().add(signingPartReference);
        SigningKeyInfo signingKeyInfo = this.bindingFactory.createSigningKeyInfo();
        signingInfo.getSigningKeyInfo().add(signingKeyInfo);
        KeyInfo keyInfo = this.bindingFactory.createKeyInfo();
        TokenReference tokenReference = this.bindingFactory.createTokenReference();
        keyInfo.setTokenReference(tokenReference);
        transform.setAlgorithm(this.consumerSymmetric.getTransformAlgorithm());
        TokenConsumer tokenConsumer = WSFactoryUtils.createSymmetricTokenConsumer(this.bindingFactory, this.consumerSymmetric.getToken());
        securityInboundBindingConfig.getTokenConsumer().add(tokenConsumer);
        keyInfo.setType(this.consumerSymmetric.getToken().getKeyInfoType(true));
        keyInfo.setName("con_signkeyinfo");
        keyInfo.setClassname("com.ibm.ws.wssecurity.wssapi.CommonContentConsumer");
        this.generateDerivedKeyInfoSection(this.consumerSymmetric.getDerivedKey(), keyInfo);
        tokenReference.setReference(tokenConsumer.getName());
        securityInboundBindingConfig.getKeyInfo().add(keyInfo);
        signingKeyInfo.setReference(keyInfo.getName());
        securityInboundBindingConfig.getSigningInfo().add(signingInfo);
    }

    private void genSymmetricSignatureOutbound(String policyId, SecurityOutboundBindingConfig securityOutboundBindingConfig) {
        SigningInfo signingInfo = this.bindingFactory.createSigningInfo();
        signingInfo.setName(policyId);
        SigningPartReference signingPartReference = this.bindingFactory.createSigningPartReference();
        signingPartReference.setReference(policyId);
        Transform transform = this.bindingFactory.createTransform();
        signingPartReference.getTransform().add(transform);
        signingInfo.getSigningPartReference().add(signingPartReference);
        SigningKeyInfo signingKeyInfo = this.bindingFactory.createSigningKeyInfo();
        signingInfo.getSigningKeyInfo().add(signingKeyInfo);
        KeyInfo keyInfo = this.bindingFactory.createKeyInfo();
        TokenReference tokenReference = this.bindingFactory.createTokenReference();
        keyInfo.setTokenReference(tokenReference);
        TokenGenerator tokenGenerator = WSFactoryUtils.createSymmetricTokenGenerator(this.bindingFactory, this.generatorSymmetric.getToken());
        transform.setAlgorithm(this.generatorSymmetric.getTransformAlgorithm());
        securityOutboundBindingConfig.getTokenGenerator().add(tokenGenerator);
        keyInfo.setType(this.generatorSymmetric.getToken().getKeyInfoType(true));
        keyInfo.setName("gen_signkeyinfo");
        keyInfo.setClassname("com.ibm.ws.wssecurity.wssapi.CommonContentGenerator");
        this.generateDerivedKeyInfoSection(this.generatorSymmetric.getDerivedKey(), keyInfo);
        tokenReference.setReference(this.generatorSymmetric.getToken().getId());
        securityOutboundBindingConfig.getKeyInfo().add(keyInfo);
        if (this.SignOutbound == null) {
            signingInfo.setOrder("1");
        } else {
            signingInfo.setOrder(this.SignOutbound.getOrder());
        }
        signingKeyInfo.setReference(keyInfo.getName());
        securityOutboundBindingConfig.getSigningInfo().add(signingInfo);
    }

    private void genAsymmetricEncryptionInbound(String policyId, SecurityInboundBindingConfig securityInboundBindingConfig) {
        EncryptionInfo encryptionInfo = this.bindingFactory.createEncryptionInfo();
        encryptionInfo.setName(policyId);
        EncryptionPartReference encryptionPartReference = this.bindingFactory.createEncryptionPartReference();
        encryptionPartReference.setReference(policyId);
        encryptionInfo.setEncryptionPartReference(encryptionPartReference);
        KeyInfo keyInfo = this.bindingFactory.createKeyInfo();
        TokenReference tokenReference = this.bindingFactory.createTokenReference();
        keyInfo.setTokenReference(tokenReference);
        TokenConsumer tokenConsumer = WSFactoryUtils.createAsymmetricTokenConsumer(this.bindingFactory, this.EncInbound);
        CallbackHandler handler = tokenConsumer.getCallbackHandler();
        ProtectionToken token = this.EncInbound.getToken();
        if (token instanceof X509ProtectionToken) {
            WSFactoryUtils.createKeyStore(this.bindingFactory, handler, ((X509ProtectionToken)this.EncInbound.getToken()).getKeyStore());
        }
        CertPathSettings certPathSettings = this.bindingFactory.createCertPathSettings();
        TrustAnyCertificate trustAnyCertificate = this.bindingFactory.createTrustAnyCertificate();
        certPathSettings.setTrustAnyCertificate(trustAnyCertificate);
        handler.setCertPathSettings(certPathSettings);
        securityInboundBindingConfig.getTokenConsumer().add(tokenConsumer);
        keyInfo.setName("con_enckeyinfo");
        keyInfo.setClassname("com.ibm.ws.wssecurity.wssapi.CommonContentConsumer");
        keyInfo.setType(token.getKeyInfoType(false));
        this.generateDerivedKeyInfoSection(this.EncInbound.getDerivedKey(), keyInfo);
        tokenReference.setReference(tokenConsumer.getName());
        securityInboundBindingConfig.getKeyInfo().add(keyInfo);
        KeyEncryptionKeyInfo keyEncryptionKeyInfo = this.bindingFactory.createKeyEncryptionKeyInfo();
        keyEncryptionKeyInfo.setReference(keyInfo.getName());
        encryptionInfo.getKeyEncryptionKeyInfo().add(keyEncryptionKeyInfo);
        securityInboundBindingConfig.getEncryptionInfo().add(encryptionInfo);
    }

    private void genAsymmetricSignatureInbound(String policyId, SecurityInboundBindingConfig securityInboundBindingConfig) {
        SigningInfo signingInfo = this.bindingFactory.createSigningInfo();
        signingInfo.setName(policyId);
        SigningPartReference signingPartReference = this.bindingFactory.createSigningPartReference();
        signingPartReference.setReference(policyId);
        Transform transform = this.bindingFactory.createTransform();
        transform.setAlgorithm(this.SignInbound.getTransformAlgorithm());
        signingPartReference.getTransform().add(transform);
        signingInfo.getSigningPartReference().add(signingPartReference);
        SigningKeyInfo signingKeyInfo = this.bindingFactory.createSigningKeyInfo();
        signingInfo.getSigningKeyInfo().add(signingKeyInfo);
        KeyInfo keyInfo = this.bindingFactory.createKeyInfo();
        TokenReference tokenReference = this.bindingFactory.createTokenReference();
        keyInfo.setTokenReference(tokenReference);
        TokenConsumer tokenConsumer = WSFactoryUtils.createAsymmetricTokenConsumer(this.bindingFactory, (SecurityBindingObject)this.SignInbound);
        securityInboundBindingConfig.getTokenConsumer().add(tokenConsumer);
        ProtectionToken token = this.SignInbound.getToken();
        CertPathSettings certPathSettings = this.bindingFactory.createCertPathSettings();
        if (token instanceof X509ProtectionToken) {
            X509ProtectionToken x509token = (X509ProtectionToken)token;
            if (x509token.getKeyStore() != null) {
                TrustAnchor trustAnchor = this.bindingFactory.createTrustAnchor();
                trustAnchor.setName("DigSigTrustAnchor");
                WSFactoryUtils.createKeyStore(this.bindingFactory, trustAnchor, x509token.getKeyStore());
                securityInboundBindingConfig.getTrustAnchor().add(trustAnchor);
                TrustAnchorRef trustAnchorRef = this.bindingFactory.createTrustAnchorRef();
                trustAnchorRef.setReference(trustAnchor.getName());
                certPathSettings.setTrustAnchorRef(trustAnchorRef);
                if (x509token.getCertificatePathString() != null && x509token.getCertificatePathString().length() > 0) {
                    CertStoreList certStoreList = this.bindingFactory.createCertStoreList();
                    CollectionCertStores collectionCertStore = this.bindingFactory.createCollectionCertStores();
                    collectionCertStore.setName("DigSigCertStore");
                    collectionCertStore.setProvider("IBMCertPath");
                    X509Certificates x509Certificate = this.bindingFactory.createX509Certificates();
                    x509Certificate.setPath(x509token.getCertificatePathString());
                    collectionCertStore.getX509CertificatesOrCRL().add(x509Certificate);
                    certStoreList.getLdapCertStoresOrCollectionCertStores().add(collectionCertStore);
                    securityInboundBindingConfig.setCertStoreList(certStoreList);
                    CertStoreRef certStoreRef = this.bindingFactory.createCertStoreRef();
                    certStoreRef.setReference("DigSigCertStore");
                    certPathSettings.setCertStoreRef(certStoreRef);
                }
            }
        } else {
            TrustAnyCertificate trustAnyCertificate = this.bindingFactory.createTrustAnyCertificate();
            certPathSettings.setTrustAnyCertificate(trustAnyCertificate);
        }
        tokenConsumer.getCallbackHandler().setCertPathSettings(certPathSettings);
        keyInfo.setName("con_signkeyinfo");
        keyInfo.setClassname("com.ibm.ws.wssecurity.wssapi.CommonContentConsumer");
        keyInfo.setType(token.getKeyInfoType(true));
        this.generateDerivedKeyInfoSection(this.SignInbound.getDerivedKey(), keyInfo);
        tokenReference.setReference(token.getId());
        securityInboundBindingConfig.getKeyInfo().add(keyInfo);
        signingKeyInfo.setReference(keyInfo.getName());
        securityInboundBindingConfig.getSigningInfo().add(signingInfo);
    }

    private void genAsymmetricSignatureOutbound(String policyId, SecurityOutboundBindingConfig securityOutboundBindingConfig) {
        SigningInfo signingInfo = this.bindingFactory.createSigningInfo();
        signingInfo.setName(policyId);
        SigningPartReference signingPartReference = this.bindingFactory.createSigningPartReference();
        signingPartReference.setReference(policyId);
        Transform transform = this.bindingFactory.createTransform();
        transform.setAlgorithm(this.SignOutbound.getTransformAlgorithm());
        signingPartReference.getTransform().add(transform);
        signingInfo.getSigningPartReference().add(signingPartReference);
        SigningKeyInfo signingKeyInfo = this.bindingFactory.createSigningKeyInfo();
        signingInfo.getSigningKeyInfo().add(signingKeyInfo);
        KeyInfo keyInfo = this.bindingFactory.createKeyInfo();
        TokenReference tokenReference = this.bindingFactory.createTokenReference();
        keyInfo.setTokenReference(tokenReference);
        securityOutboundBindingConfig.getTokenGenerator().add(WSFactoryUtils.createAsymmetricTokenGenerator(this.bindingFactory, (SecurityBindingObject)this.SignOutbound));
        ProtectionToken token = this.SignOutbound.getToken();
        keyInfo.setType(token.getKeyInfoType(true));
        keyInfo.setName("gen_signkeyinfo");
        keyInfo.setClassname("com.ibm.ws.wssecurity.wssapi.CommonContentGenerator");
        this.generateDerivedKeyInfoSection(this.SignOutbound.getDerivedKey(), keyInfo);
        tokenReference.setReference(token.getId());
        securityOutboundBindingConfig.getKeyInfo().add(keyInfo);
        signingInfo.setOrder(this.SignOutbound.getOrder());
        signingKeyInfo.setReference(keyInfo.getName());
        securityOutboundBindingConfig.getSigningInfo().add(signingInfo);
    }

    private void genAsymmetricEncryptionOutbound(String policyId, SecurityOutboundBindingConfig securityOutboundBindingConfig) {
        EncryptionInfo encryptionInfo = this.bindingFactory.createEncryptionInfo();
        encryptionInfo.setName(policyId);
        EncryptionPartReference encryptionPartReference = this.bindingFactory.createEncryptionPartReference();
        encryptionPartReference.setReference(policyId);
        encryptionInfo.setEncryptionPartReference(encryptionPartReference);
        KeyInfo keyInfo = this.bindingFactory.createKeyInfo();
        TokenReference tokenReference = this.bindingFactory.createTokenReference();
        keyInfo.setTokenReference(tokenReference);
        securityOutboundBindingConfig.getTokenGenerator().add(WSFactoryUtils.createAsymmetricTokenGenerator(this.bindingFactory, (SecurityBindingObject)this.EncOutbound));
        ProtectionToken token = this.EncOutbound.getToken();
        keyInfo.setName("gen_enckeyinfo");
        keyInfo.setType(token.getKeyInfoType(false));
        keyInfo.setClassname("com.ibm.ws.wssecurity.wssapi.CommonContentGenerator");
        this.generateDerivedKeyInfoSection(this.EncOutbound.getDerivedKey(), keyInfo);
        tokenReference.setReference(token.getId());
        securityOutboundBindingConfig.getKeyInfo().add(keyInfo);
        encryptionInfo.setOrder(this.EncOutbound.getOrder());
        KeyEncryptionKeyInfo keyEncryptionKeyInfo = this.bindingFactory.createKeyEncryptionKeyInfo();
        keyEncryptionKeyInfo.setReference(keyInfo.getName());
        encryptionInfo.getKeyEncryptionKeyInfo().add(keyEncryptionKeyInfo);
        encryptionInfo.getProperties().add(this.getPropertyObject(this.bindingFactory, this.EncOutbound.getEnableMTOM()));
        encryptionInfo.getProperties().add(this.getPropertyObject(this.bindingFactory, this.EncOutbound.getEncryptedHeader()));
        securityOutboundBindingConfig.getEncryptionInfo().add(encryptionInfo);
    }

    private void genSymmetricEncryptionInbound(String policyId, SecurityInboundBindingConfig securityInboundBindingConfig) {
        EncryptionInfo encryptionInfo = this.bindingFactory.createEncryptionInfo();
        encryptionInfo.setName(policyId);
        EncryptionPartReference encryptionPartReference = this.bindingFactory.createEncryptionPartReference();
        encryptionPartReference.setReference(policyId);
        encryptionInfo.setEncryptionPartReference(encryptionPartReference);
        KeyInfo keyInfo = this.bindingFactory.createKeyInfo();
        TokenReference tokenReference = this.bindingFactory.createTokenReference();
        keyInfo.setTokenReference(tokenReference);
        keyInfo.setType(this.consumerSymmetric.getToken().getKeyInfoType(true));
        keyInfo.setName("con_enckeyinfo");
        keyInfo.setClassname("com.ibm.ws.wssecurity.wssapi.CommonContentConsumer");
        this.generateDerivedKeyInfoSection(this.consumerSymmetric.getDerivedKey(), keyInfo);
        tokenReference.setReference(this.consumerSymmetric.getToken().getId());
        securityInboundBindingConfig.getKeyInfo().add(keyInfo);
        DataEncryptionKeyInfo dataEncryptionKeyInfo = this.bindingFactory.createDataEncryptionKeyInfo();
        dataEncryptionKeyInfo.setReference(keyInfo.getName());
        encryptionPartReference.getDataEncryptionKeyInfo().add(dataEncryptionKeyInfo);
        securityInboundBindingConfig.getEncryptionInfo().add(encryptionInfo);
    }

    private void genSymmetricEncryptionOutbound(String policyId, SecurityOutboundBindingConfig securityOutboundBindingConfig) {
        EncryptionInfo encryptionInfo = this.bindingFactory.createEncryptionInfo();
        encryptionInfo.setName(policyId);
        EncryptionPartReference encryptionPartReference = this.bindingFactory.createEncryptionPartReference();
        encryptionPartReference.setReference(policyId);
        encryptionInfo.setEncryptionPartReference(encryptionPartReference);
        KeyInfo keyInfo = this.bindingFactory.createKeyInfo();
        TokenReference tokenReference = this.bindingFactory.createTokenReference();
        keyInfo.setTokenReference(tokenReference);
        keyInfo.setType(this.generatorSymmetric.getToken().getKeyInfoType(true));
        keyInfo.setName("gen_enckeyinfo");
        keyInfo.setClassname("com.ibm.ws.wssecurity.wssapi.CommonContentGenerator");
        this.generateDerivedKeyInfoSection(this.generatorSymmetric.getDerivedKey(), keyInfo);
        tokenReference.setReference(this.generatorSymmetric.getToken().getId());
        securityOutboundBindingConfig.getKeyInfo().add(keyInfo);
        if (this.EncInbound == null) {
            encryptionInfo.setOrder("2");
        } else {
            encryptionInfo.setOrder(this.EncOutbound.getOrder());
        }
        DataEncryptionKeyInfo dataEncryptionKeyInfo = this.bindingFactory.createDataEncryptionKeyInfo();
        dataEncryptionKeyInfo.setReference(keyInfo.getName());
        encryptionPartReference.getDataEncryptionKeyInfo().add(dataEncryptionKeyInfo);
        securityOutboundBindingConfig.getEncryptionInfo().add(encryptionInfo);
    }

    private void getSignedParts(Policy qosPolicyInstance) {
        List policys = qosPolicyInstance.getPolicyOrAllOrExactlyOne();
        int j = 0;
        while (j < policys.size()) {
            Policy policy;
            JAXBElement jaxbel;
            QName name;
            if (policys.get(j) instanceof Policy && (PolicyConfigUtil.signedPartsQName.equals(name = (jaxbel = (JAXBElement)(policy = (Policy)policys.get(j)).getPolicyOrAllOrExactlyOne().get(0)).getName()) || PolicyConfigUtil.signedElementsQName.equals(name))) {
                if (policy.getId().startsWith("request:")) {
                    this.isOutboundSignatureFound = true;
                }
                if (policy.getId().startsWith("response:")) {
                    this.isInboundSignatureFound = true;
                }
            }
            ++j;
        }
    }

    private void getEncryptionParts(Policy qosPolicyInstance) {
        List policys = qosPolicyInstance.getPolicyOrAllOrExactlyOne();
        int j = 0;
        while (j < policys.size()) {
            Policy policy;
            JAXBElement jaxbel;
            QName name;
            if (policys.get(j) instanceof Policy && (PolicyConfigUtil.encryptedPartsQName.equals(name = (jaxbel = (JAXBElement)(policy = (Policy)policys.get(j)).getPolicyOrAllOrExactlyOne().get(0)).getName()) || PolicyConfigUtil.encryptedElementsQName.equals(name))) {
                if (policy.getId().startsWith("request:")) {
                    this.isOutboundEncryptionFound = true;
                }
                if (policy.getId().startsWith("response:")) {
                    this.isInboundEncryptionFound = true;
                }
            }
            ++j;
        }
    }

    private void getTokenSpecificationNames(Policy qosPolicyInstance) {
        try {
            List policys = qosPolicyInstance.getPolicyOrAllOrExactlyOne();
            int j = 0;
            while (j < policys.size()) {
                if (policys.get(j) instanceof JAXBElement) {
                    JAXBElement jaxbel = (JAXBElement)policys.get(j);
                    QName name = jaxbel.getName();
                    NestedPolicyType nestedPolicy = (NestedPolicyType)jaxbel.getValue();
                    if (PolicyConfigUtil.asymmetricBindingQName.equals(name)) {
                        this.AsymmetricBinding(nestedPolicy);
                    } else if (PolicyConfigUtil.symmetricBindingQName.equals(name)) {
                        this.SymmetricBinding(nestedPolicy);
                    } else if (PolicyConfigUtil.supportingTokenQName.equals(name)) {
                        Object anObject;
                        Policy supportingTokenPolicy = nestedPolicy.getPolicy();
                        JAXBElement jaxbAssertion = (JAXBElement)supportingTokenPolicy.getPolicyOrAllOrExactlyOne().get(0);
                        String assertion = jaxbAssertion.getName().getLocalPart();
                        String localPart = null;
                        TokenAssertionType authToken = (TokenAssertionType)jaxbAssertion.getValue();
                        List any = authToken.getAny();
                        if (any != null && any.size() != 0 && (anObject = any.get(0)) instanceof Policy) {
                            Policy tokenPolicy = (Policy)anObject;
                            Object object = tokenPolicy.getPolicyOrAllOrExactlyOne().get(0);
                            if (object instanceof JAXBElement) {
                                localPart = ((JAXBElement)object).getName().getLocalPart();
                            } else if (object instanceof WssCustomToken) {
                                this.authenticationToken = this.setupCustomSupportingToken(((WssCustomToken)object).getLocalname());
                            }
                        }
                        if (this.authenticationToken == null) {
                            this.authenticationToken = this.setupSupportingToken(assertion, localPart);
                            if (this.authenticationToken != null) {
                                this.authenticationToken.setBasicAuth(new BasicAuthentication("", ""));
                            }
                        }
                    }
                }
                ++j;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getMessageExpiryTime() {
        return this.messageExpiryTime;
    }

    public void setMessageExpiryTime(String messageExpiryTime) {
        this.messageExpiryTime = messageExpiryTime;
    }

    public SecurityBindingObject getEncInbound() {
        return this.EncInbound;
    }

    public void setEncInbound(SecurityBindingObject encInbound) {
        this.EncInbound = encInbound;
    }

    public SecurityBindingObject getEncOutbound() {
        return this.EncOutbound;
    }

    public void setEncOutbound(EncryptionOutBoundSecurityBindingObject encOutbound) {
        this.EncOutbound = encOutbound;
    }

    public SignatureSecurityBindingObject getSignInbound() {
        return this.SignInbound;
    }

    public void setSignInbound(SignatureSecurityBindingObject signInbound) {
        this.SignInbound = signInbound;
    }

    public SignatureSecurityBindingObject getSignOutbound() {
        return this.SignOutbound;
    }

    public void setSignOutbound(SignatureSecurityBindingObject signOutbound) {
        this.SignOutbound = signOutbound;
    }

    public AuthenticationToken getAuthenticationToken() {
        return this.authenticationToken;
    }

    private Properties getPropertyObject(ObjectFactory factory, String name, String value) {
        Properties properties = factory.createProperties();
        properties.setName(name);
        properties.setValue(value);
        return properties;
    }

    private Properties getPropertyObject(ObjectFactory factory, PropertyObject object) {
        return this.getPropertyObject(factory, object.getName(), object.getValue());
    }

    public void setAuthenticationToken(AuthenticationToken token) {
        this.authenticationToken = token;
    }

    private DerivedKeyInfoObject readDerivedKeyInfo(KeyInfo keyInfo) {
        DerivedKeyInfoObject object = null;
        if (keyInfo.getDerivedKeyInfo() != null) {
            DerivedKeyInfo info = keyInfo.getDerivedKeyInfo();
            object = new DerivedKeyInfoObject();
            object.setRequireDerivedKeys(true);
            object.setUseExplicitKeys(info.getRequireExplicitDerivedKeys() != null);
            object.setServiceLabel(info.getServiceLabel());
            object.setClientLabel(info.getClientLabel());
            object.setNonceLength(info.getNonceLength());
            object.setKeyLength(info.getKeyLength());
        }
        return object;
    }

    private void generateDerivedKeyInfoSection(DerivedKeyInfoObject derivedKeyObject, KeyInfo keyInfo) {
        if (derivedKeyObject != null && derivedKeyObject.isRequireDerivedKeys()) {
            DerivedKeyInfo derivedKeyInfo = this.bindingFactory.createDerivedKeyInfo();
            derivedKeyInfo.setClientLabel(derivedKeyObject.getClientLabel());
            derivedKeyInfo.setServiceLabel(derivedKeyObject.getServiceLabel());
            derivedKeyInfo.setKeyLength(derivedKeyObject.getKeyLength());
            derivedKeyInfo.setNonceLength(derivedKeyObject.getNonceLength());
            derivedKeyInfo.setRequireDerivedKeys(this.bindingFactory.createRequireDerivedKeys());
            if (derivedKeyObject.isUseExplicitKeys()) {
                derivedKeyInfo.setRequireExplicitDerivedKeys(this.bindingFactory.createRequireExplicitDerivedKeys());
            } else {
                derivedKeyInfo.setRequireImpliedDerivedKeys(this.bindingFactory.createRequireImpliedDerivedKeys());
            }
            keyInfo.setDerivedKeyInfo(derivedKeyInfo);
        }
    }

    private AuthenticationToken setupSupportingToken(String assertion, String localPart) {
        if (assertion.equalsIgnoreCase("UsernameToken")) {
            return new UserNameAuthenticationToken(localPart, true);
        }
        if (assertion.equalsIgnoreCase("LTPAToken")) {
            return new LTPAAuthenticationToken("LTPAToken", true);
        }
        if (assertion.equalsIgnoreCase("LTPAPropagationToken")) {
            return new LTPAPropAuthenticationToken("LTPAPropagationToken", true);
        }
        MessageDialog.openWarning(null, (String)Activator.getMessage((String)"MESSAGE_TITLE_TOKEN_NOT_SUPPORTED"), (String)Activator.getMessage((String)"WARNING_NOT_SUPPORTED_TOKEN", (Object[])new String[]{assertion}));
        return null;
    }

    private AuthenticationToken setupCustomSupportingToken(String localPart) {
        Object token = new KerberosProtectionToken(localPart, true);
        if (token == null || token.getTokenName() == null) {
            token = new SAMLBearerProtectionToken(localPart);
        }
        if (token == null || token.getTokenName() == null) {
            token = new CustomeAuthenticationToken(localPart);
            this.unrecognizedTokenFound = new String("CustomToken");
        }
        return token;
    }

    public SignatureSecurityBindingObject getGeneratorSymmetricObject() {
        return this.generatorSymmetric;
    }

    public SignatureSecurityBindingObject getConsumerSymmmetricObject() {
        return this.consumerSymmetric;
    }

    public void setGeneratorSymmetricObject(SignatureSecurityBindingObject generatorSymmetric) {
        this.generatorSymmetric = generatorSymmetric;
    }

    public void setConsumerSymmetricObject(SignatureSecurityBindingObject consumerSymmetric) {
        this.consumerSymmetric = consumerSymmetric;
    }

    public boolean isOnlySignEntireHeadersAndBodyBoot() {
        return this.onlySignEntireHeadersAndBodyBoot;
    }

    public void setOnlySignEntireHeadersAndBodyBoot(boolean onlySignEntireHeadersAndBodyBoot) {
        this.onlySignEntireHeadersAndBodyBoot = onlySignEntireHeadersAndBodyBoot;
    }

    public boolean isOnlySignEntireHeadersAndBodyApp() {
        return this.onlySignEntireHeadersAndBodyApp;
    }

    public void setOnlySignEntireHeadersAndBodyApp(boolean onlySignEntireHeadersAndBodyApp) {
        this.onlySignEntireHeadersAndBodyApp = onlySignEntireHeadersAndBodyApp;
    }
}

