/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.was7.policyset.ui.types;

import com.ibm.ISecurityUtilityImpl.PasswordUtil;
import com.ibm.ast.ws.policyset.ui.common.KeyStoreWithKey;
import com.ibm.ast.ws.policyset.ui.common.PropertyObject;
import com.ibm.ast.ws.policyset.ui.common.SecurityBindingObject;
import com.ibm.ast.ws.policyset.ui.common.SignatureSecurityBindingObject;
import com.ibm.ast.ws.policyset.ui.tokens.AuthenticationToken;
import com.ibm.ast.ws.policyset.ui.tokens.KerberosProtectionToken;
import com.ibm.ast.ws.policyset.ui.tokens.ProtectionToken;
import com.ibm.ast.ws.policyset.ui.tokens.X509ProtectionToken;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.BasicAuth;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.CallbackHandler;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.JAASConfig;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.Key;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.KeyStore;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.ObjectFactory;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.Properties;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.TokenConsumer;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.TokenGenerator;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.TrustAnchor;
import com.ibm.xmlns.prod.websphere._200710.ws_securitybinding.ValueType;
import java.util.List;

public class WSFactoryUtils {
    public static void createKeyStore(ObjectFactory bindingFactory, CallbackHandler handler, com.ibm.ast.ws.policyset.ui.common.KeyStore k) {
        if (k != null) {
            KeyStore keyStore = bindingFactory.createKeyStore();
            keyStore.setStorepass(PasswordUtil.passwordEncode((String)k.getPassword()));
            keyStore.setPath(k.getPath());
            keyStore.setType(k.getType());
            handler.setKeyStore(keyStore);
            if (k instanceof KeyStoreWithKey) {
                Key key = bindingFactory.createKey();
                key.setAlias(((KeyStoreWithKey)k).getKeyAlias());
                key.setKeypass(PasswordUtil.passwordEncode((String)((KeyStoreWithKey)k).getKeyPassword()));
                key.setName(((KeyStoreWithKey)k).getKeyName());
                handler.setKey(key);
            }
        }
    }

    public static void createKeyStore(ObjectFactory bindingFactory, TrustAnchor trust, com.ibm.ast.ws.policyset.ui.common.KeyStore k) {
        if (k != null) {
            KeyStore keyStore = bindingFactory.createKeyStore();
            keyStore.setStorepass(PasswordUtil.passwordEncode((String)k.getPassword()));
            keyStore.setPath(k.getPath());
            keyStore.setType(k.getType());
            trust.setKeyStore(keyStore);
        }
    }

    public static TokenGenerator createAsymmetricTokenGenerator(ObjectFactory bindingFactory, SecurityBindingObject securityObject) {
        ProtectionToken token = securityObject.getToken();
        TokenGenerator tokenGenerator = bindingFactory.createTokenGenerator();
        tokenGenerator.setName(token.getId());
        tokenGenerator.setClassname(token.getTokenGeneratorClassname());
        CallbackHandler callbackHandler = bindingFactory.createCallbackHandler();
        callbackHandler.setClassname(token.getCallBackHandler());
        if (token instanceof X509ProtectionToken) {
            WSFactoryUtils.createKeyStore(bindingFactory, callbackHandler, ((X509ProtectionToken)token).getKeyStore());
        }
        if (token.getProperties() != null) {
            List properties = callbackHandler.getProperties();
            for (PropertyObject property : token.getProperties().getProperties()) {
                properties.add(WSFactoryUtils.getPropertyObject(bindingFactory, property));
            }
        }
        tokenGenerator.setCallbackHandler(callbackHandler);
        ValueType valueType = bindingFactory.createValueType();
        valueType.setLocalName(token.getTokenLocalName());
        valueType.setUri(token.getTokenURI());
        tokenGenerator.setValueType(valueType);
        JAASConfig jAASConfig = bindingFactory.createJAASConfig();
        jAASConfig.setConfigName(token.getJAASConfig());
        tokenGenerator.setJAASConfig(jAASConfig);
        return tokenGenerator;
    }

    public static TokenGenerator createSymmetricTokenGenerator(ObjectFactory bindingFactory, ProtectionToken token) {
        TokenGenerator tokenGenerator = WSFactoryUtils.createTokenGenerator(bindingFactory, (AuthenticationToken)token);
        List properties = token instanceof KerberosProtectionToken ? tokenGenerator.getProperties() : tokenGenerator.getCallbackHandler().getProperties();
        for (PropertyObject property : token.getProperties().getProperties()) {
            properties.add(WSFactoryUtils.getPropertyObject(bindingFactory, property));
        }
        return tokenGenerator;
    }

    public static TokenGenerator createSupportedTokenGenerator(ObjectFactory bindingFactory, AuthenticationToken token) {
        TokenGenerator tokenGenerator = WSFactoryUtils.createTokenGenerator(bindingFactory, token);
        if (token != null && token.getBasicAuth() != null) {
            BasicAuth basicAuth = bindingFactory.createBasicAuth();
            basicAuth.setUserid(token.getBasicAuth().getUserName() == null ? "" : token.getBasicAuth().getUserName());
            basicAuth.setPassword(token.getBasicAuth().getPassword() == null ? "" : PasswordUtil.passwordEncode((String)token.getBasicAuth().getPassword()));
            tokenGenerator.getCallbackHandler().setBasicAuth(basicAuth);
        }
        List properties = token instanceof KerberosProtectionToken ? tokenGenerator.getProperties() : tokenGenerator.getCallbackHandler().getProperties();
        for (PropertyObject property : token.getProperties().getProperties()) {
            properties.add(WSFactoryUtils.getPropertyObject(bindingFactory, property));
        }
        return tokenGenerator;
    }

    public static TokenGenerator createTokenGenerator(ObjectFactory bindingFactory, AuthenticationToken token) {
        TokenGenerator tokenGenerator = bindingFactory.createTokenGenerator();
        tokenGenerator.setName(token.getId());
        tokenGenerator.setClassname(token.getTokenGeneratorClassname());
        CallbackHandler callbackHandler = bindingFactory.createCallbackHandler();
        callbackHandler.setClassname(token.getCallBackHandler());
        tokenGenerator.setCallbackHandler(callbackHandler);
        ValueType valueType = bindingFactory.createValueType();
        valueType.setLocalName(token.getTokenLocalName());
        valueType.setUri(token.getTokenURI());
        tokenGenerator.setValueType(valueType);
        JAASConfig jAASConfig = bindingFactory.createJAASConfig();
        jAASConfig.setConfigName(token.getJAASConfig());
        tokenGenerator.setJAASConfig(jAASConfig);
        return tokenGenerator;
    }

    public static TokenConsumer createSymmetricTokenConsumer(ObjectFactory bindingFactory, ProtectionToken token) {
        TokenConsumer tokenConsumer = bindingFactory.createTokenConsumer();
        tokenConsumer.setName(token.getId());
        tokenConsumer.setClassname(token.getTokenConsumerClassname());
        CallbackHandler callbackHandler = bindingFactory.createCallbackHandler();
        callbackHandler.setClassname(token.getCallBackHandler());
        tokenConsumer.setCallbackHandler(callbackHandler);
        ValueType valueType = bindingFactory.createValueType();
        valueType.setLocalName(token.getTokenLocalName());
        valueType.setUri(token.getTokenURI());
        tokenConsumer.setValueType(valueType);
        JAASConfig jAASConfig = bindingFactory.createJAASConfig();
        jAASConfig.setConfigName(token.getJAASConfig());
        tokenConsumer.setJAASConfig(jAASConfig);
        return tokenConsumer;
    }

    public static TokenConsumer createAsymmetricTokenConsumer(ObjectFactory bindingFactory, SecurityBindingObject securityObject) {
        ProtectionToken token = securityObject.getToken();
        TokenConsumer tokenConsumer = bindingFactory.createTokenConsumer();
        tokenConsumer.setName(token.getId());
        tokenConsumer.setClassname(token.getTokenConsumerClassname());
        CallbackHandler callbackHandler = bindingFactory.createCallbackHandler();
        callbackHandler.setClassname(token.getCallBackHandler());
        if (!(securityObject instanceof SignatureSecurityBindingObject) && token instanceof X509ProtectionToken) {
            WSFactoryUtils.createKeyStore(bindingFactory, callbackHandler, ((X509ProtectionToken)token).getKeyStore());
        }
        if (token.getProperties() != null) {
            List properties = callbackHandler.getProperties();
            for (PropertyObject property : token.getProperties().getProperties()) {
                properties.add(WSFactoryUtils.getPropertyObject(bindingFactory, property));
            }
        }
        tokenConsumer.setCallbackHandler(callbackHandler);
        ValueType valueType = bindingFactory.createValueType();
        valueType.setLocalName(token.getTokenLocalName());
        valueType.setUri(token.getTokenURI());
        tokenConsumer.setValueType(valueType);
        JAASConfig jAASConfig = bindingFactory.createJAASConfig();
        jAASConfig.setConfigName(token.getJAASConfig());
        tokenConsumer.setJAASConfig(jAASConfig);
        return tokenConsumer;
    }

    private static Properties getPropertyObject(ObjectFactory factory, PropertyObject object) {
        return WSFactoryUtils.getPropertyObject(factory, object.getName(), object.getValue());
    }

    private static Properties getPropertyObject(ObjectFactory factory, String name, String value) {
        Properties properties = factory.createProperties();
        properties.setName(name);
        properties.setValue(value);
        return properties;
    }

    public static com.ibm.ast.ws.policyset.ui.common.KeyStore readKeyStore(CallbackHandler callbackHandler) {
        com.ibm.ast.ws.policyset.ui.common.KeyStore newKeyStore = null;
        KeyStore keyStore = callbackHandler.getKeyStore();
        if (keyStore == null) {
            return newKeyStore;
        }
        Key key = callbackHandler.getKey();
        newKeyStore = new com.ibm.ast.ws.policyset.ui.common.KeyStore(PasswordUtil.passwordDecode((String)keyStore.getStorepass()), keyStore.getPath(), keyStore.getType());
        if (key != null) {
            newKeyStore = new KeyStoreWithKey(newKeyStore);
            ((KeyStoreWithKey)newKeyStore).setKeyAlias(key.getAlias());
            ((KeyStoreWithKey)newKeyStore).setKeyName(key.getName());
            ((KeyStoreWithKey)newKeyStore).setKeyPassword(PasswordUtil.passwordDecode((String)key.getKeypass()));
        }
        return newKeyStore;
    }
}

