/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.was7.policyset.ui.types;

import com.ibm.ast.ws.policyset.ui.common.BasicAuthentication;
import com.ibm.ast.ws.was7.policyset.ui.common.PolicyUtils;
import com.ibm.ast.ws.was7.policyset.ui.dialogs.WsJmsTransportBindingConfigurationDialog;
import com.ibm.ast.ws.was7.policyset.ui.plugin.Activator;
import com.ibm.ast.ws.was7.policyset.ui.types.PolicyType;
import com.ibm.ws.websvcs.transport.policyset.jms.jaxb.All;
import com.ibm.ws.websvcs.transport.policyset.jms.jaxb.BasicAuth;
import com.ibm.ws.websvcs.transport.policyset.jms.jaxb.ExactlyOne;
import com.ibm.ws.websvcs.transport.policyset.jms.jaxb.ObjectFactory;
import com.ibm.ws.websvcs.transport.policyset.jms.jaxb.OutAsyncResponseBasicAuth;
import com.ibm.ws.websvcs.transport.policyset.jms.jaxb.OutRequestBasicAuth;
import com.ibm.ws.websvcs.transport.policyset.jms.jaxb.Policy;
import com.ibm.ws.wssecurity.platform.websphere.util.WasPasswordUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.widgets.Shell;

public class JMSTransportPolicy
extends PolicyType {
    public static String PolicyTypeName = "JMSTransport";
    public static String ContextPath = "com.ibm.ws.websvcs.transport.policyset.jms.jaxb";
    private BasicAuthentication outRequest;
    protected static JAXBContext jc;
    protected static Unmarshaller u;
    protected static Marshaller m;
    private WasPasswordUtil passUtil = new WasPasswordUtil();
    protected String CONTEXT_PATH = "com.ibm.ws.websvcs.transport.policyset.jms.jaxb:org.xmlsoap.schemas.ws._2004._09.policy";

    protected Marshaller getMarshaller() throws JAXBException {
        if (jc == null) {
            jc = JAXBContext.newInstance((String)this.CONTEXT_PATH);
        }
        if (m == null) {
            m = jc.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)true);
        }
        return m;
    }

    protected Unmarshaller getUnmarshaller() throws JAXBException {
        if (jc == null) {
            jc = JAXBContext.newInstance((String)this.CONTEXT_PATH);
        }
        if (u == null) {
            u = jc.createUnmarshaller();
        }
        return u;
    }

    public IStatus saveBindingConfiguration(File location) {
        try {
            Policy bindings = this.jmsTransportBindings();
            this.writeJMSTransportBindings(bindings, location);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Status.OK_STATUS;
    }

    private Policy jmsTransportBindings() {
        ObjectFactory bindingFactory = new ObjectFactory();
        Policy transportPolicy = bindingFactory.createPolicy();
        ExactlyOne exactlyOne = bindingFactory.createExactlyOne();
        All all = bindingFactory.createAll();
        OutRequestBasicAuth outRequestwithJMS = bindingFactory.createOutRequestBasicAuth();
        BasicAuth basicAuth = new BasicAuth();
        basicAuth.setUserid(this.outRequest.getUserName());
        basicAuth.setPassword(this.passUtil.encode(this.outRequest.getPassword()));
        outRequestwithJMS.setBasicAuth(basicAuth);
        all.setOutRequestBasicAuth(outRequestwithJMS);
        OutAsyncResponseBasicAuth asynchResponseWithJMS = bindingFactory.createOutAsyncResponseBasicAuth();
        BasicAuth basicAuth2 = new BasicAuth();
        basicAuth2.setUserid("");
        basicAuth2.setPassword("");
        asynchResponseWithJMS.setBasicAuth(basicAuth2);
        all.setOutAsyncResponseBasicAuth(asynchResponseWithJMS);
        exactlyOne.getAll().add(all);
        transportPolicy.setExactlyOne(exactlyOne);
        return transportPolicy;
    }

    private void writeJMSTransportBindings(Policy transportPolicy, File bindingLocation) throws Exception {
        IPath fileLocation = new Path(bindingLocation.getAbsolutePath()).append("bindings.xml");
        JAXBContext jc = JAXBContext.newInstance((String)ContextPath);
        Marshaller m = jc.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)true);
        FileOutputStream os = new FileOutputStream(fileLocation.toFile());
        m.marshal((Object)transportPolicy, (OutputStream)os);
        ((OutputStream)os).close();
    }

    public String getName() {
        return PolicyTypeName;
    }

    public Dialog getConfigurationDialog(Shell shell) {
        return new WsJmsTransportBindingConfigurationDialog(shell, this);
    }

    public String validateConfiguration() {
        if (this.outRequest != null && this.outRequest.isValid()) {
            return Activator.getMessage("CONFIGURED");
        }
        return Activator.getMessage("NOT_CONFIGURED");
    }

    public BasicAuthentication getOutRequestwithJMS() {
        return this.outRequest;
    }

    public void setOutRequestwithJMS(BasicAuthentication outRequestwithSSL) {
        this.outRequest = outRequestwithSSL;
    }

    public void readBindingConfiguration(IPath folder) {
        if (folder == null) {
            return;
        }
        try {
            Object policy = PolicyUtils.readExistingBindingConfiguration(folder, this.getName(), ContextPath);
            if (policy == null) {
                this.outRequest = new BasicAuthentication("", "");
                return;
            }
            Policy transportPolicy = (Policy)policy;
            ExactlyOne exactlyOne = transportPolicy.getExactlyOne();
            All all = (All)exactlyOne.getAll().get(0);
            OutRequestBasicAuth outRequestwithJMS = all.getOutRequestBasicAuth();
            BasicAuth configAlias = outRequestwithJMS.getBasicAuth();
            this.outRequest = new BasicAuthentication(configAlias.getUserid(), this.passUtil.decode(configAlias.getPassword()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

