/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.was7.policyset.ui.types;

import com.ibm.ast.ws.policyset.ui.common.BasicAuthentication;
import com.ibm.ast.ws.policyset.ui.common.Proxy;
import com.ibm.ast.ws.was7.policyset.ui.common.PolicyUtils;
import com.ibm.ast.ws.was7.policyset.ui.dialogs.WsHttpTransportBindingConfigurationDialog;
import com.ibm.ast.ws.was7.policyset.ui.plugin.Activator;
import com.ibm.ast.ws.was7.policyset.ui.types.PolicyType;
import com.ibm.ws.websvcs.transport.policyset.jaxb.All;
import com.ibm.ws.websvcs.transport.policyset.jaxb.BasicAuth;
import com.ibm.ws.websvcs.transport.policyset.jaxb.ConnectInfo;
import com.ibm.ws.websvcs.transport.policyset.jaxb.ExactlyOne;
import com.ibm.ws.websvcs.transport.policyset.jaxb.ObjectFactory;
import com.ibm.ws.websvcs.transport.policyset.jaxb.OutRequestBasicAuth;
import com.ibm.ws.websvcs.transport.policyset.jaxb.OutRequestProxy;
import com.ibm.ws.websvcs.transport.policyset.jaxb.Policy;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.widgets.Shell;

public class HTTPTransportPolicy
extends PolicyType {
    public static String PolicyTypeName = "HTTPTransport";
    public static String ContextPath = "com.ibm.ws.websvcs.transport.policyset.jaxb";
    private BasicAuthentication outRequestBasicAuthentication;
    private Proxy outboundRequestProxy;
    protected static JAXBContext jc;
    protected static Unmarshaller u;
    protected static Marshaller m;
    protected String CONTEXT_PATH = "com.ibm.ws.websvcs.transport.policyset.jaxb:org.xmlsoap.schemas.ws._2004._09.policy";

    protected Marshaller getMarshaller() throws JAXBException {
        if (jc == null) {
            jc = JAXBContext.newInstance((String)this.CONTEXT_PATH);
        }
        if (m == null) {
            m = jc.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)true);
        }
        return m;
    }

    protected Unmarshaller getUnmarshaller() throws JAXBException {
        if (jc == null) {
            jc = JAXBContext.newInstance((String)this.CONTEXT_PATH);
        }
        if (u == null) {
            u = jc.createUnmarshaller();
        }
        return u;
    }

    public IStatus saveBindingConfiguration(File location) {
        try {
            Policy bindings = this.httpTransportBindings();
            this.writeHttpTransportBindings(bindings, location);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Status.OK_STATUS;
    }

    private Policy httpTransportBindings() {
        ObjectFactory bindingFactory = new ObjectFactory();
        Policy transportPolicy = bindingFactory.createPolicy();
        ExactlyOne exactlyOne = bindingFactory.createExactlyOne();
        All all = bindingFactory.createAll();
        OutRequestBasicAuth outRequestBasicAuth = bindingFactory.createOutRequestBasicAuth();
        BasicAuth basicAuth = bindingFactory.createBasicAuth();
        basicAuth.setUserid(this.outRequestBasicAuthentication == null ? "" : this.outRequestBasicAuthentication.getUserName());
        basicAuth.setPassword(this.outRequestBasicAuthentication == null ? "" : this.outRequestBasicAuthentication.getPassword());
        outRequestBasicAuth.setBasicAuth(basicAuth);
        all.setOutRequestBasicAuth(outRequestBasicAuth);
        OutRequestProxy outRequestProxy = bindingFactory.createOutRequestProxy();
        ConnectInfo connectInfo = bindingFactory.createConnectInfo();
        connectInfo.setHost(this.outboundRequestProxy == null ? "" : this.outboundRequestProxy.getHost());
        connectInfo.setPort(this.outboundRequestProxy == null ? "" : this.outboundRequestProxy.getPort());
        outRequestProxy.setConnectInfo(connectInfo);
        basicAuth = bindingFactory.createBasicAuth();
        basicAuth.setUserid(this.outboundRequestProxy == null ? "" : this.outboundRequestProxy.getAuthentication().getUserName());
        basicAuth.setPassword(this.outboundRequestProxy == null ? "" : this.outboundRequestProxy.getAuthentication().getPassword());
        outRequestProxy.setBasicAuth(basicAuth);
        all.setOutRequestProxy(outRequestProxy);
        exactlyOne.getAll().add(all);
        transportPolicy.setExactlyOne(exactlyOne);
        return transportPolicy;
    }

    private void writeHttpTransportBindings(Policy transportPolicy, File bindingLocation) throws Exception {
        IPath fileLocation = new Path(bindingLocation.getAbsolutePath()).append("bindings.xml");
        JAXBContext jc = JAXBContext.newInstance((String)ContextPath);
        Marshaller m = jc.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)true);
        FileOutputStream os = new FileOutputStream(fileLocation.toFile());
        m.marshal((Object)transportPolicy, (OutputStream)os);
        ((OutputStream)os).close();
    }

    public void readBindingConfiguration(IPath folder) {
        if (folder == null) {
            return;
        }
        try {
            Object policy = PolicyUtils.readExistingBindingConfiguration(folder, this.getName(), ContextPath);
            if (policy == null) {
                return;
            }
            Policy transportPolicy = (Policy)policy;
            ExactlyOne exactlyOne = transportPolicy.getExactlyOne();
            All all = (All)exactlyOne.getAll().get(0);
            OutRequestBasicAuth outRequestBasicAuth = all.getOutRequestBasicAuth();
            BasicAuth basicAuth = outRequestBasicAuth.getBasicAuth();
            this.outRequestBasicAuthentication = new BasicAuthentication(basicAuth.getUserid(), basicAuth.getPassword());
            OutRequestProxy outRequestProxy = all.getOutRequestProxy();
            basicAuth = outRequestProxy.getBasicAuth();
            BasicAuthentication basicAuthentication = new BasicAuthentication(basicAuth.getUserid(), basicAuth.getPassword());
            ConnectInfo connectInfo = outRequestProxy.getConnectInfo();
            this.outboundRequestProxy = new Proxy(connectInfo.getHost(), connectInfo.getPort(), basicAuthentication);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getName() {
        return PolicyTypeName;
    }

    public Dialog getConfigurationDialog(Shell shell) {
        return new WsHttpTransportBindingConfigurationDialog(shell, this);
    }

    public String validateConfiguration() {
        return Activator.getMessage("CONFIGURED");
    }

    public BasicAuthentication getOutRequestBasicAuth() {
        return this.outRequestBasicAuthentication;
    }

    public void setOutRequestBasicAuth(BasicAuthentication outRequestBasicAuth) {
        this.outRequestBasicAuthentication = outRequestBasicAuth;
    }

    public Proxy getOutRequestProxy() {
        return this.outboundRequestProxy;
    }

    public void setOutRequestProxy(Proxy outRequestProxy) {
        this.outboundRequestProxy = outRequestProxy;
    }
}

