/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.was7.policyset.ui.tokens;

import com.ibm.ast.ws.policyset.ui.common.PropertyList;
import com.ibm.ast.ws.policyset.ui.tokens.CustomeAuthenticationToken;
import com.ibm.ast.ws.was7.policyset.ui.callback.dialog.SAMLCallbackHandlerDialog;
import org.eclipse.swt.widgets.Shell;

public abstract class SAMLProtectionToken
extends CustomeAuthenticationToken {
    public static String CONFIRMATION_METHOD = "confirmationMethod";
    public static String KEY_TYPE = "keyType";
    public static String STS_URI = "stsURI";
    public static String TRUST_CLIENT_POLICY = "wstrustClientPolicy";
    public static String TRUST_CLIENT_BINDING = "wstrustClientBinding";
    public static String SOAP_VERSION = "wstrustClientSoapVersion";
    public static String BEARER = "Bearer";
    public static String HOLDER_OF_KEY = "Holder-of-key";
    public static String SENDER_VOUCHES = "sender-vouches";
    public static final String SAML_GENERATOR_CALLBACK_HANDLER = "com.ibm.websphere.wssecurity.callbackhandler.SAMLGenerateCallbackHandler";
    public static final String SAML_CONSUMER_CALLBACK_HANDLER = "com.ibm.websphere.wssecurity.callbackhandler.SAMLConsumerCallbackHandler";

    public static String[] getConfirmationMethods() {
        return new String[]{BEARER, HOLDER_OF_KEY, SENDER_VOUCHES};
    }

    public SAMLProtectionToken(String localname, boolean isGenerator) {
        super("CustomToken");
        if (localname.equals("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0") || localname.equals("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1")) {
            this.localName = localname;
            if (isGenerator) {
                this.jaasLogin = "system.wss.generate.saml";
                this.callBackHandler = SAML_GENERATOR_CALLBACK_HANDLER;
            } else {
                this.callBackHandler = SAML_CONSUMER_CALLBACK_HANDLER;
                this.jaasLogin = "system.wss.consume.saml";
            }
            this.callbackHandlers = new String[]{this.callBackHandler};
            this.jaasConfigs = new String[]{this.jaasLogin};
            this.properties = new PropertyList();
        } else {
            this.tokenName = null;
        }
    }

    public boolean isSymmetric() {
        return true;
    }

    public String getDefaultEncryptionKeyInfoType() {
        return "STRREF";
    }

    public boolean isValid() {
        return this.properties.getProperties().size() == 0 || this.properties.getProperty(KEY_TYPE).getValue().length() != 0;
    }

    public boolean getCallbackHandlerAdvancedDialog(Shell parent, String callback) {
        if (SAML_CONSUMER_CALLBACK_HANDLER.equals(this.callBackHandler)) {
            return false;
        }
        if (parent != null) {
            SAMLCallbackHandlerDialog dialog = new SAMLCallbackHandlerDialog(parent);
            dialog.setProperties(this.properties);
            int result = dialog.open();
            if (result == 0) {
                this.properties = dialog.getProperties();
            }
        }
        return true;
    }
}

