/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.was7.policyset.ui.tokens;

import com.ibm.ast.ws.policyset.ui.callback.dialog.UsernameCallbackHandlerDialog;
import com.ibm.ast.ws.policyset.ui.common.PropertyList;
import com.ibm.ast.ws.policyset.ui.tokens.AuthenticationToken;
import org.eclipse.swt.widgets.Shell;

public class LTPAAuthenticationToken
extends AuthenticationToken {
    public LTPAAuthenticationToken(String namelocalPart, boolean tokenGenerator) {
        super(namelocalPart);
        this.localName = "LTPAv2";
        if (tokenGenerator) {
            this.jaasLogin = "system.wss.generate.ltpa";
            this.callBackHandler = "com.ibm.websphere.wssecurity.callbackhandler.LTPAGenerateCallbackHandler";
        } else {
            this.jaasLogin = "system.wss.consume.ltpa";
            this.callBackHandler = "com.ibm.websphere.wssecurity.callbackhandler.LTPAConsumeCallbackHandler";
        }
        this.callbackHandlers = new String[]{this.callBackHandler};
        this.jaasConfigs = new String[]{this.jaasLogin};
        this.properties = new PropertyList();
    }

    public static String[] getSupportedLTPATokens() {
        return new String[]{"LTPAv2", "LTPA"};
    }

    public String getTokenURI() {
        if ("LTPAv2".equals(this.localName)) {
            return "http://www.ibm.com/websphere/appserver/tokentype";
        }
        return "http://www.ibm.com/websphere/appserver/tokentype/5.0.2";
    }

    public void setTokenLocalName(String name) {
        this.localName = name;
    }

    public boolean getCallbackHandlerAdvancedDialog(Shell parent, String callback) {
        if (parent != null) {
            UsernameCallbackHandlerDialog dialog = new UsernameCallbackHandlerDialog(parent, callback);
            dialog.setBasicAuthentication(this.auth);
            dialog.setPropertiesList(this.properties);
            int result = dialog.open();
            if (result == 0) {
                this.auth = dialog.getBasicAuthentication();
                dialog.setPropertiesList(this.properties);
            }
        }
        return true;
    }
}

