/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.was7.policyset.ui.tables;

import com.ibm.ast.ws.was7.policyset.ui.common.BindingObject;
import com.ibm.ast.ws.was7.policyset.ui.common.WSPolicyClientControlReferenceObject;
import com.ibm.ast.ws.was7.policyset.ui.common.WSPolicyControlReferenceObject;
import com.ibm.ast.ws.was7.policyset.ui.dialogs.ClientSidePolicySharingConfigDialog;
import com.ibm.ast.ws.was7.policyset.ui.dialogs.ServerSidePolicySharingConfigDialog;
import com.ibm.ast.ws.was7.policyset.ui.plugin.Activator;
import com.ibm.ast.ws.was7.policyset.ui.tables.AbstractConfigurationTable;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PolicySharingConfigurationTable
extends AbstractConfigurationTable {
    protected Listener statusListener_;
    private String INFOPOP_CSPSC_CONFIG = "CSPSC0001";
    protected Button config_;
    private String INFOPOP_CSPSC_REMOVE = "CSPSC0002";
    protected Button remove_;
    protected Map<String, WSPolicyControlReferenceObject> references;
    private Map<String, BindingObject> bindings;
    private Map<String, TableItem> tableItems;
    private boolean isClient;
    protected boolean isApplicationLevelWSPolicyEnabled;
    PolicySharingConfigurationTable me;

    public PolicySharingConfigurationTable(Composite parent, Listener statusListener, String[] columns) {
        super(parent, columns);
        this.statusListener_ = statusListener;
        this.isClient = false;
        this.tableItems = new HashMap<String, TableItem>();
        this.me = this;
    }

    public void setReferences(Map<String, WSPolicyControlReferenceObject> references) {
        this.references = references;
        this.table_.clearAll();
        this.refreshTable();
    }

    public void refreshTable() {
        if (this.references == null || this.bindings == null) {
            return;
        }
        TableItem selectedItem = null;
        if (this.table_.getSelectionIndex() >= 0) {
            selectedItem = this.table_.getItem(this.table_.getSelectionIndex());
        }
        String selectedDisplayName = null;
        if (selectedItem != null) {
            selectedDisplayName = selectedItem.getText(0);
        }
        this.table_.removeAll();
        this.tableItems.clear();
        this.isApplicationLevelWSPolicyEnabled = this.references.get(Activator.getMessage("LABEL_ALL_SERVICES")) != null ? this.references.get(Activator.getMessage("LABEL_ALL_SERVICES")).isWSPolicyEnabled() : false;
        for (String displayName : this.references.keySet()) {
            if (this.references.get(displayName).isIgnored()) continue;
            String state = this.getState(displayName);
            TableItem newItem = new TableItem(this.table_, 8);
            newItem.setText(new String[]{displayName, state});
            this.tableItems.put(displayName, newItem);
        }
        if (selectedDisplayName != null) {
            selectedItem = this.tableItems.get(selectedDisplayName);
            this.table_.select(this.table_.indexOf(selectedItem));
        } else if (this.table_.getItemCount() > 0) {
            this.table_.select(0);
            selectedItem = this.table_.getItem(0);
        }
        this.widgetSelected(null);
    }

    protected abstract String getConfigLabel();

    protected abstract String getRemoveLabel();

    @Override
    protected void addButtonsAndHandlers(Composite parent) {
        this.config_ = this.uiUtils.createPushButton(parent, this.getConfigLabel(), null, this.INFOPOP_CSPSC_CONFIG);
        this.config_.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                TableItem itemToEdit = PolicySharingConfigurationTable.this.table_.getItem(PolicySharingConfigurationTable.this.table_.getSelectionIndex());
                String displayName = itemToEdit.getText(0);
                WSPolicyControlReferenceObject refObject = PolicySharingConfigurationTable.this.references.get(displayName);
                TitleAreaDialog dialog = null;
                dialog = PolicySharingConfigurationTable.this.isClient ? new ClientSidePolicySharingConfigDialog(PolicySharingConfigurationTable.this.getShell(), (WSPolicyClientControlReferenceObject)refObject, PolicySharingConfigurationTable.this.bindings) : new ServerSidePolicySharingConfigDialog(PolicySharingConfigurationTable.this.getShell(), refObject, PolicySharingConfigurationTable.this.bindings);
                if (dialog != null) {
                    dialog.open();
                    String state = null;
                    if (displayName.equals(Activator.getMessage("LABEL_ALL_SERVICES"))) {
                        PolicySharingConfigurationTable.this.refreshTable();
                    } else {
                        state = PolicySharingConfigurationTable.this.getState(displayName);
                    }
                    itemToEdit.setText(new String[]{displayName, state});
                    PolicySharingConfigurationTable.this.me.widgetSelected(event);
                    PolicySharingConfigurationTable.this.statusListener_.handleEvent(null);
                }
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.remove_ = this.uiUtils.createPushButton(parent, this.getRemoveLabel(), null, this.INFOPOP_CSPSC_REMOVE);
        this.remove_.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                TableItem itemToEdit = PolicySharingConfigurationTable.this.table_.getItem(PolicySharingConfigurationTable.this.table_.getSelectionIndex());
                String displayName = itemToEdit.getText(0);
                String resource = PolicySharingConfigurationTable.this.references.get(displayName).getResource();
                PolicySharingConfigurationTable.this.references.get(displayName).reset();
                PolicySharingConfigurationTable.this.references.get(displayName).setResource(resource);
                String state = null;
                if (displayName.equals(Activator.getMessage("LABEL_ALL_SERVICES"))) {
                    PolicySharingConfigurationTable.this.refreshTable();
                } else {
                    state = PolicySharingConfigurationTable.this.getState(displayName);
                }
                itemToEdit.setText(new String[]{displayName, state});
                PolicySharingConfigurationTable.this.me.widgetSelected(event);
                PolicySharingConfigurationTable.this.statusListener_.handleEvent(null);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void setClient(boolean isClient) {
        this.isClient = isClient;
    }

    public void setBindings(Map<String, BindingObject> bindings) {
        this.bindings = bindings;
        this.refreshTable();
    }

    public void selectClient(String displayName) {
        if (displayName == null) {
            this.table_.select(0);
        } else {
            TableItem item = this.tableItems.get(displayName);
            if (item != null && this.table_.indexOf(item) != -1) {
                this.table_.select(this.table_.indexOf(item));
            } else {
                this.table_.select(0);
            }
        }
        this.refreshTable();
    }

    protected abstract String getState(String var1);

    public abstract void widgetSelected(SelectionEvent var1);
}

