/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.was7.policyset.ui.migration;

import com.ibm.ast.ws.policyset.ui.common.BasicAuthentication;
import com.ibm.ast.ws.policyset.ui.common.KeyStoreWithKey;
import com.ibm.ast.ws.policyset.ui.common.PropertyObject;
import com.ibm.ast.ws.policyset.ui.common.SignatureSecurityBindingObject;
import com.ibm.ast.ws.policyset.ui.tokens.KerberosProtectionToken;
import com.ibm.ast.ws.policyset.ui.tokens.ProtectionToken;
import com.ibm.ast.ws.policyset.ui.tokens.X509ProtectionToken;
import com.ibm.ast.ws.was7.policyset.ui.common.PolicyUtils;
import com.ibm.ast.ws.was7.policyset.ui.types.WSSecurityPolicy;
import com.ibm.ws.security.util.PasswordUtil;
import com.ibm.ws.wssecurity.platform.websphere.util.WasPasswordUtil;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.BasicAuth;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.CallbackHandler;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.CertStoreList;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.CollectionCertStores;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.EncryptionInfo;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.Key;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.KeyEncryptionKeyInfo;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.KeyInfo;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.KeyStore;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.Properties;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.SecurityBinding;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.SecurityBindings;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.SecurityInboundBindingConfig;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.SecurityOutboundBindingConfig;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.SigningInfo;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.SigningKeyInfo;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.SigningPartReference;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.TimestampExpires;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.TokenConsumer;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.TokenGenerator;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.Transform;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.TrustAnchor;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.X509Certificates;
import java.util.List;
import org.eclipse.core.runtime.IPath;

public class MigrateBindingConfigurationsUtils {
    public static String BindingContextPath = "com.ibm.xmlns.prod.websphere._200608.ws_securitybinding";

    public static boolean migrate(IPath location, String name, WSSecurityPolicy policy7, WasPasswordUtil passUtil) {
        Object securityBindings;
        try {
            securityBindings = PolicyUtils.readExistingBindingConfiguration(location, name, BindingContextPath);
        }
        catch (Exception exception) {
            return false;
        }
        if (securityBindings == null) {
            return false;
        }
        List bindings = ((SecurityBindings)securityBindings).getSecurityBinding();
        for (SecurityBinding securityBinding : bindings) {
            SecurityOutboundBindingConfig securityOutboundBindingConfig = securityBinding.getSecurityOutboundBindingConfig();
            boolean isApplicationSection = securityBinding.getName().equals(WSSecurityPolicy.ApplicationBindingName);
            if (isApplicationSection) {
                policy7.setOnlySignEntireHeadersAndBodyApp(false);
            } else {
                policy7.setOnlySignEntireHeadersAndBodyBoot(false);
            }
            boolean isSymmetricApplicationSection = isApplicationSection && policy7.getGeneratorSymmetricObject() != null;
            List signingInfos = securityOutboundBindingConfig.getSigningInfo();
            List encryptionInfos = securityOutboundBindingConfig.getEncryptionInfo();
            List keyInfos = securityOutboundBindingConfig.getKeyInfo();
            List tokenGenerators = securityOutboundBindingConfig.getTokenGenerator();
            TimestampExpires expiry = securityOutboundBindingConfig.getTimestampExpires();
            if (expiry != null) {
                policy7.setMessageExpiryTime(expiry.getExpires());
            }
            for (TokenGenerator tokenGenerator : tokenGenerators) {
                CallbackHandler callbackHandler = tokenGenerator.getCallbackHandler();
                if (callbackHandler == null) continue;
                int k = 0;
                while (k < keyInfos.size()) {
                    KeyInfo keyInfo = (KeyInfo)keyInfos.get(k);
                    if (tokenGenerator.getName().equalsIgnoreCase(keyInfo.getTokenReference().getReference())) {
                        ProtectionToken token;
                        Object secObject;
                        int l = 0;
                        while (l < signingInfos.size()) {
                            SigningInfo signingInfo = (SigningInfo)signingInfos.get(l);
                            for (SigningKeyInfo SigningKeyInfo2 : signingInfo.getSigningKeyInfo()) {
                                Object object = secObject = isSymmetricApplicationSection ? policy7.getGeneratorSymmetricObject() : policy7.getSignOutbound();
                                if (!keyInfo.getName().equalsIgnoreCase(SigningKeyInfo2.getReference())) continue;
                                token = secObject.getToken();
                                if (token instanceof X509ProtectionToken) {
                                    ((X509ProtectionToken)token).setKeyStore(MigrateBindingConfigurationsUtils.readKeyStore(callbackHandler));
                                }
                                secObject.setTransformAlgorithm(((Transform)((SigningPartReference)signingInfo.getSigningPartReference().get(0)).getTransform().get(0)).getAlgorithm());
                                secObject.setOrder(signingInfo.getOrder());
                                token.setKeyInfoType(keyInfo.getType());
                                token.setCallBackHandler(callbackHandler.getClassname());
                                token.setJAASConfig(tokenGenerator.getJAASConfig().getConfigName());
                                secObject.setDerivedKey(null);
                                for (Properties property : callbackHandler.getProperties()) {
                                    secObject.addProperty(new PropertyObject(property.getName(), property.getValue()));
                                }
                            }
                            ++l;
                        }
                        int m = 0;
                        while (m < encryptionInfos.size()) {
                            Object secObject2 = isSymmetricApplicationSection ? policy7.getGeneratorSymmetricObject() : policy7.getEncOutbound();
                            EncryptionInfo encryptionInfo = (EncryptionInfo)encryptionInfos.get(m);
                            for (Properties property : encryptionInfo.getProperties()) {
                                secObject2.addProperty(new PropertyObject(property.getName(), property.getValue()));
                            }
                            secObject = encryptionInfo.getKeyEncryptionKeyInfo().iterator();
                            while (secObject.hasNext()) {
                                KeyEncryptionKeyInfo encryptionKeyInfo = (KeyEncryptionKeyInfo)secObject.next();
                                if (keyInfo.getName().equalsIgnoreCase(encryptionKeyInfo.getReference())) {
                                    callbackHandler.getKey().setKeypass(null);
                                    token = secObject2.getToken();
                                    if (token instanceof X509ProtectionToken) {
                                        ((X509ProtectionToken)token).setKeyStore(MigrateBindingConfigurationsUtils.readKeyStore(callbackHandler));
                                    }
                                    token.setKeyInfoType(keyInfo.getType());
                                    token.setCallBackHandler(callbackHandler.getClassname());
                                    token.setJAASConfig(tokenGenerator.getJAASConfig().getConfigName());
                                    secObject2.setDerivedKey(null);
                                    for (Properties property : callbackHandler.getProperties()) {
                                        secObject2.addProperty(new PropertyObject(property.getName(), property.getValue()));
                                    }
                                }
                                secObject2.setOrder(encryptionInfo.getOrder());
                            }
                            ++m;
                        }
                    }
                    ++k;
                }
                BasicAuth basicAuth = callbackHandler.getBasicAuth();
                if (basicAuth != null && policy7.getAuthenticationToken() != null) {
                    BasicAuthentication basicAuthentication = new BasicAuthentication(basicAuth.getUserid(), passUtil.passwordDecode(basicAuth.getPassword()));
                    policy7.getAuthenticationToken().setBasicAuth(basicAuthentication);
                    policy7.getAuthenticationToken().setCallBackHandler(callbackHandler.getClassname());
                    policy7.getAuthenticationToken().setJAASConfig(tokenGenerator.getJAASConfig().getConfigName());
                    for (Properties property : callbackHandler.getProperties()) {
                        basicAuthentication.addProperty(new PropertyObject(property.getName(), property.getValue()));
                    }
                }
                if (policy7.getGeneratorSymmetricObject() == null || !(policy7.getGeneratorSymmetricObject().getToken() instanceof KerberosProtectionToken)) continue;
                KerberosProtectionToken kerberosToken = (KerberosProtectionToken)policy7.getGeneratorSymmetricObject().getToken();
                for (Properties property : tokenGenerator.getProperties()) {
                    kerberosToken.addProperty(new PropertyObject(property.getName(), property.getValue()));
                }
            }
            SecurityInboundBindingConfig securityInboundBindingConfig = securityBinding.getSecurityInboundBindingConfig();
            signingInfos = securityInboundBindingConfig.getSigningInfo();
            encryptionInfos = securityInboundBindingConfig.getEncryptionInfo();
            keyInfos = securityInboundBindingConfig.getKeyInfo();
            List tokenConsumers = securityInboundBindingConfig.getTokenConsumer();
            for (TokenConsumer tokenConsumer : tokenConsumers) {
                CallbackHandler callbackHandler = tokenConsumer.getCallbackHandler();
                if (callbackHandler == null) continue;
                int k = 0;
                while (k < keyInfos.size()) {
                    KeyInfo keyInfo = (KeyInfo)keyInfos.get(k);
                    if (tokenConsumer.getName().equalsIgnoreCase(keyInfo.getTokenReference().getReference())) {
                        ProtectionToken token;
                        SignatureSecurityBindingObject secObject;
                        int l = 0;
                        while (l < signingInfos.size()) {
                            SigningInfo signingInfo = (SigningInfo)signingInfos.get(l);
                            for (SigningKeyInfo SigningKeyInfo3 : signingInfo.getSigningKeyInfo()) {
                                SignatureSecurityBindingObject signatureSecurityBindingObject = secObject = isSymmetricApplicationSection ? policy7.getConsumerSymmmetricObject() : policy7.getSignInbound();
                                if (!keyInfo.getName().equalsIgnoreCase(SigningKeyInfo3.getReference())) continue;
                                token = secObject.getToken();
                                if (token instanceof X509ProtectionToken) {
                                    ((X509ProtectionToken)token).setKeyStore(MigrateBindingConfigurationsUtils.readKeyStore(callbackHandler));
                                }
                                token.setKeyInfoType(keyInfo.getType());
                                token.setCallBackHandler(callbackHandler.getClassname());
                                token.setJAASConfig(tokenConsumer.getJAASConfig().getConfigName());
                                secObject.setDerivedKey(null);
                                secObject.setTransformAlgorithm(((Transform)((SigningPartReference)signingInfo.getSigningPartReference().get(0)).getTransform().get(0)).getAlgorithm());
                                for (Properties property : callbackHandler.getProperties()) {
                                    secObject.addProperty(new PropertyObject(property.getName(), property.getValue()));
                                }
                            }
                            ++l;
                        }
                        for (EncryptionInfo encryptionInfo : encryptionInfos) {
                            for (KeyEncryptionKeyInfo encryptionKeyInfo : encryptionInfo.getKeyEncryptionKeyInfo()) {
                                Object object = secObject = isSymmetricApplicationSection ? policy7.getConsumerSymmmetricObject() : policy7.getEncInbound();
                                if (!keyInfo.getName().equalsIgnoreCase(encryptionKeyInfo.getReference())) continue;
                                token = secObject.getToken();
                                if (token instanceof X509ProtectionToken) {
                                    ((X509ProtectionToken)token).setKeyStore(MigrateBindingConfigurationsUtils.readKeyStore(callbackHandler));
                                }
                                secObject.setDerivedKey(null);
                                token.setKeyInfoType(keyInfo.getType());
                                token.setCallBackHandler(callbackHandler.getClassname());
                                token.setJAASConfig(tokenConsumer.getJAASConfig().getConfigName());
                                for (Properties property : callbackHandler.getProperties()) {
                                    secObject.addProperty(new PropertyObject(property.getName(), property.getValue()));
                                }
                            }
                        }
                    }
                    ++k;
                }
            }
            List trustAnchors = securityInboundBindingConfig.getTrustAnchor();
            for (TrustAnchor trustAnchor : trustAnchors) {
                KeyStore keyStore = trustAnchor.getKeyStore();
                if (keyStore == null) continue;
                com.ibm.ast.ws.policyset.ui.common.KeyStore newKeyStore = new com.ibm.ast.ws.policyset.ui.common.KeyStore(passUtil.passwordDecode(keyStore.getStorepass()), keyStore.getPath(), keyStore.getType());
                ((X509ProtectionToken)policy7.getSignInbound().getToken()).setKeyStore(newKeyStore);
            }
            CertStoreList certStoreList = securityInboundBindingConfig.getCertStoreList();
            if (certStoreList == null) continue;
            List collectionCertStores = certStoreList.getLdapCertStoresOrCollectionCertStores();
            int j = 0;
            while (j < collectionCertStores.size()) {
                CollectionCertStores collectionCertStore = (CollectionCertStores)collectionCertStores.get(j);
                List x509CertificatesOrCRLs = collectionCertStore.getX509CertificatesOrCRL();
                int k = 0;
                while (k < x509CertificatesOrCRLs.size()) {
                    X509Certificates x509Certificates = (X509Certificates)x509CertificatesOrCRLs.get(k);
                    if (x509Certificates != null) {
                        ((X509ProtectionToken)policy7.getSignInbound().getToken()).setCertificatePathString(x509Certificates.getPath());
                    }
                    ++k;
                }
                ++j;
            }
        }
        return true;
    }

    public static com.ibm.ast.ws.policyset.ui.common.KeyStore readKeyStore(CallbackHandler callbackHandler) {
        com.ibm.ast.ws.policyset.ui.common.KeyStore newKeyStore = null;
        KeyStore keyStore = callbackHandler.getKeyStore();
        if (keyStore == null) {
            return newKeyStore;
        }
        Key key = callbackHandler.getKey();
        newKeyStore = new com.ibm.ast.ws.policyset.ui.common.KeyStore(PasswordUtil.passwordDecode((String)keyStore.getStorepass()), keyStore.getPath(), keyStore.getType());
        if (key != null) {
            newKeyStore = new KeyStoreWithKey(newKeyStore);
            ((KeyStoreWithKey)newKeyStore).setKeyAlias(key.getAlias());
            ((KeyStoreWithKey)newKeyStore).setKeyName(key.getName());
            ((KeyStoreWithKey)newKeyStore).setKeyPassword(PasswordUtil.passwordDecode((String)key.getKeypass()));
        }
        return newKeyStore;
    }
}

